/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.web.common;

import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRequestStatus;
import com.sun.symon.base.client.alarm.SMAlarmStatusData;
import com.sun.symon.base.client.alarm.SMAlarmStatusResponse;
import com.sun.symon.base.client.topology.SMHierarchyResponse;
import com.sun.symon.base.client.topology.SMHierarchyViewData;
import com.sun.symon.base.client.topology.SMTopologyRequest;
import com.sun.symon.base.web.common.SMWebServlet;
import com.sun.symon.base.web.common.SMWebSession;
import com.sun.symon.base.web.common.SMWebTreeObject;
import com.sun.symon.base.web.common.SMWebTreeToHtml;
import com.sun.symon.base.web.common.SMWebUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SMWebGetTreeObject
implements SMHierarchyResponse,
SMAlarmStatusResponse {
    int no = 0;
    String rootURL = null;
    Object rootReqHandle = null;
    Object alarmReqHandle = null;
    Hashtable expandedHash = new Hashtable();
    String branchServletName = null;
    String leafServletName = null;
    boolean isBrowserTree = false;
    SMRawDataRequest rawRequest = null;
    SMWebTreeObject rootTreeObj = null;
    SMWebTreeToHtml treeToHtml = null;
    SMWebSession webSession = null;
    SMHierarchyViewData rootData = null;
    SMTopologyRequest tRequest = null;
    String errorMessage = null;

    public SMWebGetTreeObject(String string, String string2, boolean bl) {
        this.branchServletName = string;
        this.leafServletName = string2;
        this.isBrowserTree = bl;
        this.treeToHtml = new SMWebTreeToHtml(string, string2, bl);
    }

    public void clear() {
        if (this.rootTreeObj != null) {
            this.rootTreeObj.clear();
            this.rootTreeObj = null;
        }
        if (this.expandedHash != null) {
            this.expandedHash.clear();
            this.expandedHash = null;
        }
        this.treeToHtml = null;
    }

    public void doWork(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        Object object;
        Object object2;
        Object object3;
        this.errorMessage = null;
        PrintWriter printWriter = SMWebServlet.initOutput(httpServletResponse);
        this.webSession = (SMWebSession)httpServletRequest.getSession(false).getValue("SMWebSession");
        this.tRequest = this.webSession.getTopoRequest();
        this.rawRequest = this.webSession.getRawRequest();
        boolean bl = false;
        String string = httpServletRequest.getParameter("sunmcURL");
        if (string != null && !string.equals(this.rootURL)) {
            if (this.rootURL != null && this.rootTreeObj != null) {
                this.rootTreeObj.clear();
            }
            this.rootURL = string;
            bl = true;
        }
        if (!bl) {
            object3 = httpServletRequest.getParameter("collapse");
            object2 = httpServletRequest.getParameter("expand");
            if (object2 != null && this.expandedHash.get(object2) == null) {
                this.expandedHash.put(object2, new Integer(1));
            } else if (object3 != null && this.expandedHash.get(object3) != null) {
                this.expandedHash.remove(object3);
            }
        } else {
            try {
                this.rootReqHandle = this.isBrowserTree ? this.tRequest.getHierarchyRootRequestFromTopology(this.rootURL, "0", (SMHierarchyResponse)this, null) : this.tRequest.getHierarchyRootRequest(this.rootURL, "0", false, (SMHierarchyResponse)this, null);
                object3 = this;
                synchronized (object3) {
                    this.wait();
                }
            }
            catch (Exception exception) {
                SMWebUtil.log("Error in sending SunMC hierarchy root request", exception);
                throw new ServletException(exception.getMessage());
            }
            this.rootTreeObj = new SMWebTreeObject(null, "", "/", this.rootData.getName(), this.rootURL, true, null, this.rootData.getFamilyImages().getIconFileName(false), this.rootData.getFamilyImages().getIconFileName(true));
            this.expandedHash.put("/", new Integer(1));
        }
        try {
            this.alarmReqHandle = this.webSession.getAlarmRequest().getTopAlarmStatusRequest(this.rootData.getNavigationUrl(), "0", (SMAlarmStatusResponse)this, null);
            object3 = this;
            synchronized (object3) {
                this.wait();
            }
        }
        catch (Exception exception) {
            SMWebUtil.log("Error in sending SunMC alarm status request", exception);
            throw new ServletException(exception.getMessage());
        }
        object3 = this.rootData.getAlarmStatusInfo();
        if (object3 != null) {
            this.rootTreeObj.setAlarmStatus((SMAlarmStatusData)object3);
        }
        ++this.no;
        object2 = null;
        try {
            object2 = this.isBrowserTree ? this.tRequest.getHierarchyChildRequest(this.rootData.getNavigationUrl(), "0", true, (SMHierarchyResponse)this, (Object)this.rootTreeObj) : this.tRequest.getHierarchyChildRequest(this.rootURL, "0", true, (SMHierarchyResponse)this, (Object)this.rootTreeObj);
            this.rootTreeObj.setReqHandle(object2);
            object = this;
            synchronized (object) {
                this.wait();
            }
        }
        catch (Exception exception) {
            SMWebUtil.log("Error in sending SunMC hierarchy child request", exception);
            throw new ServletException(exception.getMessage());
        }
        object = this.treeToHtml.objToHtml(this.rootTreeObj, this.webSession.getLocale(), this.expandedHash, this.errorMessage);
        this.rootTreeObj.clearChildren();
        printWriter.println((String)object);
    }

    public void getAlarmStatusListResponse(SMRequestStatus sMRequestStatus, SMAlarmStatusData[] sMAlarmStatusDataArray, Object object) {
    }

    public String getCurrentDomainName() {
        return this.rootData.getName();
    }

    public void getHierarchyChildResponse(SMRequestStatus sMRequestStatus, SMHierarchyViewData[] sMHierarchyViewDataArray, Object object) {
        SMWebGetTreeObject sMWebGetTreeObject;
        Object object2;
        if (sMRequestStatus.getReturnCode() != 0) {
            SMWebUtil.log("Error in getting SunMC hierarchy child response:" + sMRequestStatus.getMessageText());
            this.errorMessage = sMRequestStatus.getMessageText();
            SMWebGetTreeObject sMWebGetTreeObject2 = this;
            synchronized (sMWebGetTreeObject2) {
                --this.no;
                if (this.no == 0) {
                    this.notify();
                }
            }
            return;
        }
        SMWebTreeObject sMWebTreeObject = (SMWebTreeObject)object;
        try {
            object2 = sMWebTreeObject.getReqHandle();
            if (object2 != null) {
                this.rawRequest.removeURLRequest(object2);
                sMWebTreeObject.setReqHandle(null);
            }
        }
        catch (Exception exception) {
            SMWebUtil.log("Error in removing SunMC hierarchy child request", exception);
        }
        int n = 0;
        while (n < sMHierarchyViewDataArray.length) {
            sMWebGetTreeObject = sMHierarchyViewDataArray[n].getAlarmStatusInfo();
            String string = sMHierarchyViewDataArray[n].getFamilyCommands().getNavigateSpec();
            if (string == null && sMHierarchyViewDataArray[n].getNavigationUrl().equals(sMHierarchyViewDataArray[n].getTargetUrl())) {
                string = ".templates.consoles.agent-details";
            }
            object2 = new SMWebTreeObject(sMWebTreeObject, sMHierarchyViewDataArray[n].getObjectId(), String.valueOf(sMWebTreeObject.getPath()) + sMHierarchyViewDataArray[n].getObjectId() + "/", sMHierarchyViewDataArray[n].getName(), sMHierarchyViewDataArray[n].getTargetUrl(), sMHierarchyViewDataArray[n].getIsBranch(), string, sMHierarchyViewDataArray[n].getFamilyImages().getIconFileName(false), sMHierarchyViewDataArray[n].getFamilyImages().getIconFileName(true));
            if (sMWebGetTreeObject != null) {
                ((SMWebTreeObject)object2).setAlarmStatus((SMAlarmStatusData)sMWebGetTreeObject);
            }
            sMWebTreeObject.addChild((SMWebTreeObject)object2);
            if (sMHierarchyViewDataArray[n].getIsBranch() && this.expandedHash.get(((SMWebTreeObject)object2).getPath()) != null) {
                try {
                    Object object3 = this;
                    synchronized (object3) {
                        ++this.no;
                    }
                    object3 = this.tRequest.getHierarchyChildRequest(sMHierarchyViewDataArray[n].getTargetUrl(), "0", true, (SMHierarchyResponse)this, object2);
                    ((SMWebTreeObject)object2).setReqHandle(object3);
                }
                catch (Exception exception) {
                    SMWebUtil.log("Error in sending SunMC hierarchy child request", exception);
                }
            }
            ++n;
        }
        sMWebGetTreeObject = this;
        synchronized (sMWebGetTreeObject) {
            --this.no;
            if (this.no == 0) {
                this.notify();
            }
        }
    }

    public void getHierarchyRootResponse(SMRequestStatus sMRequestStatus, SMHierarchyViewData sMHierarchyViewData, Object object) {
        SMWebGetTreeObject sMWebGetTreeObject;
        try {
            try {
                if (sMRequestStatus.getReturnCode() != 0) {
                    SMWebUtil.log("Error in getting SunMC hierarchy root response:" + sMRequestStatus.getMessageText());
                    this.errorMessage = sMRequestStatus.getMessageText();
                } else {
                    if (this.rootReqHandle != null) {
                        this.rawRequest.removeURLRequest(this.rootReqHandle);
                        this.rootReqHandle = null;
                    }
                    this.rootData = sMHierarchyViewData;
                }
            }
            catch (Exception exception) {
                SMWebUtil.log("Error in getting SunMC hierarchy root response", exception);
            }
            Object var5_7 = null;
            sMWebGetTreeObject = this;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            SMWebGetTreeObject sMWebGetTreeObject2 = this;
            synchronized (sMWebGetTreeObject2) {
                this.notify();
            }
            throw throwable;
        }
        synchronized (sMWebGetTreeObject) {
            this.notify();
        }
    }

    public void getTopAlarmStatusResponse(SMRequestStatus sMRequestStatus, SMAlarmStatusData sMAlarmStatusData, Object object) {
        SMWebGetTreeObject sMWebGetTreeObject;
        try {
            try {
                if (sMRequestStatus.getReturnCode() != 0) {
                    SMWebUtil.log("Error in getting SunMC alarm status response:" + sMRequestStatus.getMessageText());
                    this.errorMessage = sMRequestStatus.getMessageText();
                } else {
                    if (this.alarmReqHandle != null) {
                        this.rawRequest.removeURLRequest(this.alarmReqHandle);
                        this.alarmReqHandle = null;
                    }
                    this.rootData.setAlarmStatusInfo(sMAlarmStatusData);
                }
            }
            catch (Exception exception) {
                SMWebUtil.log("Error in getting SunMC alarm status response", exception);
            }
            Object var5_7 = null;
            sMWebGetTreeObject = this;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            SMWebGetTreeObject sMWebGetTreeObject2 = this;
            synchronized (sMWebGetTreeObject2) {
                this.notify();
            }
            throw throwable;
        }
        synchronized (sMWebGetTreeObject) {
            this.notify();
        }
    }
}

