/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.tools.sfix;

import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.mgmtservice.common.MSDB;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.utility.UcInternationalizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class TsFixMain {
    PrintWriter out;
    File fileHandle;
    FileOutputStream fos;
    private File[] riFilesInDefault;
    private File[] riFilesInRecent;
    private Hashtable sfListInDefault;
    private Hashtable sfListInRecent;
    private Hashtable sfFinalList = new Hashtable();
    private Vector toOracle;
    private Connection conn;
    private Statement stmt;
    private PreparedStatement pstmt;
    private static MSLogPrintWriter logError;
    private static MSLogPrintWriter logInfo;
    private static String DEFAULT_RI_PATH;
    private static String RECENT_RI_PATH;
    private String SUGGESTED_FIX_TAG = "suggestedfix:";
    private String EQUALTO = "=";
    private String COLON = ":";
    static final Locale[] supportedLocales;

    static {
        supportedLocales = new Locale[]{new Locale("de", ""), new Locale("es", ""), new Locale("fr", ""), new Locale("it", ""), new Locale("ja", ""), new Locale("ko", ""), new Locale("zh", ""), new Locale("zh", "TW"), new Locale("en", "")};
        MSLogPrintWriter.init((String)"com.sun.symon.tools.sfix.log");
        logInfo = MSLogPrintWriter.getInfoWriter();
        logError = MSLogPrintWriter.getErrorWriter();
        try {
            DEFAULT_RI_PATH = System.getProperty("DEFAULT_RI_PATH");
            RECENT_RI_PATH = System.getProperty("RECENT_RI_PATH");
        }
        catch (SecurityException securityException) {
            logError.println("system property not allowed to retrieve");
            System.exit(1);
        }
        catch (NullPointerException nullPointerException) {
            logError.println("no system property is set");
            System.exit(1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logError.println("the specified key does not have value");
            System.exit(1);
        }
    }

    public TsFixMain() {
        this.sfListInRecent = new Hashtable();
        this.sfListInDefault = new Hashtable();
        this.toOracle = new Vector();
    }

    private void deleteSuggestedFix() {
        try {
            logInfo.println("trying to connect oracle ...");
            this.conn = MSDB.getConnection();
            logInfo.println("connected succesfully");
            this.stmt = this.conn.createStatement();
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            logError.println("not able to connect ....quitting");
            System.exit(1);
        }
        catch (SMDatabaseException sMDatabaseException) {
            logError.println(sMDatabaseException.getMessage());
            System.exit(1);
        }
        catch (SQLException sQLException) {
            logError.println(sQLException.getMessage());
            System.exit(1);
        }
        try {
            String string = "delete from SUGGESTED_FIX";
            logInfo.println("purging data from suggested fix table ....");
            int n = this.stmt.executeUpdate(string);
            logInfo.println(String.valueOf(n) + " records deleted");
        }
        catch (SQLException sQLException) {
            logError.println(sQLException.getMessage());
            logError.println("error when purging");
            System.exit(1);
        }
        try {
            this.conn.commit();
            this.conn.close();
            logInfo.println("Closed ...");
        }
        catch (SQLException sQLException) {
            logError.println(sQLException.getMessage());
            System.exit(1);
        }
    }

    private void displayUsage() {
        System.out.println(UcInternationalizer.translateKey((String)"com.sun.symon.tools.sfix.SuggestedFixUsage:usagetitle"));
        System.out.println(UcInternationalizer.translateKey((String)"com.sun.symon.tools.sfix.SuggestedFixUsage:usage1"));
        System.out.println(UcInternationalizer.translateKey((String)"com.sun.symon.tools.sfix.SuggestedFixUsage:usage2"));
        System.out.println(UcInternationalizer.translateKey((String)"com.sun.symon.tools.sfix.SuggestedFixUsage:usage3"));
    }

    private void dumpData(Vector vector) {
        int n = 0;
        if (vector.isEmpty()) {
            logInfo.println("no data to log .....");
        } else {
            try {
                logInfo.println("trying to connect oracle");
                this.conn = MSDB.getConnection();
                logInfo.println("Connected succesfully");
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                logError.println("not able to connect ...quitting");
                System.exit(1);
            }
            catch (SMDatabaseException sMDatabaseException) {
                logError.println(sMDatabaseException.getMessage());
                System.exit(1);
            }
            try {
                this.pstmt = this.conn.prepareStatement("INSERT into SUGGESTED_FIX values(SEQ_SUGGESTED_FIX_ID.nextval,?,?,?,?,sysdate)");
                int n2 = 0;
                while (n2 < vector.size()) {
                    OracleInfo oracleInfo = (OracleInfo)vector.elementAt(n2);
                    this.pstmt.setString(1, oracleInfo.propKey);
                    this.pstmt.setString(2, oracleInfo.propValue);
                    this.pstmt.setString(3, oracleInfo.locale);
                    this.pstmt.setString(4, "SYSTEM");
                    this.pstmt.executeUpdate();
                    ++n;
                    ++n2;
                }
            }
            catch (SQLException sQLException) {
                logError.println(sQLException.getMessage());
                logError.println("error when inserting records ");
                System.exit(1);
            }
            logInfo.println("no of rows inserted : " + n);
            try {
                this.conn.commit();
                this.conn.close();
                logInfo.println("connection closed ....");
            }
            catch (SQLException sQLException) {
                logError.println(sQLException.getMessage());
                System.exit(1);
            }
        }
    }

    private void flushOldData(Vector vector) {
        logInfo.println("looking for property keys (already existing ones)");
        if (vector.isEmpty()) {
            logInfo.println("no keys present to look up.....");
        } else {
            try {
                logInfo.println("connecting to oracle ...");
                this.conn = MSDB.getConnection();
                logInfo.println("connected succesfully");
                this.stmt = this.conn.createStatement();
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                logError.println("not able to connect ....quitting");
                System.exit(1);
            }
            catch (SMDatabaseException sMDatabaseException) {
                logError.println(sMDatabaseException.getMessage());
                System.exit(1);
            }
            catch (SQLException sQLException) {
                logError.println(sQLException.getMessage());
                System.exit(1);
            }
            try {
                this.pstmt = this.conn.prepareStatement("delete from SUGGESTED_FIX where PROPERTYURL = ? ");
                int n = 0;
                while (n < vector.size()) {
                    OracleInfo oracleInfo = (OracleInfo)vector.elementAt(n);
                    this.pstmt.setString(1, oracleInfo.propKey);
                    this.pstmt.executeUpdate();
                    ++n;
                }
            }
            catch (SQLException sQLException) {
                logError.println(sQLException.getMessage());
                logError.println("error when purging");
                System.exit(1);
            }
            try {
                this.conn.commit();
                this.conn.close();
                logInfo.println("connection closed ...");
            }
            catch (SQLException sQLException) {
                logError.println(sQLException.getMessage());
                System.exit(1);
            }
        }
    }

    private Hashtable getFinalList(Hashtable hashtable, Hashtable hashtable2) {
        String string;
        String string2;
        Enumeration enumeration;
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
        logInfo.println("Keys in Default Table :- " + hashtable.size());
        logInfo.println("Keys in Recent  Table :- " + hashtable2.size());
        if (!hashtable2.isEmpty()) {
            enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                if (!hashtable.containsKey(string2)) continue;
                hashtable.remove(string2);
            }
        }
        if (!hashtable2.isEmpty()) {
            enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                string = (String)hashtable2.get(string2);
                hashtable3.put(string2, string);
            }
        }
        if (!hashtable.isEmpty()) {
            enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                string = (String)hashtable.get(string2);
                hashtable3.put(string2, string);
            }
        }
        logInfo.println("Final Table :- " + hashtable3.size());
        return hashtable3;
    }

    public static void main(String[] stringArray) {
        TsFixMain tsFixMain = new TsFixMain();
        switch (stringArray.length) {
            case 0: {
                logInfo.println("normal processing");
                tsFixMain.storeSuggestedFix();
                break;
            }
            case 1: {
                if (stringArray[0].equalsIgnoreCase("-C")) {
                    logInfo.println("performing clean & dump");
                    tsFixMain.deleteSuggestedFix();
                    tsFixMain.storeSuggestedFix();
                    break;
                }
                tsFixMain.displayUsage();
                break;
            }
            case 2: {
                if (stringArray[0].equalsIgnoreCase("-M")) {
                    logInfo.println("processing only for the specified module");
                    tsFixMain.processOnlyForModule(stringArray[1]);
                    break;
                }
                tsFixMain.displayUsage();
                break;
            }
        }
        System.exit(0);
    }

    private boolean modulePresentAt(String string, String string2) {
        String string3 = String.valueOf(string2) + "/" + string + "-ruleinit-d.x";
        this.fileHandle = new File(string3);
        if (this.fileHandle.exists()) {
            logInfo.println("module: " + string + " :- exists in   " + string2);
            return true;
        }
        logInfo.println("module: " + string + " :- NOT exists in   " + string2);
        return false;
    }

    private Hashtable parseRIFiles(File[] fileArray) {
        Hashtable hashtable = new Hashtable();
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n] == null) break;
            this.retrieveSuggFixTags(fileArray[n], hashtable);
            ++n;
        }
        return hashtable;
    }

    private void processOnlyForModule(String string) {
        Hashtable hashtable = new Hashtable();
        logInfo.println("Processing for ....." + string);
        if (this.modulePresentAt(string, RECENT_RI_PATH)) {
            String string2 = String.valueOf(RECENT_RI_PATH) + "/" + string + "-ruleinit-d.x";
            File file = new File(string2);
            this.retrieveSuggFixTags(file, hashtable);
        } else if (this.modulePresentAt(string, DEFAULT_RI_PATH)) {
            String string3 = String.valueOf(DEFAULT_RI_PATH) + "/" + string + "-ruleinit-d.x";
            File file = new File(string3);
            this.retrieveSuggFixTags(file, hashtable);
        } else {
            logInfo.println("specified module does not exist ....");
            System.exit(0);
        }
        this.toOracle = this.propLookUp(hashtable);
        this.flushOldData(this.toOracle);
        this.dumpData(this.toOracle);
    }

    private Vector propLookUp(Hashtable hashtable) {
        String string = "";
        Vector<OracleInfo> vector = new Vector<OracleInfo>();
        if (hashtable.isEmpty()) {
            logInfo.println("no data to lookup..");
        } else {
            Enumeration enumeration = hashtable.keys();
            logInfo.println("doing final lookup information");
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = (String)hashtable.get(string2);
                int n = 0;
                while (n < supportedLocales.length) {
                    try {
                        ResourceBundle resourceBundle = ResourceBundle.getBundle(string3, supportedLocales[n]);
                        try {
                            string = resourceBundle.getString(string2);
                            vector.add(new OracleInfo(string2, string, supportedLocales[n].toString()));
                            logInfo.println("added --> " + string2 + "<---->" + string);
                            string = "";
                        }
                        catch (MissingResourceException missingResourceException) {
                            logInfo.println("Key[" + string2 + "] not found in prop file[" + string3 + "]");
                        }
                    }
                    catch (MissingResourceException missingResourceException) {
                        logInfo.println(missingResourceException.getMessage());
                    }
                    ++n;
                }
            }
            logInfo.println("No of Property-Value pairs to be Logged :- " + vector.size());
        }
        return vector;
    }

    private File[] retrieveRuleInitFiles(String string) {
        int n = 0;
        int n2 = 0;
        this.fileHandle = new File(string);
        n = this.fileHandle.list().length;
        File[] fileArray = new File[n];
        File[] fileArray2 = new File[n];
        fileArray = this.fileHandle.listFiles();
        logInfo.println("Search Path           : " + string);
        int n3 = 0;
        while (n3 < fileArray.length) {
            if (fileArray[n3].isFile() && fileArray[n3].toString().endsWith("-ruleinit-d.x")) {
                fileArray2[n2++] = fileArray[n3];
            }
            ++n3;
        }
        logInfo.println("Total Files Found     : " + n);
        logInfo.println("Rule Init Files Found : " + n2);
        return fileArray2;
    }

    private void retrieveSuggFixTags(File file, Hashtable hashtable) {
        BufferedReader bufferedReader = null;
        logInfo.println("Now Processing : " + file.toString());
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            int n = 0;
            while ((string = bufferedReader.readLine()) != null) {
                ++n;
                if (!string.trim().startsWith(this.SUGGESTED_FIX_TAG)) continue;
                if (string.indexOf(this.EQUALTO) != -1) {
                    String string2 = string.substring(string.indexOf(this.COLON) + 1, string.indexOf(this.EQUALTO)).trim();
                    if (string2.length() > 1) {
                        String string3 = string.substring(string.indexOf(this.EQUALTO) + 1).trim();
                        if (string3.length() > 1) {
                            hashtable.put(string2, new String(string3));
                            logInfo.println("Key   : " + string2);
                            logInfo.println("Value : " + string3);
                            continue;
                        }
                        logInfo.println("Line:" + n + " - for key[" + string2 + "] value not defined");
                        continue;
                    }
                    logInfo.println("Line:" + n + " - key not defined");
                    continue;
                }
                logInfo.println("Line: " + n + " - incorrect suggested fix format");
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            logError.println("file: " + file.toString() + " not found");
        }
        catch (IOException iOException) {
            logError.println("file: " + file.toString() + " not available (check permissions)");
        }
    }

    private void storeSuggestedFix() {
        logInfo.println("Looking for RuleInit file from DEFAULT PATH ..");
        this.riFilesInDefault = this.retrieveRuleInitFiles(DEFAULT_RI_PATH);
        this.sfListInDefault = this.parseRIFiles(this.riFilesInDefault);
        logInfo.println("Looking for RuleInit file from RECENT PATH ..");
        this.riFilesInRecent = this.retrieveRuleInitFiles(RECENT_RI_PATH);
        this.sfListInRecent = this.parseRIFiles(this.riFilesInRecent);
        this.sfFinalList = this.getFinalList(this.sfListInDefault, this.sfListInRecent);
        this.toOracle = this.propLookUp(this.sfFinalList);
        this.dumpData(this.toOracle);
    }

    class OracleInfo {
        String propKey;
        String locale;
        String propValue;

        OracleInfo(String string, String string2, String string3) {
            this.propKey = string;
            this.propValue = string2;
            this.locale = string3;
        }
    }
}

