/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.grouping.request;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.log.SMLogReader;
import com.sun.symon.base.client.log.SMLogRecord;
import com.sun.symon.base.console.grouping.CgUtil;
import com.sun.symon.base.console.grouping.request.CgRequestManagerDialog;
import com.sun.symon.base.console.manager.CmConsoleSession;
import com.sun.symon.base.utility.UcDialog;
import com.sun.symon.base.utility.UcThreadWorker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;

public class CgRequestLogViewDialog
extends JDialog
implements ActionListener {
    private JTextArea textArea;
    private JButton closeBtn;
    private JButton helpBtn;
    private JLabel statusLbl;
    private JScrollPane pane;
    private Timer timer;
    private SMLogReader reader;
    private boolean bRefreshed = false;
    private Date timestamp;
    private static final int refreshInterval = 60000;

    public CgRequestLogViewDialog(CgRequestManagerDialog cgRequestManagerDialog) throws SMAPIException {
        super((JFrame)cgRequestManagerDialog.getOwner());
        this.createGUI();
        this.setTitle(CgUtil.getI18nMsg((String)"requestLogTitle"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CgRequestLogViewDialog.this.close();
            }
        });
        CgUtil.addDialogToPool((String)"request log", (JDialog)this);
        this.timer = new Timer(60000, this);
        this.reader = cgRequestManagerDialog.rqstHandle.getLogReader();
        UcThreadWorker ucThreadWorker = new UcThreadWorker(){

            public void doWork() {
                CgRequestLogViewDialog.this.refreshLog();
            }
        };
        ucThreadWorker.start();
        this.timer.start();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.closeBtn) {
            this.close();
        } else if (object == this.helpBtn) {
            CmConsoleSession.getInstance().launchHelp("grouping-request-log-help");
        } else if (object == this.timer) {
            if (this.bRefreshed) {
                this.loadNewLog();
            } else {
                this.refreshLog();
            }
        }
    }

    void close() {
        this.timer.stop();
        CgUtil.removeDialogFromPool((String)"request log");
        ((Component)this).setVisible(false);
        this.dispose();
    }

    void createGUI() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.textArea = new JTextArea(25, 50);
        this.textArea.setEditable(false);
        this.textArea.setBackground(jPanel.getBackground());
        this.pane = new JScrollPane(this.textArea);
        jPanel.add(this.pane);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(new EmptyBorder(10, 0, 0, 0));
        jPanel2.add(Box.createHorizontalGlue());
        this.closeBtn = new JButton(CgUtil.getI18nMsg((String)"close"));
        this.closeBtn.addActionListener(this);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(this.closeBtn);
        this.helpBtn = new JButton(CgUtil.getI18nMsg((String)"help"));
        this.helpBtn.addActionListener(this);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(this.helpBtn);
        jPanel.add((Component)jPanel2, "South");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add(jPanel);
        this.statusLbl = new JLabel(" ");
        this.statusLbl.setForeground(Color.black);
        this.statusLbl.setBorder(new EmptyBorder(0, 10, 0, 0));
        jPanel3.add((Component)this.statusLbl, "South");
        this.setContentPane(jPanel3);
    }

    void loadNewLog() {
        try {
            int n;
            this.statusLbl.setText(CgUtil.getI18nMsg((String)"rqstLog.loading"));
            int n2 = n = this.reader.getSize();
            SMLogRecord[] sMLogRecordArray = null;
            while (n2 > 0) {
                sMLogRecordArray = this.reader.getLines(n2, 1);
                if (sMLogRecordArray == null || sMLogRecordArray.length != 1) continue;
                if (!sMLogRecordArray[0].getTimestamp().after(this.timestamp)) break;
                --n2;
            }
            if (n > n2) {
                sMLogRecordArray = this.reader.getLastLines(n - n2);
                if (sMLogRecordArray != null) {
                    int n3 = 0;
                    while (n3 < sMLogRecordArray.length) {
                        this.textArea.append(sMLogRecordArray[n3].toString());
                        if (n3 == sMLogRecordArray.length - 1) {
                            this.timestamp = sMLogRecordArray[n3].getTimestamp();
                        }
                        ++n3;
                    }
                }
                this.textArea.revalidate();
            }
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showError((Component)this, (Object)sMAPIException.getMessage());
        }
        this.statusLbl.setText(" ");
    }

    void refreshLog() {
        try {
            this.statusLbl.setText(CgUtil.getI18nMsg((String)"rqstLog.loading"));
            this.textArea.setText("");
            int n = this.reader.getSize();
            SMLogRecord[] sMLogRecordArray = this.reader.getLines(1, n);
            if (sMLogRecordArray != null) {
                int n2 = 0;
                while (n2 < sMLogRecordArray.length) {
                    this.textArea.append(sMLogRecordArray[n2].toString());
                    if (n2 == sMLogRecordArray.length - 1) {
                        this.timestamp = sMLogRecordArray[n2].getTimestamp();
                        if (this.timestamp != null) {
                            this.bRefreshed = true;
                        }
                    }
                    ++n2;
                }
                this.textArea.revalidate();
            }
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showError((Component)this, (Object)sMAPIException.getMessage());
        }
        this.statusLbl.setText(" ");
    }
}

