/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.table;

import com.sun.symon.base.client.alarm.SMAlarmStatusData;
import com.sun.symon.base.console.views.table.CvCommonTable;
import com.sun.symon.base.console.views.table.CvTable;
import com.sun.symon.base.console.views.table.CvTableContainer;
import com.sun.symon.base.console.views.table.CvTblCell;
import com.sun.symon.base.console.views.table.CvTblFilterEvent;
import com.sun.symon.base.console.views.table.CvTblFilterListener;
import com.sun.symon.base.console.views.table.CvTblTableColumn;
import com.sun.symon.base.console.views.table.CvTblTableEvent;
import com.sun.symon.base.console.views.table.CvTblTableEventListener;
import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;

public class CvTblTableModel
extends AbstractTableModel {
    protected Vector cellData = new Vector();
    protected Vector rawCellData = new Vector();
    protected Vector filterListeners = new Vector();
    protected ArrayList[] rowsSeverity;
    protected int[] rowsMapping;
    protected Vector tableEventListeners = new Vector();
    protected Color foreground = Color.black;
    protected Color background = Color.white;
    protected Font alarmFont = CvTable.DEFAULT_ALARM_FONT;
    protected Font headerFont = CvTable.DEFAULT_HEADER_FONT;
    protected Font normalFont = CvTable.DEFAULT_NORMAL_FONT;
    protected String[] dataURLs = null;
    protected String[] internalNames = null;
    protected String[] headerNames = null;
    protected String[] statusURLs = null;
    protected int rowNum;
    protected String[] indexValues = null;
    protected String[] indexValues4URL = null;
    protected String[] indexURLs = new String[0];
    protected String alarmMode = "background";
    protected int rowCount = 0;
    protected int columnCount = 0;
    protected int realNumColumns = 0;
    protected int updatedRowCount = 0;
    protected int updatedColumnCount = 0;
    protected boolean vertical = false;
    protected boolean isLarge = false;
    protected boolean initialized = false;
    protected String refInterval = null;
    protected CvTableContainer ownerTable = null;
    protected int tableNumber = 0;
    protected Vector accessValues = new Vector();
    protected Vector cEditorName = new Vector();
    protected Vector dFormats = new Vector();
    protected ArrayList sevMapping;
    TableCellEditor[] customEditors;
    protected Vector alarmFilter = new Vector();
    protected CvCommonTable ownTable = null;
    protected boolean allowEdit = false;
    protected int[] indexes;
    Vector sortingColumns = new Vector();
    boolean ascending = true;
    boolean firstSet = true;
    int compares;
    public static final int ERR = 25;
    public static final int WRN = 15;
    public static final int INF = 5;
    public static final int DWN = 29;
    Object lock = new Object();
    boolean dataSetting = false;

    public CvTblTableModel() {
        this.indexes = new int[0];
    }

    public CvTblTableModel(CvTableContainer cvTableContainer, int n) {
        this.ownerTable = cvTableContainer;
        this.tableNumber = n;
        this.reallocateIndexes();
    }

    public void addFilterListener(CvTblFilterListener cvTblFilterListener) {
        this.filterListeners.add(cvTblFilterListener);
    }

    public void addTableEventListener(CvTblTableEventListener cvTblTableEventListener) {
        this.tableEventListeners.addElement(cvTblTableEventListener);
    }

    protected void checkModel() {
        if (this.indexes.length != this.getRowCount()) {
            System.err.println("Sorter not informed of a change in model.");
        }
    }

    public void clearPageSortIndex() {
        CvTblTableModel cvTblTableModel = this;
        synchronized (cvTblTableModel) {
            this.indexes = new int[50];
            int n = 0;
            while (n < 50) {
                this.indexes[n] = n;
                ++n;
            }
        }
    }

    public int compare(int n, int n2) {
        ++this.compares;
        int n3 = 0;
        while (n3 < this.sortingColumns.size()) {
            Integer n4 = (Integer)this.sortingColumns.elementAt(n3);
            int n5 = this.compareRowsByColumn(n, n2, n4);
            if (n5 != 0) {
                return this.ascending ? n5 : -n5;
            }
            ++n3;
        }
        return 0;
    }

    protected int compareRowsByColumn(int n, int n2, int n3) {
        Object object;
        String string;
        CvTblTableColumn cvTblTableColumn = (CvTblTableColumn)this.ownTable.getColumnModel().getColumn(n3);
        String string2 = cvTblTableColumn.getDataType();
        Object object2 = this.convertData(this.getRawValueAt(n, n3), string2);
        Object object3 = this.convertData(this.getRawValueAt(n2, n3), string2);
        if (object2 == null && object3 == null) {
            return 0;
        }
        if (object2 == null) {
            return -1;
        }
        if (object3 == null) {
            return 1;
        }
        if (string2.equals("int") || string2.equals("float")) {
            Number number;
            double d;
            Number number2 = (Number)object2;
            double d2 = number2.doubleValue();
            if (d2 < (d = (number = (Number)object3).doubleValue())) {
                return -1;
            }
            if (d2 > d) {
                return 1;
            }
            return 0;
        }
        if (string2.equals("date")) {
            Date date;
            long l;
            Date date2 = (Date)object2;
            long l2 = date2.getTime();
            if (l2 < (l = (date = (Date)object3).getTime())) {
                return -1;
            }
            if (l2 > l) {
                return 1;
            }
            return 0;
        }
        if (string2.equals("string")) {
            String string3 = (String)object2;
            String string4 = (String)object3;
            int n4 = string3.compareTo(string4);
            if (n4 < 0) {
                return -1;
            }
            if (n4 > 0) {
                return 1;
            }
            return 0;
        }
        if (string2.equals("boolean")) {
            Boolean bl;
            boolean bl2;
            Boolean bl3 = (Boolean)object2;
            boolean bl4 = bl3;
            if (bl4 == (bl2 = (bl = (Boolean)object3).booleanValue())) {
                return 0;
            }
            if (bl4) {
                return 1;
            }
            return -1;
        }
        Object object4 = this.getRawValueAt(n, n3);
        String string5 = object4.toString();
        int n5 = string5.compareTo(string = (object = this.getRawValueAt(n2, n3)).toString());
        if (n5 < 0) {
            return -1;
        }
        if (n5 > 0) {
            return 1;
        }
        return 0;
    }

    protected Object convertData(Object object, String string) {
        if (object == null) {
            return null;
        }
        String string2 = ((CvTblCell)object).getDataValue();
        if (string2 == null) {
            return null;
        }
        if (string.equals("string")) {
            return string2.toString();
        }
        if (string.equals("int")) {
            return new Integer(string2);
        }
        if (string.equals("float")) {
            return new Float(string2);
        }
        if (string.equals("boolean")) {
            Boolean bl = null;
            if (string2.equals("true")) {
                bl = new Boolean(true);
            } else if (string2.equals("false")) {
                bl = new Boolean(false);
            }
            return bl;
        }
        if (string.equals("date")) {
            Date date = null;
            try {
                DateFormat dateFormat = DateFormat.getDateInstance(2, Locale.US);
                date = dateFormat.parse(string2);
            }
            catch (Exception exception) {
                date = null;
            }
            return date;
        }
        return null;
    }

    private int convertIndex(int n, int n2) {
        int n3 = this.vertical ? (this.rowsMapping != null ? this.rowsMapping[n] : n) : n2;
        return n3;
    }

    public int convertRowToModel(int n) {
        int n2 = n;
        if (!this.isLarge && !this.vertical) {
            n2 = this.indexes[n];
        }
        int n3 = this.rowsMapping != null ? this.rowsMapping[n2] : n2;
        return n3;
    }

    private void drawAlarmIcon(Vector vector, SMAlarmStatusData[] sMAlarmStatusDataArray) {
        int n = 0;
        while (n < sMAlarmStatusDataArray.length) {
            CvTblCell cvTblCell = null;
            cvTblCell = this.vertical ? (CvTblCell)((Vector)vector.get(0)).get(n) : (CvTblCell)((Vector)vector.get(n)).get(0);
            if (cvTblCell != null) {
                final CvTblCell cvTblCell2 = cvTblCell;
                final SMAlarmStatusData sMAlarmStatusData = sMAlarmStatusDataArray[n];
                Runnable runnable = new Runnable(){

                    public void run() {
                        cvTblCell2.setAlarmMode("dot_left");
                        cvTblCell2.setAlarmStatus(sMAlarmStatusData);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
            ++n;
        }
    }

    protected String escapeSpecialChars(String string) {
        StringBuffer stringBuffer = new StringBuffer(64);
        if (string != null && string.length() != 0 && (string.indexOf(",") != -1 || string.indexOf("%") != -1 || string.indexOf("#") != -1)) {
            int n = 0;
            while (n < string.length()) {
                if (string.charAt(n) == ',') {
                    stringBuffer.append("%2c");
                } else if (string.charAt(n) == '%') {
                    stringBuffer.append("%25");
                } else if (string.charAt(n) == '#') {
                    stringBuffer.append("%23");
                } else {
                    stringBuffer.append(string.charAt(n));
                }
                ++n;
            }
        } else {
            stringBuffer.append(string);
        }
        return new String(stringBuffer);
    }

    protected Vector filteringData(Vector vector, boolean bl) {
        try {
            Vector vector2 = new Vector();
            this.sevMapping = new ArrayList();
            int n = 0;
            while (n < vector.size()) {
                if ((Vector)vector.elementAt(n) != null && (!bl || this.vertical || this.alarmFilter.size() <= 0 || this.rowInAlarmFilter(this.rowsSeverity[n]))) {
                    Vector vector3 = (Vector)vector.elementAt(n);
                    Vector<CvTblCell> vector4 = new Vector<CvTblCell>(vector3.size());
                    int n2 = 0;
                    while (n2 < vector3.size()) {
                        if (!bl || !this.vertical || this.alarmFilter.size() <= 0 || this.rowInAlarmFilter(this.rowsSeverity[n2])) {
                            if (this.vertical && n == 0) {
                                this.sevMapping.add(new Integer(n2));
                            }
                            vector4.add((CvTblCell)vector3.elementAt(n2));
                        }
                        ++n2;
                    }
                    vector2.add(vector4);
                    if (!this.vertical) {
                        this.sevMapping.add(new Integer(n));
                    }
                }
                ++n;
            }
            return vector2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void fireFilterChange(boolean bl) {
        try {
            String[] stringArray = new String[5];
            stringArray[0] = this.rowsSeverity != null ? String.valueOf(this.rowsSeverity.length) : String.valueOf(this.getRowCount());
            int n = 1;
            while (n < 5) {
                stringArray[n] = "0";
                ++n;
            }
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            if (bl && this.rowsSeverity != null) {
                int n6 = 0;
                while (n6 < this.rowsSeverity.length) {
                    ArrayList arrayList = this.rowsSeverity[n6];
                    if (arrayList.contains(new Integer(25))) {
                        ++n2;
                    }
                    if (arrayList.contains(new Integer(15))) {
                        ++n3;
                    }
                    if (arrayList.contains(new Integer(5))) {
                        ++n4;
                    }
                    if (arrayList.contains(new Integer(29))) {
                        ++n5;
                    }
                    ++n6;
                }
                stringArray[1] = String.valueOf(n2);
                stringArray[2] = String.valueOf(n3);
                stringArray[3] = String.valueOf(n4);
                stringArray[4] = String.valueOf(n5);
            }
            CvTblFilterEvent cvTblFilterEvent = new CvTblFilterEvent(this, stringArray);
            int n7 = 0;
            while (n7 < this.filterListeners.size()) {
                ((CvTblFilterListener)this.filterListeners.get(n7)).labelsChanged(cvTblFilterEvent);
                ++n7;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Font getAlarmFont() {
        return this.alarmFont;
    }

    public int getColumnCount() {
        return !this.vertical ? this.columnCount : this.rowCount;
    }

    public String getColumnInternalName(int n) {
        if (n < 0 || n >= this.internalNames.length) {
            return null;
        }
        return this.internalNames[n];
    }

    public String[] getColumnInternalNames() {
        return this.internalNames;
    }

    public String getCustomEditorName(int n, int n2) {
        if (!this.vertical ? n < 0 || n > this.rowCount || n2 < 0 || n2 > this.columnCount : n < 0 || n > this.columnCount || n2 < 1 || n2 > this.rowCount) {
            return null;
        }
        if (!this.dFormats.isEmpty()) {
            int n3 = this.convertIndex(n, n2);
            return (String)this.cEditorName.elementAt(n3);
        }
        return null;
    }

    public TableCellEditor getCustomerEditor(int n, int n2) {
        int n3 = this.convertIndex(n, n2);
        return this.customEditors[n3];
    }

    public String getDataFormat(int n, int n2) {
        int n3;
        String string = null;
        if (!this.vertical ? n < 0 || n > this.rowCount || n2 < 0 || n2 > this.columnCount : n < 0 || n > this.columnCount || n2 < 1 || n2 > this.rowCount) {
            return null;
        }
        if (!this.dFormats.isEmpty() && (string = (String)this.dFormats.elementAt(n3 = this.convertIndex(n, n2))).equals("")) {
            string = null;
        }
        return string;
    }

    public String[] getDataURLs() {
        if (this.indexURLs.length > 0) {
            String[] stringArray = new String[this.realNumColumns + this.indexURLs.length];
            int n = 0;
            n = 0;
            while (n < this.indexURLs.length) {
                stringArray[n] = this.indexURLs[n];
                ++n;
            }
            int n2 = 0;
            while (n2 < this.realNumColumns) {
                stringArray[n] = this.dataURLs[n2];
                ++n;
                ++n2;
            }
            return stringArray;
        }
        return this.dataURLs;
    }

    public String getDataValue(int n, int n2) {
        if (!this.vertical ? n < 0 || n > this.rowCount || n2 < 0 || n2 > this.columnCount : n < 0 || n > this.columnCount || n2 < 1 || n2 > this.rowCount) {
            return null;
        }
        CvTblCell cvTblCell = (CvTblCell)this.getValueAt(n, n2);
        if (cvTblCell != null) {
            return cvTblCell.getDataValue();
        }
        return null;
    }

    public String getDataValue(int n, String string) {
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.internalNames.length) {
            if (string.compareTo(this.internalNames[n3]) == 0) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (n2 == -1) {
            return null;
        }
        return this.getDataValue(n, n2);
    }

    public String getExclusionInfo(int n, int n2) {
        int n3 = -1;
        if (!this.vertical) {
            n3 = n2;
        } else {
            int n4 = n3 = this.rowsMapping != null ? this.rowsMapping[n] : n;
        }
        if (n3 < 0) {
            return null;
        }
        return this.ownerTable.getExclusionsFor(this.tableNumber, n3);
    }

    public String getFullName(int n, int n2) {
        int n3 = -1;
        if (!this.vertical) {
            n3 = n2;
        } else {
            int n4 = n3 = this.rowsMapping != null ? this.rowsMapping[n] : n;
        }
        if (n3 < 0) {
            return null;
        }
        return this.ownerTable.getColumnHeading(this.tableNumber, n3);
    }

    public String getFullURL(int n, int n2) {
        String string = this.getURL(n, n2);
        if (string == null) {
            return null;
        }
        if (this.indexValues == null || this.vertical) {
            return string;
        }
        String string2 = this.getIndexValue4URL(n);
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        return String.valueOf(string) + "#" + string2;
    }

    public Font getHeaderFont() {
        return this.headerFont;
    }

    public String getHeaderName(int n) {
        if (this.headerNames == null || n >= this.headerNames.length || n < 0) {
            return null;
        }
        return this.headerNames[n];
    }

    public String[] getHeaderNames() {
        return this.headerNames;
    }

    public String[] getIndexURLs() {
        return this.indexURLs;
    }

    public String getIndexValue(int n) {
        int n2 = n;
        if (n < 0 || n >= this.indexes.length) {
            return "";
        }
        if (this.indexes != null) {
            n = n2 = this.indexes[n];
        }
        if (this.rowsMapping != null) {
            n2 = this.rowsMapping[n];
        }
        if (this.indexValues == null || this.indexURLs.length == 0) {
            return "";
        }
        return n2 < 0 || n2 >= this.indexValues.length ? "" : this.indexValues[n2];
    }

    public String getIndexValue4URL(int n) {
        int n2 = n;
        if (this.indexes != null && n >= 0 && n < this.indexes.length) {
            n = n2 = this.indexes[n];
        }
        if (this.rowsMapping != null && n >= 0 && n < this.rowsMapping.length) {
            n2 = this.rowsMapping[n];
        }
        if (this.indexValues4URL == null || this.indexURLs.length == 0) {
            return "";
        }
        return n2 < 0 || n2 >= this.indexValues4URL.length ? "" : this.indexValues4URL[n2];
    }

    public String[] getInternalColumnNames() {
        return this.internalNames;
    }

    public boolean getIsLarge() {
        return this.isLarge;
    }

    public Font getNormalFont() {
        return this.normalFont;
    }

    public CvTableContainer getOwnerTable() {
        return this.ownerTable;
    }

    public Object getRawValueAt(int n, int n2) {
        if (!this.vertical) {
            if (n < 0 || n >= this.rowCount || n2 < 0 || n2 >= this.columnCount) {
                return null;
            }
            return ((Vector)this.cellData.elementAt(n)).elementAt(n2);
        }
        if (n < 0 || n >= this.columnCount || n2 < 0 || n2 >= this.rowCount) {
            return null;
        }
        return ((Vector)this.cellData.elementAt(n2)).elementAt(n);
    }

    public int getRowCount() {
        int n = 0;
        n = this.vertical ? (this.updatedRowCount < this.columnCount ? this.updatedRowCount : this.columnCount) : (this.updatedColumnCount < this.rowCount ? this.updatedColumnCount : this.rowCount);
        return n;
    }

    public int getRowFromIndexValue(String string) {
        if (string == null) {
            return -1;
        }
        if (this.indexValues == null || this.indexURLs.length == 0) {
            return 0;
        }
        int n = 0;
        while (n < this.indexValues.length) {
            if (this.indexValues[n] != null && this.indexValues[n].compareTo(string) == 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Vector getSortingColumns() {
        return this.sortingColumns;
    }

    public String[] getStatusURLs() {
        return this.statusURLs;
    }

    public String getURL(int n, int n2) {
        String string = null;
        if (!this.vertical) {
            if (this.dataURLs.length > n2 - 1) {
                string = this.dataURLs[n2];
            }
        } else if (this.dataURLs.length > n - 1) {
            int n3 = this.rowsMapping != null ? this.rowsMapping[n] : n;
            string = this.dataURLs[n3];
        }
        return string;
    }

    public Object getValueAt(int n, int n2) {
        if (this.vertical) {
            return this.getRawValueAt(n, n2);
        }
        if (n < 0 || n >= this.indexes.length) {
            return null;
        }
        return this.getRawValueAt(this.indexes[n], n2);
    }

    public boolean getVertical() {
        return this.vertical;
    }

    private ArrayList[] initArrayList(int n) {
        ArrayList[] arrayListArray = new ArrayList[n];
        int n2 = 0;
        while (n2 < n) {
            arrayListArray[n2] = new ArrayList();
            ++n2;
        }
        return arrayListArray;
    }

    public void initColInternalNames() {
        this.internalNames = new String[this.realNumColumns];
        this.headerNames = new String[this.realNumColumns];
        int n = 0;
        while (n < this.realNumColumns) {
            String string = this.dataURLs[n];
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            String string2 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            }
            this.internalNames[n] = string2;
            this.headerNames[n] = this.ownerTable.getColumnHeading(this.tableNumber, n);
            ++n;
        }
    }

    public boolean isCellEditable(int n, int n2) {
        if (!this.allowEdit) {
            return false;
        }
        if (this.vertical) {
            if (n < 0 || n > this.columnCount) {
                return false;
            }
            if (n2 == 0) {
                return false;
            }
            if (this.accessValues.isEmpty()) {
                return false;
            }
            return (Boolean)this.accessValues.elementAt(n);
        }
        if (this.accessValues.isEmpty()) {
            return false;
        }
        if (n2 < 0 || n2 > this.accessValues.size()) {
            return false;
        }
        boolean bl = (Boolean)this.accessValues.elementAt(n2);
        return bl;
    }

    private void mapCellData(boolean bl) {
        if (this.isLarge) {
            return;
        }
        if (this.rawCellData == null || this.rawCellData.size() == 0) {
            return;
        }
        this.cellData = new Vector();
        this.cellData = this.filteringData(this.rawCellData, true);
        int n = 0;
        if (this.vertical) {
            if (this.cellData.size() > 1) {
                n = ((Vector)this.cellData.elementAt(1)).size();
            }
            this.columnCount = n;
            this.rowCount = this.cellData.size();
            this.updatedRowCount = n;
        } else {
            this.updatedColumnCount = this.rowCount = (n = this.cellData.size());
            if (this.cellData.size() > 0 && this.cellData.elementAt(0) != null) {
                this.updatedRowCount = this.columnCount = ((Vector)this.cellData.elementAt(0)).size();
            }
        }
        this.indexes = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.indexes[n2] = n;
            ++n2;
        }
        this.rowsMapping = new int[this.sevMapping.size()];
        int n3 = 0;
        while (n3 < this.sevMapping.size()) {
            this.rowsMapping[n3] = (Integer)this.sevMapping.get(n3);
            ++n3;
        }
        if (bl) {
            this.fireFilterChange(true);
        }
        this.fireTableDataChanged();
        this.reSortingColumn();
    }

    protected void reSortingColumn() {
        if (this.vertical || this.isLarge) {
            return;
        }
        Vector vector = this.getSortingColumns();
        if (vector.size() > 0) {
            int n = (Integer)vector.get(0);
            if (n == -1) {
                return;
            }
            CvTblTableColumn cvTblTableColumn = (CvTblTableColumn)this.ownTable.getColumnModel().getColumn(n);
            int n2 = cvTblTableColumn.getStatus();
            boolean bl = n2 == CvTblTableColumn.ASCENDING;
            this.sortByColumn(n, bl, this.ownTable);
        }
    }

    protected void reallocateIndexes() {
        int n = this.getRowCount();
        this.reallocateIndexes(n);
    }

    protected void reallocateIndexes(int n) {
        this.indexes = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.indexes[n2] = n2;
            ++n2;
        }
    }

    public void removeFilterListener(CvTblFilterListener cvTblFilterListener) {
        this.filterListeners.removeElement(cvTblFilterListener);
    }

    public void removeTableEventListener(CvTblTableEventListener cvTblTableEventListener) {
        this.tableEventListeners.removeElement(cvTblTableEventListener);
    }

    private boolean rowInAlarmFilter(ArrayList arrayList) {
        int n = 0;
        while (n < arrayList.size()) {
            if (this.alarmFilter.contains((Integer)arrayList.get(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void setAlarmFilter(String string) {
        this.alarmFilter.removeAllElements();
        if (string.indexOf("ERR") >= 0) {
            this.alarmFilter.add(new Integer(25));
        }
        if (string.indexOf("WRN") >= 0) {
            this.alarmFilter.add(new Integer(15));
        }
        if (string.indexOf("INF") >= 0) {
            this.alarmFilter.add(new Integer(5));
        }
        if (string.indexOf("DWN") >= 0) {
            this.alarmFilter.add(new Integer(29));
        }
        if (!this.firstSet) {
            this.mapCellData(false);
        }
    }

    public void setAlarmFont(Font font) {
        this.alarmFont = font != null ? font : CvTable.DEFAULT_ALARM_FONT;
    }

    protected void setAllCellProperties() {
        int n = 0;
        while (n < this.rowCount) {
            Vector vector = (Vector)this.cellData.elementAt(n);
            int n2 = 0;
            while (n2 < vector.size()) {
                Object e = vector.elementAt(n2);
                if (e instanceof CvTblCell) {
                    this.setCellProperties((CvTblCell)e);
                }
                ++n2;
            }
            ++n;
        }
        this.fireTableDataChanged();
    }

    public void setAllProperties(Font font, Font font2, Font font3, String string) {
        this.setAlarmFont(font3);
        this.setHeaderFont(font);
        this.setNormalFont(font2);
        this.alarmMode = string;
        this.setAllCellProperties();
    }

    public void setAllowEdit(boolean bl) {
        this.allowEdit = bl;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    protected void setCellProperties(CvTblCell cvTblCell) {
        if (cvTblCell != null) {
            cvTblCell.setHeaderFont(this.headerFont);
            cvTblCell.setNormalFont(this.normalFont);
            cvTblCell.setAlarmFont(this.alarmFont);
            cvTblCell.setForeground(this.foreground);
            cvTblCell.setBackground(this.background);
            cvTblCell.setAlarmMode(this.alarmMode);
        }
    }

    public void setCustomerEditor(int n, int n2, TableCellEditor tableCellEditor) {
        if (this.vertical) {
            this.customEditors[n] = tableCellEditor;
        } else {
            this.customEditors[n2] = tableCellEditor;
        }
    }

    public void setDataValue(int n, int n2, String string) {
        CvTblCell cvTblCell = (CvTblCell)this.getValueAt(n, n2);
        if (cvTblCell == null) {
            cvTblCell = new CvTblCell(false, string);
            this.setCellProperties(cvTblCell);
            this.setValueAt(cvTblCell, n, n2);
        } else {
            cvTblCell.setDataValue(string);
        }
        this.fireTableDataChanged();
    }

    public void setDataValues(String[][] stringArray) {
        boolean bl;
        Object object;
        int n;
        if (stringArray == null) {
            Object object2 = this.lock;
            synchronized (object2) {
                this.dataSetting = true;
                this.lock.notify();
            }
            return;
        }
        int n2 = 0;
        int n3 = n = this.getVertical() ? 1 : 0;
        if (this.indexURLs.length > 0) {
            this.indexValues = new String[stringArray[0].length];
            this.indexValues4URL = new String[stringArray[0].length];
            int n4 = 0;
            while (n4 < stringArray[0].length) {
                String string = stringArray[0][n4];
                object = this.escapeSpecialChars(string);
                int n5 = 1;
                while (n5 < this.indexURLs.length) {
                    string = String.valueOf(string) + "," + stringArray[n5][n4];
                    object = String.valueOf(object) + "," + this.escapeSpecialChars(stringArray[n5][n4]);
                    ++n5;
                }
                this.indexValues[n4] = string;
                this.indexValues4URL[n4] = object;
                ++n4;
            }
            n2 += this.indexURLs.length;
        }
        String[] stringArray2 = CvTable.removeBlankURLs(this.statusURLs);
        boolean bl2 = bl = this.isLarge || this.statusURLs.length == 0 || stringArray2 == null;
        if (!bl && this.vertical && this.firstSet) {
            this.rawCellData = this.filteringData(this.cellData, false);
        }
        this.firstSet = false;
        this.setTblData(stringArray, n2, n, bl);
        object = this.lock;
        synchronized (object) {
            this.dataSetting = true;
            this.lock.notify();
        }
    }

    public void setEditInfo(Vector vector, Vector vector2, Vector vector3, int n) {
        this.accessValues = vector;
        this.cEditorName = vector2;
        this.dFormats = vector3;
        this.customEditors = new TableCellEditor[n];
        int n2 = 0;
        while (n2 < n) {
            this.customEditors[n2] = null;
            ++n2;
        }
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public void setHeaderFont(Font font) {
        this.headerFont = font != null ? font : CvTable.DEFAULT_HEADER_FONT;
    }

    public void setIndexURLs(String[] stringArray) {
        this.indexURLs = stringArray;
    }

    public void setIsLarge(boolean bl) {
        this.isLarge = bl;
    }

    public void setNormalFont(Font font) {
        this.normalFont = font != null ? font : CvTable.DEFAULT_NORMAL_FONT;
    }

    public void setOwnTable(CvCommonTable cvCommonTable) {
        this.ownTable = cvCommonTable;
    }

    public void setRealNumColumns(int n) {
        int n2;
        String[] stringArray;
        if (this.realNumColumns < 0) {
            return;
        }
        this.realNumColumns = n;
        if (this.dataURLs == null) {
            this.dataURLs = new String[n];
        } else if (n < this.dataURLs.length) {
            stringArray = new String[n];
            n2 = 0;
            while (n2 < n) {
                stringArray[n2] = this.dataURLs[n2];
                ++n2;
            }
            this.dataURLs = stringArray;
        } else if (n > this.dataURLs.length) {
            stringArray = new String[n];
            n2 = 0;
            while (n2 < this.dataURLs.length) {
                stringArray[n2] = this.dataURLs[n2];
                ++n2;
            }
            this.dataURLs = stringArray;
        }
        if (this.statusURLs == null) {
            this.statusURLs = new String[n];
        } else if (n < this.statusURLs.length) {
            stringArray = new String[n];
            n2 = 0;
            while (n2 < n) {
                stringArray[n2] = this.statusURLs[n2];
                ++n2;
            }
            this.statusURLs = stringArray;
        } else if (n > this.statusURLs.length) {
            stringArray = new String[n];
            n2 = 0;
            while (n2 < this.statusURLs.length) {
                stringArray[n2] = this.statusURLs[n2];
                ++n2;
            }
            this.statusURLs = stringArray;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void setStatusValues(SMAlarmStatusData[][] var1_1) {
        try {
            if (var1_1 == null) {
                this.dataSetting = false;
                return;
            }
            var2_2 = this.lock;
            synchronized (var2_2) {
                if (!this.dataSetting && !this.isLarge) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException v0) {
                        this.dataSetting = false;
                    }
                }
                this.dataSetting = false;
            }
            var2_2 = this.isLarge != false ? this.cellData : this.rawCellData;
            var3_4 = 0;
            var4_5 = this.getVertical() == true ? 1 : 0;
            var5_6 = this.vertical != false ? this.dataURLs.length : var1_1[0].length;
            this.rowsSeverity = this.initArrayList(var5_6);
            var6_7 = new int[var5_6];
            var7_8 = new SMAlarmStatusData[var5_6];
            if (var1_1[0].length == 0) {
                this.updatedColumnCount = 0;
                this.fireTableDataChanged();
                return;
            }
            var8_9 = 0;
            while (var8_9 < var1_1.length) {
                var9_10 = 0;
                while (var9_10 < var1_1[var8_9].length) {
                    block24: {
                        var10_11 = null;
                        var11_12 = var1_1[var8_9][var9_10].getSeverity();
                        var12_13 = var4_5 + this.getRowFromIndexValue(var1_1[var8_9][var9_10].getObjectId());
                        if (var12_13 != -1) ** GOTO lbl39
                        break block24;
lbl-1000:
                        // 1 sources

                        {
                            ++var3_4;
lbl39:
                            // 2 sources

                            ** while (this.statusURLs[var3_4] == null || this.statusURLs[var3_4].length() == 0)
                        }
lbl40:
                        // 1 sources

                        v2 = var13_14 = this.vertical != false ? var3_4 : var12_13;
                        if (!var1_1[var8_9][var9_10].getState().equals("ACK")) {
                            var14_15 = var1_1[var8_9][var9_10].getState();
                            var15_16 = this.state2severity((String)var14_15);
                            this.rowsSeverity[var13_14].add(new Integer(var15_16));
                            if (var6_7[var13_14] < var11_12) {
                                var6_7[var13_14] = var11_12;
                                var7_8[var13_14] = var1_1[var8_9][var9_10];
                            }
                        }
                        if (var12_13 < var2_2.size() && var3_4 < ((Vector)var2_2.elementAt(var12_13)).size()) {
                            var14_15 = (Vector)var2_2.elementAt(var12_13);
                            var10_11 = (CvTblCell)var14_15.elementAt(var3_4);
                        }
                        if ((var14_15 = this.statusURLs[var3_4]) != null && var14_15.length() > 0) {
                            if (var10_11 == null) {
                                var10_11 = new CvTblCell(false, var1_1[var8_9][var9_10]);
                                this.setCellProperties(var10_11);
                                if (this.isLarge) {
                                    this.setValueAt(var10_11, var12_13, var3_4);
                                } else {
                                    this.setValueAt(var10_11, var12_13, var3_4, (Vector)var2_2);
                                }
                                if (this.ownerTable != null) {
                                    var10_11.setColumnHeading(this.ownerTable.getColumnHeading(this.tableNumber, var3_4));
                                }
                            } else {
                                var10_11.setAlarmStatus(var1_1[var8_9][var9_10]);
                            }
                        }
                    }
                    ++var9_10;
                }
                ++var3_4;
                ++var8_9;
            }
            this.drawAlarmIcon((Vector)var2_2, var7_8);
            if (!this.isLarge) {
                this.mapCellData(true);
            } else {
                this.fireTableDataChanged();
            }
        }
        catch (Exception var2_3) {
            var2_3.printStackTrace();
        }
    }

    public void setTblData(String[][] stringArray, int n, int n2, boolean bl) {
        int n3;
        int n4;
        int n5;
        Vector vector = new Vector();
        if (bl) {
            this.reallocateIndexes(stringArray[0].length);
            vector = this.cellData;
        } else {
            if (!this.vertical && stringArray[0].length < this.rawCellData.size()) {
                n5 = stringArray[0].length;
                while (n5 < this.rawCellData.size()) {
                    this.rawCellData.removeElementAt(n5);
                    ++n5;
                }
            }
            vector = this.rawCellData;
        }
        n5 = n;
        while (n5 < stringArray.length) {
            n4 = 0;
            while (n4 < stringArray[n5].length) {
                Object object;
                n3 = n4 + n2;
                int n6 = n5 - n;
                CvTblCell cvTblCell = null;
                if (n3 < vector.size() && n6 < ((Vector)vector.elementAt(n3)).size()) {
                    object = (Vector)vector.elementAt(n3);
                    cvTblCell = (CvTblCell)((Vector)object).elementAt(n6);
                }
                if ((object = this.dataURLs[n6]) != null && ((String)object).length() > 0) {
                    if (cvTblCell == null) {
                        cvTblCell = new CvTblCell(false, stringArray[n5][n4]);
                        this.setCellProperties(cvTblCell);
                        if (bl) {
                            this.setValueAt(cvTblCell, n3, n6);
                        } else {
                            this.setValueAt(cvTblCell, n3, n6, vector);
                        }
                        if (this.ownerTable != null) {
                            cvTblCell.setColumnHeading(this.ownerTable.getColumnHeading(this.tableNumber, n6));
                        }
                    } else {
                        cvTblCell.setDataValue(stringArray[n5][n4]);
                    }
                }
                ++n4;
            }
            ++n5;
        }
        if (!this.isLarge) {
            this.rowsSeverity = this.vertical ? this.initArrayList(stringArray.length) : this.initArrayList(stringArray[0].length);
        }
        if (bl) {
            if (stringArray != null && stringArray.length != 0 && stringArray[0] != null) {
                this.updatedColumnCount = stringArray[0].length;
                this.updatedRowCount = stringArray.length;
            }
            n4 = this.vertical ? this.updatedRowCount : this.updatedColumnCount;
            this.rowsMapping = new int[n4];
            n3 = 0;
            while (n3 < n4) {
                this.rowsMapping[n3] = n3;
                ++n3;
            }
            if (!this.isLarge && this.alarmFilter.size() > 0) {
                if (this.vertical) {
                    this.updatedRowCount = 0;
                } else {
                    this.updatedColumnCount = 0;
                }
            }
            if (!this.isLarge) {
                this.fireFilterChange(false);
            }
            this.fireTableDataChanged();
            this.rawCellData = this.cellData;
            this.reSortingColumn();
        }
    }

    public void setURLs(int n, String string, String string2) {
        if (n >= 0 && n < this.realNumColumns) {
            this.dataURLs[n] = string;
            this.statusURLs[n] = string2;
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        Serializable serializable;
        int n3;
        if (!this.vertical) {
            n = this.indexes[n];
        }
        if (n < 0 || n2 < 0) {
            return;
        }
        if (this.vertical && n > this.rowCount - 1 && n > 1) {
            n3 = 0;
            while (n3 <= n - this.rowCount) {
                serializable = new CvTblTableEvent(this, 4, "", "", 0, n + n3);
                int n4 = 0;
                while (n4 < this.tableEventListeners.size()) {
                    Object e = this.tableEventListeners.elementAt(n4);
                    ((CvTblTableEventListener)e).tableEventOccurred((CvTblTableEvent)serializable);
                    ++n4;
                }
                ++n3;
            }
        }
        if (n >= this.rowCount) {
            n3 = 0;
            while (n3 <= n - this.rowCount) {
                serializable = new Vector();
                serializable.setSize(this.columnCount);
                this.cellData.addElement(serializable);
                ++n3;
            }
            this.rowCount = n + 1;
        }
        n3 = 0;
        while (n3 < this.rowCount) {
            serializable = (Vector)this.cellData.elementAt(n3);
            if (n2 >= serializable.size()) {
                serializable.setSize(n2 + 1);
            }
            ++n3;
        }
        this.columnCount = ((Vector)this.cellData.elementAt(0)).size();
        ((Vector)this.cellData.elementAt(n)).setElementAt(object, n2);
    }

    public void setValueAt(Object object, int n, int n2, Vector vector) {
        Vector vector2;
        int n3;
        int n4 = vector.size();
        int n5 = 0;
        if (vector.size() > 0) {
            n5 = ((Vector)vector.elementAt(0)).size();
        }
        if (n >= n4) {
            n3 = 0;
            while (n3 <= n - n4) {
                vector2 = new Vector();
                vector2.setSize(n5);
                vector.addElement(vector2);
                ++n3;
            }
            n4 = n + 1;
        }
        n3 = 0;
        while (n3 < n4) {
            vector2 = (Vector)vector.elementAt(n3);
            if (n2 >= vector2.size()) {
                vector2.setSize(n2 + 1);
            }
            ++n3;
        }
        ((Vector)vector.elementAt(n)).setElementAt(object, n2);
    }

    public void setVertical(boolean bl) {
        this.vertical = bl;
    }

    public void shrinkSize(int n) {
        if (n > this.updatedColumnCount) {
            return;
        }
        this.updatedRowCount = this.dataURLs.length;
        this.updatedColumnCount = n;
        this.fireTableDataChanged();
    }

    protected void shuttlesort(int[] nArray, int[] nArray2, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n + n2) / 2;
        this.shuttlesort(nArray2, nArray, n, n3);
        this.shuttlesort(nArray2, nArray, n3, n2);
        int n4 = n;
        int n5 = n3;
        if (n2 - n >= 4 && this.compare(nArray[n3 - 1], nArray[n3]) <= 0) {
            int n6 = n;
            while (n6 < n2) {
                nArray2[n6] = nArray[n6];
                ++n6;
            }
            return;
        }
        int n7 = n;
        while (n7 < n2) {
            nArray2[n7] = n5 >= n2 || n4 < n3 && this.compare(nArray[n4], nArray[n5]) <= 0 ? nArray[n4++] : nArray[n5++];
            ++n7;
        }
    }

    public void sort(Object object) {
        this.reallocateIndexes();
        this.checkModel();
        this.compares = 0;
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
    }

    public void sortByColumn(int n, boolean bl, CvCommonTable cvCommonTable) {
        if (this.isLarge) {
            return;
        }
        this.ascending = bl;
        this.sortingColumns.removeAllElements();
        this.sortingColumns.addElement(new Integer(n));
        this.sort(this);
        this.tableChanged(new TableModelEvent(this));
    }

    private int state2severity(String string) {
        if (string.equals("ERR")) {
            return 25;
        }
        if (string.equals("WRN")) {
            return 15;
        }
        if (string.equals("INF")) {
            return 5;
        }
        if (string.equals("DIS")) {
            return 29;
        }
        return 0;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.fireTableChanged(tableModelEvent);
    }

    protected void updateRowNumber(int n) {
        this.updatedRowCount = n;
        this.fireTableDataChanged();
    }
}

