/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.table;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRequestStatus;
import com.sun.symon.base.client.alarm.SMAlarmStatusData;
import com.sun.symon.base.client.console.SMConsoleContext;
import com.sun.symon.base.client.console.SMContextPopupEvent;
import com.sun.symon.base.client.console.SMContextPopupItem;
import com.sun.symon.base.client.console.SMMenuGenerator;
import com.sun.symon.base.client.console.SMObjectDetailContext;
import com.sun.symon.base.client.console.SMTblSelectionInfo;
import com.sun.symon.base.client.table.SMTableColumnFormat;
import com.sun.symon.base.client.table.SMTableFormat;
import com.sun.symon.base.client.table.SMTableRequest;
import com.sun.symon.base.client.table.SMTableResponse;
import com.sun.symon.base.client.topology.SMFamilyCommands;
import com.sun.symon.base.console.awx.AwxServiceManager;
import com.sun.symon.base.console.awx.AwxServiceProvider;
import com.sun.symon.base.console.didgets.CdEnableFilter;
import com.sun.symon.base.console.didgets.CdGlobalAlarmEvent;
import com.sun.symon.base.console.didgets.CdGlobalAlarmListener;
import com.sun.symon.base.console.didgets.CdPropValueEditor;
import com.sun.symon.base.console.didgets.CdPropValueEditorPane;
import com.sun.symon.base.console.views.CvContextPopupEvent;
import com.sun.symon.base.console.views.CvContextPopupListener;
import com.sun.symon.base.console.views.CvNavigationListener;
import com.sun.symon.base.console.views.CvPresentationView;
import com.sun.symon.base.console.views.CvSelectionInfo;
import com.sun.symon.base.console.views.table.CvCommonTable;
import com.sun.symon.base.console.views.table.CvTableContainer;
import com.sun.symon.base.console.views.table.CvTableSelectEvent;
import com.sun.symon.base.console.views.table.CvTableSelectListener;
import com.sun.symon.base.console.views.table.CvTblAlarmEvent;
import com.sun.symon.base.console.views.table.CvTblAlarmFilter;
import com.sun.symon.base.console.views.table.CvTblAlarmListener;
import com.sun.symon.base.console.views.table.CvTblCell;
import com.sun.symon.base.console.views.table.CvTblFilterListener;
import com.sun.symon.base.console.views.table.CvTblSlider;
import com.sun.symon.base.console.views.table.CvTblTable;
import com.sun.symon.base.console.views.table.CvTblTableColumn;
import com.sun.symon.base.console.views.table.CvTblTableEvent;
import com.sun.symon.base.console.views.table.CvTblTableEventListener;
import com.sun.symon.base.console.views.table.CvTblTableHeader;
import com.sun.symon.base.console.views.table.CvTblTableModel;
import com.sun.symon.base.console.views.table.CvTooBigNotify;
import com.sun.symon.base.utility.UcAgentURL;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class CvTable
extends JScrollPane
implements CvPresentationView,
CvTblTableEventListener,
CvTableContainer,
SMTableResponse,
CvTblAlarmListener,
CdGlobalAlarmListener,
AwxServiceManager,
MouseListener {
    private AwxServiceProvider SvcProvider = null;
    public static final String ALARMMODE_DOT_LEFT = "dot_left";
    public static final String ALARMMODE_DOT_RIGHT = "dot_right";
    public static final String ALARMMODE_BACKGROUND = "background";
    protected static final String DEFAULT_ALARM_MODE = "background";
    protected static final Font DEFAULT_ALARM_FONT = new Font("dialog", 0, 12);
    protected static final Font DEFAULT_HEADER_FONT = new Font("dialog", 0, 12);
    protected static final Font DEFAULT_SORT_HEADER_FONT = new Font("dialog", 1, 12);
    protected static final Font DEFAULT_NORMAL_FONT = new Font("dialog", 0, 12);
    protected static final Font DEFAULT_TITLE_FONT = new Font("dialog", 3, 14);
    protected static final int DEFAULT_TABLE_WIDTH = 220;
    protected static final int DEFAULT_COLUMN_WIDTH = 110;
    protected static final int MIN_COLUMN_WIDTH = 110;
    protected static final int LARGE_SIZE = 50;
    public static final int PAGE = 50;
    protected static final int DEFAULT_TITLE_JUSTIFICATION = 2;
    private Font normalFont = DEFAULT_NORMAL_FONT;
    private Font alarmFont = DEFAULT_ALARM_FONT;
    private Font headerFont = DEFAULT_HEADER_FONT;
    private Font titleFont = DEFAULT_TITLE_FONT;
    private SMTableFormat[] tableFormat = null;
    private CvTblTableModel[] tableModels = null;
    private CvTblTable[] tables = null;
    private CvTblAlarmFilter[] filters = null;
    private Vector sliders = new Vector();
    private JLabel[] tableTitles = null;
    private Object[] dataRequests = null;
    private Object[] statusRequests = null;
    private Object layoutRequest = null;
    private Vector selectListeners = new Vector();
    private Vector navigationListeners = new Vector();
    private Vector contextPopupListeners = new Vector();
    private JPanel tableHolder = new JPanel();
    private SMTableRequest dataSource = null;
    private SMRawDataRequest origDataSource = null;
    private String alarmMode = "background";
    private String stdRefreshPeriod = "never";
    private String fragment = "";
    private String managedObjectUrl = "";
    private String topologyUrl = null;
    private String nodeName = null;
    SMObjectDetailContext objectContext;
    private int visibleLines = -1;
    private boolean fragmentMode = false;
    private boolean initialized = false;
    private boolean valueSet = false;
    private boolean allowEdit = true;
    private boolean showHeader = true;
    private int maxDataWidth = 0;
    private int tableWidth = 220;
    private int defaultColumnWidth = 110;
    private Color titleBackground = new Color(102, 96, 170);
    private Color titleForeground = Color.white;
    private Color tableBackground = Color.white;
    private Color tableForeground = Color.black;
    private Color gridColor = Color.black;
    private boolean showHorizontalLines = true;
    private boolean showVerticalLines = true;
    private int titleJustification = 2;
    private String updated = "";
    private String alarmFilter;
    boolean alarmFilterEnabled;
    private CdEnableFilter alarmMenuObj;
    private boolean showFilter = false;
    private Icon acknowledgedIcon = null;
    private String i18nProperty = UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:table.i18nProperty");
    private String i18nValue = UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:table.i18nValue");
    private boolean cellSelectionAllowed = false;
    private boolean allowSelection = true;
    private boolean selectClearInProgress = false;
    public boolean tooBigDialogShowing = false;
    public boolean fromMDR = false;
    CdPropValueEditor editor = null;

    public CvTable() {
        this.tableHolder.setLayout(new BoxLayout(this.tableHolder, 1));
        this.tableHolder.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.getViewport().add(this.tableHolder);
        this.tableHolder.setOpaque(true);
        this.updated = UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:standard.updated");
        int n = ((Component)this).getFontMetrics(this.normalFont).getAscent() + ((Component)this).getFontMetrics(this.normalFont).getDescent() + 4;
        this.getHorizontalScrollBar().setUnitIncrement(n);
        this.getVerticalScrollBar().setUnitIncrement(n);
    }

    public void addCvContextPopupListener(CvContextPopupListener cvContextPopupListener) {
        this.contextPopupListeners.addElement(cvContextPopupListener);
    }

    public void addCvNavigationListener(CvNavigationListener cvNavigationListener) {
        this.navigationListeners.addElement(cvNavigationListener);
    }

    public void addCvTableSelectListener(CvTableSelectListener cvTableSelectListener) {
        this.selectListeners.addElement(cvTableSelectListener);
    }

    public void alarmFilterChanged(CvTblAlarmEvent cvTblAlarmEvent) {
        Object object;
        if (!this.showFilter) {
            return;
        }
        if (this.SvcProvider != null && this.alarmFilterEnabled && (object = new String[]{cvTblAlarmEvent.getAlarmFilter()})[0] != null) {
            this.SvcProvider.triggerService("alarmFilter", (String[])object);
        }
        if (this.alarmFilterEnabled) {
            int n = 0;
            while (n < this.tableModels.length) {
                this.tableModels[n].setAlarmFilter(cvTblAlarmEvent.getAlarmFilter());
                this.filters[n].setFilter(cvTblAlarmEvent.getAlarmFilter());
                ++n;
            }
            int n2 = 0;
            while (n2 < this.sliders.size()) {
                ((CvTblSlider)this.sliders.elementAt(n2)).setAlarmFilter(cvTblAlarmEvent.getAlarmFilter());
                ++n2;
            }
        } else {
            object = (CvTblTable)cvTblAlarmEvent.getSource();
            CvTblTableModel cvTblTableModel = (CvTblTableModel)((JTable)object).getModel();
            cvTblTableModel.setAlarmFilter(cvTblAlarmEvent.getAlarmFilter());
            if (cvTblTableModel.getIsLarge()) {
                ((CvTblTable)object).getSlider().setAlarmFilter(cvTblAlarmEvent.getAlarmFilter());
            }
        }
    }

    public void busyStart() {
        if (this.SvcProvider != null) {
            this.SvcProvider.triggerService("busyStart");
        }
    }

    public void busyStop() {
        if (this.SvcProvider != null) {
            this.SvcProvider.triggerService("busyEnd");
        }
    }

    private Color calculateAlternateColour(Color color) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return new Color(Color.HSBtoRGB(fArray[0], fArray[1], fArray[2] * 0.9f));
    }

    public void cleanFootMessage() {
        if (this.SvcProvider != null) {
            String[] stringArray = new String[]{""};
            this.SvcProvider.triggerService("message", stringArray);
        }
    }

    public void clearSelection() {
        if (this.tables == null) {
            return;
        }
        int n = 0;
        while (n < this.tables.length) {
            if (this.tables[n] != null) {
                this.tables[n].setHeaderSelected(false);
                this.tables[n].clearSelection();
            }
            ++n;
        }
        this.revalidate();
        this.repaint();
        this.setIsForColumn(false);
    }

    public int columnHeaderWidth(JTable jTable, TableColumn tableColumn) {
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        Component component = tableCellRenderer.getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), false, false, 0, 0);
        return component.getPreferredSize().width;
    }

    public void displayFootMessage() {
        this.displayFootMessage("base.console.ConsoleMessages:console.loading");
    }

    public void displayFootMessage(String string) {
        if (this.SvcProvider != null) {
            String[] stringArray = new String[]{UcInternationalizer.translateKey((String)string)};
            this.SvcProvider.triggerService("message", stringArray);
        }
    }

    public void doLayout() {
        this.tableHolder.setSize(this.tableHolder.getPreferredSize());
        this.layoutTitles();
        super.doLayout();
    }

    public Icon getAcknowledgedIcon() {
        return this.acknowledgedIcon;
    }

    public Font getAlarmFont() {
        return this.alarmFont;
    }

    public String getAlarmMode() {
        return this.alarmMode;
    }

    public String getColumnHeading(int n, int n2) {
        if (this.tableFormat == null || n < 0 || n >= this.tableFormat.length) {
            return "";
        }
        SMTableColumnFormat sMTableColumnFormat = this.tableFormat[n].getColumn(n2);
        return sMTableColumnFormat != null ? sMTableColumnFormat.getColumnHeading() : "";
    }

    public SMContextPopupEvent getDataViewInfo() {
        if (this.tables != null) {
            int n = 0;
            while (n < this.tables.length) {
                CvSelectionInfo cvSelectionInfo;
                if (this.tables[n] != null && (cvSelectionInfo = this.tables[n].getSelectionInfo(this, this.getTableFormat(n))) != null) {
                    SMTblSelectionInfo sMTblSelectionInfo = this.tables[n].getContextSelection();
                    SMContextPopupEvent sMContextPopupEvent = new SMContextPopupEvent(this.tables[n], sMTblSelectionInfo, cvSelectionInfo.ContextInfo.getNodeName(), cvSelectionInfo.ContextInfo.getTargetUrl(), sMTblSelectionInfo.getSelectedRow(), sMTblSelectionInfo.getSelectedColumn(), this.objectContext);
                    return sMContextPopupEvent;
                }
                ++n;
            }
        }
        return null;
    }

    public int getDefaultColumnWidth() {
        return this.defaultColumnWidth;
    }

    public String getExclusionsFor(int n, int n2) {
        if (this.tableFormat == null || n < 0 || n >= this.tableFormat.length) {
            return null;
        }
        SMTableColumnFormat sMTableColumnFormat = this.tableFormat[n].getColumn(n2);
        return sMTableColumnFormat != null ? sMTableColumnFormat.getExclusionList() : null;
    }

    public String getFragment() {
        return this.fragment;
    }

    public boolean getFragmentMode() {
        return this.fragmentMode;
    }

    public Font getHeaderFont() {
        return this.headerFont;
    }

    public Insets getInsets() {
        return new Insets(2, 4, 4, 4);
    }

    public String getManagedObjectUrl() {
        return this.managedObjectUrl;
    }

    public Font getNormalFont() {
        return this.normalFont;
    }

    public int getNumTables() {
        return this.tableFormat != null ? this.tableFormat.length : 0;
    }

    public int getNumberColumnsForTable(int n) {
        if (n < 0 || this.tableFormat == null) {
            return 0;
        }
        return n < this.tableFormat.length ? this.tableFormat[n].getNumColumns() : 0;
    }

    public Dimension getPreferredSize() {
        Serializable serializable;
        Dimension dimension = new Dimension(0, 0);
        int n = 0;
        while (n < this.tableHolder.getComponentCount()) {
            serializable = this.tableHolder.getComponent(n);
            Dimension dimension2 = serializable.getPreferredSize();
            dimension.width = dimension.width < dimension2.width ? dimension2.width : dimension.width;
            dimension.height += dimension2.height + 26;
            ++n;
        }
        this.tableHolder.setSize(dimension);
        serializable = this.getInsets();
        dimension.width += ((Insets)serializable).left + ((Insets)serializable).right + 2;
        dimension.height += ((Insets)serializable).top + ((Insets)serializable).bottom + 2;
        return dimension;
    }

    public CvSelectionInfo getSelectionInfo() {
        if (this.tables != null) {
            int n = 0;
            while (n < this.tables.length) {
                CvSelectionInfo cvSelectionInfo = this.tables[n].getSelectionInfo(this, this.getTableFormat(n));
                if (cvSelectionInfo != null) {
                    return cvSelectionInfo;
                }
                ++n;
            }
        }
        return null;
    }

    public boolean getShowHeader() {
        return this.showHeader;
    }

    public String getStdRefreshPeriod() {
        return this.stdRefreshPeriod;
    }

    public CvTblTable getTable(int n) {
        return n >= 0 && n < this.tables.length ? this.tables[n] : null;
    }

    public void getTableAlarmStatusResponse(SMRequestStatus sMRequestStatus, SMAlarmStatusData[][] sMAlarmStatusDataArray, Object object) {
        if (sMRequestStatus.getReturnCode() != 0) {
            if (sMRequestStatus.getMessageText().indexOf("SNMP request returned error status 1 (too big)") != -1) {
                UcDDL.logErrorMessage((String)("Too Big Error receiving table alarm status data for table with url " + this.managedObjectUrl));
                UcDDL.logErrorMessage((String)"Maximum SNMP packet size (64kB) was exceeded.");
                if (this.tooBigDialogShowing) {
                    return;
                }
                Thread thread = new Thread((Runnable)new CvTooBigNotify(this), "tooBigNotify");
                thread.start();
            } else if (sMRequestStatus.getReturnCode() == 1) {
                UcDDL.logErrorMessage((String)("Security Error receiving alarm status data for table with url " + this.managedObjectUrl));
            } else if (sMRequestStatus.getReturnCode() == 2) {
                UcDDL.logErrorMessage((String)("Invalid Url Error receiving alarm status data for table with url " + this.managedObjectUrl));
            } else {
                UcDDL.logErrorMessage((String)("Data Request Error receiving alarm status data for table with url " + this.managedObjectUrl));
            }
            return;
        }
        if (sMRequestStatus == null || object == null || sMAlarmStatusDataArray == null || sMAlarmStatusDataArray.length == 0) {
            if (sMRequestStatus == null) {
                UcDDL.logErrorMessage((String)("Null status received while retrieving alarm status data for table with url " + this.managedObjectUrl));
            }
            if (object == null) {
                UcDDL.logErrorMessage((String)("Null object identifier received while retrieving alarm status data for table with url " + this.managedObjectUrl));
            }
            if (sMAlarmStatusDataArray == null || sMAlarmStatusDataArray.length == 0) {
                UcDDL.logErrorMessage((String)("Null data received while retrieving alarm status data for table with url " + this.managedObjectUrl));
            }
            return;
        }
        if (!(object instanceof CvTblTableModel)) {
            return;
        }
        boolean bl = false;
        int n = 0;
        while (n < this.tableModels.length && !bl) {
            bl = this.tableModels[n].equals(object);
            ++n;
        }
        if (!bl) {
            return;
        }
        ((CvTblTableModel)object).setStatusValues(sMAlarmStatusDataArray);
    }

    public Color getTableBackground() {
        return this.tableBackground == null ? this.getBackground() : this.tableBackground;
    }

    private void getTableData() {
        this.shutdownDataRequests();
        if (this.fromMDR) {
            return;
        }
        if (this.getFragment().length() == 0 && this.getFragmentMode()) {
            return;
        }
        this.dataRequests = new Object[this.tableModels.length];
        this.statusRequests = new Object[this.tableModels.length];
        int n = 0;
        while (n < this.tableModels.length) {
            Object object;
            String string;
            CvTblTableModel cvTblTableModel = this.tableModels[n];
            SMTableFormat sMTableFormat = this.tableFormat[n];
            String string2 = string = sMTableFormat.getRefreshInterval() != "" ? sMTableFormat.getRefreshInterval() : this.getStdRefreshPeriod();
            if (cvTblTableModel.getIsLarge()) {
                object = this.tables[n];
                this.displayFootMessage();
                ((CvTblTable)object).getSlider().initTablePageRequest(string);
            } else {
                object = CvTable.removeBlankURLs(cvTblTableModel.getDataURLs());
                if (object != null) {
                    if (this.getFragmentMode()) {
                        int n2 = 0;
                        while (n2 < ((Object)object).length) {
                            object[n2] = String.valueOf(object[n2]) + "#" + this.getFragment();
                            ++n2;
                        }
                    }
                    try {
                        this.dataRequests[n] = this.dataSource.getTableFieldRequest((String[])object, sMTableFormat.getIsScalar() ^ true, string, (SMTableResponse)this, (Object)cvTblTableModel);
                        this.displayFootMessage();
                    }
                    catch (SMAPIException sMAPIException) {
                        UcDDL.logWarningMessage((String)"CvTable:getTableData - received exception getting table data", (Throwable)sMAPIException);
                        this.cleanFootMessage();
                    }
                }
                if ((object = CvTable.removeBlankURLs(cvTblTableModel.getStatusURLs())) != null) {
                    try {
                        this.statusRequests[n] = this.dataSource.getTableAlarmStatusRequest((String[])object, sMTableFormat.getIsScalar() ^ true, string, (SMTableResponse)this, (Object)cvTblTableModel);
                    }
                    catch (SMAPIException sMAPIException) {
                        UcDDL.logWarningMessage((String)"CvTable:getTableData - received exception getting table status", (Throwable)sMAPIException);
                    }
                }
            }
            ++n;
        }
    }

    public void getTableFieldResponse(SMRequestStatus sMRequestStatus, String[][] stringArray, Object object) {
        if (sMRequestStatus.getReturnCode() != 0) {
            if (sMRequestStatus.getMessageText().indexOf("SNMP request returned error status 1 (too big)") != -1) {
                UcDDL.logErrorMessage((String)("Too Big Error receiving table field data for table with url " + this.managedObjectUrl));
                UcDDL.logErrorMessage((String)"Maximum SNMP packet size (64kB) was exceeded.");
                if (this.tooBigDialogShowing) {
                    this.cleanFootMessage();
                    return;
                }
                Thread thread = new Thread((Runnable)new CvTooBigNotify(this), "tooBigNotify");
                thread.start();
            } else if (sMRequestStatus.getReturnCode() == 1) {
                UcDDL.logErrorMessage((String)("Security Error receiving table field data for table with url " + this.managedObjectUrl));
            } else if (sMRequestStatus.getReturnCode() == 2) {
                UcDDL.logErrorMessage((String)("Invalid Url Error receiving table field data for table with url " + this.managedObjectUrl));
            } else {
                UcDDL.logErrorMessage((String)("Data Request Error receiving table field data for table with url " + this.managedObjectUrl));
            }
            this.cleanFootMessage();
            return;
        }
        if (sMRequestStatus == null || object == null || stringArray == null || stringArray.length == 0) {
            if (sMRequestStatus == null) {
                UcDDL.logErrorMessage((String)("Null status received while retrieving field data for table with url " + this.managedObjectUrl));
            }
            if (object == null) {
                UcDDL.logErrorMessage((String)("Null object identifier received while retrieving field data for table with url " + this.managedObjectUrl));
            }
            if (stringArray == null || stringArray.length == 0) {
                UcDDL.logErrorMessage((String)("Null data received while retrieving field data for table with url " + this.managedObjectUrl));
            }
            this.cleanFootMessage();
            return;
        }
        if (!(object instanceof CvTblTableModel)) {
            this.cleanFootMessage();
            return;
        }
        boolean bl = false;
        CvCommonTable cvCommonTable = null;
        int n = 0;
        while (n < this.tableModels.length && !bl) {
            bl = this.tableModels[n].equals(object);
            if (bl) {
                cvCommonTable = this.tables[n];
            }
            ++n;
        }
        if (!bl) {
            this.cleanFootMessage();
            return;
        }
        ((CvTblTableModel)object).setDataValues(stringArray);
        if (stringArray == null || stringArray[0].length == 0) {
            cvCommonTable.clearSelection();
        }
        this.cleanFootMessage();
    }

    public Color getTableForeground() {
        return this.tableForeground == null ? this.getForeground() : this.tableForeground;
    }

    public SMTableFormat[] getTableFormat() {
        return this.tableFormat;
    }

    public SMTableFormat getTableFormat(int n) {
        if (n < 0 || this.tableFormat == null) {
            return null;
        }
        return n < this.tableFormat.length ? this.tableFormat[n] : null;
    }

    public void getTableLayoutResponse(SMRequestStatus sMRequestStatus, SMTableFormat[] sMTableFormatArray, Object object) {
        if (sMRequestStatus.getReturnCode() != 0) {
            if (sMRequestStatus.getMessageText().indexOf("SNMP request returned error status 1 (too big)") != -1) {
                UcDDL.logErrorMessage((String)("Too Big Error receiving layout data for table with url " + this.managedObjectUrl));
                UcDDL.logErrorMessage((String)"Maximum SNMP packet size (64kB) was exceeded.");
                if (this.tooBigDialogShowing) {
                    return;
                }
                Thread thread = new Thread((Runnable)new CvTooBigNotify(this), "tooBigNotify");
                thread.start();
            } else if (sMRequestStatus.getReturnCode() == 1) {
                UcDDL.logErrorMessage((String)("Security Error receiving layout data for table with url " + this.managedObjectUrl));
            } else if (sMRequestStatus.getReturnCode() == 2) {
                UcDDL.logErrorMessage((String)("Invalid Url Error receiving layout data for table with url " + this.managedObjectUrl));
            } else {
                UcDDL.logErrorMessage((String)("Data Request Error receiving layout data for table with url " + this.managedObjectUrl));
            }
            return;
        }
        if (sMRequestStatus == null || object == null || sMTableFormatArray == null || sMTableFormatArray.length == 0) {
            if (sMRequestStatus == null) {
                UcDDL.logErrorMessage((String)("Null status received while retrieving layout data for table with url " + this.managedObjectUrl));
            }
            if (object == null) {
                UcDDL.logErrorMessage((String)("Null object identifier received while retrieving layout data for table with url " + this.managedObjectUrl));
            }
            if (sMTableFormatArray == null || sMTableFormatArray.length == 0) {
                UcDDL.logErrorMessage((String)("Null data received while retrieving layout data for table with url " + this.managedObjectUrl + " -> " + (sMTableFormatArray == null ? "null" : String.valueOf(sMTableFormatArray.length))));
            }
            return;
        }
        if (object == this) {
            this.setTableFormat(sMTableFormatArray);
            this.setupTables();
            this.getTableData();
            this.layoutTitles();
        } else {
            UcDDL.logWarningMessage((String)"Invalid identifier for table layout");
        }
    }

    public int getTableWidth() {
        return this.tableWidth;
    }

    public Color getTitleBackground() {
        return this.titleBackground;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public Color getTitleForeground() {
        return this.titleForeground;
    }

    public int getTitleJustification() {
        return this.titleJustification;
    }

    public String getTopologyDomain() {
        if (this.topologyUrl == null) {
            return null;
        }
        UcAgentURL ucAgentURL = new UcAgentURL(this.topologyUrl);
        return ucAgentURL.getModuleSpec();
    }

    public int getVisibleLines() {
        return this.visibleLines;
    }

    public void globalAlarmChanged(CdGlobalAlarmEvent cdGlobalAlarmEvent) {
        this.alarmFilterEnabled = cdGlobalAlarmEvent.isGlobalSet();
        if (this.alarmFilterEnabled) {
            int n = 0;
            while (n < this.tableModels.length) {
                this.tableModels[n].setAlarmFilter(this.alarmFilter);
                ++n;
            }
            int n2 = 0;
            while (n2 < this.sliders.size()) {
                ((CvTblSlider)this.sliders.elementAt(n2)).setAlarmFilter(this.alarmFilter);
                ++n2;
            }
        }
    }

    public void init() {
        this.initialized = true;
        if (!this.alarmFilterEnabled) {
            this.alarmFilter = "";
        }
        this.initObjectContext();
        if (this.tableFormat == null) {
            this.setFragmentMode(false);
            try {
                this.layoutRequest = this.dataSource.getTableLayoutRequest(this.managedObjectUrl, (SMTableResponse)this, (Object)this);
            }
            catch (SMAPIException sMAPIException) {
                UcDDL.logWarningMessage((String)"CvTable:init - got exception getting table layout", (Throwable)sMAPIException);
            }
        } else {
            boolean bl = true;
            int n = 0;
            while (n < this.tableFormat.length) {
                bl &= this.tableFormat[n].getIsVertical() ^ true;
                ++n;
            }
            if (!bl) {
                this.setFragmentMode(false);
            }
            this.setupTables();
            this.getTableData();
        }
    }

    public void initObjectContext() {
        this.objectContext = new SMObjectDetailContext(this.nodeName, this.managedObjectUrl, SMConsoleContext.getInstance());
        try {
            if (this.managedObjectUrl == null || this.managedObjectUrl.equals("")) {
                return;
            }
            boolean bl = this.origDataSource.isAgentVersionNotLower(this.managedObjectUrl, "3.0");
            if (!bl) {
                this.showFilter = false;
            }
        }
        catch (SMAPIException sMAPIException) {}
    }

    private void layoutTitles() {
        if (this.tableTitles != null && this.tables != null) {
            int n = 0;
            while (n < this.tableTitles.length) {
                if (this.tableTitles[n] != null && this.tables[n] != null) {
                    JLabel jLabel = this.tableTitles[n];
                    Dimension dimension = this.tables[n].getSize();
                    Dimension dimension2 = jLabel.getSize();
                    Dimension dimension3 = new Dimension(dimension2.width, dimension2.height);
                    jLabel.setSize(dimension3);
                }
                ++n;
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.clearSelection();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void registerServiceProvider(AwxServiceProvider awxServiceProvider) {
        this.SvcProvider = awxServiceProvider;
    }

    public static String[] removeBlankURLs(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            n += stringArray[n2] != null && stringArray[n2].length() > 0 ? 1 : 0;
            ++n2;
        }
        if (n == 0) {
            return null;
        }
        String[] stringArray2 = new String[n];
        n = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (stringArray[n3] != null && stringArray[n3].length() > 0) {
                stringArray2[n++] = stringArray[n3];
            }
            ++n3;
        }
        return stringArray2;
    }

    public void removeCvContextPopupListener(CvContextPopupListener cvContextPopupListener) {
        this.contextPopupListeners.removeElement(cvContextPopupListener);
    }

    public void removeCvNavigationListener(CvNavigationListener cvNavigationListener) {
        this.navigationListeners.removeElement(cvNavigationListener);
    }

    public void removeCvTableSelectListener(CvTableSelectListener cvTableSelectListener) {
        this.selectListeners.removeElement(cvTableSelectListener);
    }

    public void saveAgentData(CvTblTableModel cvTblTableModel, int n, int n2, String string, String string2, int n3) {
        boolean bl = n3 == 1;
        String string3 = cvTblTableModel.getDataValue(n, n2);
        cvTblTableModel.setDataValue(n, n2, string);
        Thread thread = new Thread((Runnable)new SaveDataThread(cvTblTableModel, n, n2, string, string2, bl, this, this.origDataSource, string3), "saveValue");
        thread.start();
    }

    public void setAcknowledgedIcon(Icon icon) {
        this.acknowledgedIcon = icon;
        if (this.tables != null) {
            int n = 0;
            while (n < this.tables.length) {
                this.tables[n].setAcknowledgedIcon(icon);
                ++n;
            }
        }
    }

    public void setAlarmFilter(String string) {
        if (string == null) {
            return;
        }
        this.alarmFilter = string;
    }

    public void setAlarmFont(Font font) {
        this.alarmFont = font != null ? font : DEFAULT_ALARM_FONT;
        this.updateModelProperties();
    }

    public void setAlarmMenuBean(Object object) {
        if (object != null) {
            ((CdEnableFilter)object).addCdGlobalAlarmListener(this);
            this.alarmMenuObj = (CdEnableFilter)object;
        }
    }

    public void setAlarmMode(String string) {
        if (string.equals(ALARMMODE_DOT_LEFT) || string.equals(ALARMMODE_DOT_RIGHT) || string.equals("background")) {
            this.alarmMode = string;
            this.updateModelProperties();
        }
    }

    public void setAllowCellSelect(boolean bl) {
        this.cellSelectionAllowed = bl;
        this.updateTableProperties();
    }

    public void setAllowEdit(boolean bl) {
        this.allowEdit = bl;
        this.updateTableProperties();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.tableHolder != null) {
            this.tableHolder.setBackground(color);
        }
    }

    public void setDataSource(SMRawDataRequest sMRawDataRequest) {
        this.dataSource = new SMTableRequest(sMRawDataRequest);
        this.origDataSource = sMRawDataRequest;
    }

    public void setDefaultColumnWidth(int n) {
        this.defaultColumnWidth = n;
    }

    public void setFilterEnabled(String string) {
        if (string == null) {
            return;
        }
        if (string.equals("true")) {
            this.alarmFilterEnabled = true;
        } else if (string.equals("false")) {
            this.alarmFilterEnabled = false;
        }
    }

    public void setFont(Font font) {
        this.setNormalFont(font);
    }

    public void setFragment(String string) {
        String string2 = this.fragment = string != null ? string : "";
        if (this.initialized && this.fragmentMode) {
            this.getTableData();
        }
    }

    public void setFragmentMode(boolean bl) {
        if (!this.initialized) {
            this.fragmentMode = bl;
        }
    }

    public void setFromMetadata(boolean bl) {
        this.fromMDR = bl;
    }

    public void setGridColor(Color color) {
        if (color != null) {
            this.gridColor = color;
            this.updateTableProperties();
        }
    }

    public void setHeaderFont(Font font) {
        this.headerFont = font != null ? font : DEFAULT_HEADER_FONT;
        this.updateModelProperties();
    }

    public void setIsForColumn(boolean bl) {
        if (this.SvcProvider != null && !this.fromMDR) {
            String[] stringArray = new String[]{String.valueOf(bl)};
            this.SvcProvider.triggerService("forColumn", stringArray);
        }
    }

    public void setManagedObjectUrl(String string) {
        this.managedObjectUrl = string != null ? string : "";
    }

    public void setNodeName(String string) {
        this.nodeName = string;
    }

    public void setNormalFont(Font font) {
        this.normalFont = font != null ? font : DEFAULT_NORMAL_FONT;
        int n = ((Component)this).getFontMetrics(this.normalFont).getAscent() + ((Component)this).getFontMetrics(this.normalFont).getDescent() + 4;
        this.getHorizontalScrollBar().setUnitIncrement(n);
        this.getVerticalScrollBar().setUnitIncrement(n);
        this.updateModelProperties();
    }

    public void setShowFilter(boolean bl) {
        this.showFilter = bl;
    }

    public void setShowHeader(boolean bl) {
        this.showHeader = bl;
    }

    public void setShowHorizontalLines(boolean bl) {
        this.showHorizontalLines = bl;
        this.updateTableProperties();
    }

    public void setShowVerticalLines(boolean bl) {
        this.showVerticalLines = bl;
        this.updateTableProperties();
    }

    public void setStdRefreshPeriod(String string) {
        this.stdRefreshPeriod = string != null ? string : "";
    }

    public void setTableBackground(Color color) {
        if (color == null) {
            return;
        }
        this.tableBackground = color;
        if (this.tableModels != null) {
            int n = 0;
            while (n < this.tableModels.length) {
                this.tableModels[n].setBackground(color);
                ++n;
            }
        }
        if (this.tables != null) {
            Color color2 = this.calculateAlternateColour(color);
            int n = 0;
            while (n < this.tables.length) {
                this.tables[n].setBackground(color, color2);
                ++n;
            }
        }
    }

    public void setTableForeground(Color color) {
        int n;
        if (color == null) {
            return;
        }
        this.tableForeground = color;
        if (this.tableModels != null) {
            n = 0;
            while (n < this.tableModels.length) {
                this.tableModels[n].setForeground(color);
                ++n;
            }
        }
        if (this.tables != null) {
            n = 0;
            while (n < this.tables.length) {
                this.tables[n].setForeground(color);
                ++n;
            }
        }
    }

    public void setTableFormat(SMTableFormat[] sMTableFormatArray) {
        if (sMTableFormatArray == null) {
            this.tableFormat = null;
            return;
        }
        this.tableFormat = new SMTableFormat[sMTableFormatArray.length];
        int n = 0;
        while (n < sMTableFormatArray.length) {
            this.tableFormat[n] = sMTableFormatArray[n];
            ++n;
        }
    }

    public void setTableWidth(int n) {
        this.tableWidth = n > 0 ? n : 220;
    }

    public void setTitleBackground(Color color) {
        this.titleBackground = color != null ? color : this.titleBackground;
        int n = 0;
        while (n < this.tableTitles.length) {
            this.tableTitles[n].setBackground(this.titleBackground);
            ++n;
        }
    }

    public void setTitleFont(Font font) {
        this.titleFont = font != null ? font : DEFAULT_TITLE_FONT;
        int n = 0;
        while (n < this.tableTitles.length) {
            this.tableTitles[n].setFont(this.titleFont);
            ++n;
        }
    }

    public void setTitleForeground(Color color) {
        this.titleForeground = color != null ? color : this.titleBackground;
        int n = 0;
        while (n < this.tableTitles.length) {
            this.tableTitles[n].setForeground(this.titleForeground);
            ++n;
        }
    }

    public void setTitleJustification(int n) {
        if (n == 2 || n == 4 || n == 0) {
            this.titleJustification = n;
            int n2 = 0;
            while (n2 < this.tableTitles.length) {
                this.tableTitles[n2].setHorizontalAlignment(this.titleJustification);
                ++n2;
            }
        }
    }

    public void setTopologyUrl(String string) {
        this.topologyUrl = string;
    }

    public void setVisibleLines(int n) {
        if (n >= -1) {
            this.visibleLines = n;
            this.updateTableProperties();
        }
    }

    private void setupTables() {
        if (this.tableFormat == null) {
            return;
        }
        this.tableHolder.removeAll();
        this.tableModels = new CvTblTableModel[this.tableFormat.length];
        this.tables = new CvTblTable[this.tableFormat.length];
        this.tableTitles = new JLabel[this.tableFormat.length];
        this.filters = new CvTblAlarmFilter[this.tableFormat.length];
        Color color = this.calculateAlternateColour(this.getTableBackground());
        int n = 0;
        while (n < this.tableFormat.length) {
            int n2;
            Object object;
            int n3;
            Object object2;
            Serializable serializable;
            Object object3;
            Object object4;
            Serializable serializable2;
            Serializable serializable3;
            int n4 = 0;
            SMTableFormat sMTableFormat = this.tableFormat[n];
            int n5 = sMTableFormat.getNumColumns();
            int n6 = sMTableFormat.getWidth() > 0 ? sMTableFormat.getWidth() : this.tableWidth;
            int n7 = 0;
            CvTblTableModel cvTblTableModel = new CvTblTableModel(this, n);
            cvTblTableModel.setAllowEdit(this.allowEdit);
            if (this.allowEdit) {
                serializable3 = new Vector();
                serializable2 = new Vector();
                object4 = new Vector<String>();
                int n8 = 0;
                while (n8 < n5) {
                    SMTableColumnFormat sMTableColumnFormat = sMTableFormat.getColumn(n8);
                    object3 = sMTableColumnFormat.getEditAccess();
                    serializable = new Boolean(sMTableColumnFormat.isCellEditable());
                    ((Vector)serializable3).addElement(serializable);
                    object2 = sMTableColumnFormat.getCustomCellEditor();
                    ((Vector)serializable2).addElement(object2);
                    String string = sMTableColumnFormat.getDataFormat();
                    ((Vector)object4).addElement(string);
                    ++n8;
                }
                cvTblTableModel.setEditInfo((Vector)serializable3, (Vector)serializable2, (Vector)object4, n5);
            }
            this.tableModels[n] = cvTblTableModel;
            serializable3 = new CvTblTable();
            ((JTable)serializable3).setAutoResizeMode(2);
            this.tables[n] = serializable3;
            serializable2 = new JLabel(sMTableFormat.getTitle());
            this.tableTitles[n] = serializable2;
            cvTblTableModel.setVertical(sMTableFormat.getIsVertical());
            cvTblTableModel.setIndexURLs(sMTableFormat.getIndexURLs());
            cvTblTableModel.setRealNumColumns(n5);
            cvTblTableModel.setBackground(this.getTableBackground());
            cvTblTableModel.setForeground(this.getTableForeground());
            cvTblTableModel.setAllProperties(this.getHeaderFont(), this.getNormalFont(), this.getAlarmFont(), this.getAlarmMode());
            cvTblTableModel.addTableEventListener(this);
            cvTblTableModel.setAlarmFilter(this.alarmFilter);
            ((JTable)serializable3).setModel(cvTblTableModel);
            ((CvCommonTable)serializable3).setBackground(this.getTableBackground(), color);
            ((JComponent)serializable3).setForeground(this.getTableForeground());
            ((JTable)serializable3).setShowHorizontalLines(this.showHorizontalLines);
            ((JTable)serializable3).setShowVerticalLines(this.showVerticalLines);
            ((CvCommonTable)serializable3).setVisibleLines(this.getVisibleLines());
            ((CvCommonTable)serializable3).addTableEventListener(this);
            ((CvCommonTable)serializable3).setAcknowledgedIcon(this.acknowledgedIcon);
            ((CvCommonTable)serializable3).setAllowCellSelect(this.cellSelectionAllowed);
            ((CvCommonTable)serializable3).setFromMDR(this.fromMDR);
            cvTblTableModel.setOwnTable((CvCommonTable)serializable3);
            object4 = sMTableFormat.getTableMenuGenerator();
            if (object4 != null) {
                ((CvTblTable)serializable3).setTableMenuGenerator((String)object4);
            }
            if (this.gridColor != null) {
                ((JTable)serializable3).setGridColor(this.gridColor);
            }
            ((JComponent)serializable2).setForeground(this.titleForeground);
            ((JComponent)serializable2).setBackground(this.titleBackground);
            ((JComponent)serializable2).setFont(this.titleFont);
            ((JLabel)serializable2).setHorizontalAlignment(this.titleJustification);
            ((JLabel)serializable2).setLabelFor((Component)serializable3);
            ((JComponent)serializable2).setOpaque(true);
            Dimension dimension = ((Component)serializable2).getSize();
            int n9 = SwingUtilities.computeStringWidth(((Component)this).getFontMetrics(this.titleFont), sMTableFormat.getTitle());
            ((JComponent)serializable2).setPreferredSize(new Dimension(n9, 30));
            ((JComponent)serializable2).setMaximumSize(new Dimension(n9 + 5, 35));
            object3 = new Dimension(n6 * 2, 300);
            ((JComponent)serializable3).setPreferredSize((Dimension)object3);
            if (!cvTblTableModel.getVertical()) {
                serializable = (Serializable)new int[n5];
                object2 = new String[n5];
                n3 = 0;
                while (n3 < n5) {
                    object = sMTableFormat.getColumn(n3);
                    object2[n3] = object.getColumnHeaderGenerator();
                    cvTblTableModel.setURLs(n3, object.getDataURL(), object.getStatusURL());
                    CvTblTableColumn cvTblTableColumn = new CvTblTableColumn(n3, object.getColumnHeading(), object.getRawDataType(), this.defaultColumnWidth);
                    ((JTable)serializable3).addColumn(cvTblTableColumn);
                    n2 = this.columnHeaderWidth((JTable)serializable3, cvTblTableColumn);
                    int n10 = n2 > 110 ? n2 : 110;
                    cvTblTableColumn.setPreferredWidth(n10);
                    cvTblTableColumn.setMinWidth(n10);
                    cvTblTableColumn.addTableEventListener(this);
                    ++n3;
                }
                ((CvTblTable)serializable3).setHeadersMenuGenerator((String[])object2);
                cvTblTableModel.initColInternalNames();
                n4 = this.dataSource.getTableDepth(cvTblTableModel.getDataURLs()[0]);
                if (n4 > 50 && this.dataSource.isLargeTableSupported(cvTblTableModel.getDataURLs()[0])) {
                    cvTblTableModel.setIsLarge(true);
                }
            } else {
                serializable = new Vector();
                object2 = new String[n5];
                n3 = 0;
                while (n3 < n5) {
                    object = sMTableFormat.getColumn(n3);
                    cvTblTableModel.setURLs(n3, object.getDataURL(), object.getStatusURL());
                    cvTblTableModel.setValueAt(new CvTblCell(false, object.getColumnHeading()), 0, n3);
                    ((Vector)serializable).addElement(object.getRawDataType());
                    int n11 = object.getColumnWidth();
                    object2[n3] = object.getColumnHeaderGenerator();
                    if (n11 < 1) {
                        n11 = this.defaultColumnWidth;
                    }
                    if (n11 < 1) {
                        ++n7;
                    } else if (this.maxDataWidth < n11) {
                        this.maxDataWidth = n11;
                    }
                    ++n3;
                }
                ((CvTblTable)serializable3).setHeadersMenuGenerator((String[])object2);
                int n12 = 0;
                int n13 = 0;
                if (n7 == n5) {
                    n12 = n6 / 2;
                    this.maxDataWidth = n13 = n6 / 2;
                } else {
                    n12 = n6 - this.maxDataWidth;
                    n13 = this.maxDataWidth;
                }
                CvTblTableColumn cvTblTableColumn = new CvTblTableColumn(0, this.i18nProperty, "string", n12);
                ((JTable)serializable3).addColumn(cvTblTableColumn);
                cvTblTableColumn.addTableEventListener(this);
                if (this.fromMDR) {
                    cvTblTableModel.updateRowNumber(n5);
                }
                if (!this.fromMDR) {
                    cvTblTableColumn = new CvTblTableColumn(1, this.i18nValue, "string", n13);
                    ((JTable)serializable3).addColumn(cvTblTableColumn);
                    cvTblTableColumn.setRowsDataType((Vector)serializable);
                    cvTblTableColumn.addTableEventListener(this);
                }
            }
            serializable = new JPanel();
            ((Component)serializable).setSize(new Dimension(120, 30));
            ((Container)serializable).setLayout(new BoxLayout((Container)serializable, 0));
            ((JComponent)serializable).setAlignmentX(0.0f);
            ((JComponent)serializable).setBackground(this.tableBackground);
            ((JComponent)serializable2).setAlignmentY(0.0f);
            ((Container)serializable).add((Component)serializable2);
            object2 = null;
            if (this.showFilter) {
                this.filters[n] = object2 = new CvTblAlarmFilter((CvTblTable)serializable3, this.origDataSource, this.alarmFilter);
                cvTblTableModel.addFilterListener((CvTblFilterListener)object2);
                ((CvTblAlarmFilter)object2).addAlarmListener(this);
                ((JComponent)object2).setAlignmentY(0.0f);
                ((Container)serializable).add(new JLabel("  "));
                ((Container)serializable).add((Component)object2);
            }
            this.tableHolder.add((Component)serializable);
            this.tableHolder.add(Box.createRigidArea(new Dimension(3, 3)));
            if (cvTblTableModel.getIsLarge()) {
                CvTblSlider cvTblSlider = new CvTblSlider(this, (CvTblTable)serializable3, this.origDataSource, this.dataSource, n4);
                cvTblSlider.repaint();
                cvTblSlider.setAlarmFilter(this.alarmFilter);
                cvTblSlider.addFilterListener((CvTblFilterListener)object2);
                this.tableHolder.add(cvTblSlider);
                ((CvTblTable)serializable3).setSlider(cvTblSlider);
                this.sliders.addElement(cvTblSlider);
                this.tableHolder.add(Box.createRigidArea(new Dimension(3, 3)));
            }
            if (this.showHeader) {
                CvTblTableHeader cvTblTableHeader = new CvTblTableHeader(((JTable)serializable3).getColumnModel());
                ((JTable)serializable3).setTableHeader(cvTblTableHeader);
                object = cvTblTableHeader.getSize();
                int n14 = ((JTable)serializable3).getColumnModel().getTotalColumnWidth();
                n2 = ((CvCommonTable)serializable3).getRowHeight();
                object.width = n14;
                object.height = n2;
                cvTblTableHeader.setPreferredSize((Dimension)object);
                cvTblTableHeader.setPreferredSize((Dimension)object);
                cvTblTableHeader.addMouseListener((MouseListener)((Object)serializable3));
                cvTblTableHeader.sortColumn(0);
                cvTblTableHeader.setAlignmentX(0.0f);
                cvTblTableHeader.setAlignmentY(0.0f);
                this.tableHolder.add(cvTblTableHeader);
            }
            this.tableHolder.add((Component)serializable3);
            ((JComponent)serializable3).revalidate();
            if (n < this.tableFormat.length - 1) {
                this.tableHolder.add(Box.createVerticalStrut(15));
            }
            ++n;
        }
        this.tableHolder.setSize(this.getPreferredSize());
        this.tableHolder.validate();
        this.tableHolder.revalidate();
        this.addMouseListener(this);
        this.layoutTitles();
    }

    public void shutdown() {
        this.selectListeners.removeAllElements();
        this.navigationListeners.removeAllElements();
        this.contextPopupListeners.removeAllElements();
        this.shutdownDataRequests();
        this.shutdownPageRequsts();
        this.shutdownLayoutRequest();
        if (this.alarmMenuObj != null) {
            this.alarmMenuObj.removeCdGloablAlarmListener(this);
            this.alarmMenuObj = null;
        }
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
    }

    public void shutdownDataRequests() {
        int n;
        if (this.dataRequests != null) {
            n = 0;
            while (n < this.dataRequests.length) {
                if (this.dataRequests[n] != null) {
                    try {
                        this.origDataSource.removeURLRequest(this.dataRequests[n]);
                    }
                    catch (SMAPIException sMAPIException) {}
                }
                ++n;
            }
        }
        if (this.statusRequests != null) {
            n = 0;
            while (n < this.statusRequests.length) {
                if (this.statusRequests[n] != null) {
                    try {
                        this.origDataSource.removeURLRequest(this.statusRequests[n]);
                    }
                    catch (SMAPIException sMAPIException) {}
                }
                ++n;
            }
        }
    }

    public void shutdownLayoutRequest() {
        block2: {
            if (this.layoutRequest == null) break block2;
            try {
                this.origDataSource.removeURLRequest(this.layoutRequest);
            }
            catch (SMAPIException sMAPIException) {}
        }
    }

    public void shutdownPageRequsts() {
        if (this.sliders.isEmpty()) {
            return;
        }
        int n = 0;
        while (n < this.sliders.size()) {
            CvTblSlider cvTblSlider = (CvTblSlider)this.sliders.get(n);
            if (cvTblSlider != null) {
                cvTblSlider.shutdown();
            }
            ++n;
        }
    }

    public void tableEventOccurred(CvTblTableEvent cvTblTableEvent) {
        if (cvTblTableEvent == null) {
            return;
        }
        switch (cvTblTableEvent.getEventType()) {
            case 1: {
                this.tableHolder.validate();
                this.tableHolder.setSize(this.tableHolder.getSize());
                this.layoutTitles();
                int n = 0;
                while (n < this.tables.length) {
                    if (this.tables[n] != null) {
                        this.tables[n].reallyDraw();
                        JTableHeader jTableHeader = this.tables[n].getTableHeader();
                        if (jTableHeader != null) {
                            Dimension dimension = jTableHeader.getSize();
                            if (this.tables[n].getColumnModel() != null && dimension != null) {
                                int n2;
                                dimension.width = n2 = this.tables[n].getColumnModel().getTotalColumnWidth();
                                jTableHeader.setPreferredSize(dimension);
                                jTableHeader.setPreferredSize(dimension);
                            }
                        }
                    }
                    ++n;
                }
                break;
            }
            case 3: {
                CvContextPopupEvent cvContextPopupEvent;
                Object object;
                SMFamilyCommands sMFamilyCommands = null;
                CvTblTable cvTblTable = (CvTblTable)cvTblTableEvent.getSource();
                CvTblTableModel cvTblTableModel = (CvTblTableModel)cvTblTable.getModel();
                if (!this.fromMDR) {
                    int n = 0;
                    while (n < this.tables.length) {
                        SMTableFormat sMTableFormat;
                        if (this.tables[n] == cvTblTable && (sMTableFormat = this.getTableFormat(n)) != null) {
                            sMFamilyCommands = sMTableFormat.getTableHdrCommands();
                        }
                        ++n;
                    }
                }
                Point point = cvTblTable.getLocation();
                int n = cvTblTableEvent.getXPos() - point.x;
                int n3 = cvTblTableEvent.getYPos() - point.y;
                point = new Point(n, n3);
                int n4 = cvTblTable.columnAtPoint(point);
                int n5 = cvTblTable.convertColumnIndexToModel(n4);
                String string = " !graph";
                if (cvTblTableModel.getVertical()) {
                    string = " !saveColumnValue";
                } else {
                    String string2 = string = cvTblTableModel.isCellEditable(0, n5) ? null : " !saveColumnValue";
                }
                if (!this.fromMDR && cvTblTableModel.getRowCount() == 0) {
                    string = String.valueOf(string) + " !saveColumnValue";
                }
                String string3 = string;
                if (!this.fromMDR) {
                    string3 = String.valueOf(string3) + cvTblTableEvent.getExclusionInfo();
                }
                SMMenuGenerator sMMenuGenerator = null;
                if (!this.fromMDR && !cvTblTableModel.getVertical()) {
                    sMMenuGenerator = cvTblTable.getHeaderMenuGenerator(n4);
                }
                if (sMMenuGenerator != null) {
                    SMTblSelectionInfo sMTblSelectionInfo = cvTblTable.getContextSelection();
                    object = new SMContextPopupEvent(cvTblTable, sMTblSelectionInfo, cvTblTableEvent.getName(), cvTblTableEvent.getUrl(), -1, n4, this.objectContext);
                    SMContextPopupItem[] sMContextPopupItemArray = sMMenuGenerator.getMenuItems(object);
                    cvContextPopupEvent = new CvContextPopupEvent(this, "header", null, cvTblTableEvent.getName(), sMFamilyCommands, cvTblTableEvent.getXPos() - this.getHorizontalScrollBar().getValue(), cvTblTableEvent.getYPos() - this.getVerticalScrollBar().getValue(), cvTblTableEvent.getUrl(), cvTblTableEvent.getUrl(), cvTblTableEvent.getUrl(), string3, null, sMContextPopupItemArray);
                } else {
                    cvContextPopupEvent = new CvContextPopupEvent(this, "header", null, cvTblTableEvent.getName(), sMFamilyCommands, cvTblTableEvent.getXPos() - this.getHorizontalScrollBar().getValue(), cvTblTableEvent.getYPos() - this.getVerticalScrollBar().getValue(), cvTblTableEvent.getUrl(), cvTblTableEvent.getUrl(), cvTblTableEvent.getUrl(), string3, null);
                }
                int n6 = 0;
                while (n6 < this.contextPopupListeners.size()) {
                    object = this.contextPopupListeners.elementAt(n6);
                    ((CvContextPopupListener)object).contextPopupOccurred(cvContextPopupEvent);
                    ++n6;
                }
                break;
            }
            case 2: {
                CvContextPopupEvent cvContextPopupEvent;
                Object object;
                String string;
                SMFamilyCommands sMFamilyCommands = null;
                CvTblTable cvTblTable = (CvTblTable)cvTblTableEvent.getSource();
                CvTblTableModel cvTblTableModel = (CvTblTableModel)cvTblTable.getModel();
                if (!this.fromMDR) {
                    int n = 0;
                    while (n < this.tables.length) {
                        SMTableFormat sMTableFormat;
                        if (this.tables[n] == cvTblTable && (sMTableFormat = this.getTableFormat(n)) != null) {
                            sMFamilyCommands = sMTableFormat.getTableRowCommands();
                        }
                        ++n;
                    }
                }
                SMTblSelectionInfo sMTblSelectionInfo = cvTblTable.getContextSelection();
                String string4 = cvTblTableEvent.getExclusionInfo();
                if (sMTblSelectionInfo == null || sMTblSelectionInfo.getSelectionType() != 2) {
                    string4 = String.valueOf(string4) + " !dvrow";
                    string4 = String.valueOf(string4) + " !dvcell";
                } else {
                    int n = cvTblTable.convertColumnIndexToModel(sMTblSelectionInfo.getSelectedColumn());
                    if (n == 0 && cvTblTableModel.getVertical()) {
                        string4 = String.valueOf(string4) + " !dvcell";
                    }
                }
                Point point = cvTblTable.getLocation();
                int n = cvTblTableEvent.getXPos() - point.x;
                int n7 = cvTblTableEvent.getYPos() - point.y;
                point = new Point(n, n7);
                int n8 = cvTblTable.rowAtPoint(point);
                int n9 = cvTblTable.columnAtPoint(point);
                SMMenuGenerator sMMenuGenerator = null;
                if (!this.fromMDR) {
                    sMMenuGenerator = !cvTblTableModel.getVertical() ? cvTblTable.getMenuGenerator() : cvTblTable.getHeaderMenuGenerator(n8);
                }
                if (cvTblTableModel.getVertical() && this.fromMDR) {
                    string = cvTblTableModel.isCellEditable(n8, 1) ? null : " !saveColumnValue";
                    string4 = String.valueOf(string4) + string;
                }
                if (sMMenuGenerator != null) {
                    int n10 = cvTblTable.convertColumnIndexToModel(n9);
                    string = new SMContextPopupEvent(cvTblTable, sMTblSelectionInfo, cvTblTableEvent.getName(), cvTblTableEvent.getUrl(), n8, n9, this.objectContext);
                    object = sMMenuGenerator.getMenuItems((SMContextPopupEvent)string);
                    cvContextPopupEvent = new CvContextPopupEvent(this, null, null, cvTblTableEvent.getName(), sMFamilyCommands, cvTblTableEvent.getXPos() - this.getHorizontalScrollBar().getValue(), cvTblTableEvent.getYPos() - this.getVerticalScrollBar().getValue(), cvTblTableEvent.getUrl(), cvTblTableEvent.getUrl(), cvTblTableEvent.getUrl(), string4, null, (SMContextPopupItem[])object);
                } else {
                    cvContextPopupEvent = new CvContextPopupEvent(this, null, null, cvTblTableEvent.getName(), sMFamilyCommands, cvTblTableEvent.getXPos() - this.getHorizontalScrollBar().getValue(), cvTblTableEvent.getYPos() - this.getVerticalScrollBar().getValue(), cvTblTableEvent.getUrl(), cvTblTableEvent.getUrl(), cvTblTableEvent.getUrl(), string4, null);
                }
                int n11 = 0;
                while (n11 < this.contextPopupListeners.size()) {
                    object = this.contextPopupListeners.elementAt(n11);
                    ((CvContextPopupListener)object).contextPopupOccurred(cvContextPopupEvent);
                    ++n11;
                }
                break;
            }
            case 4: {
                int n = 0;
                while (n < this.tableModels.length) {
                    if (this.tableModels[n] == cvTblTableEvent.getSource()) {
                        CvTblTableColumn cvTblTableColumn = new CvTblTableColumn(cvTblTableEvent.getYPos(), "Value", "string", this.maxDataWidth);
                        this.tables[n].addColumn(cvTblTableColumn);
                        cvTblTableColumn.addTableEventListener(this);
                    }
                    ++n;
                }
                break;
            }
            case 5: 
            case 7: {
                this.selectClearInProgress = true;
                if (this.tables != null) {
                    int n = 0;
                    while (n < this.tables.length) {
                        if (this.tables[n] != (CvTblTable)cvTblTableEvent.getSource()) {
                            this.tables[n].clearSelection();
                            this.tables[n].setHeaderSelected(false);
                        }
                        ++n;
                    }
                }
                this.selectClearInProgress = false;
                CvTableSelectEvent cvTableSelectEvent = new CvTableSelectEvent(this, 1);
                int n = 0;
                while (n < this.selectListeners.size()) {
                    CvTableSelectListener cvTableSelectListener = (CvTableSelectListener)this.selectListeners.elementAt(n);
                    cvTableSelectListener.selectionOccurred(cvTableSelectEvent);
                    ++n;
                }
                this.revalidate();
                this.repaint();
                break;
            }
            case 6: {
                if (this.selectClearInProgress) break;
                CvTableSelectEvent cvTableSelectEvent = new CvTableSelectEvent(this, 0);
                int n = 0;
                while (n < this.selectListeners.size()) {
                    CvTableSelectListener cvTableSelectListener = (CvTableSelectListener)this.selectListeners.elementAt(n);
                    cvTableSelectListener.selectionOccurred(cvTableSelectEvent);
                    ++n;
                }
                break;
            }
        }
    }

    private void updateModelProperties() {
        if (this.tableModels == null) {
            return;
        }
        int n = 0;
        while (n < this.tableModels.length) {
            this.tableModels[n].setAllProperties(this.headerFont, this.normalFont, this.alarmFont, this.alarmMode);
            ++n;
        }
    }

    private void updateTableProperties() {
        if (this.tables == null) {
            return;
        }
        int n = 0;
        while (n < this.tables.length) {
            this.tables[n].setVisibleLines(this.visibleLines);
            if (this.gridColor != null) {
                this.tables[n].setGridColor(this.gridColor);
            }
            this.tables[n].setShowHorizontalLines(this.showHorizontalLines);
            this.tables[n].setShowVerticalLines(this.showVerticalLines);
            this.tables[n].setAllowCellSelect(this.cellSelectionAllowed);
            ++n;
        }
    }

    class SaveDataThread
    implements Runnable {
        private String url;
        private String value;
        private String type;
        private String format;
        private int row;
        private int col;
        private boolean style;
        private Component parent;
        private CvTblTableModel tableModel;
        SMRawDataRequest handle;
        private String origVal;

        SaveDataThread(CvTblTableModel cvTblTableModel, int n, int n2, String string, String string2, boolean bl, Component component, SMRawDataRequest sMRawDataRequest, String string3) {
            this.tableModel = cvTblTableModel;
            this.url = cvTblTableModel.getFullURL(n, n2);
            this.value = string;
            this.type = string2;
            this.format = cvTblTableModel.getDataFormat(n, n2);
            this.style = bl;
            this.parent = component;
            this.handle = sMRawDataRequest;
            this.row = n;
            this.col = n2;
            this.origVal = string3;
        }

        public void run() {
            boolean bl = CdPropValueEditorPane.saveDataToAgent(this.url, this.value, this.type, this.format, this.style, this.parent, this.handle);
            if (!bl && this.url.compareTo(this.tableModel.getFullURL(this.row, this.col)) == 0) {
                this.tableModel.setDataValue(this.row, this.col, this.origVal);
            }
        }
    }
}

