/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.modules;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRequestStatus;
import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.base.client.console.SMConsoleContext;
import com.sun.symon.base.client.module.SMModuleData;
import com.sun.symon.base.client.module.SMModuleInfo;
import com.sun.symon.base.client.module.SMModuleRequest;
import com.sun.symon.base.client.module.SMModuleScheduledResponse;
import com.sun.symon.base.console.awx.AwxBusyPanel;
import com.sun.symon.base.console.manager.CmConsoleSession;
import com.sun.symon.base.console.modules.CmLoadNowDialog;
import com.sun.symon.base.console.modules.CmRuleDialog;
import com.sun.symon.base.console.views.table.CvBaseTable;
import com.sun.symon.base.console.views.table.CvBaseTableModel;
import com.sun.symon.base.utility.UcAgentURL;
import com.sun.symon.base.utility.UcCommon;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;

public class CmModulesPanel
extends JPanel
implements ListSelectionListener,
SMModuleScheduledResponse {
    static final String RULE = "Rules";
    static final String UNLOAD = "Unload";
    static final String LOAD = "Load";
    static final String LOADED_MODULES = "LoadedModules";
    static final String AVAIL_MODULES = "AvailableModules";
    static final String TYPE = "Type";
    static final String NAME = "ModuleName";
    static final String ICON_FILE = "icon_file";
    static final String MODULE_NAME = "moduleName";
    static final String MODULE_LOADED = "moduleLoaded";
    static final String MODULE_ENABLED = "moduleEnabled";
    static final String MODULE_SCHEDULED = "scheduled";
    static final String RUN_NOW = "runNow";
    static final String ENABLED = "enabled";
    static final String DISABLED = "disabled";
    static final String EDIT = "edit";
    static final String NO = "No";
    static final String YES = "Yes";
    static final String INSTANCE = "instance";
    static final String TAB_RFH_PERIOD = "6000";
    static final String VERSION_WARNING = "verWarning";
    private String win;
    private CmConsoleSession session;
    private SMRawDataRequest rawReq;
    private String host;
    private int port;
    private boolean isRightVersion;
    private JLabel status;
    private SMModuleRequest modReq;
    private JButton ruleBtn;
    private JButton unloadBtn;
    private JButton loadBtn;
    private JButton runnowBtn;
    private JButton enabledBtn;
    private JButton disabledBtn;
    private JButton editBtn;
    private JFrame rootFrame;
    private Vector loadedModulesVector = null;
    private Vector availModulesVector = null;
    private Vector moduleRef = new Vector();
    private Vector paramRef = new Vector();
    private Vector availRef = new Vector();
    private Hashtable schHash = new Hashtable();
    private Hashtable loadHash = new Hashtable();
    private String[][] schModule = null;
    private int selectModule;
    private int availModule;
    private CvBaseTable availModulesTable;
    private CvBaseTable loadModulesTable;
    private ImageIcon scheduledIcon;
    private ImageIcon noScheduledIcon;
    private ImageIcon multiIcon;
    private ImageIcon singleIcon;
    private Object ldHandle;
    private Object schHandle;
    private CmRuleDialog ruleDlg = null;

    private void busyEnd() {
        this.rootFrame.getGlassPane().setVisible(false);
        Toolkit.getDefaultToolkit().sync();
    }

    private void busyStart() {
        if (!(this.rootFrame.getGlassPane() instanceof AwxBusyPanel)) {
            this.rootFrame.setGlassPane(new AwxBusyPanel());
            this.rootFrame.validate();
        }
        this.rootFrame.getGlassPane().setVisible(true);
        Toolkit.getDefaultToolkit().sync();
    }

    public void cleanUp() {
        Container container;
        try {
            if (this.ldHandle != null) {
                this.rawReq.removeURLRequest(this.ldHandle);
            }
            if (this.schHandle != null) {
                this.rawReq.removeURLRequest(this.schHandle);
            }
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logErrorMessage((String)("Error while removing get modules request" + sMAPIException.getMessage()));
        }
        this.modReq = null;
        this.rawReq = null;
        if (this.ruleDlg != null) {
            this.ruleDlg.dispose();
            this.ruleDlg = null;
        }
        if ((container = this.getParent()) != null) {
            container.remove(this);
        }
    }

    private void flushAvailModuleTable() {
        Runnable runnable = new Runnable(){

            public void run() {
                Vector[] vectorArray = CmModulesPanel.this.getAllModule();
                CmModulesPanel.this.updateAvailSelection(vectorArray);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void flushLoadedModuleTable() {
        Runnable runnable = new Runnable(){

            public void run() {
                Vector[] vectorArray = CmModulesPanel.this.getLoadedModule();
                CmModulesPanel.this.updateLoadedSelection(vectorArray);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private Vector[] getAllModule() {
        Vector[] vectorArray = null;
        int n = 0;
        if (this.availModulesVector == null) {
            return vectorArray;
        }
        int n2 = this.availModulesVector.size();
        if (n2 == 0) {
            return vectorArray;
        }
        int n3 = this.availModulesTable.getModel().getColumnCount();
        if (n3 == 0) {
            return vectorArray;
        }
        vectorArray = new Vector[n3];
        int n4 = 0;
        while (n4 < n3) {
            vectorArray[n4] = new Vector();
            ++n4;
        }
        this.availRef.clear();
        Enumeration enumeration = this.availModulesVector.elements();
        while (enumeration.hasMoreElements()) {
            SMModuleInfo sMModuleInfo = (SMModuleInfo)enumeration.nextElement();
            if (sMModuleInfo.isMultiInstance()) {
                vectorArray[0].add(sMModuleInfo.getModuleName());
                vectorArray[1].add(new Boolean(true));
                this.availRef.add(sMModuleInfo.getModuleId());
            } else if (this.schHash.get(sMModuleInfo.getModule()) == null && this.loadHash.get(sMModuleInfo.getModule()) == null) {
                vectorArray[0].add(sMModuleInfo.getModuleName());
                vectorArray[1].add(new Boolean(false));
                this.availRef.add(sMModuleInfo.getModuleId());
            }
            ++n;
        }
        return vectorArray;
    }

    private Vector[] getLoadedModule() {
        SMModuleData sMModuleData;
        Vector[] vectorArray = null;
        int n = -1;
        if (this.loadedModulesVector == null && this.schModule == null) {
            return vectorArray;
        }
        int n2 = this.loadModulesTable.getModel().getColumnCount();
        if (n2 == 0) {
            return vectorArray;
        }
        vectorArray = new Vector[n2];
        int n3 = 0;
        while (n3 < n2) {
            vectorArray[n3] = new Vector();
            ++n3;
        }
        this.moduleRef.clear();
        this.paramRef.clear();
        Hashtable hashtable = (Hashtable)this.loadHash.clone();
        if (this.schModule != null && this.schModule.length > 0) {
            int n4 = 0;
            while (n4 < this.schModule.length) {
                String string;
                String string2 = this.schModule[n4][0];
                sMModuleData = (SMModuleData)this.loadHash.get(this.schModule[n4][0]);
                if (sMModuleData != null) {
                    vectorArray[0].add(sMModuleData.getModuleI18Name());
                    vectorArray[1].add(YES);
                    hashtable.remove(this.schModule[n4][0]);
                    vectorArray[3].add(new Boolean(sMModuleData.isEnabled()));
                } else {
                    String[] stringArray = SMModuleRequest.getModuleFromSpec((String)string2);
                    string = this.schModule[n4][1];
                    String string3 = null;
                    int n5 = string.indexOf("i18nModuleName = ");
                    if (n5 == -1) {
                        UcDDL.logErrorMessage((String)"Error in getting module Name");
                        string3 = String.valueOf(stringArray[0]) + (stringArray[1].length() == 0 ? "" : " [" + stringArray[1] + "]");
                    } else {
                        String string4 = string.substring(n5);
                        int n6 = string4.indexOf(34);
                        int n7 = string4.indexOf(59);
                        if (n6 == -1 || n7 == -1) {
                            UcDDL.logErrorMessage((String)"Error in getting moduleName");
                            string3 = String.valueOf(stringArray[0]) + (stringArray[1].length() == 0 ? "" : " [" + stringArray[1] + "]");
                        } else {
                            string3 = UcInternationalizer.translateKey((String)string4.substring(n6 + 1, n7 - 1));
                        }
                    }
                    vectorArray[0].add(string3);
                    vectorArray[1].add(NO);
                    vectorArray[3].add(new Boolean(false));
                }
                vectorArray[2].add(new Boolean(true));
                string = "snmp://" + this.host + ":" + this.port + "/mod/" + string2;
                this.moduleRef.add(string);
                this.paramRef.add(this.schModule[n4][1]);
                ++n4;
            }
        }
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            sMModuleData = (SMModuleData)enumeration.nextElement();
            vectorArray[0].add(sMModuleData.getModuleI18Name());
            vectorArray[1].add(YES);
            vectorArray[2].add(new Boolean(false));
            vectorArray[3].add(new Boolean(sMModuleData.isEnabled()));
            String string = "snmp://" + this.host + ":" + this.port + "/mod/" + sMModuleData.getModuleSpec();
            this.moduleRef.add(string);
            this.paramRef.add(null);
        }
        hashtable = null;
        return vectorArray;
    }

    public void getModuleDataResponse(SMRequestStatus sMRequestStatus, Vector vector) {
        SMModuleData sMModuleData;
        if (sMRequestStatus.getReturnCode() != 0) {
            UcDDL.logErrorMessage((String)("Loaded modules request failed : " + sMRequestStatus.getMessageText()));
            if (sMRequestStatus.getReturnCode() == 4) {
                this.rawReq.launchTimeoutNotification("both");
            }
            return;
        }
        this.loadedModulesVector = vector;
        this.loadHash.clear();
        if (this.loadedModulesVector != null) {
            Enumeration enumeration = this.loadedModulesVector.elements();
            while (enumeration.hasMoreElements()) {
                sMModuleData = (SMModuleData)enumeration.nextElement();
                this.loadHash.put(sMModuleData.getModuleSpec(), sMModuleData);
            }
        }
        sMModuleData = null;
        this.flushLoadedModuleTable();
        this.flushAvailModuleTable();
    }

    public SMRawDataRequest getRawRequestHandle() {
        return this.rawReq;
    }

    private JFrame getRootFrame() {
        Container container = this;
        while ((container = container.getParent()) != null) {
            if (!(container instanceof JFrame)) continue;
            return (JFrame)container;
        }
        return null;
    }

    public void getScheduledModuleInfoResponse(SMRequestStatus sMRequestStatus, String[][] stringArray) {
        if (sMRequestStatus.getReturnCode() != 0) {
            UcDDL.logErrorMessage((String)("Get module info request failed: " + sMRequestStatus.getMessageText()));
            if (sMRequestStatus.getReturnCode() == 4) {
                this.rawReq.launchTimeoutNotification("both");
            }
            return;
        }
        this.schModule = stringArray;
        this.schHash.clear();
        if (this.schModule != null) {
            int n = 0;
            while (n < this.schModule.length) {
                String[] stringArray2 = SMModuleRequest.getModuleFromSpec((String)this.schModule[n][0]);
                this.schHash.put(stringArray2[0], this.schModule[n][0]);
                ++n;
            }
        }
        this.flushLoadedModuleTable();
        this.flushAvailModuleTable();
    }

    private Window getWin(Component component) {
        Window window = null;
        while ((component = component.getParent()) != null) {
            if (!(component instanceof Window)) continue;
            window = (Window)component;
            break;
        }
        return window;
    }

    public void init() {
        Object[] objectArray = new Object[]{this.translate("OK")};
        this.session = CmConsoleSession.getInstance();
        this.rootFrame = this.getRootFrame();
        try {
            this.modReq = new SMModuleRequest(this.rawReq);
        }
        catch (Exception exception) {
            JOptionPane.showOptionDialog(this.getWin(this), String.valueOf(this.translate("requestHandleException")) + "\n" + exception.getMessage(), this.translate("alert"), -1, 0, null, objectArray, objectArray[0]);
            this.modReq = null;
            return;
        }
        if (this.status != null) {
            this.status.setText("");
        }
        this.setBorder(new EmptyBorder(17, 17, 17, 17));
        this.setLayout(new BoxLayout(this, 1));
        this.setAlignmentX(0.0f);
        JLabel jLabel = new JLabel(this.translate(LOADED_MODULES));
        jLabel.setAlignmentX(0.0f);
        this.add(jLabel);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentX(0.0f);
        LoadedModuleModel loadedModuleModel = new LoadedModuleModel(this);
        this.loadModulesTable = new CvBaseTable(loadedModuleModel);
        this.loadModulesTable.setRowHeight(22);
        this.loadModulesTable.setSelectionMode(0);
        this.loadModulesTable.getSelectionModel().addListSelectionListener(this);
        TableColumnModel tableColumnModel = this.loadModulesTable.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(50);
        tableColumnModel.getColumn(1).setPreferredWidth(5);
        tableColumnModel.getColumn(2).setPreferredWidth(20);
        tableColumnModel.getColumn(2).setCellRenderer(new BooleanRenderer());
        tableColumnModel.getColumn(3).setCellRenderer(new StatusRenderer());
        this.loadModulesTable.setBackground(UcCommon.getLightGrayColor());
        JScrollPane jScrollPane = new JScrollPane(this.loadModulesTable, 20, 30);
        jScrollPane.setAlignmentY(0.0f);
        jScrollPane.setPreferredSize(new Dimension(128, 200));
        jPanel.add(jScrollPane);
        jPanel.add(Box.createRigidArea(new Dimension(12, 0)));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setAlignmentY(0.0f);
        this.unloadBtn = new JButton(this.translate(UNLOAD));
        this.unloadBtn.setAlignmentX(0.0f);
        this.unloadBtn.setEnabled(false);
        jPanel2.add(this.unloadBtn);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 4)));
        this.runnowBtn = new JButton(this.translate(RUN_NOW));
        this.runnowBtn.setAlignmentX(0.0f);
        this.runnowBtn.setEnabled(false);
        jPanel2.add(this.runnowBtn);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 14)));
        this.unloadBtn.setMaximumSize(this.runnowBtn.getPreferredSize());
        this.editBtn = new JButton(this.translate(EDIT));
        this.editBtn.setAlignmentX(0.0f);
        this.editBtn.setMaximumSize(this.runnowBtn.getPreferredSize());
        this.editBtn.setEnabled(false);
        jPanel2.add(this.editBtn);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 14)));
        this.enabledBtn = new JButton(this.translate(ENABLED));
        this.enabledBtn.setAlignmentX(0.0f);
        this.enabledBtn.setMaximumSize(this.runnowBtn.getPreferredSize());
        this.enabledBtn.setEnabled(false);
        jPanel2.add(this.enabledBtn);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 4)));
        this.disabledBtn = new JButton(this.translate(DISABLED));
        this.disabledBtn.setAlignmentX(0.0f);
        this.disabledBtn.setMaximumSize(this.runnowBtn.getPreferredSize());
        this.disabledBtn.setEnabled(false);
        jPanel2.add(this.disabledBtn);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 14)));
        SMResourceAccess sMResourceAccess = new SMResourceAccess(SMConsoleContext.getInstance().getAPIHandle());
        this.scheduledIcon = new ImageIcon(sMResourceAccess.getImage("stdimages/scheduled.gif"));
        this.noScheduledIcon = new ImageIcon(sMResourceAccess.getImage("stdimages/noscheduled.gif"));
        this.multiIcon = new ImageIcon(sMResourceAccess.getImage("stdimages/MultiInstance-Module-16x16.gif"));
        this.singleIcon = new ImageIcon(sMResourceAccess.getImage("topoimages/module-small.gif"));
        this.ruleBtn = new JButton(this.translate(RULE));
        this.ruleBtn.setMaximumSize(this.runnowBtn.getPreferredSize());
        this.ruleBtn.setEnabled(false);
        this.ruleBtn.setAlignmentX(0.0f);
        this.ruleBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CmModulesPanel.this.busyStart();
                if (CmModulesPanel.this.ruleDlg != null) {
                    CmModulesPanel.this.ruleDlg.dispose();
                    CmModulesPanel.this.ruleDlg = null;
                }
                CmModulesPanel.this.ruleDlg = new CmRuleDialog(CmModulesPanel.this.rawReq, (String)((LoadedModuleModel)CmModulesPanel.this.loadModulesTable.getModel()).getRealValueAt(CmModulesPanel.this.selectModule, 0), (String)CmModulesPanel.this.moduleRef.elementAt(CmModulesPanel.this.selectModule));
                CmModulesPanel.this.busyEnd();
            }
        });
        jPanel2.add(this.ruleBtn);
        jPanel.add(jPanel2);
        this.add(jPanel);
        this.add(Box.createRigidArea(new Dimension(0, 18)));
        jLabel = new JLabel(this.translate(AVAIL_MODULES));
        jLabel.setAlignmentX(0.0f);
        this.add(jLabel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.setAlignmentX(0.0f);
        this.availModulesTable = new CvBaseTable(new ModuleTableModel(this));
        this.availModulesTable.getSelectionModel().addListSelectionListener(this);
        this.availModulesTable.setRowHeight(22);
        this.availModulesTable.setSelectionMode(0);
        this.availModulesTable.setBackground(UcCommon.getLightGrayColor());
        this.availModulesTable.getColumnModel().getColumn(1).setPreferredWidth(5);
        this.availModulesTable.getColumnModel().getColumn(1).setCellRenderer(new InstanceRenderer());
        JScrollPane jScrollPane2 = new JScrollPane(this.availModulesTable, 20, 30);
        jScrollPane2.setAlignmentY(0.0f);
        jPanel3.add(jScrollPane2);
        jPanel3.add(Box.createRigidArea(new Dimension(12, 0)));
        this.loadBtn = new JButton(this.translate(LOAD));
        this.loadBtn.setAlignmentY(0.0f);
        this.loadBtn.setPreferredSize(this.runnowBtn.getPreferredSize());
        this.loadBtn.setEnabled(false);
        jPanel3.add(this.loadBtn);
        this.add(jPanel3);
        try {
            this.isRightVersion = this.rawReq.isAgentVersionNotLower(this.host, this.port, "3.0");
            if (!this.isRightVersion) {
                this.status.setText(this.translate(VERSION_WARNING));
            }
            this.ldHandle = this.modReq.getModuleDataRequest(this.host, this.port, TAB_RFH_PERIOD, (SMModuleScheduledResponse)this);
            this.availModulesVector = this.modReq.getModuleInfo(this.host, this.port);
            this.flushAvailModuleTable();
            this.schHandle = this.modReq.getScheduledModuleInfoRequest(this.host, this.port, TAB_RFH_PERIOD, (SMModuleScheduledResponse)this);
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logErrorMessage((String)("Failed to get modules." + sMAPIException.getMessage()));
        }
        this.loadBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String[] stringArray = new String[5];
                    stringArray[0] = CmModulesPanel.this.win;
                    stringArray[1] = ".templates.tools.moduleloader";
                    stringArray[2] = "agentHost=" + CmModulesPanel.this.host;
                    stringArray[3] = "agentPort=" + CmModulesPanel.this.port;
                    ModuleTableModel moduleTableModel = (ModuleTableModel)CmModulesPanel.this.availModulesTable.getModel();
                    int n = CmModulesPanel.this.availModulesTable.getSelectedRow();
                    int n2 = moduleTableModel.convertRowIndexToModel(n);
                    stringArray[4] = "moduleId=" + CmModulesPanel.this.availRef.elementAt(n2).toString();
                    CmModulesPanel.this.session.launchUniqueDialogOnParent(stringArray);
                }
                catch (Exception exception) {
                    UcDDL.logErrorMessage((String)"Failed to load module.");
                }
            }
        });
        this.unloadBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string = (String)CmModulesPanel.this.moduleRef.elementAt(CmModulesPanel.this.selectModule);
                    String[] stringArray = new String[]{CmModulesPanel.this.win, ".templates.tools.confirmunload", "objectUrl=" + string};
                    CmModulesPanel.this.session.launchDialogOnParent(stringArray);
                }
                catch (Exception exception) {
                    UcDDL.logErrorMessage((String)"Failed to unload module.");
                }
            }
        });
        this.enabledBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    UcAgentURL ucAgentURL = new UcAgentURL((String)CmModulesPanel.this.moduleRef.elementAt(CmModulesPanel.this.selectModule));
                    boolean bl = CmModulesPanel.this.modReq.enableModule(ucAgentURL.getHost(), ucAgentURL.getAgentPort(), ucAgentURL.getModuleId(), ucAgentURL.getInstance());
                    if (bl) {
                        LoadedModuleModel loadedModuleModel = (LoadedModuleModel)CmModulesPanel.this.loadModulesTable.getModel();
                        loadedModuleModel.setRealValueAt(new Boolean(true), CmModulesPanel.this.selectModule, 3);
                        loadedModuleModel.fireTableChanged(new TableModelEvent(loadedModuleModel));
                        CmModulesPanel.this.valueChanged(new ListSelectionEvent(CmModulesPanel.this.loadModulesTable.getSelectionModel(), CmModulesPanel.this.selectModule, CmModulesPanel.this.selectModule, false));
                        CmModulesPanel.this.status.setText("Succeed in enabling module.");
                    }
                }
                catch (SMAPIException sMAPIException) {
                    UcDDL.logErrorMessage((String)"Failed to enable module.");
                }
            }
        });
        this.disabledBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    UcAgentURL ucAgentURL = new UcAgentURL((String)CmModulesPanel.this.moduleRef.elementAt(CmModulesPanel.this.selectModule));
                    boolean bl = CmModulesPanel.this.modReq.disableModule(ucAgentURL.getHost(), ucAgentURL.getAgentPort(), ucAgentURL.getModuleId(), ucAgentURL.getInstance());
                    if (bl) {
                        LoadedModuleModel loadedModuleModel = (LoadedModuleModel)CmModulesPanel.this.loadModulesTable.getModel();
                        loadedModuleModel.setRealValueAt(new Boolean(false), CmModulesPanel.this.selectModule, 3);
                        loadedModuleModel.fireTableChanged(new TableModelEvent(loadedModuleModel));
                        CmModulesPanel.this.valueChanged(new ListSelectionEvent(CmModulesPanel.this.loadModulesTable.getSelectionModel(), CmModulesPanel.this.selectModule, CmModulesPanel.this.selectModule, false));
                        CmModulesPanel.this.status.setText("Succeed in disabling module.");
                    }
                }
                catch (SMAPIException sMAPIException) {
                    UcDDL.logErrorMessage((String)"Failed to disable module.");
                }
            }
        });
        this.editBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    UcAgentURL ucAgentURL = new UcAgentURL((String)CmModulesPanel.this.moduleRef.elementAt(CmModulesPanel.this.selectModule));
                    String[] stringArray = new String[]{CmModulesPanel.this.win, ".templates.tools.moduleeditor", "agentHost=" + CmModulesPanel.this.host, "agentPort=" + CmModulesPanel.this.port, "moduleId=" + ucAgentURL.getModuleId(), "moduleSpec=" + ucAgentURL.getModuleSpec()};
                    CmModulesPanel.this.session.launchUniqueDialogOnParent(stringArray);
                }
                catch (Exception exception) {
                    UcDDL.logErrorMessage((String)"Failed to open edit window.");
                }
            }
        });
        this.runnowBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    CmLoadNowDialog cmLoadNowDialog = new CmLoadNowDialog(CmModulesPanel.this.rootFrame);
                    UcAgentURL ucAgentURL = new UcAgentURL((String)CmModulesPanel.this.moduleRef.elementAt(CmModulesPanel.this.selectModule));
                    if (cmLoadNowDialog.getClicked() == CmLoadNowDialog.OK) {
                        if (cmLoadNowDialog.getCommand() == "preserve") {
                            CmModulesPanel.this.modReq.loadModule(CmModulesPanel.this.host, CmModulesPanel.this.port, ucAgentURL.getModuleId(), ucAgentURL.getInstance(), (String)CmModulesPanel.this.paramRef.elementAt(CmModulesPanel.this.selectModule));
                        } else {
                            int n;
                            CmModulesPanel.this.modReq.removeModuleSchedule(CmModulesPanel.this.host, CmModulesPanel.this.port, ucAgentURL.getModuleId(), ucAgentURL.getInstance());
                            String string = (String)CmModulesPanel.this.paramRef.elementAt(CmModulesPanel.this.selectModule);
                            if (string != null && (n = string.indexOf("loadtimewindow =")) != -1) {
                                String string2 = string.substring(n);
                                string = string.substring(0, n);
                                int n2 = string2.indexOf(59);
                                if (n2 < string2.length() - 1) {
                                    string = String.valueOf(string) + string2.substring(n2 + 1);
                                }
                                CmModulesPanel.this.paramRef.setElementAt(string, CmModulesPanel.this.selectModule);
                            }
                            CmModulesPanel.this.modReq.loadModule(ucAgentURL.getHost(), ucAgentURL.getAgentPort(), ucAgentURL.getModuleId(), ucAgentURL.getInstance(), string);
                        }
                    }
                }
                catch (Exception exception) {
                    UcDDL.logErrorMessage((String)exception.getMessage());
                    UcDDL.logErrorMessage((String)"Failed to load module.");
                }
            }
        });
    }

    public void setHostName(String string) {
        this.host = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setRawDataRequestHandle(SMRawDataRequest sMRawDataRequest) {
        this.rawReq = sMRawDataRequest;
    }

    public void setStatusField(Object object) {
        this.status = (JLabel)object;
    }

    public void setWindowID(String string) {
        this.win = string;
    }

    public String translate(String string) {
        return UcInternationalizer.translateKey((String)("com.sun.symon.base.console.modules.ModuleBundle:" + string));
    }

    private synchronized void updateAvailSelection(Vector[] vectorArray) {
        ModuleTableModel moduleTableModel = (ModuleTableModel)this.availModulesTable.getModel();
        int n = this.availModulesTable.getSelectedRow();
        moduleTableModel.setNewData(vectorArray);
        int n2 = this.availModulesTable.getRowCount();
        if (--n2 < n) {
            this.availModulesTable.getSelectionModel().setSelectionInterval(n2, n2);
        }
        moduleTableModel.fireTableChanged(new TableModelEvent(moduleTableModel));
    }

    private synchronized void updateLoadedSelection(Vector[] vectorArray) {
        LoadedModuleModel loadedModuleModel = (LoadedModuleModel)this.loadModulesTable.getModel();
        int n = this.loadModulesTable.getSelectedRow();
        loadedModuleModel.setNewData(vectorArray);
        int n2 = this.loadModulesTable.getRowCount();
        if (--n2 < n) {
            n = n2;
        }
        this.loadModulesTable.getSelectionModel().setSelectionInterval(n, n);
        loadedModuleModel.fireTableChanged(new TableModelEvent(loadedModuleModel));
        if (n >= 0) {
            this.selectModule = loadedModuleModel.convertRowIndexToModel(n);
        }
        this.valueChanged(new ListSelectionEvent(this.loadModulesTable.getSelectionModel(), this.selectModule, this.selectModule, false));
        if (this.loadModulesTable.getSelectionModel().isSelectionEmpty() || n2 < 0) {
            this.ruleBtn.setEnabled(false);
            this.unloadBtn.setEnabled(false);
            this.editBtn.setEnabled(false);
            this.runnowBtn.setEnabled(false);
            this.enabledBtn.setEnabled(false);
            this.disabledBtn.setEnabled(false);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (listSelectionModel == this.loadModulesTable.getSelectionModel()) {
            LoadedModuleModel loadedModuleModel = (LoadedModuleModel)this.loadModulesTable.getModel();
            this.selectModule = loadedModuleModel.convertRowIndexToModel(listSelectionModel.getMinSelectionIndex());
            if (this.selectModule < 0) {
                return;
            }
            String string = (String)loadedModuleModel.getRealValueAt(this.selectModule, 1);
            Boolean bl = (Boolean)loadedModuleModel.getRealValueAt(this.selectModule, 2);
            if (string == null || bl == null) {
                return;
            }
            if (string.equals(NO) && bl.booleanValue()) {
                this.runnowBtn.setEnabled(true);
                this.enabledBtn.setEnabled(false);
                this.disabledBtn.setEnabled(false);
                this.unloadBtn.setEnabled(false);
                this.ruleBtn.setEnabled(false);
                this.editBtn.setEnabled(true);
            } else {
                this.unloadBtn.setEnabled(true);
                if (this.isRightVersion) {
                    this.ruleBtn.setEnabled(true);
                } else {
                    this.ruleBtn.setEnabled(false);
                }
                if (((Boolean)loadedModuleModel.getRealValueAt(this.selectModule, 3)).booleanValue()) {
                    this.disabledBtn.setEnabled(true);
                    this.enabledBtn.setEnabled(false);
                } else {
                    this.enabledBtn.setEnabled(true);
                    this.disabledBtn.setEnabled(false);
                }
                this.runnowBtn.setEnabled(false);
                this.editBtn.setEnabled(true);
            }
            UcAgentURL ucAgentURL = new UcAgentURL((String)this.moduleRef.elementAt(this.selectModule));
            try {
                boolean bl2 = this.modReq.isCoreModule(this.host, this.port, ucAgentURL.getModuleId(), ucAgentURL.getInstance());
                if (bl2) {
                    this.unloadBtn.setEnabled(false);
                }
            }
            catch (SMAPIException sMAPIException) {
                UcDDL.logErrorMessage((String)("Error while getting module core info" + sMAPIException.getMessage()));
            }
        } else {
            this.loadBtn.setEnabled(true);
            this.availModule = listSelectionModel.getMinSelectionIndex();
        }
    }

    class LoadedModuleModel
    extends CvBaseTableModel {
        Vector[] o = null;
        String[] columnNames = new String[]{CmModulesPanel.this.translate("moduleName"), CmModulesPanel.this.translate("moduleLoaded"), CmModulesPanel.this.translate("scheduled"), CmModulesPanel.this.translate("moduleEnabled")};

        public LoadedModuleModel(CmModulesPanel cmModulesPanel2) {
            this.o = cmModulesPanel2.getLoadedModule();
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getRealValueAt(int n, int n2) {
            if (n < 0 || n2 < 0) {
                return null;
            }
            if (this.o[n2].size() <= n) {
                return null;
            }
            return this.o[n2].elementAt(n);
        }

        public int getRowCount() {
            return this.o == null ? 0 : this.o[0].size();
        }

        public void setNewData(Vector[] vectorArray) {
            this.o = vectorArray;
        }

        public void setRealValueAt(Object object, int n, int n2) {
            this.o[n2].setElementAt(object, n);
        }
    }

    class ModuleTableModel
    extends CvBaseTableModel {
        Vector[] o = null;
        String[] colNames = new String[]{CmModulesPanel.this.translate("moduleName"), CmModulesPanel.this.translate("instance")};

        public ModuleTableModel(CmModulesPanel cmModulesPanel2) {
            this.o = cmModulesPanel2.getAllModule();
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public int getColumnCount() {
            return this.colNames.length;
        }

        public String getColumnName(int n) {
            return this.colNames[n];
        }

        public Object getRealValueAt(int n, int n2) {
            return this.o[n2].elementAt(n);
        }

        public int getRowCount() {
            return this.o == null ? 0 : this.o[0].size();
        }

        public void setNewData(Vector[] vectorArray) {
            this.o = vectorArray;
        }
    }

    class BooleanRenderer
    extends DefaultTableCellRenderer {
        BooleanRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (((Boolean)object).booleanValue()) {
                jLabel.setIcon(CmModulesPanel.this.scheduledIcon);
                jLabel.setText(CmModulesPanel.YES);
            } else {
                jLabel.setIcon(CmModulesPanel.this.noScheduledIcon);
                jLabel.setText(CmModulesPanel.NO);
            }
            return jLabel;
        }
    }

    class StatusRenderer
    extends DefaultTableCellRenderer {
        StatusRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (((Boolean)object).booleanValue()) {
                jLabel.setText(CmModulesPanel.YES);
            } else {
                jLabel.setText(CmModulesPanel.NO);
            }
            return jLabel;
        }
    }

    class InstanceRenderer
    extends DefaultTableCellRenderer {
        InstanceRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (((Boolean)object).booleanValue()) {
                jLabel.setIcon(CmModulesPanel.this.multiIcon);
                jLabel.setText(CmModulesPanel.YES);
            } else {
                jLabel.setIcon(CmModulesPanel.this.singleIcon);
                jLabel.setText(CmModulesPanel.NO);
            }
            return jLabel;
        }
    }
}

