/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.mcp;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.base.client.console.SMConsoleContext;
import com.sun.symon.base.client.mcp.SMMCP;
import com.sun.symon.base.client.mcp.SMParcelData;
import com.sun.symon.base.client.module.SMModuleInfo;
import com.sun.symon.base.client.module.SMModuleRequest;
import com.sun.symon.base.client.service.SMDuplicateException;
import com.sun.symon.base.client.service.SMLengthException;
import com.sun.symon.base.client.service.SMSecurityException;
import com.sun.symon.base.console.grouping.CgUtil;
import com.sun.symon.base.console.grouping.table.CgData;
import com.sun.symon.base.console.grouping.table.CgRowSaveEvent;
import com.sun.symon.base.console.grouping.table.CgRowSaveListener;
import com.sun.symon.base.console.grouping.table.CgTable;
import com.sun.symon.base.console.grouping.table.CgTblColumnFormat;
import com.sun.symon.base.console.grouping.table.CgTblModel;
import com.sun.symon.base.console.grouping.table.CgTblPane;
import com.sun.symon.base.console.grouping.table.CgTblSelectEvent;
import com.sun.symon.base.console.grouping.table.CgTblSelectListener;
import com.sun.symon.base.console.manager.CmConsoleSession;
import com.sun.symon.base.console.mcp.CpEditParcelDialog;
import com.sun.symon.base.console.mcp.CpFieldValidator;
import com.sun.symon.base.console.mcp.CpMCPController;
import com.sun.symon.base.utility.UcCommon;
import com.sun.symon.base.utility.UcDialog;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcURL;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class CpMCPManager
extends JDialog
implements CgTblSelectListener,
CgRowSaveListener {
    private static final int NAME_COLUMN = 0;
    private static final int HOST_COLUMN = 1;
    private static final int PORT_COLUMN = 2;
    private static final int MODULES_COLUMN = 3;
    private static final int MAX_COLUMNS = 4;
    private static final String MODULES_SPECIFIED = "true";
    private static final String MODULES_NOT_SPECIFIED = "false";
    private static int testRows_ = 1;
    private SMMCP mcp_ = null;
    private static boolean testing_ = false;
    private boolean isAddingRow_ = false;
    private int currentRow_ = -1;
    private ImageIcon moduleIcon_;
    private boolean tableEnabled_ = true;
    private boolean okButtonSelected_ = false;
    private Hashtable localizedModule_ = null;
    private boolean isSaving_ = false;
    JPanel bottomPanel_ = new JPanel();
    JButton cancelButton_ = new JButton();
    JButton helpButton_ = new JButton();
    JPanel buttonPanel_ = new JPanel();
    FlowLayout buttonFlowLayout_ = new FlowLayout();
    JLabel statusLabel_ = new JLabel();
    GridBagLayout bottomGridBagLayout_ = new GridBagLayout();
    JSeparator separator_ = new JSeparator();
    JPanel bodyPanel_ = new JPanel();
    BorderLayout mainBorderLayout_ = new BorderLayout();
    JPanel modulePanel_ = new JPanel();
    JLabel moduleLabel_ = new JLabel();
    GridBagLayout moduleGridBagLayout_ = new GridBagLayout();
    JPanel moduleListPanel_ = new JPanel();
    JButton okButton_ = new JButton();
    JButton applyButton_ = new JButton();
    JScrollPane moduleScrollPane_ = new JScrollPane();
    BorderLayout moduleListBorderLayout_ = new BorderLayout();
    JList moduleList_ = new JList();
    JPanel moduleLabelPanel_ = new JPanel();
    BorderLayout moduleLabelBorderLayout_ = new BorderLayout();
    JLabel syncDateLabel_ = new JLabel();
    GridBagLayout bodyGridBagLayout_ = new GridBagLayout();
    JButton deleteButton_ = new JButton();
    BorderLayout parcelButtonBorderLayout_ = new BorderLayout();
    JPanel parcelButtonPanel_ = new JPanel();
    BorderLayout moduleButtonBorderLayout_ = new BorderLayout();
    JButton syncButton_ = new JButton();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JPanel moduleButtonPanel_ = new JPanel();
    GridBagLayout parcelGridBagLayout_ = new GridBagLayout();
    GridBagLayout descGridBagLayout_ = new GridBagLayout();
    BorderLayout parcelDescBorderLayout_ = new BorderLayout();
    CgTblPane table_ = new CgTblPane();
    JLabel parcelTitleLabel_ = new JLabel();
    JPanel parcelPanel_ = new JPanel();
    JPanel descPanel_ = new JPanel();
    BorderLayout tableDescBorderLayout_ = new BorderLayout();
    JLabel descLabel_ = new JLabel();
    JTextArea descTextArea_ = new JTextArea();
    JPanel tableDescPanel_ = new JPanel();
    JPanel parcelDescPanel_ = new JPanel();

    public CpMCPManager() throws SMAPIException {
        this(false);
    }

    CpMCPManager(boolean bl) {
        testing_ = bl;
        this.initTable();
        try {
            this.jbInit();
        }
        catch (Exception exception) {}
        this.syncDateLabel_.setFont(new Font("Dialog", 0, 12));
        this.syncDateLabel_.setForeground(Color.black);
        this.moduleList_.setBackground(this.syncDateLabel_.getBackground());
        this.moduleList_.setSelectionBackground(this.syncDateLabel_.getBackground());
        this.moduleList_.setSelectionForeground(Color.black);
        this.moduleList_.setForeground(Color.black);
        this.statusLabel_.setForeground(Color.black);
        this.localize();
        this.pack();
        ((Component)this).setSize(600, 480);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((int)(dimension.getWidth() - (double)this.getWidth()) / 2, (int)(dimension.getHeight() - (double)this.getHeight()) / 2);
        this.refreshParcels();
        ((Component)this).setVisible(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (!CpMCPManager.this.isSaving_) {
                    CpMCPManager.this.cancelButton_.doClick();
                }
            }
        });
    }

    void applyButton__actionPerformed(ActionEvent actionEvent) {
        this.table_.getTable().editingStopped(new ChangeEvent(this));
        this.save();
    }

    void cancelButton__actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    public Object cellButtonPressed() {
        CpEditParcelDialog cpEditParcelDialog;
        String[] stringArray;
        int n;
        int n2 = this.table_.getRowCount() - 1;
        Vector vector = this.table_.getRowData(n2);
        String string = this.getEnteredValue((CgData)vector.elementAt(1));
        if (string == null) {
            CpMCPManager.showError("hostMissing");
            return null;
        }
        String string2 = this.getEnteredValue((CgData)vector.elementAt(2));
        if (string2 == null) {
            CpMCPManager.showError("portMissing");
            return null;
        }
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            n = 161;
        }
        if (n <= 0) {
            n = 161;
        }
        if ((stringArray = (cpEditParcelDialog = new CpEditParcelDialog(string, n, this.localizedModule_)).getModules()) == null) {
            return null;
        }
        CgData cgData = new CgData(MODULES_SPECIFIED, null, stringArray);
        String[] stringArray2 = new String[stringArray.length];
        int n3 = 0;
        while (n3 < stringArray.length) {
            stringArray2[n3] = this.localizeModule(stringArray[n3]);
            ++n3;
        }
        this.moduleList_.setListData(stringArray2);
        return cgData;
    }

    void deleteButton__actionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = new String[]{CpMCPManager.localize("standard.delete"), CpMCPManager.localize("standard.cancel")};
        String string = CpMCPManager.localize("alert");
        String string2 = CpMCPManager.localize("permDelete");
        String string3 = CpMCPManager.localize("confirmDelete");
        JLabel jLabel = new JLabel(string3);
        jLabel.setFont(new Font("Dialog", 0, 12));
        jLabel.setForeground(Color.black);
        int n = JOptionPane.showOptionDialog(this, new Object[]{string2, jLabel}, string, 0, 2, null, objectArray, objectArray[1]);
        if (n != 0) {
            return;
        }
        this.setStatusMessage("deleting");
        this.setTableEnabled(false);
        this.deleteButton_.setEnabled(false);
        this.syncButton_.setEnabled(false);
        Thread thread = new Thread(){

            public void run() {
                SMParcelData sMParcelData = CpMCPManager.this.getRowData(CpMCPManager.this.table_.getSelectedRow());
                try {
                    try {
                        if (CpMCPManager.isTesting()) {
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (Exception exception) {}
                            testRows_ = testRows_ - 1;
                        } else {
                            CpMCPManager.this.mcp_.delete(sMParcelData.getObjectID());
                        }
                        CpMCPManager.this.setTableEnabled(true);
                        CpMCPManager.this.refreshParcels();
                    }
                    catch (SMSecurityException sMSecurityException) {
                        CpMCPManager.showError("securityError");
                        CpMCPManager.this.setTableEnabled(true);
                        CpMCPManager.this.deleteButton_.setEnabled(true);
                        CpMCPManager.this.syncButton_.setEnabled(true);
                    }
                    catch (Exception exception) {
                        CpMCPManager.showError("parcelDeleteError");
                        CpMCPManager.this.setTableEnabled(true);
                        CpMCPManager.this.deleteButton_.setEnabled(true);
                        CpMCPManager.this.syncButton_.setEnabled(true);
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    CpMCPManager.this.setStatusMessage("");
                    throw throwable;
                }
                CpMCPManager.this.setStatusMessage("");
            }
        };
        thread.start();
    }

    public void dispose() {
        this.table_.removeCgTblSelectListener(this);
        if (this.mcp_ != null) {
            try {
                this.mcp_.close();
            }
            catch (SMAPIException sMAPIException) {}
            this.mcp_ = null;
        }
        super.dispose();
    }

    private void getAllParcels() {
        SMParcelData sMParcelData;
        SMParcelData[] sMParcelDataArray;
        if (!CpMCPManager.isTesting()) {
            try {
                if (this.mcp_ == null) {
                    this.mcp_ = new SMMCP(SMConsoleContext.getInstance().getAPIHandle());
                }
            }
            catch (Exception exception) {
                CpMCPManager.showError("serviceError");
                return;
            }
            try {
                sMParcelDataArray = this.mcp_.getAll();
                CgData[][] cgDataArray = new CgData[sMParcelDataArray.length][4];
                int n = 0;
                while (n < sMParcelDataArray.length) {
                    sMParcelData = this.mcp_.load(sMParcelDataArray[n].getObjectID());
                    cgDataArray[n][0] = new CgData(sMParcelData.getName(), null, sMParcelData);
                    cgDataArray[n][1] = new CgData(sMParcelData.getHost());
                    cgDataArray[n][2] = new CgData(String.valueOf(sMParcelData.getPort()));
                    cgDataArray[n][3] = new CgData(MODULES_SPECIFIED);
                    ++n;
                }
                this.table_.setData(cgDataArray);
                this.table_.setRowSelectionInterval(0, 0);
            }
            catch (SMAPIException sMAPIException) {
                sMAPIException.printStackTrace();
                CpMCPManager.showError("parcelRetrieveError");
                return;
            }
        }
        sMParcelDataArray = new SMParcelData[testRows_];
        try {
            int n = 0;
            while (n < testRows_) {
                sMParcelDataArray[n] = new SMParcelData();
                sMParcelDataArray[n].setName("Server" + n);
                sMParcelDataArray[n].setHost("osftserv" + n);
                sMParcelDataArray[n].setPort(1161);
                sMParcelDataArray[n].setDescription("This is a server" + n + " cfg.\nThis is the 2nd line.");
                sMParcelDataArray[n].setSyncDate(new Date());
                if (n % 2 == 0) {
                    sMParcelDataArray[n].setModules(new String[]{"fscan", "health-monitor"});
                } else {
                    sMParcelDataArray[n].setModules(new String[]{"kernel-reader", "fscan"});
                }
                ++n;
            }
        }
        catch (Exception exception) {}
        sMParcelData = new CgData[sMParcelDataArray.length][4];
        int n = 0;
        while (n < sMParcelDataArray.length) {
            sMParcelData[n][0] = new CgData(sMParcelDataArray[n].getName(), null, sMParcelDataArray[n]);
            sMParcelData[n][1] = new CgData(sMParcelDataArray[n].getHost());
            sMParcelData[n][2] = new CgData(String.valueOf(sMParcelDataArray[n].getPort()));
            sMParcelData[n][3] = new CgData(MODULES_SPECIFIED);
            ++n;
        }
        this.table_.setData((CgData[][])sMParcelData);
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {}
        this.isAddingRow_ = false;
        this.currentRow_ = -1;
        this.deleteButton_.setEnabled(false);
        this.descTextArea_.setEditable(true);
        this.descTextArea_.setBackground(Color.white);
        this.descTextArea_.setText("");
        this.moduleList_.setListData(new String[0]);
        this.setSyncDate(null);
        this.syncButton_.setEnabled(false);
        if (this.table_.getRowCount() > 1) {
            this.table_.getTable().getSelectionModel().setSelectionInterval(0, 0);
            this.selectionOccurred(new CgTblSelectEvent(this, CgTblSelectEvent.SELECT, 0));
        }
        int n2 = 0;
        while (n2 < 4) {
            this.table_.setLastRowCellEditable(n2, true);
            ++n2;
        }
    }

    private String getEnteredValue(CgData cgData) {
        if (cgData == null) {
            return null;
        }
        String string = cgData.getLabel();
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).equals("")) {
            return null;
        }
        return string;
    }

    private void getLocalModuleNames() {
        if (CpMCPManager.isTesting()) {
            this.localizedModule_.put("kernel-reader", "Kernel Reader");
            this.localizedModule_.put("fscan", "File Scan");
            this.localizedModule_.put("health-monitor", "Health Monitor");
        } else {
            int n;
            SMModuleRequest sMModuleRequest = new SMModuleRequest(SMConsoleContext.getInstance().getAPIHandle());
            UcURL ucURL = new UcURL(SMConsoleContext.getInstance().getAPIHandle().getMDRBaseURL());
            try {
                n = Integer.parseInt(ucURL.getPort());
            }
            catch (Exception exception) {
                n = 168;
            }
            try {
                Vector vector = sMModuleRequest.getModuleInfo(ucURL.getHost(), n);
                sMModuleRequest = null;
                int n2 = 0;
                while (n2 < vector.size()) {
                    SMModuleInfo sMModuleInfo = (SMModuleInfo)vector.elementAt(n2);
                    this.localizedModule_.put(sMModuleInfo.getModule(), sMModuleInfo.toString());
                    ++n2;
                }
            }
            catch (Exception exception) {}
        }
    }

    private SMParcelData getRowData(int n) {
        Vector vector = this.table_.getRowData(n);
        CgData cgData = (CgData)vector.elementAt(0);
        return (SMParcelData)cgData.getUserData();
    }

    void helpButton__actionPerformed(ActionEvent actionEvent) {
        CmConsoleSession.getInstance().launchHelp("mcp-manager-help");
    }

    private void initTable() {
        CgTblColumnFormat[] cgTblColumnFormatArray = new CgTblColumnFormat[4];
        boolean bl = false;
        cgTblColumnFormatArray[0] = new CgTblColumnFormat(CpMCPManager.localize("name"), bl, new DefaultCellEditor(new JTextField(new CpFieldValidator(32, 4L), "", 0)));
        cgTblColumnFormatArray[0].setToolTip(CpMCPManager.localize("nameToolTip"));
        cgTblColumnFormatArray[1] = new CgTblColumnFormat(CpMCPManager.localize("host"), bl, new DefaultCellEditor(new JTextField(new CpFieldValidator(64, 1L), "", 0)));
        cgTblColumnFormatArray[1].setToolTip(CpMCPManager.localize("hostToolTip"));
        cgTblColumnFormatArray[2] = new CgTblColumnFormat(CpMCPManager.localize("port"), bl, new DefaultCellEditor(new JTextField(new CpFieldValidator(5, 2L), "", 0)));
        cgTblColumnFormatArray[2].setToolTip(CpMCPManager.localize("portToolTip"));
        cgTblColumnFormatArray[3] = new CgTblColumnFormat(CpMCPManager.localize("modules"), bl, new ModuleCellEditor(), new CgData(MODULES_NOT_SPECIFIED));
        cgTblColumnFormatArray[3].setToolTip(CpMCPManager.localize("modulesToolTip"));
        this.table_ = new CgTblPane(cgTblColumnFormatArray, true);
        this.table_.setAlignmentX(0.0f);
        this.table_.setShowConfirmForRow(true);
        this.table_.addCgTblSelectListener(this);
        this.table_.addCgRowSaveListener(this);
        ParcelTableCellRenderer parcelTableCellRenderer = new ParcelTableCellRenderer();
        int n = 0;
        while (n < 4) {
            TableColumn tableColumn = this.table_.getTable().getColumnModel().getColumn(n);
            tableColumn.setCellRenderer(parcelTableCellRenderer);
            if (n == 0) {
                tableColumn.setPreferredWidth(180);
            }
            ++n;
        }
    }

    private boolean isTableEnabled() {
        return this.tableEnabled_;
    }

    static boolean isTesting() {
        return testing_;
    }

    private void jbInit() throws Exception {
        this.cancelButton_.setText(CpMCPManager.localize("standard.cancel"));
        this.cancelButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CpMCPManager.this.cancelButton__actionPerformed(actionEvent);
            }
        });
        this.helpButton_.setPreferredSize(new Dimension(71, 27));
        this.helpButton_.setText(CpMCPManager.localize("standard.help"));
        this.helpButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CpMCPManager.this.helpButton__actionPerformed(actionEvent);
            }
        });
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(this.mainBorderLayout_);
        this.bottomPanel_.setLayout(this.bottomGridBagLayout_);
        this.bottomPanel_.setMinimumSize(new Dimension(0, 0));
        this.bottomPanel_.setPreferredSize(new Dimension(200, 85));
        this.buttonPanel_.setLayout(this.buttonFlowLayout_);
        this.buttonFlowLayout_.setAlignment(2);
        this.buttonFlowLayout_.setHgap(10);
        this.buttonFlowLayout_.setVgap(0);
        this.statusLabel_.setMaximumSize(new Dimension(200, 30));
        this.statusLabel_.setMinimumSize(new Dimension(200, 30));
        this.statusLabel_.setPreferredSize(new Dimension(200, 30));
        this.statusLabel_.setHorizontalTextPosition(0);
        this.buttonPanel_.setMinimumSize(new Dimension(0, 30));
        this.buttonPanel_.setPreferredSize(new Dimension(0, 30));
        this.bodyPanel_.setLayout(this.bodyGridBagLayout_);
        this.moduleLabel_.setText(CpMCPManager.localize("modulesInParcel"));
        this.modulePanel_.setLayout(this.moduleGridBagLayout_);
        this.modulePanel_.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.modulePanel_.setMinimumSize(new Dimension(92, 250));
        this.modulePanel_.setPreferredSize(new Dimension(280, 250));
        this.okButton_.setEnabled(false);
        this.okButton_.setPreferredSize(new Dimension(71, 27));
        this.okButton_.setText(CpMCPManager.localize("standard.ok"));
        this.okButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CpMCPManager.this.okButton__actionPerformed(actionEvent);
            }
        });
        this.applyButton_.setEnabled(false);
        this.applyButton_.setText(CpMCPManager.localize("standard.apply"));
        this.applyButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CpMCPManager.this.applyButton__actionPerformed(actionEvent);
            }
        });
        this.moduleListPanel_.setLayout(this.moduleListBorderLayout_);
        this.moduleLabelPanel_.setLayout(this.moduleLabelBorderLayout_);
        this.syncDateLabel_.setHorizontalAlignment(4);
        this.syncDateLabel_.setText("last");
        this.moduleLabelBorderLayout_.setHgap(10);
        this.deleteButton_.setEnabled(false);
        this.deleteButton_.setMaximumSize(new Dimension(99, 27));
        this.deleteButton_.setMinimumSize(new Dimension(99, 27));
        this.deleteButton_.setPreferredSize(new Dimension(99, 27));
        this.deleteButton_.setText(CpMCPManager.localize("delete"));
        this.deleteButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CpMCPManager.this.deleteButton__actionPerformed(actionEvent);
            }
        });
        this.parcelButtonPanel_.setLayout(this.parcelButtonBorderLayout_);
        this.syncButton_.setEnabled(false);
        this.syncButton_.setText(CpMCPManager.localize("sync"));
        this.syncButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CpMCPManager.this.syncButton__actionPerformed(actionEvent);
            }
        });
        this.moduleButtonPanel_.setLayout(this.moduleButtonBorderLayout_);
        this.parcelTitleLabel_.setText(CpMCPManager.localize("parcels"));
        this.parcelPanel_.setLayout(this.parcelGridBagLayout_);
        this.descPanel_.setLayout(this.descGridBagLayout_);
        this.descPanel_.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.descPanel_.setMinimumSize(new Dimension(221, 75));
        this.descPanel_.setPreferredSize(new Dimension(221, 75));
        this.descLabel_.setText(CpMCPManager.localize("description"));
        this.descTextArea_.setPreferredSize(new Dimension(4, 36));
        this.descTextArea_.setRows(2);
        this.descTextArea_.setBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)));
        this.descTextArea_.setMinimumSize(new Dimension(4, 36));
        this.tableDescPanel_.setLayout(this.tableDescBorderLayout_);
        this.parcelDescPanel_.setLayout(this.parcelDescBorderLayout_);
        this.parcelPanel_.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.parcelPanel_.setMinimumSize(new Dimension(241, 250));
        this.parcelPanel_.setPreferredSize(new Dimension(241, 250));
        this.getContentPane().add((Component)this.bottomPanel_, "South");
        this.bottomPanel_.add((Component)this.buttonPanel_, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
        this.buttonPanel_.add((Component)this.okButton_, null);
        this.buttonPanel_.add((Component)this.applyButton_, null);
        this.buttonPanel_.add((Component)this.cancelButton_, null);
        this.buttonPanel_.add((Component)this.helpButton_, null);
        this.bottomPanel_.add((Component)this.statusLabel_, new GridBagConstraints(0, 3, 1, 2, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 197, 2));
        this.bottomPanel_.add((Component)this.separator_, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 15, 0), 0, 0));
        this.getContentPane().add((Component)this.bodyPanel_, "Center");
        this.bodyPanel_.add((Component)this.modulePanel_, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.modulePanel_.add((Component)this.moduleListPanel_, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.moduleListPanel_.add((Component)this.moduleScrollPane_, "Center");
        this.moduleScrollPane_.getViewport().add((Component)this.moduleList_, null);
        this.modulePanel_.add((Component)this.moduleLabelPanel_, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.moduleLabelPanel_.add((Component)this.moduleLabel_, "West");
        this.moduleLabelPanel_.add((Component)this.syncDateLabel_, "Center");
        this.bodyPanel_.add((Component)this.parcelButtonPanel_, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(27, 0, 0, 10), 0, 0));
        this.parcelButtonPanel_.add((Component)this.deleteButton_, "North");
        this.bodyPanel_.add((Component)this.moduleButtonPanel_, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(27, 0, 0, 10), 0, 0));
        this.moduleButtonPanel_.add((Component)this.syncButton_, "North");
        this.bodyPanel_.add((Component)this.parcelPanel_, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.parcelPanel_.add((Component)this.parcelTitleLabel_, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.parcelPanel_.add((Component)this.parcelDescPanel_, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.parcelDescPanel_.add((Component)this.tableDescPanel_, "Center");
        this.tableDescPanel_.add((Component)this.descPanel_, "South");
        this.descPanel_.add((Component)this.descLabel_, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 160), 0, 0));
        this.descPanel_.add((Component)this.descTextArea_, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.tableDescPanel_.add((Component)this.table_, "Center");
    }

    private void localize() {
        this.setTitle(CpMCPManager.localize("title"));
        this.parcelTitleLabel_.setText(CpMCPManager.localize("parcels"));
        this.deleteButton_.setText(CpMCPManager.localize("delete"));
        this.descLabel_.setText(CpMCPManager.localize("description"));
        this.moduleLabel_.setText(CpMCPManager.localize("modulesInParcel"));
        this.setSyncDate(null);
        this.syncButton_.setText(CpMCPManager.localize("sync"));
        this.okButton_.setText(CpMCPManager.localize("standard.ok"));
        this.applyButton_.setText(CpMCPManager.localize("standard.apply"));
        this.cancelButton_.setText(CpMCPManager.localize("standard.cancel"));
        this.helpButton_.setText(CpMCPManager.localize("standard.help"));
    }

    static String localize(String string) {
        if (string.equals("")) {
            return "";
        }
        String string2 = UcInternationalizer.translateKey((String)("com.sun.symon.base.console.mcp.CpMCPManager:" + string), (boolean)false);
        if (!string2.startsWith("com.")) {
            return string2;
        }
        string2 = UcInternationalizer.translateKey((String)("com.sun.symon.base.console.ConsoleGeneric:" + string), (boolean)false);
        if (!string2.startsWith("com.")) {
            return string2;
        }
        string2 = UcInternationalizer.translateKey((String)("com.sun.symon.base.utility.UcDialogBundle:" + string), (boolean)false);
        if (!string2.startsWith("com.")) {
            return string2;
        }
        return string;
    }

    private String localizeModule(String string) {
        int n = string.indexOf("+");
        String string2 = n == -1 ? string : string.substring(0, n);
        String string3 = (String)this.localizedModule_.get(string2);
        if (string3 == null) {
            return string;
        }
        return n == -1 ? string3 : String.valueOf(string3) + " [" + string.substring(n + 1) + "]";
    }

    void okButton__actionPerformed(ActionEvent actionEvent) {
        this.okButtonSelected_ = true;
        this.applyButton__actionPerformed(actionEvent);
    }

    private void refreshParcels() {
        this.deleteButton_.setEnabled(false);
        this.syncButton_.setEnabled(false);
        this.setStatusMessage("retrieving");
        final CpMCPManager cpMCPManager = this;
        Thread thread = new Thread(){

            public void run() {
                if (!CpMCPManager.isTesting()) {
                    UcCommon.isServiceLicenseAvailable((String)"MCP", (Component)cpMCPManager);
                }
                if (moduleIcon_ == null) {
                    if (CpMCPManager.isTesting()) {
                        moduleIcon_ = new ImageIcon("\\mcp\\AddTask-16x16.gif");
                    } else {
                        SMResourceAccess sMResourceAccess = new SMResourceAccess(SMConsoleContext.getInstance().getAPIHandle());
                        moduleIcon_ = new ImageIcon(sMResourceAccess.getImage("stdimages/AddTask-16x16.gif"));
                    }
                }
                if (localizedModule_ == null) {
                    localizedModule_ = new Hashtable();
                    this.getLocalModuleNames();
                }
                try {
                    this.getAllParcels();
                }
                finally {
                    Object var2_3 = null;
                    this.setStatusMessage("");
                }
            }
        };
        thread.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void save() {
        String[] stringArray;
        int n;
        String string;
        String string2;
        Object object;
        boolean bl;
        int n2;
        block21: {
            block20: {
                block19: {
                    block18: {
                        block17: {
                            this.currentRow_ = n2 = this.table_.getRowCount() - 1;
                            bl = false;
                            this.isSaving_ = true;
                            try {
                                CgData cgData;
                                String string3;
                                object = this.table_.getRowData(n2);
                                string2 = this.getEnteredValue((CgData)((Vector)object).elementAt(0));
                                string = this.getEnteredValue((CgData)((Vector)object).elementAt(1));
                                String string4 = this.getEnteredValue((CgData)((Vector)object).elementAt(2));
                                if (string2 == null && string == null && string4 == null) {
                                    if (this.okButtonSelected_) {
                                        this.dispose();
                                        this.okButtonSelected_ = false;
                                    }
                                    Object var10_7 = null;
                                    if (!bl) {
                                        this.currentRow_ = n2;
                                        this.table_.getTable().getSelectionModel().setSelectionInterval(n2, n2);
                                        return;
                                    }
                                    return;
                                }
                                if (string2 == null) {
                                    CpMCPManager.showError("parcelNameMissing");
                                    break block17;
                                }
                                if (string == null) {
                                    CpMCPManager.showError("hostMissing");
                                    break block18;
                                }
                                if (string4 == null) {
                                    CpMCPManager.showError("portMissing");
                                    break block19;
                                }
                                try {
                                    n = Integer.parseInt(string4);
                                }
                                catch (Exception exception) {
                                    n = 161;
                                }
                                if (n <= 0) {
                                    n = 161;
                                }
                                if (!(string3 = this.getEnteredValue(cgData = (CgData)((Vector)object).elementAt(3))).equals(MODULES_SPECIFIED)) {
                                    CpMCPManager.showError("modulesMissing");
                                    break block20;
                                }
                                stringArray = (String[])cgData.getUserData();
                                bl = true;
                                break block21;
                            }
                            catch (Throwable throwable) {
                                Object var10_13 = null;
                                if (!bl) {
                                    this.currentRow_ = n2;
                                    this.table_.getTable().getSelectionModel().setSelectionInterval(n2, n2);
                                    return;
                                }
                                throw throwable;
                            }
                        }
                        Object var10_8 = null;
                        if (bl) return;
                        this.currentRow_ = n2;
                        this.table_.getTable().getSelectionModel().setSelectionInterval(n2, n2);
                        return;
                    }
                    Object var10_9 = null;
                    if (bl) return;
                    this.currentRow_ = n2;
                    this.table_.getTable().getSelectionModel().setSelectionInterval(n2, n2);
                    return;
                }
                Object var10_10 = null;
                if (bl) return;
                this.currentRow_ = n2;
                this.table_.getTable().getSelectionModel().setSelectionInterval(n2, n2);
                return;
            }
            Object var10_11 = null;
            if (bl) return;
            this.currentRow_ = n2;
            this.table_.getTable().getSelectionModel().setSelectionInterval(n2, n2);
            return;
        }
        final SMParcelData sMParcelData = null;
        if (!bl) {
            this.currentRow_ = n2;
            this.table_.getTable().getSelectionModel().setSelectionInterval(n2, n2);
            return;
        }
        String string5 = this.descTextArea_.getText();
        string5 = string5 != null ? string5.trim() : "";
        sMParcelData = new SMParcelData();
        try {
            sMParcelData.setName(string2);
            sMParcelData.setHost(string);
            sMParcelData.setPort(n);
            sMParcelData.setDescription(string5);
            sMParcelData.setModules(stringArray);
        }
        catch (SMLengthException sMLengthException) {}
        if (CpMCPManager.isTesting()) {
            System.out.println(sMParcelData);
            ++testRows_;
        }
        this.setStatusMessage("saving");
        this.deleteButton_.setEnabled(false);
        this.syncButton_.setEnabled(false);
        this.applyButton_.setEnabled(false);
        this.cancelButton_.setEnabled(false);
        this.okButton_.setEnabled(false);
        this.setTableEnabled(false);
        object = new Thread(){

            public void run() {
                block8: {
                    try {
                        CpMCPController cpMCPController;
                        if (CpMCPManager.isTesting()) {
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (Exception exception) {}
                        }
                        if ((cpMCPController = new CpMCPController(mcp_)).save(sMParcelData, true)) {
                            this.setTableEnabled(true);
                            if (!okButtonSelected_) {
                                this.refreshParcels();
                            }
                            break block8;
                        }
                        this.setTableEnabled(true);
                        deleteButton_.setEnabled(true);
                        syncButton_.setEnabled(true);
                        applyButton_.setEnabled(true);
                        okButton_.setEnabled(true);
                        cancelButton_.setEnabled(true);
                    }
                    catch (Throwable throwable) {
                        Object var2_3 = null;
                        this.setStatusMessage("");
                        throw throwable;
                    }
                }
                Object var2_2 = null;
                this.setStatusMessage("");
                if (okButtonSelected_) {
                    this.dispose();
                    okButtonSelected_ = false;
                }
                isSaving_ = false;
            }
        };
        ((Thread)object).start();
    }

    public boolean saveData(CgRowSaveEvent cgRowSaveEvent) {
        this.table_.getTable().editingStopped(new ChangeEvent(this));
        this.save();
        return true;
    }

    public void selectionOccurred(CgTblSelectEvent cgTblSelectEvent) {
        if (!this.isTableEnabled()) {
            return;
        }
        if (cgTblSelectEvent.getEventType() == CgTblSelectEvent.SELECT) {
            Object object;
            Object object2;
            if (cgTblSelectEvent.getSelectedRow() < this.table_.getRowCount() - 1) {
                this.isAddingRow_ = false;
                this.deleteButton_.setEnabled(true);
                object2 = this.getRowData(cgTblSelectEvent.getSelectedRow());
                this.descTextArea_.setEditable(false);
                this.descTextArea_.setBackground(UcCommon.getLightGrayColor());
                this.descTextArea_.setText(object2.getDescription());
                this.setSyncDate(object2.getSyncDate());
                this.syncButton_.setEnabled(true);
                object = object2.getModules();
                String[] stringArray = new String[((String[])object).length];
                int n = 0;
                while (n < ((String[])object).length) {
                    stringArray[n] = this.localizeModule(object[n]);
                    ++n;
                }
                this.moduleList_.setListData(stringArray);
                this.applyButton_.setEnabled(true);
                this.okButton_.setEnabled(true);
                this.cancelButton_.setEnabled(true);
            } else {
                this.isAddingRow_ = true;
                this.deleteButton_.setEnabled(false);
                this.descTextArea_.setEditable(true);
                this.descTextArea_.setBackground(Color.white);
                this.descTextArea_.setText("");
                this.moduleList_.setListData(new String[0]);
                this.applyButton_.setEnabled(true);
                this.okButton_.setEnabled(true);
                this.cancelButton_.setEnabled(true);
                this.setSyncDate(null);
                this.syncButton_.setEnabled(false);
            }
            if (this.currentRow_ != cgTblSelectEvent.getSelectedRow()) {
                this.currentRow_ = cgTblSelectEvent.getSelectedRow();
                if (this.table_.getTable().isDataUpdated()) {
                    object2 = CgUtil.getI18nMsg("table.confirmSave");
                    object = CgUtil.getI18nMsg("table.cancelSave");
                    int n = UcDialog.showOkCancel((String)(String.valueOf(object2) + (String)object));
                    if (n == 0) {
                        this.save();
                    } else {
                        this.table_.resetWorkingRow();
                    }
                }
            }
        }
    }

    private void setStatusMessage(String string) {
        this.statusLabel_.setText(CpMCPManager.localize(string));
    }

    private void setSyncDate(Date date) {
        if (date == null) {
            this.syncDateLabel_.setText("");
        } else {
            this.syncDateLabel_.setText(String.valueOf(CpMCPManager.localize("syncDate")) + ": " + date);
        }
    }

    private void setTableEnabled(boolean bl) {
        if (!this.tableEnabled_ && bl) {
            this.table_.getTable().getSelectionModel().setSelectionInterval(this.currentRow_, this.currentRow_);
        }
        this.tableEnabled_ = bl;
    }

    static void setTesting(boolean bl) {
        testing_ = bl;
    }

    static void showError(String string) {
        UcDialog.showError(null, (Object)CpMCPManager.localize(string));
    }

    void syncButton__actionPerformed(ActionEvent actionEvent) {
        final SMParcelData sMParcelData = this.getRowData(this.table_.getSelectedRow());
        if (sMParcelData == null) {
            return;
        }
        this.setStatusMessage("synchronizing");
        this.setTableEnabled(false);
        this.deleteButton_.setEnabled(false);
        this.syncButton_.setEnabled(false);
        Thread thread = new Thread(){

            public void run() {
                block2: {
                    try {
                        CpMCPController cpMCPController = new CpMCPController(mcp_);
                        Date date = cpMCPController.sync(sMParcelData.getObjectID());
                        if (date == null) break block2;
                        sMParcelData.setSyncDate(date);
                        if (sMParcelData.getSyncDate() == null) break block2;
                        this.setSyncDate(sMParcelData.getSyncDate());
                    }
                    catch (Throwable throwable) {
                        Object var2_4 = null;
                        this.setTableEnabled(true);
                        deleteButton_.setEnabled(true);
                        syncButton_.setEnabled(true);
                        this.setStatusMessage("");
                        throw throwable;
                    }
                }
                Object var2_3 = null;
                this.setTableEnabled(true);
                deleteButton_.setEnabled(true);
                syncButton_.setEnabled(true);
                this.setStatusMessage("");
            }
        };
        thread.start();
    }

    private void throwEx() throws SMAPIException {
        throw new SMDuplicateException();
    }

    class ParcelTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private Border focusBorder_;
        private Border noFocusBorder_;

        public ParcelTableCellRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setFont(new Font("dialog", 0, 12));
            this.focusBorder_ = BorderFactory.createLineBorder(new Color(102, 102, 153), 1);
            this.noFocusBorder_ = new EmptyBorder(1, 2, 1, 2);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            CgTable cgTable = (CgTable)jTable;
            if (n == jTable.getRowCount() - 1) {
                int n3;
                CgTblModel cgTblModel = (CgTblModel)cgTable.getModel();
                String string = cgTblModel.getColumnToolTip(n3 = cgTable.convertColumnIndexToModel(n2));
                if (string != null) {
                    this.setToolTipText(string);
                } else {
                    this.setToolTipText(null);
                }
            }
            if (object != null) {
                if (n2 == 3) {
                    if (object.toString().equals(CpMCPManager.MODULES_SPECIFIED)) {
                        this.setHorizontalAlignment(0);
                        this.setText(null);
                        this.setIcon(CpMCPManager.this.moduleIcon_);
                    } else if (object.toString().equals(CpMCPManager.MODULES_NOT_SPECIFIED)) {
                        this.setText(null);
                        this.setIcon(null);
                    } else {
                        this.setHorizontalAlignment(2);
                        this.setText(object.toString());
                        this.setIcon(null);
                    }
                } else {
                    this.setHorizontalAlignment(2);
                    this.setText(object.toString());
                    this.setIcon(null);
                }
            }
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(UcCommon.getLightGrayColor());
                this.setForeground(cgTable.getForeground());
            }
            if (bl2) {
                this.setBorder(this.focusBorder_);
            } else {
                this.setBorder(this.noFocusBorder_);
            }
            return this;
        }
    }

    class ModuleCellEditor
    extends DefaultCellEditor {
        private Object result_;
        private JLabel label_ = new JLabel();

        public ModuleCellEditor() {
            super(new JTextField());
            this.setClickCountToStart(1);
            this.label_.setHorizontalAlignment(0);
            this.label_.setOpaque(true);
        }

        public Object getCellEditorValue() {
            return this.result_;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            String string = jTable.getValueAt(n, n2).toString();
            if (string.equals(CpMCPManager.MODULES_SPECIFIED)) {
                this.label_.setIcon(CpMCPManager.this.moduleIcon_);
            } else {
                Object object2 = CpMCPManager.this.cellButtonPressed();
                if (object2 == null) {
                    this.result_ = CpMCPManager.MODULES_NOT_SPECIFIED;
                    this.label_.setIcon(null);
                } else {
                    this.result_ = object2;
                    this.label_.setIcon(CpMCPManager.this.moduleIcon_);
                    jTable.setValueAt(object2, n, n2);
                }
                bl = true;
            }
            if (bl) {
                this.label_.setForeground(jTable.getSelectionForeground());
                this.label_.setBackground(jTable.getSelectionBackground());
            } else {
                this.label_.setBackground(UcCommon.getLightGrayColor());
                this.label_.setForeground(jTable.getForeground());
            }
            return this.label_;
        }
    }
}

