/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.grouping.table;

import com.sun.symon.base.console.grouping.table.CgCancelRowSaveListener;
import com.sun.symon.base.console.grouping.table.CgData;
import com.sun.symon.base.console.grouping.table.CgRowSaveListener;
import com.sun.symon.base.console.grouping.table.CgRowTransEvent;
import com.sun.symon.base.console.grouping.table.CgRowTransListener;
import com.sun.symon.base.console.grouping.table.CgTable;
import com.sun.symon.base.console.grouping.table.CgTblColumnFormat;
import com.sun.symon.base.console.grouping.table.CgTblModel;
import com.sun.symon.base.console.grouping.table.CgTblSelectListener;
import com.sun.symon.base.console.grouping.table.CgTblUpdateListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;

public class CgTblPane
extends JPanel
implements CgRowTransListener {
    private boolean editable;
    private int columnNum;
    private CgTable table;
    private CgTblModel model;
    private boolean confirmRow = true;
    static int TRUE = 0;
    static int FALSE = 1;
    static int USEDEFAULT = 2;
    private boolean noNewRow = false;

    public CgTblPane() {
        this((CgTblColumnFormat[])null, true);
    }

    public CgTblPane(boolean bl) {
        this((CgTblColumnFormat[])null, bl);
    }

    public CgTblPane(CgTblColumnFormat[] cgTblColumnFormatArray, boolean bl) {
        this.setLayout(new BoxLayout(this, 1));
        this.editable = bl;
        if (cgTblColumnFormatArray != null) {
            this.setupTable(cgTblColumnFormatArray);
        }
    }

    public void addCgCancelRowSaveListener(CgCancelRowSaveListener cgCancelRowSaveListener) {
        if (this.table != null) {
            this.table.addCgCancelRowSaveListener(cgCancelRowSaveListener);
        }
    }

    public void addCgRowSaveListener(CgRowSaveListener cgRowSaveListener) {
        if (this.table != null) {
            this.table.addCgRowSaveListener(cgRowSaveListener);
        }
    }

    public void addCgTblSelectListener(CgTblSelectListener cgTblSelectListener) {
        if (this.table != null) {
            this.table.addCgTblSelectListener(cgTblSelectListener);
        }
    }

    public void addCgTblUpdateListener(CgTblUpdateListener cgTblUpdateListener) {
        if (this.table != null) {
            this.table.addCgTblUpdateListener(cgTblUpdateListener);
        }
    }

    public void addRow(Vector vector) {
        int n = !this.noNewRow ? this.getRowCount() - 1 : this.getRowCount() - 2;
        if (n < 0) {
            n = 0;
        } else if (n > this.getRowCount()) {
            n = this.getRowCount() - 1;
        }
        this.table.insertRow(vector, n);
    }

    public static Vector array2Vector(Object[] objectArray) {
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        while (n < objectArray.length) {
            vector.add(objectArray[n]);
            ++n;
        }
        return vector;
    }

    public void clearSelection() {
        this.table.clearSelection();
    }

    public void deleteRow(int n) {
        this.table.deleteRow(n);
    }

    public CgData getColumnDefaultVal(int n) {
        int n2 = this.table.convertColumnIndexToModel(n);
        return this.model.getColumnDefaultVal(n2);
    }

    public int getPreEditingColumn() {
        return this.table.getPreEditingColumn();
    }

    public int getPreEditingRow() {
        return this.table.getPreEditingRow();
    }

    public int getRowCount() {
        return this.table.getRowCount();
    }

    public Vector getRowData(int n) {
        Vector<Object> vector = new Vector<Object>();
        int n2 = 0;
        while (n2 < this.table.getColumnCount()) {
            vector.add(this.getValueAt(n, n2));
            ++n2;
        }
        return vector;
    }

    public int getSelectedRow() {
        return this.table.getSelectedRow();
    }

    public int getSelectedRowCount() {
        return this.table.getSelectedRowCount();
    }

    public CgTable getTable() {
        return this.table;
    }

    public Object getValueAt(int n, int n2) {
        CgData cgData = (CgData)this.table.getCurrentValueAt(n, n2);
        if (cgData != null && cgData.isDummy()) {
            cgData = null;
        }
        return cgData;
    }

    public boolean isCellEditable(int n, int n2) {
        return this.table.isCellEditable(n, n2);
    }

    public boolean isNoNewRow() {
        return this.noNewRow;
    }

    public boolean isTableDataUpdated() {
        return this.table.isDataUpdated();
    }

    public boolean isTableEditing() {
        return this.table.isEditing();
    }

    public void removeAllRows() {
        int n = 0;
        while (n < this.table.getRowCount()) {
            this.table.deleteRow(n);
            ++n;
        }
    }

    public void removeCgCancelRowSaveListener(CgCancelRowSaveListener cgCancelRowSaveListener) {
        if (this.table != null) {
            this.table.removeCgCancelRowSaveListener(cgCancelRowSaveListener);
        }
    }

    public void removeCgRowSaveListener(CgRowSaveListener cgRowSaveListener) {
        if (this.table != null) {
            this.table.removeCgRowSaveListener(cgRowSaveListener);
        }
    }

    public void removeCgTblSelectListener(CgTblSelectListener cgTblSelectListener) {
        if (this.table != null) {
            this.table.removeCgTblSelectListener(cgTblSelectListener);
        }
    }

    public void removeCgTblUpdateListener(CgTblUpdateListener cgTblUpdateListener) {
        if (this.table != null) {
            this.table.removeCgTblUpdateListener(cgTblUpdateListener);
        }
    }

    public void resetWorkingCell() {
        this.table.resetWorkingCell();
    }

    public void resetWorkingRow() {
        this.table.resetWorkingRow();
    }

    public void setCellEditable(int n, int n2, boolean bl) {
        this.table.setCellEditable(n, n2, bl);
    }

    public void setColumnDefaultVal(int n, CgData cgData) {
        int n2 = this.table.convertColumnIndexToModel(n);
        this.model.setColumnDefaultVal(n2, cgData);
    }

    public void setData(Vector vector) {
        if (this.table.isEditing()) {
            this.table.removeEditor();
        }
        this.table.resetStatus();
        this.model.removeAllRows();
        this.model.addData(vector);
        if (this.editable && !this.noNewRow) {
            this.table.newCreatingRow();
        }
    }

    public void setData(CgData[][] cgDataArray) {
        if (this.table.isEditing()) {
            this.table.removeEditor();
        }
        this.table.resetStatus();
        this.model.removeAllRows();
        if (cgDataArray != null) {
            int n = 0;
            while (n < cgDataArray.length) {
                Vector vector = CgTblPane.array2Vector(cgDataArray[n]);
                this.table.addRow(vector);
                ++n;
            }
        }
        if (this.editable && !this.noNewRow) {
            this.table.newCreatingRow();
        }
    }

    public void setLastRowCellEditable(int n, boolean bl) {
        this.table.setLastRowCellEditable(n, bl);
    }

    public void setNoNewRow(boolean bl) {
        this.noNewRow = bl;
        if (this.table != null) {
            this.table.setNoNewRow(bl);
        }
    }

    public void setRowSelectionInterval(int n, int n2) {
        this.table.setRowSelectionInterval(n, n2);
    }

    public void setShowConfirmForRow(boolean bl) {
        this.confirmRow = bl;
        if (this.table != null) {
            this.table.setConfirmRow(this.confirmRow);
        }
    }

    public void setTableDataUpdated(boolean bl) {
        this.table.setDataUpdated(bl);
    }

    public void setValueAt(Object object, int n, int n2) {
        this.table.setValueAt(object, n, n2);
    }

    private void setupTable(CgTblColumnFormat[] cgTblColumnFormatArray) {
        if (cgTblColumnFormatArray == null) {
            return;
        }
        String[] stringArray = new String[cgTblColumnFormatArray.length];
        int n = 0;
        while (n < cgTblColumnFormatArray.length) {
            stringArray[n] = cgTblColumnFormatArray[n].getColHeading();
            ++n;
        }
        this.columnNum = cgTblColumnFormatArray.length;
        this.model = new CgTblModel(stringArray, new Vector());
        this.model.setColFormats(cgTblColumnFormatArray);
        this.table = new CgTable((TableModel)this.model, false);
        this.table.setIsEditable(this.editable);
        if (this.editable) {
            this.table.newCreatingRow();
        }
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.setAlignmentX(0.0f);
        jTableHeader.setReorderingAllowed(false);
        this.add(jTableHeader);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setAlignmentX(0.0f);
        this.add(jScrollPane);
    }

    public void transactionFinished(CgRowTransEvent cgRowTransEvent) {
        if (cgRowTransEvent.getType() == 0) {
            if (SwingUtilities.isEventDispatchThread()) {
                if (this.table.isEditing()) {
                    this.table.removeEditor();
                }
                this.table.submitted();
                this.table.revalidate();
            }
        } else {
            this.table.resetWorkingRow();
        }
    }
}

