/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.emitters;

import com.sun.symon.base.server.common.ScRequestDispatchException;
import com.sun.symon.base.server.common.ScRequestSink;
import com.sun.symon.base.server.common.ScResponseException;
import com.sun.symon.base.server.emitters.SeEmitter;
import com.sun.symon.base.server.emitters.SeFileEmitter;
import com.sun.symon.base.server.events.SvRequestEvent;
import com.sun.symon.base.server.remitters.splitter.SmSplitterOneRemitter;
import com.sun.symon.base.server.remitters.ticker.SmTickerRemitter;
import com.sun.symon.base.server.types.StBytes;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.server.types.StString;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcStreamReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class SeFileEmitter
extends SeEmitter {
    public SeFileEmitter(String string) {
        super(string, true, true);
        this.pushRemitter(new SmSplitterOneRemitter());
        this.pushRemitter(new SmTickerRemitter());
    }

    protected abstract InputStream findFile(String var1) throws IOException;

    protected abstract Vector getPathComponents();

    protected ScRequestSink newSink(SvRequestEvent svRequestEvent) throws ScRequestDispatchException {
        ScRequestSink scRequestSink;
        String string = svRequestEvent.getURL()[0];
        int n = string.indexOf(58);
        if (n == -1) {
            throw new ScRequestDispatchException("bad url: '" + string + "' (missing ':')");
        }
        if (string.length() <= n + 2) {
            throw new ScRequestDispatchException("bad url: '" + string + "' (too short)");
        }
        if (string.charAt(n + 1) != '/') {
            throw new ScRequestDispatchException("bad url: '" + string + "' (missing '/')");
        }
        String string2 = string.substring(n + 2);
        if (string2.endsWith("?command=ls")) {
            int n2 = string2.length();
            String string3 = n2 == 11 ? null : string2.substring(0, n2 - 11);
            scRequestSink = this.newSinkForDir(string, string3);
        } else if (string2.endsWith("?command=exists")) {
            int n3 = string2.length();
            string2 = n3 == 15 ? null : string2.substring(0, n3 - 15);
            scRequestSink = this.newSinkForFileTest(string, string2);
        } else {
            scRequestSink = this.newSinkForFile(string, string2);
        }
        return scRequestSink;
    }

    private ScRequestSink newSinkForDir(String string, String string2) {
        class SinkDir
        extends ScRequestSink {
            private final /* synthetic */ String val$url;
            private final /* synthetic */ SeFileEmitter this$0;
            private final /* synthetic */ String val$dirName;

            SinkDir(String string, SeFileEmitter seFileEmitter, String string2) {
                this.val$dirName = string;
                this.this$0 = seFileEmitter;
                this.val$url = string2;
            }

            protected void doDelete() {
            }

            protected void doEmit() {
                try {
                    UcDDL.logInfoMessage((String)("Reading directory '" + (this.val$dirName == null ? "" : this.val$dirName) + "'"));
                    StString[] stStringArray = this.this$0.readDir(this.val$dirName);
                    this.respond(new StObject[][]{stStringArray});
                }
                catch (IOException iOException) {
                    ScResponseException scResponseException = new ScResponseException(iOException.getMessage(), 3);
                    this.respond(this.val$url, scResponseException);
                }
            }
        }
        return new SinkDir(string2, this, string);
    }

    private ScRequestSink newSinkForFile(String string, String string2) {
        class SinkFile
        extends ScRequestSink {
            private final /* synthetic */ String val$url;
            private final /* synthetic */ SeFileEmitter this$0;
            private final /* synthetic */ String val$fileName;

            SinkFile(String string, SeFileEmitter seFileEmitter, String string2) {
                this.val$fileName = string;
                this.this$0 = seFileEmitter;
                this.val$url = string2;
            }

            protected void doDelete() {
            }

            protected void doEmit() {
                try {
                    UcDDL.logInfoMessage((String)("Reading file '" + this.val$fileName + "'"));
                    InputStream inputStream = this.this$0.findFile(this.val$fileName);
                    byte[] byArray = UcStreamReader.gobble((InputStream)inputStream);
                    this.respond(new StObject[][]{{new StBytes(byArray)}});
                }
                catch (IOException iOException) {
                    ScResponseException scResponseException = new ScResponseException(iOException.getMessage(), 3);
                    this.respond(this.val$url, scResponseException);
                }
            }
        }
        return new SinkFile(string2, this, string);
    }

    private ScRequestSink newSinkForFileTest(String string, String string2) {
        class SinkFileTest
        extends ScRequestSink {
            private final /* synthetic */ SeFileEmitter this$0;
            private final /* synthetic */ String val$fileName;

            SinkFileTest(String string, SeFileEmitter seFileEmitter) {
                this.val$fileName = string;
                this.this$0 = seFileEmitter;
            }

            protected void doDelete() {
            }

            protected void doEmit() {
                try {
                    UcDDL.logInfoMessage((String)("Looking for file '" + this.val$fileName + "'"));
                    InputStream inputStream = this.this$0.findFile(this.val$fileName);
                    this.respond(new StObject[][]{{new StString("true")}});
                }
                catch (IOException iOException) {
                    this.respond(new StObject[][]{{new StString("false")}});
                }
            }
        }
        return new SinkFileTest(string2, this);
    }

    protected StString[] readDir(String string) throws IOException {
        StString[] stStringArray;
        Vector vector = this.getPathComponents();
        if (vector == null) {
            File file;
            if (string == null) {
                string = File.separator;
            }
            if (!(file = new File(string)).isDirectory()) {
                throw new IOException("Not a directory");
            }
            String[] stringArray = file.list();
            stStringArray = new StString[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                stStringArray[n] = new StString(stringArray[n]);
                ++n;
            }
        } else {
            Object object;
            int n = vector.size();
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                object = (String)vector.elementAt(n3);
                Object object2 = string == null ? object : String.valueOf(object) + File.separator + string;
                File file = new File((String)object2);
                if (file.isDirectory()) {
                    String[] stringArray = file.list();
                    int n4 = 0;
                    while (n4 < stringArray.length) {
                        String string2 = stringArray[n4];
                        if (!hashtable.contains(string2)) {
                            ++n2;
                        }
                        hashtable.put(string2, string2);
                        ++n4;
                    }
                }
                ++n3;
            }
            stStringArray = new StString[n2];
            n3 = 0;
            object = hashtable.elements();
            while (object.hasMoreElements()) {
                stStringArray[n3] = new StString((String)object.nextElement());
                ++n3;
            }
        }
        return stStringArray;
    }

    protected Vector splitPath(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        return vector;
    }
}

