/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.mcp;

import com.sun.symon.base.mgmtservice.mcp.MmMCPServlet;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class MmMultipartRequest {
    private static final int DEFAULT_MAX_POST_SIZE = 0x100000;
    private static final String NO_FILE = "unknown";
    private HttpServletRequest req_;
    private File dir_;
    private int maxSize_;
    private MmMCPServlet servlet_;
    private Hashtable parameters = new Hashtable();
    private Hashtable files = new Hashtable();

    public MmMultipartRequest(HttpServletRequest httpServletRequest, String string, int n, MmMCPServlet mmMCPServlet) throws IOException {
        if (httpServletRequest == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("saveDirectory cannot be null");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("maxPostSize must be positive");
        }
        this.req_ = httpServletRequest;
        this.dir_ = new File(string);
        this.maxSize_ = n;
        this.servlet_ = mmMCPServlet;
        if (!this.dir_.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + string);
        }
        if (!this.dir_.canWrite()) {
            throw new IllegalArgumentException("Not writable: " + string);
        }
        this.readRequest();
    }

    public MmMultipartRequest(HttpServletRequest httpServletRequest, String string, MmMCPServlet mmMCPServlet) throws IOException {
        this(httpServletRequest, string, 0x100000, mmMCPServlet);
    }

    private String extractBoundary(String string) {
        int n = string.lastIndexOf("boundary=");
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(n + 9);
        string2 = "--" + string2;
        return string2;
    }

    private String extractContentType(String string) throws IOException {
        String string2 = null;
        String string3 = string;
        if ((string = string3.toLowerCase()).startsWith("content-type")) {
            int n = string.indexOf(" ");
            if (n == -1) {
                throw new IOException("Content type corrupt: " + string3);
            }
            string2 = string.substring(n + 1);
        } else if (string.length() != 0) {
            throw new IOException("Malformed line after disposition: " + string3);
        }
        return string2;
    }

    private String[] extractDispositionInfo(String string) throws IOException {
        String[] stringArray = new String[4];
        String string2 = string;
        string = string2.toLowerCase();
        int n = string.indexOf("content-disposition: ");
        int n2 = string.indexOf(";");
        if (n == -1 || n2 == -1) {
            throw new IOException("Content disposition corrupt: " + string2);
        }
        String string3 = string.substring(n + 21, n2);
        if (!string3.equals("form-data")) {
            throw new IOException("Invalid content disposition: " + string3);
        }
        n = string.indexOf("name=\"", n2);
        n2 = string.indexOf("\"", n + 7);
        if (n == -1 || n2 == -1) {
            throw new IOException("Content disposition corrupt: " + string2);
        }
        String string4 = string2.substring(n + 6, n2);
        String string5 = null;
        String string6 = "";
        n = string.indexOf("filename=\"", n2 + 2);
        n2 = string.indexOf("\"", n + 10);
        if (n != -1 && n2 != -1) {
            string5 = string2.substring(n + 10, n2);
            int n3 = Math.max(string5.lastIndexOf(47), string5.lastIndexOf(92));
            if (n3 > -1) {
                string6 = string5.substring(0, n3);
                string5 = string5.substring(n3 + 1);
            }
            if (string5.equals("")) {
                string5 = NO_FILE;
            }
        }
        stringArray[0] = string3;
        stringArray[1] = string4;
        stringArray[2] = string5;
        stringArray[3] = string6;
        return stringArray;
    }

    public String getContentType(String string) {
        try {
            UploadedFile uploadedFile = (UploadedFile)this.files.get(string);
            return uploadedFile.getContentType();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public File getFile(String string) {
        try {
            UploadedFile uploadedFile = (UploadedFile)this.files.get(string);
            return uploadedFile.getFile();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Enumeration getFileNames() {
        return this.files.keys();
    }

    public String getFilesystemName(String string) {
        try {
            UploadedFile uploadedFile = (UploadedFile)this.files.get(string);
            return uploadedFile.getFilesystemName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getParameter(String string) {
        try {
            Vector vector = (Vector)this.parameters.get(string);
            if (vector == null || vector.size() == 0) {
                return null;
            }
            String string2 = (String)vector.elementAt(vector.size() - 1);
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Enumeration getParameterNames() {
        return this.parameters.keys();
    }

    public String[] getParameterValues(String string) {
        try {
            Vector vector = (Vector)this.parameters.get(string);
            if (vector == null || vector.size() == 0) {
                return null;
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void makeSubDirectories(String string) throws IOException {
        File file = new File(String.valueOf(String.valueOf(this.dir_)) + File.separator + string);
        if (!file.exists()) {
            if (!file.mkdirs()) {
                throw new IOException("Unable to create directory: " + this.dir_ + File.separator + string);
            }
        } else if (!file.isDirectory()) {
            throw new IOException("Not a directory: " + this.dir_ + File.separator + string);
        }
    }

    protected void readAndSaveFile(MultipartInputStreamHandler multipartInputStreamHandler, String string, String string2, String string3) throws IOException {
        int n;
        Object object;
        OutputStream outputStream = null;
        if (string2.equals(NO_FILE)) {
            outputStream = new ByteArrayOutputStream();
        } else {
            object = new File(String.valueOf(String.valueOf(this.dir_)) + File.separator + string2);
            outputStream = new BufferedOutputStream(new FileOutputStream((File)object), 8192);
        }
        object = new byte[102400];
        boolean bl = false;
        while ((n = multipartInputStreamHandler.readLine((byte[])object, 0, ((byte[])object).length)) != -1) {
            String string4;
            if (n > 2 && object[0] == 45 && object[1] == 45 && (string4 = new String((byte[])object, 0, n, "ISO-8859-1")).startsWith(string)) break;
            if (bl) {
                outputStream.write(13);
                outputStream.write(10);
                bl = false;
            }
            if (n >= 2 && object[n - 2] == 13 && object[n - 1] == 10) {
                outputStream.write((byte[])object, 0, n - 2);
                bl = true;
                continue;
            }
            outputStream.write((byte[])object, 0, n);
        }
        outputStream.flush();
        outputStream.close();
    }

    protected boolean readNextPart(MultipartInputStreamHandler multipartInputStreamHandler, String string) throws IOException {
        String string2 = multipartInputStreamHandler.readLine();
        if (string2 == null) {
            return true;
        }
        if (string2.length() == 0) {
            return true;
        }
        this.servlet_.log(string2);
        String[] stringArray = this.extractDispositionInfo(string2);
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        String string5 = stringArray[2];
        String string6 = stringArray[3];
        string2 = multipartInputStreamHandler.readLine();
        if (string2 == null) {
            return true;
        }
        String string7 = this.extractContentType(string2);
        if (string7 != null) {
            string2 = multipartInputStreamHandler.readLine();
            if (string2 == null || string2.length() > 0) {
                throw new IOException("Malformed line after content type: " + string2);
            }
        } else {
            string7 = "application/octet-stream";
        }
        if (string5 == null) {
            Vector<String> vector;
            String string8 = this.readParameter(multipartInputStreamHandler, string);
            if (string8.equals("")) {
                string8 = null;
            }
            if ((vector = (Vector<String>)this.parameters.get(string4)) == null) {
                vector = new Vector<String>();
                this.parameters.put(string4, vector);
            }
            vector.addElement(string8);
        } else {
            if (!this.servlet_.isAllowed(string4, string6, this.req_)) {
                throw new IllegalArgumentException("invalid id");
            }
            if (!string5.equals(NO_FILE)) {
                this.makeSubDirectories(string6);
                this.dir_ = new File(String.valueOf(String.valueOf(this.dir_)) + File.separator + string6);
            }
            this.readAndSaveFile(multipartInputStreamHandler, string, string5, string7);
            if (string5.equals(NO_FILE)) {
                this.files.put(string4, new UploadedFile(null, null, null));
            } else {
                this.files.put(string4, new UploadedFile(this.dir_.toString(), string5, string7));
            }
        }
        return false;
    }

    protected String readParameter(MultipartInputStreamHandler multipartInputStreamHandler, String string) throws IOException {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        while ((string2 = multipartInputStreamHandler.readLine()) != null) {
            if (string2.startsWith(string)) break;
            stringBuffer.append(String.valueOf(string2) + "\r\n");
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        stringBuffer.setLength(stringBuffer.length() - 2);
        return stringBuffer.toString();
    }

    protected void readRequest() throws IOException {
        int n = this.req_.getContentLength();
        if (n > this.maxSize_) {
            throw new IOException("Posted content length of " + n + " exceeds limit of " + this.maxSize_);
        }
        String string = null;
        String string2 = this.req_.getHeader("Content-Type");
        String string3 = this.req_.getContentType();
        if (string2 == null && string3 != null) {
            string = string3;
        } else if (string3 == null && string2 != null) {
            string = string2;
        } else if (string2 != null && string3 != null) {
            String string4 = string = string2.length() > string3.length() ? string2 : string3;
        }
        if (string == null || !string.toLowerCase().startsWith("multipart/form-data")) {
            throw new IOException("Posted content type isn't multipart/form-data");
        }
        String string5 = this.extractBoundary(string);
        if (string5 == null) {
            throw new IOException("Separation boundary was not specified");
        }
        MultipartInputStreamHandler multipartInputStreamHandler = new MultipartInputStreamHandler(this.req_.getInputStream(), n);
        String string6 = multipartInputStreamHandler.readLine();
        if (string6 == null) {
            throw new IOException("Corrupt form data: premature ending");
        }
        if (!string6.startsWith(string5)) {
            throw new IOException("Corrupt form data: no leading boundary");
        }
        boolean bl = false;
        while (!bl) {
            bl = this.readNextPart(multipartInputStreamHandler, string5);
        }
    }

    class UploadedFile {
        private String dir;
        private String filename;
        private String type;

        UploadedFile(String string, String string2, String string3) {
            this.dir = string;
            this.filename = string2;
            this.type = string3;
        }

        public String getContentType() {
            return this.type;
        }

        public File getFile() {
            if (this.dir == null || this.filename == null) {
                return null;
            }
            return new File(String.valueOf(this.dir) + File.separator + this.filename);
        }

        public String getFilesystemName() {
            return this.filename;
        }
    }

    class MultipartInputStreamHandler {
        ServletInputStream in;
        int totalExpected;
        int totalRead = 0;
        byte[] buf = new byte[8192];

        public MultipartInputStreamHandler(ServletInputStream servletInputStream, int n) {
            this.in = servletInputStream;
            this.totalExpected = n;
        }

        public String readLine() throws IOException {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            do {
                if ((n = this.readLine(this.buf, 0, this.buf.length)) == -1) continue;
                stringBuffer.append(new String(this.buf, 0, n, "ISO-8859-1"));
            } while (n == this.buf.length);
            if (stringBuffer.length() == 0) {
                return null;
            }
            stringBuffer.setLength(stringBuffer.length() - 2);
            return stringBuffer.toString();
        }

        public int readLine(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (this.totalRead >= this.totalExpected) {
                return -1;
            }
            if (n2 > this.totalExpected - this.totalRead) {
                n2 = this.totalExpected - this.totalRead;
            }
            if ((n3 = this.in.readLine(byArray, n, n2)) > 0) {
                this.totalRead += n3;
            }
            return n3;
        }
    }
}

