/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.awt;

import com.sun.prodreg.awt.ComponentSelectableViewComponent;
import com.sun.prodreg.awt.Node;
import com.sun.prodreg.awt.RegNode;
import com.sun.prodreg.event.ExpansionEvent;
import com.sun.prodreg.event.ExpansionListener;
import com.sun.prodreg.event.NoExpansionException;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;

public class KioskCanvas
extends ComponentSelectableViewComponent {
    static int fontSize = 12;
    static Image closeImage = null;
    static Image openImage = null;
    static Image damageImage = null;
    MediaTracker imageTrack = null;
    Image bufferImage = null;
    Graphics bufferGraphics = null;
    private Cursor currentCursor = this.getCursor();
    public static final Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);
    public static final Cursor DEFAULT_CURSOR = Cursor.getPredefinedCursor(0);
    int currentHeight = 0;
    int currentWidth = 0;
    Vector treeDisplay = new Vector();
    Vector raw = null;
    Vector eListeners = new Vector();
    private Image offscreen;
    private Dimension oldSize;

    public KioskCanvas(Vector vector, Image image, Image image2, Image image3) {
        damageImage = image3;
        this.raw = vector;
        try {
            this.addMouseListener(new MouseKit());
            this.imageTrack = new MediaTracker(this);
            closeImage = image2;
            if (image != null) {
                this.imageTrack.addImage(closeImage, 1);
            }
            if (image2 != null) {
                this.imageTrack.addImage(openImage, 2);
            }
            if (image3 != null) {
                this.imageTrack.addImage(damageImage, 3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void _paint(Graphics graphics) {
        int n = 0;
        if (this.imageTrack != null) {
            try {
                this.imageTrack.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Problem waiting for images to load...");
            }
        }
        graphics.setColor(Node.fontColor);
        this.treeDisplay.removeAllElements();
        Enumeration enumeration = this.raw.elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            n = node.paintNode(graphics, this.isEnabled(), this.treeDisplay, 20, n + Node.nodeLeading);
        }
    }

    static /* synthetic */ Dimension access$0(KioskCanvas kioskCanvas) {
        return kioskCanvas.oldSize;
    }

    public void addExpansionListener(ExpansionListener expansionListener) {
        if (!this.eListeners.contains(expansionListener)) {
            this.eListeners.addElement(expansionListener);
        }
    }

    public void console(String string) {
        System.out.println(string);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 0;
        Font font = this.getFont();
        if (font != null) {
            Object object;
            FontMetrics fontMetrics = this.getFontMetrics(font);
            Enumeration enumeration = this.raw.elements();
            while (enumeration.hasMoreElements()) {
                object = (Node)enumeration.nextElement();
                Dimension dimension = ((Node)object).requiredSize(fontMetrics, Node.nodeIndent);
                n2 += dimension.height;
                if (dimension.width <= n) continue;
                n = dimension.width;
            }
            object = new Dimension(n + 2, n2 + 2);
            return object;
        }
        throw new InternalError("no Font for KioskCanvas");
    }

    public void leftAction(Node node) {
        try {
            ExpansionEvent expansionEvent = new ExpansionEvent(node.getTreeNode().getComponentDescription(), node.expand ^ true);
            int n = 0;
            while (n < this.eListeners.size()) {
                ExpansionListener expansionListener = (ExpansionListener)this.eListeners.elementAt(n);
                expansionListener.expanding(expansionEvent);
                ++n;
            }
            node.expand ^= true;
            int n2 = this.getSize().width;
            int n3 = this.getPreferredSize().height;
            this.setSize(new Dimension(n2, n3));
            this.validate();
            Component component = this;
            while ((component = component.getParent()) != null) {
                component.validate();
            }
            this.repaint();
            this.componentSelected(node.getTreeNode().getComponentDescription());
        }
        catch (NoExpansionException noExpansionException) {}
    }

    int mouseLine(int n) {
        return (n - Node.nodeLeading / 2) / Node.nodeLeading;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.offscreen == null || dimension.width != this.currentWidth || dimension.height != this.currentHeight) {
            if (this.offscreen != null) {
                this.offscreen.flush();
            }
            this.offscreen = this.createImage(dimension.width, dimension.height);
            this.currentWidth = dimension.width;
            this.currentHeight = dimension.height;
        }
        if (!dimension.equals(this.oldSize)) {
            this.oldSize = dimension;
            Graphics graphics2 = this.offscreen.getGraphics();
            graphics2.setColor(this.getBackground());
            graphics2.fillRect(0, 0, dimension.width, dimension.height);
            graphics2.setColor(this.getForeground());
            this._paint(graphics2);
        }
        graphics.drawImage(this.offscreen, 0, 0, this);
    }

    public void refresh(Vector vector, boolean bl) {
        int n = 0;
        while (n < this.raw.size()) {
            Node node = (Node)this.raw.elementAt(n);
            node.refresh(vector, bl);
            ++n;
        }
    }

    public void removeExpansionListener(ExpansionListener expansionListener) {
        if (this.eListeners.contains(expansionListener)) {
            this.eListeners.removeElement(expansionListener);
        }
    }

    public void rightAction(Node node) {
        this.componentSelected(node.getTreeNode().getComponentDescription());
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        int n = this.getSize().width;
        int n2 = this.getPreferredSize().height;
        this.setSize(new Dimension(n, n2));
        this.validate();
        Component component = this;
        while ((component = component.getParent()) != null) {
            component.validate();
        }
        this.repaint();
    }

    class MouseKit
    extends MouseAdapter {
        MouseKit() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = KioskCanvas.this.mouseLine(n2);
            if (n3 < 0) {
                return;
            }
            if (n3 > KioskCanvas.this.treeDisplay.size() - 1) {
                if (Node.nodeSelected != null) {
                    Node.nodeSelected = null;
                    KioskCanvas.this.oldSize = new Dimension(0, 0);
                    KioskCanvas.this.repaint();
                }
                return;
            }
            RegNode regNode = (RegNode)KioskCanvas.this.treeDisplay.elementAt(n3);
            if (!regNode.node.getTreeNode().isSelectable()) {
                return;
            }
            Node.nodeSelected = regNode.node;
            KioskCanvas.this.oldSize = new Dimension(0, 0);
            KioskCanvas.this.repaint();
            if (n < regNode.x) {
                KioskCanvas.this.leftAction(regNode.node);
            } else {
                KioskCanvas.this.rightAction(regNode.node);
            }
        }
    }
}

