/* Gate Specific Code -- BEGIN */
#
# Copyright (c) 1998-2001 by Sun Microsystems, Inc.
# All rights reserved.
#
#ident  "@(#)dns_svc_start.ksh 1.7     01/01/30 SMI"
/* Gate Specific Code -- END */
#!/bin/ksh
# Sun Cluster Data Services Builder template version 1.0
#
# Start Method for DNS.
#
# The data service is started under the control of PMF. Prior to starting the 
# process(es) for DNS some sanity checks are done. The PMF tries to start the
# service specified number of times and if the number of attempts exceeds this 
# value within a specified interval of time the PMF reports a failure to start
# the service. The number of times to retry and the interval in which it is to
# be tried are both properties of the resource set in RTR file. 

###############################################################################
# Parse program arguments.
#
function parse_args # [args ...]
{
	typeset opt

	while getopts 'R:G:T:' opt
	do
		case "$opt" in

		R)
		# Name of the DNS resource.
		RESOURCE_NAME=$OPTARG
		;;

		G)
		# Name of the resource group in which the resource is
		# configured.
		RESOURCEGROUP_NAME=$OPTARG
		;;

		T)
		# Name of the resource type.
		RESOURCETYPE_NAME=$OPTARG
		;;

		*)
		logger -p ${SYSLOG_FACILITY}.err -t \
		[$RESOURCETYPE_NAME,$RESOURCEGROUP_NAME,$RESOURCE_NAME] \
		"ERROR: Option $OPTARG unknown"
		exit 1
		;;

		esac
	done

}

###############################################################################
# MAIN
##############################################################################

export PATH=/bin:/usr/bin:/usr/cluster/bin:/usr/sbin:/usr/proc/bin:$PATH

# Obtain the syslog facility to use. This will be used to log the messages.
SYSLOG_FACILITY=`scha_cluster_get -O SYSLOG_FACILITY`

# Parse the arguments that have been passed to this method
parse_args "$@"

PMF_TAG=$RESOURCEGROUP_NAME,$RESOURCE_NAME,0.svc
SYSLOG_TAG=$RESOURCETYPE_NAME,$RESOURCEGROUP_NAME,$RESOURCE_NAME

# We need to know the full path for the gethostnames utility which resides
# in the directory <RT_BASEDIR>. Get this from the RT_BASEDIR property of the
# resource type.
RT_BASEDIR=`scha_resource_get -O RT_BASEDIR -R $RESOURCE_NAME \
	-G $RESOURCEGROUP_NAME`

hostnames=`$RT_BASEDIR/gethostnames -R $RESOURCE_NAME -G $RESOURCEGROUP_NAME \
	-T $RESOURCETYPE_NAME`

start_cmd_args=

start_cmd_prog=`echo $start_cmd_args | nawk '{print $1}'`

if [[ ! -f $start_cmd_prog || ! -x $start_cmd_prog ]]; then
	logger -p ${SYSLOG_FACILITY}.err -t [$SYSLOG_TAG] \
		"${ARGV0} File $start_cmd_prog is missing or not executable"
	exit 1
fi

# Get the value for retry count from the RTR file.
RETRY_CNT=`scha_resource_get -O Retry_Count -R $RESOURCE_NAME \
	-G $RESOURCEGROUP_NAME`

# Get the value for retry interval from the RTR file. The value for the 
# RETRY_INTERVAL in the RTR file will be in seconds. Convert this value from 
# seconds to minutes for passing on to pmfadm. Note that this is necessarily
# a conversion with round-up, eg. 59 seconds --> 1 minute.
((RETRY_INTRVAL = (`scha_resource_get -O Retry_Interval -R $RESOURCE_NAME -G \
	$RESOURCEGROUP_NAME` + 59) / 60 ))

# User added code -- BEGIN vvvvvvvvvvvvvvv
# User added code -- END   ^^^^^^^^^^^^^^^

# start the daemon under the control of Sun Cluster Process Monitor
# Facility. Let it crash and restart up to $RETRY_COUNT times in a period of 
# $RETRY_INTERVAL; if it crashes more often than that, the process monitor
# facility will cease trying to restart it
pmfadm -c $PMF_TAG -n $RETRY_CNT -t $RETRY_INTRVAL $start_cmd_args

# Log a message indicating that DNS has been started.
if [ $? -eq 0 ]; then
	logger -p ${SYSLOG_FACILITY}.info \
		-t [$SYSLOG_TAG] \
		"${ARGV0} DNS successfully started"
fi

# User added code -- BEGIN vvvvvvvvvvvvvvv
# User added code -- END   ^^^^^^^^^^^^^^^

exit 0
