#!/bin/ksh
#
# Copyright (c) 2000 by Sun Microsystems, Inc.
# All rights reserved.
#
#ident	"@(#)sc.stop.sh 1.5     00/08/17 SMI"

#
# sc.stop.sh -
#	This the stop script for II and RDC in a Sun Cluster Environment.
#	It unmounts the volumes that are passed to it by SC and used by SV,
#	stops II and RDC from using those volumes and then stops SV from 
#	using those volumes as well.
#
#	It is called from loghost_sync script of SC 2.2.
#
# Bug ID reference : 4334088

# constants

iiadm=/usr/opt/SUNWii/sbin/iiadm
new_iiadm=/usr/opt/SUNWesm/sbin/iiadm

rdcadm=/usr/opt/SUNWrdc/sbin/rdcadm
new_rdcadm=/usr/opt/SUNWesm/sbin/rdcadm
rdccf=/etc/opt/SUNWrdc/rdc.cf

svadm=/usr/opt/SUNWesm/sbin/svadm
svcf=/etc/opt/SUNWspsv/sv.cf

loginfo=/opt/SUNWcluster/bin/log_info

# functions

checkandunmount()
{
	tmp1=/tmp/cv.1.$$
        tmp2=/tmp/cv.2.$$
        splist=
        rm -f $tmp1 $tmp2

	if [[ $1 == "-F" ]]
	then
		cat ${2} > ${tmp1}

	else

		print "${1}" | sed -e 's!/rdsk/!/dsk/!' > ${tmp1}
		print "${2}" | sed -e 's!/rdsk/!/dsk/!' >> ${tmp1}
		print "${3}" | sed -e 's!/rdsk/!/dsk/!' >> ${tmp1}
	fi
	
#
# Check to see if any of these volumes are mounted.
#
        while read special junk
        do
                if [ `cat ${tmp1} | \
                        fgrep -xc -- "${special}"` -eq 0 ]
                then
                        # not an sv device
                        continue
                fi

                echo ${special}
        done </etc/mnttab >$tmp2

        # if there are filesystems that need to be unmounted, then
        # kill all procs using them and unmount them.

        if [ -s $tmp2 ]
        then
                splist=`umount_list <$tmp2`
                rm -f $tmp2
                $loginfo "sc.stop.02" "Unmounting II filesystems"
                # polite kill of procs using the filesystems

                pids=`/usr/sbin/fuser $splist 2>/dev/null`
                if [ -n "$pids" ]
                then
                        /usr/bin/kill -15 $pids
                        /usr/bin/sleep 5
                fi

                # hard kill of everyone using the filesystems

                /usr/sbin/fuser -k $splist >/dev/null 2>&1
                /usr/bin/sleep 3

                # umount filesystems in the correct order

                /sbin/sync ; /sbin/sync ; /sbin/sync
                for s in $splist
                do
                        /sbin/umount $s
                        $loginfo "sc.stop.03" "Unmounting: ${s}"
                done
        fi
	rm -f $tmp1 $tmp2

}

umount_list()
{
	# <stdin> - list of special devices
	#
	# find all filesystems that need to be unmounted in order to
	# unmount these special devices, sorted in the correct order to
	# pass to umount

	tmp1=/tmp/um.1.$$
	tmp2=/tmp/um.2.$$

	rm -f $tmp1 $tmp2

	# read list from <stdin> and convert to mount points

	cat >$tmp1

	while read special mountp junk
	do
		if fgrep -xs -- "$special" $tmp1 >/dev/null 2>&1
		then
			echo $mountp
		fi
	done </etc/mnttab >$tmp2

	# get the special devices for every mount point whose name
	# begins with that of a mount point that we need to unmount
	# eg. if we want to unmount /sv0, and there is also a /sv0/sv2
	# mount point, then the list of special devices must include
	# both (we cannot unmount /sv0 without first unmounting
	# /sv0/sv2)

	while read mountp
	do
		grep "[ 	]$mountp" /etc/mnttab
	done <$tmp2 | awk '{ print $1 }' >$tmp1

	# sort the list into reverse mnttab order to give to umount,
	# and display on <stdout>

	tail -r /etc/mnttab |
		while read special junk
		do
			if fgrep -xs -- "$special" $tmp1 >/dev/null 2>&1
			then
				echo $special
			fi
		done

	rm -f $tmp1 $tmp2
}

# main program


if [ ! -x $svadm ]
then
	$loginfo "sc.stop.01" "${0}: cannot find ${svadm}"
	exit 1
fi
#
# get the list of volumes that are being exported from SunCluster
#

params=/tmp/in.$$
rm -f $params

for vol in $*
do
	echo $vol | sed -e 's!/rdsk/!/dsk/!'
done >$params

rdskparams=/tmp/in.rdsk.$$
rm -f $rdskparams

for vol in $*
do
	echo $vol
done >$rdskparams

if [ -x $svadm -a -r /dev/sv ]
then

        # grab list of configured rdc and ii devices

        if [ -x $new_iiadm ]
        then
                iiadm=$new_iiadm
        fi

        if [ -x $new_rdcadm ]
        then
                rdcadm=$new_rdcadm
        fi

	# grab list of configured sv devices

	allsvfiles=`$svadm 2>/dev/null | \
			awk '{print $1}' - | \
			sed -e 's!/rdsk/!/dsk/!' | \
			sed -e 's/(.*)//'`

	svfiles=/tmp/sv.$$
	rm -f $svfiles

	while read special junk
	do
		if [ `echo "${allsvfiles}" | \
			fgrep -xc -- "${special}"` -eq 0 ]
		then
			# not an sv device
			continue
		fi

		echo $special
	done <$params >$svfiles

	checkandunmount "-F" ${svfiles}
#
# Get the iiadm output and put it in a file to be used later
#
	iivolsfile=/tmp/ivf.$$
	iiadmout=`${iiadm} -i all`
	print "$iiadmout" > $iivolsfile


        # Now stop II/RDC data services from using these volumes
        #
	# First get the master and shadow volumes
	#
        if [ -x $iiadm ]
        then
                iifilesmaster=`cat ${iivolsfile} | \
                                        grep 'master volume' | \
                                        cut -d: -f1`

                set -A  iifilesshadow $(cat ${iivolsfile} | \
                                        grep 'shadow volume' | \
                                        cut -d: -f1)

                set -A  iifilesbitmap $(cat ${iivolsfile} | \
                                        grep 'bitmap volume' | \
                                        cut -d: -f1)

        fi

	#
	# Now scan through the master and shadow volumes.  Disable any
	# that matches the input list
	#
        i=0
        for vol in $iifilesmaster
        do

                shadowvol=${iifilesshadow[${i}]}
		bitmapvol=${iifilesbitmap[${i}]}
                for remvol in $*
                do
                        if [[ $vol == $remvol ]]
                        then
				# check II vols and unmount any that we
				# missed earlier
				checkandunmount ${vol} ${shadowvol} ${bitmapvol}
                               	$iiadm -s $shadowvol 2>/dev/null
                                $iiadm -d $shadowvol 2>/dev/null
				$loginfo "sc.stop.04" "II volume pair disabled: ${shadowvol}"
                        fi
                        if [[ $shadowvol == $remvol ]]
                        then
				# check II vols and unmount any that we
				# missed earlier
				checkandunmount ${vol} ${shadowvol} ${bitmapvol}
                                $iiadm -s $shadowvol 2>/dev/null
                                $iiadm -d $shadowvol 2>/dev/null
				$loginfo "sc.stop.05" "II volume pair disabled: ${shadowvol}"
                        fi
			if [[ $bitmapvol == $remvol ]]
			then
				# check II vols and unmount any that we
				# missed earlier
				checkandunmount ${vol} ${shadowvol} ${bitmapvol}
                                $iiadm -s $shadowvol 2>/dev/null
				$iiadm -d $shadowvol 2>/dev/null
				$loginfo "sc.stop.06" "II volume pair disabled: ${shadowvol}"
			fi
                done
                i=`expr $i + 1`
        done

	#
	# Now take care of RDC volumes
	#
	if [ -x $rdcadm ]
	then

		rdcfiles=`$rdcadm -p 2>/dev/null | \
				grep '/rdsk/' | \
				awk '{print $1}' -`
	
		for vol in $rdcfiles
		do
			for remvol in $*
	                do
				if [[ $vol == $remvol ]]
				then
				$loginfo "sc.stop.07" "RDC volume set disabled: ${vol}"

					# extract the rdc sets from rdc.cf
					# that are related to this
					# volume (which could be a
					# primary, bitmap or secondary)
					awk '
					    ($2 == "'$vol'" || \
					     $3 == "'$vol'" || \
					     $5 == "'$vol'" || \
					     $6 == "'$vol'") {
						print; }' $rdccf | 
					while read rdcset
					do
						$rdcadm -n -d $rdcset
					done
				fi
			done
		done
	fi

	# Disable volumes in SV layer that are being exported

	$loginfo "sc.stop.08" "stopping SV Volumes" 
	$svadm -d -f $rdskparams


	rm -f $params $rdskparams $svfiles $iivolsfile


fi
