/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esm.mo.dsw;

import com.sun.dae.components.lang.CompositeException;
import com.sun.dae.components.util.ExceptionUtil;
import com.sun.esm.library.spcs.dsw.Dsw;
import com.sun.esm.library.spcs.dsw.DswConfig;
import com.sun.esm.library.spcs.dsw.DswHandle;
import com.sun.esm.library.spcs.dsw.DswStatus;
import com.sun.esm.mo.dsw.DswVolException;
import com.sun.esm.mo.dsw.DswVolImpl;
import com.sun.esm.util.Services;
import com.sun.esm.util.slm.dsw.DswModifierCodes;

class DswVolHydrateDaemon
extends Thread {
    private DswVolImpl volObject;
    private int volModifier;
    private transient DswHandle hyHandle = null;
    private transient DswConfig hyCfg = null;
    private transient Dsw hyDsw = null;
    private transient DswStatus hyStatus;
    static final String sccs_id = "@(#)DswVolHydrateDaemon.java 1.6    99/11/18 SMI";

    public DswVolHydrateDaemon(DswVolImpl dswVolImpl, int n) {
        this.setDaemon(true);
        this.volObject = dswVolImpl;
        this.volModifier = n;
        this.daemonTrace("Priority = " + this.getPriority());
        this.start();
    }

    private void daemonTrace(String string) {
        Services.trace((String)(String.valueOf(this.volObject.getShadowName()) + " hydrateDaemon[" + Thread.currentThread() + "] " + string), (String)this.getClass().getName(), (int)100, (int)32);
    }

    public void log(String string) {
        Object[] objectArray = new Object[]{this.volObject.getMasterName(), this.volObject.getShadowName()};
        Services.log((String)string, (Object[])objectArray, this.getClass(), (String)"`InstantImage`");
    }

    private void logException(Throwable throwable, String string) {
        DswVolException dswVolException;
        Object[] objectArray = new Object[]{this.volObject.getMasterName(), this.volObject.getShadowName()};
        if (throwable instanceof CompositeException) {
            dswVolException = new DswVolException(string, objectArray, ((CompositeException)throwable).getTargets());
        } else {
            Throwable[] throwableArray = new Throwable[]{throwable};
            dswVolException = new DswVolException(string, objectArray, throwableArray);
        }
        Services.log((String)string, (Object[])objectArray, ((Object)((Object)dswVolException)).getClass(), (String)"`InstantImage`", (Throwable)throwable);
    }

    public void run() {
        this.daemonTrace("recover to modifier = " + DswModifierCodes.stateName[this.volModifier]);
        try {
            this.daemonTrace("register handles with JNI");
            this.volObject.dswVolRegisterHandle();
            try {
                this.hyHandle = new DswHandle();
                this.hyHandle.register();
                this.hyCfg = new DswConfig();
                this.hyDsw = new Dsw();
                this.hyStatus = new DswStatus();
                this.log("`hydrate_recovery`");
                this.daemonTrace("issue status command");
                this.hyStatus.fillInDswStatus(this.hyHandle, this.volObject.getMasterName());
                this.daemonTrace("core is aware of the volume group");
                this.log("`hydrate_general`");
                this.daemonTrace("hydrate deamon deciphering the modifier");
                switch (this.volModifier) {
                    case 12: {
                        this.daemonTrace("hydrate deamon does nothing if a volume is suspended");
                        break;
                    }
                    case 9: {
                        this.daemonTrace("hydrate deamon does nothing if a volume is enabled");
                        break;
                    }
                    default: {
                        this.daemonTrace("hydrate deamon surprised:   modifier  " + DswModifierCodes.stateName[this.volModifier]);
                        break;
                    }
                }
            }
            catch (CompositeException compositeException) {
                this.daemonTrace("core has no clue of the volume group");
                this.daemonTrace("hydrate status exception " + ExceptionUtil.getExceptionTree((Throwable)compositeException));
                this.daemonTrace("exception trinket " + compositeException.getMessage());
                if (compositeException.getMessage().equals("`DSW_ENOTFOUND`")) {
                    this.daemonTrace("hydrate deamon deciphering the modifier");
                    switch (this.volModifier) {
                        case 12: {
                            this.daemonTrace("hydrate deamon does nothing if a volume is suspended");
                            break;
                        }
                        default: {
                            this.daemonTrace("hydrate deamon setting status to degraded:  modifier  " + DswModifierCodes.stateName[this.volModifier]);
                            this.volObject.changingDswVolModifierNoEvent(11);
                            this.volObject.sendingDegradedStatus(3);
                            this.volObject.changingDswVolModifierNoEvent(12);
                            break;
                        }
                    }
                }
                this.daemonTrace("hydrate daemon status error " + compositeException.getMessage());
            }
            this.hyHandle = null;
            this.hyCfg = null;
            this.hyDsw = null;
            this.hyStatus = null;
        }
        catch (DswVolException dswVolException) {
            this.daemonTrace("DswVolHydrateDaemonException" + ExceptionUtil.getExceptionTree((Throwable)((Object)dswVolException)));
        }
        this.daemonTrace("returning");
    }
}

