/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esm.apps.util.slm.dsw;

import com.sun.esm.apps.util.slm.dsw.DswModifierTransitions;
import com.sun.esm.apps.util.slm.dsw.DswPairHealth;
import com.sun.esm.apps.util.slm.dsw.DswStateTransitions;
import com.sun.esm.apps.util.slm.dsw.StateObject;
import com.sun.esm.util.Services;
import com.sun.esm.util.slm.dsw.DswModifierCodes;
import java.util.Vector;

public class Transition {
    private DswPairHealth myHealth;
    private int myStateLimit;
    private int myActivityLimit;
    private Vector[] myStates;
    private Vector[] myActivityStates;
    static final String sccs_id = "@(#)Transition.java 1.15    99/11/18 SMI";

    public Transition(DswPairHealth dswPairHealth) {
        this.myHealth = dswPairHealth;
        DswStateTransitions dswStateTransitions = new DswStateTransitions();
        this.myStates = dswStateTransitions.getTransitions();
        this.myStateLimit = dswStateTransitions.getLimit();
        DswModifierTransitions dswModifierTransitions = new DswModifierTransitions();
        this.myActivityStates = dswModifierTransitions.getTransitions();
        this.myActivityLimit = dswModifierTransitions.getLimit();
    }

    public boolean isActivityStateTransitionValid(int n) {
        if (this.myHealth.getActivityState() < this.myActivityLimit && this.myActivityStates[this.myHealth.getActivityState()].contains(new StateObject(n))) {
            return true;
        }
        Services.trace((String)("Invalid Activity State Transition " + DswModifierCodes.stateName[n] + " from " + DswModifierCodes.stateName[this.myHealth.getActivityState()]), (String)this.getClass().getName(), (int)32, (int)32);
        return false;
    }

    public boolean isStateTransitionValid(int n) {
        if (this.myHealth.getState() < this.myStateLimit && this.myStates[this.myHealth.getState()].contains(new StateObject(n))) {
            return true;
        }
        Services.trace((String)("Invalid State Transition " + DswModifierCodes.stateName[n] + " from " + DswModifierCodes.stateName[this.myHealth.getState()]), (String)this.getClass().getName(), (int)32, (int)32);
        return false;
    }

    public synchronized boolean transitionToActivityState(int n) {
        boolean bl = false;
        if (this.isActivityStateTransitionValid(n)) {
            Services.trace((String)("transitionToActivity " + DswModifierCodes.stateName[n] + " from " + DswModifierCodes.stateName[this.myHealth.getActivityState()]), (String)this.getClass().getName(), (int)32, (int)32);
            this.myHealth.setActivityState(n);
            bl = true;
        }
        return bl;
    }

    public synchronized boolean transitionToState(int n) {
        boolean bl = false;
        if (this.isStateTransitionValid(n)) {
            Services.trace((String)("transitionToState " + DswModifierCodes.stateName[n] + " from " + DswModifierCodes.stateName[this.myHealth.getState()]), (String)this.getClass().getName(), (int)32, (int)32);
            this.myHealth.setState(n);
            bl = true;
        }
        return bl;
    }
}

