/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esm.apps.config.slm.dsw;

import com.sun.dae.components.Pickle;
import com.sun.dae.components.event.Delegate;
import com.sun.dae.components.lang.CompositeException;
import com.sun.dae.components.util.ArrayUtil;
import com.sun.dae.components.util.ExceptionUtil;
import com.sun.dae.sdok.ByReference;
import com.sun.dae.sdok.InetStationAddress;
import com.sun.dae.sdok.OID;
import com.sun.dae.sdok.PersistenceException;
import com.sun.dae.sdok.StationAddress;
import com.sun.esm.apps.AppBoot;
import com.sun.esm.apps.AppImpl;
import com.sun.esm.apps.AppManagerProxy;
import com.sun.esm.apps.Application;
import com.sun.esm.apps.config.Config;
import com.sun.esm.apps.config.slm.dsw.BitmapDirectoryException;
import com.sun.esm.apps.config.slm.dsw.DswPair;
import com.sun.esm.apps.config.slm.dsw.SLMConfigDswCreateException;
import com.sun.esm.apps.config.slm.dsw.SLMConfigDswDeleteException;
import com.sun.esm.apps.config.slm.dsw.SLMConfigDswDupMasterException;
import com.sun.esm.apps.config.slm.dsw.SLMConfigDswDupShadowException;
import com.sun.esm.apps.config.slm.dsw.SLMConfigDswInvalidOpException;
import com.sun.esm.apps.config.slm.dsw.SLMConfigDswInvalidVolumeException;
import com.sun.esm.apps.config.slm.dsw.SLMConfigDswListener;
import com.sun.esm.apps.config.slm.dsw.SLMConfigDswMasterIsShadowException;
import com.sun.esm.apps.config.slm.dsw.SLMConfigDswPairEvent;
import com.sun.esm.apps.config.slm.dsw.SLMConfigDswPairListener;
import com.sun.esm.apps.config.slm.dsw.SLMConfigDswPairNotFoundException;
import com.sun.esm.apps.config.slm.dsw.SLMConfigDswShadowIsMasterException;
import com.sun.esm.apps.config.slm.dsw.SLMConfigDswSizeException;
import com.sun.esm.apps.config.slm.dsw.SLMConfigDswSvConditionEventObject;
import com.sun.esm.apps.config.slm.dsw.SLMConfigDswSvException;
import com.sun.esm.apps.config.slm.dsw.SLMConfigDswSvStateListener;
import com.sun.esm.apps.config.slm.dsw.SLMConfigDswSvStatusListener;
import com.sun.esm.apps.config.slm.dsw.SLMConfigDswVolsEvent;
import com.sun.esm.apps.config.slm.dsw.SvVolProperties;
import com.sun.esm.apps.control.slm.dsw.SLMControlDswVolException;
import com.sun.esm.apps.control.slm.dsw.SLMControlDswVolProxy;
import com.sun.esm.apps.util.slm.dsw.VolMountedException;
import com.sun.esm.mo.MO;
import com.sun.esm.mo.MOBoot;
import com.sun.esm.mo.MOManagerProxy;
import com.sun.esm.mo.dsw.DswConditionEventObject;
import com.sun.esm.mo.dsw.DswMOBitmapException;
import com.sun.esm.mo.dsw.DswMODupMasterException;
import com.sun.esm.mo.dsw.DswMODupShadowException;
import com.sun.esm.mo.dsw.DswMOPairNotFoundException;
import com.sun.esm.mo.dsw.DswVolException;
import com.sun.esm.mo.dsw.DswVolImplProxy;
import com.sun.esm.mo.dsw.DswVolsMOConditionListener;
import com.sun.esm.mo.dsw.DswVolsMOEvent;
import com.sun.esm.mo.dsw.DswVolsMOImplProxy;
import com.sun.esm.mo.dsw.DswVolsMOListener;
import com.sun.esm.mo.sv.SvConditionEventObject;
import com.sun.esm.mo.sv.SvImplProxy;
import com.sun.esm.mo.sv.SvMOImplProxy;
import com.sun.esm.mo.sv.SvStateListener;
import com.sun.esm.mo.sv.SvStatusListener;
import com.sun.esm.mo.sv.SvVolsEvent;
import com.sun.esm.mo.sv.SvVolsListener;
import com.sun.esm.util.Services;
import com.sun.esm.util.slm.TraceUtil;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;

public class SLMConfigDsw
extends Config
implements Application,
SvVolsListener,
SvStateListener,
SvStatusListener,
DswVolsMOConditionListener,
DswVolsMOListener,
Serializable {
    private static String[] constructorMO = new String[]{"[Lcom.sun.esm.mo.dsw.DswVolsMOImplProxy;"};
    static final long serialVersionUID = 961742685813375934L;
    private OID oid;
    private final Delegate myListenerDelegate = new Delegate(class$com$sun$esm$apps$config$slm$dsw$SLMConfigDswListener != null ? class$com$sun$esm$apps$config$slm$dsw$SLMConfigDswListener : (class$com$sun$esm$apps$config$slm$dsw$SLMConfigDswListener = SLMConfigDsw.class$("com.sun.esm.apps.config.slm.dsw.SLMConfigDswListener")));
    private final Delegate pairListenerDelegate = new Delegate(class$com$sun$esm$apps$config$slm$dsw$SLMConfigDswPairListener != null ? class$com$sun$esm$apps$config$slm$dsw$SLMConfigDswPairListener : (class$com$sun$esm$apps$config$slm$dsw$SLMConfigDswPairListener = SLMConfigDsw.class$("com.sun.esm.apps.config.slm.dsw.SLMConfigDswPairListener")));
    private final Delegate dswSvStateListenerDelegate = new Delegate(class$com$sun$esm$apps$config$slm$dsw$SLMConfigDswSvStateListener != null ? class$com$sun$esm$apps$config$slm$dsw$SLMConfigDswSvStateListener : (class$com$sun$esm$apps$config$slm$dsw$SLMConfigDswSvStateListener = SLMConfigDsw.class$("com.sun.esm.apps.config.slm.dsw.SLMConfigDswSvStateListener")));
    private final Delegate dswSvStatusListenerDelegate = new Delegate(class$com$sun$esm$apps$config$slm$dsw$SLMConfigDswSvStatusListener != null ? class$com$sun$esm$apps$config$slm$dsw$SLMConfigDswSvStatusListener : (class$com$sun$esm$apps$config$slm$dsw$SLMConfigDswSvStatusListener = SLMConfigDsw.class$("com.sun.esm.apps.config.slm.dsw.SLMConfigDswSvStatusListener")));
    private DswVolsMOImplProxy dswMOProxy = null;
    private SvMOImplProxy svMOProxy = null;
    private final Hashtable svVols = new Hashtable();
    private final Hashtable dswPairs = new Hashtable();
    private String bitmapDirectory = null;
    private static final String debugBitmapDirectory = "/tmp/bitmaps";
    private static final String defaultBitmapDirectory = "/etc/opt/SUNWiims/bm";
    private boolean d_debug = System.getProperty("com.sun.esm.slm.dsw.DBL") != null;
    private int state = 2;
    private boolean visible = true;
    private static final String sccs_id = "@(#)SLMConfigDsw.java 1.9\t 98/10/15 SMI";
    static /* synthetic */ Class class$com$sun$esm$apps$config$slm$dsw$SLMConfigDswListener;
    static /* synthetic */ Class class$com$sun$esm$apps$config$slm$dsw$SLMConfigDswPairListener;
    static /* synthetic */ Class class$com$sun$esm$apps$config$slm$dsw$SLMConfigDswSvStateListener;
    static /* synthetic */ Class class$com$sun$esm$apps$config$slm$dsw$SLMConfigDswSvStatusListener;
    static /* synthetic */ Class class$com$sun$esm$util$slm$dsw$DswConstants;
    static /* synthetic */ Class class$com$sun$esm$mo$dsw$DswVolImplProxy;
    static /* synthetic */ Class class$com$sun$esm$mo$sv$SvImplProxy;

    public SLMConfigDsw(String string, Application application, DswVolsMOImplProxy[] dswVolsMOImplProxyArray) {
        super("InstantImage", application);
        this.dswMOProxy = dswVolsMOImplProxyArray[0];
        InetStationAddress inetStationAddress = null;
        try {
            MOBoot mOBoot = new MOBoot("localhost");
            InetAddress inetAddress = InetAddress.getByName("localhost");
            this.trace("realm = " + mOBoot.getRealmName() + " station = " + mOBoot.getStationName());
            inetStationAddress = new InetStationAddress(mOBoot.getRealmName(), mOBoot.getStationName(), inetAddress);
            MO[] mOArray = MOManagerProxy.lookupByClass((String)"com.sun.esm.mo.sv.SvMOImpl", (StationAddress)inetStationAddress);
            if (mOArray.length != 0) {
                this.svMOProxy = (SvMOImplProxy)mOArray[0];
            } else {
                this.trace("in constructor: MOManager did not find SvMO");
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            this.trace("MOManager did not find SvMO");
        }
        this.getSvVols();
        this.getVolPairs();
        this.listenToSvMO();
        this.listenToDswMO();
        this.initBitmapDirectory();
        try {
            this.manage();
        }
        catch (PersistenceException persistenceException) {
            this.log("`manage_persistence`", new Object[0], persistenceException);
        }
        this.state = 1;
        this.pickle();
        this.trace("Started State Running");
        this.log("`initial_start`", new Object[0]);
    }

    public void addSLMConfigDswListener(SLMConfigDswListener sLMConfigDswListener) {
        this.trace("addSLMConfigDswListener");
        this.myListenerDelegate.addListener((EventListener)sLMConfigDswListener);
        this.pickle();
    }

    public void addSLMConfigDswPairListener(SLMConfigDswPairListener sLMConfigDswPairListener) {
        this.trace("addSLMConfigDswPairListener");
        this.pairListenerDelegate.addListener((EventListener)sLMConfigDswPairListener);
        this.pickle();
    }

    public void addSLMConfigDswSvStateListener(SLMConfigDswSvStateListener sLMConfigDswSvStateListener) {
        this.trace("addSLMConfigDswSvStateListener");
        this.dswSvStateListenerDelegate.addListener((EventListener)sLMConfigDswSvStateListener);
        this.pickle();
    }

    public void addSLMConfigDswSvStatusListener(SLMConfigDswSvStatusListener sLMConfigDswSvStatusListener) {
        this.trace("addSLMConfigDswSvStatusListener");
        this.dswSvStatusListenerDelegate.addListener((EventListener)sLMConfigDswSvStatusListener);
        this.pickle();
    }

    public synchronized void addSuspendedDswPair(String string, String string2, String string3) throws SLMConfigDswInvalidVolumeException, SLMConfigDswDupShadowException, BitmapDirectoryException, SLMConfigDswCreateException {
        this.trace("addSuspendedDswPair");
        if (!this.svVols.containsKey(string)) {
            throw new SLMConfigDswInvalidVolumeException(string);
        }
        if (!this.svVols.containsKey(string2)) {
            throw new SLMConfigDswInvalidVolumeException(string2);
        }
        SvImplProxy svImplProxy = (SvImplProxy)this.svVols.get(string);
        SvImplProxy svImplProxy2 = (SvImplProxy)this.svVols.get(string2);
        if (this.dswPairs.containsKey(string2)) {
            throw new SLMConfigDswDupShadowException(string, string2);
        }
        try {
            this.dswMOProxy.addSuspendedDswPair(svImplProxy, svImplProxy2, string3);
        }
        catch (DswMODupShadowException dswMODupShadowException) {
            throw new SLMConfigDswDupShadowException(string, string2);
        }
        catch (DswMOBitmapException dswMOBitmapException) {
            throw new BitmapDirectoryException(string3);
        }
        catch (DswVolException dswVolException) {
            this.log("`addsuspended_pair_error`", new Object[]{string, string2}, (Throwable)((Object)dswVolException));
            throw new SLMConfigDswCreateException(string, string2);
        }
        this.log("`addsuspended_pair`", new Object[]{string, string2});
    }

    void addVolPairs(DswVolImplProxy[] dswVolImplProxyArray) {
        this.trace("addVolPairs");
        Vector<DswVolImplProxy> vector = new Vector<DswVolImplProxy>();
        int n = 0;
        while (n < dswVolImplProxyArray.length) {
            if (!this.dswPairs.containsKey(dswVolImplProxyArray[n].getShadowName())) {
                this.dswPairs.put(dswVolImplProxyArray[n].getShadowName(), dswVolImplProxyArray[n]);
                this.pickle();
                this.trace("added pair to hashtable " + dswVolImplProxyArray[n].getShadowName());
                vector.add(dswVolImplProxyArray[n]);
            } else {
                this.trace("pair is already in hashtable " + dswVolImplProxyArray[n].getShadowName());
            }
            ++n;
        }
        if (vector.size() > 0) {
            this.sendConfigPairEvent((DswVolImplProxy[])ArrayUtil.vectorToArray(vector, (Class)(class$com$sun$esm$mo$dsw$DswVolImplProxy != null ? class$com$sun$esm$mo$dsw$DswVolImplProxy : (class$com$sun$esm$mo$dsw$DswVolImplProxy = SLMConfigDsw.class$("com.sun.esm.mo.dsw.DswVolImplProxy")))), "SLMConfigDswPairAdded");
        }
    }

    void addVols(SvImplProxy[] svImplProxyArray) {
        Object object;
        this.trace("addVols");
        int n = 0;
        while (n < svImplProxyArray.length) {
            object = svImplProxyArray[n].getVolName();
            if (!this.svVols.containsKey(object)) {
                this.svVols.put(object, svImplProxyArray[n]);
                this.pickle();
            }
            ++n;
        }
        object = this.getSvPairHandles(svImplProxyArray);
        if (((Vector[])object).length != 0) {
            if (object[1] != null && object[1].size() != 0) {
                this.sendConfigEvent((SvImplProxy[])ArrayUtil.vectorToArray((Vector)object[1], (Class)(class$com$sun$esm$mo$sv$SvImplProxy != null ? class$com$sun$esm$mo$sv$SvImplProxy : (class$com$sun$esm$mo$sv$SvImplProxy = SLMConfigDsw.class$("com.sun.esm.mo.sv.SvImplProxy")))), "SLMConfigDswVolAdded");
            }
            if (object[0] != null && object[0].size() != 0) {
                int n2 = 0;
                while (n2 < object[0].size()) {
                    if (((DswVolImplProxy)object[0].elementAt(n2)).getCondition().getStatus() == 20) {
                        ((DswVolImplProxy)object[0].elementAt(n2)).setPairOperable();
                    }
                    ++n2;
                }
                this.sendConfigPairEvent((DswVolImplProxy[])ArrayUtil.vectorToArray((Vector)object[0], (Class)(class$com$sun$esm$mo$dsw$DswVolImplProxy != null ? class$com$sun$esm$mo$dsw$DswVolImplProxy : (class$com$sun$esm$mo$dsw$DswVolImplProxy = SLMConfigDsw.class$("com.sun.esm.mo.dsw.DswVolImplProxy")))), "SLMConfigDswVolInPairAdded");
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void createDswPair(String string, String string2, boolean bl) throws SLMConfigDswSizeException, SLMConfigDswDupMasterException, SLMConfigDswDupShadowException, SLMConfigDswMasterIsShadowException, SLMConfigDswShadowIsMasterException, SLMConfigDswInvalidVolumeException, SLMConfigDswCreateException, BitmapDirectoryException, VolMountedException {
        this.createDswPair(string, string2, bl, null);
    }

    public synchronized void createDswPair(String string, String string2, boolean bl, String string3) throws SLMConfigDswSizeException, SLMConfigDswDupMasterException, SLMConfigDswDupShadowException, SLMConfigDswMasterIsShadowException, SLMConfigDswShadowIsMasterException, SLMConfigDswInvalidVolumeException, SLMConfigDswCreateException, BitmapDirectoryException, VolMountedException {
        int n;
        this.trace("createDswPair: master = " + string + " shadow = " + string2);
        if (!this.svVols.containsKey(string)) {
            this.log("`command_error`", new Object[]{"enable", string2});
            throw new SLMConfigDswInvalidVolumeException(string);
        }
        if (!this.svVols.containsKey(string2)) {
            this.log("`command_error`", new Object[]{"enable", string2});
            throw new SLMConfigDswInvalidVolumeException(string2);
        }
        if (this.getMaster(string) != null) {
            this.log("`command_error`", new Object[]{"enable", string2});
            throw new SLMConfigDswDupMasterException(string, string2);
        }
        if (this.getShadow(string2) != null) {
            this.log("`command_error`", new Object[]{"enable", string2});
            throw new SLMConfigDswDupShadowException(string, string2);
        }
        if (this.getMaster(string2) != null) {
            this.log("`command_error`", new Object[]{"enable", string2});
            throw new SLMConfigDswShadowIsMasterException(string, string2);
        }
        if (this.getShadow(string) != null) {
            this.log("`command_error`", new Object[]{"enable", string2});
            throw new SLMConfigDswMasterIsShadowException(string, string2);
        }
        int n2 = this.getVolSize(string);
        if (n2 > (n = this.getVolSize(string2))) {
            this.log("`command_error`", new Object[]{"enable", string2});
            throw new SLMConfigDswSizeException(string, string2, new Integer(n2), new Integer(n));
        }
        if (this.dswMOProxy.isMounted(string2)) {
            throw VolMountedException.VolMountedExceptionFactory(string2, VolMountedException.MSG_SHADOW);
        }
        try {
            DswVolImplProxy dswVolImplProxy = this.dswMOProxy.createDswPair((SvImplProxy)this.svVols.get(string), (SvImplProxy)this.svVols.get(string2), bl, string3);
        }
        catch (DswMODupMasterException dswMODupMasterException) {
            this.log("`command_error`", new Object[]{"enable", string2}, (Throwable)((Object)dswMODupMasterException));
            throw new SLMConfigDswDupMasterException(string, string2);
        }
        catch (DswMODupShadowException dswMODupShadowException) {
            this.log("`command_error`", new Object[]{"enable", string2}, (Throwable)((Object)dswMODupShadowException));
            throw new SLMConfigDswDupShadowException(string, string2);
        }
        catch (DswMOBitmapException dswMOBitmapException) {
            this.log("`command_error`", new Object[]{"enable", string2}, (Throwable)((Object)dswMOBitmapException));
            throw new BitmapDirectoryException(this.bitmapDirectory);
        }
        catch (DswVolException dswVolException) {
            this.log("`create_pair_error`", new Object[]{string, string2}, (Throwable)((Object)dswVolException));
            throw new SLMConfigDswCreateException(string, string2);
        }
        this.log("`create_pair`", new Object[]{string, string2});
    }

    public synchronized void deleteDswPair(String string) throws SLMConfigDswPairNotFoundException, SLMConfigDswDeleteException, SLMConfigDswInvalidOpException, VolMountedException {
        this.trace("deleteDswPair: shadow = " + string);
        DswVolImplProxy dswVolImplProxy = (DswVolImplProxy)this.dswPairs.get(string);
        if (dswVolImplProxy == null) {
            this.log("`command_error`", new Object[]{"disable", string});
            throw new SLMConfigDswPairNotFoundException(string);
        }
        if (!this.isDisableValid(dswVolImplProxy)) {
            this.log("`command_error`", new Object[]{"disable", string});
            throw SLMConfigDswInvalidOpException.newDisableCopyingPairErr(string);
        }
        if (!dswVolImplProxy.isEnabledIndependent()) {
            if (this.dswMOProxy.isMounted(string)) {
                throw VolMountedException.VolMountedExceptionFactory(string, VolMountedException.MSG_SHADOW);
            }
        } else {
            int n = dswVolImplProxy.getCondition().getModifier();
            if (n == 6) {
                this.suspendPair(string);
            }
        }
        try {
            this.dswMOProxy.deleteDswPair(dswVolImplProxy);
        }
        catch (DswMOPairNotFoundException dswMOPairNotFoundException) {
            this.log("`command_error`", new Object[]{"disable", string}, (Throwable)((Object)dswMOPairNotFoundException));
            this.trace("disable failed for " + string);
            throw new SLMConfigDswPairNotFoundException(string);
        }
        catch (DswVolException dswVolException) {
            this.log("`delete_pair_error`", new Object[]{string}, (Throwable)((Object)dswVolException));
            this.trace("disable failed for " + string);
            throw new SLMConfigDswDeleteException(string);
        }
        this.log("`delete_pair`", new Object[]{string});
    }

    void deleteVolPairs(DswVolImplProxy[] dswVolImplProxyArray) {
        this.trace("deleteVolPairs");
        Vector<DswVolImplProxy> vector = new Vector<DswVolImplProxy>();
        int n = 0;
        while (n < dswVolImplProxyArray.length) {
            if (this.dswPairs.containsKey(dswVolImplProxyArray[n].getShadowName())) {
                this.dswPairs.remove(dswVolImplProxyArray[n].getShadowName());
                this.pickle();
                vector.add(dswVolImplProxyArray[n]);
            }
            ++n;
        }
        if (vector.size() > 0) {
            this.sendConfigPairEvent((DswVolImplProxy[])ArrayUtil.vectorToArray(vector, (Class)(class$com$sun$esm$mo$dsw$DswVolImplProxy != null ? class$com$sun$esm$mo$dsw$DswVolImplProxy : (class$com$sun$esm$mo$dsw$DswVolImplProxy = SLMConfigDsw.class$("com.sun.esm.mo.dsw.DswVolImplProxy")))), "SLMConfigDswPairDeleted");
        }
    }

    void deleteVols(SvImplProxy[] svImplProxyArray) {
        this.trace("deleteVols");
        Vector[] vectorArray = this.getSvPairHandles(svImplProxyArray);
        if (vectorArray.length != 0) {
            int n;
            if (vectorArray[1] != null && vectorArray[1].size() != 0) {
                n = 0;
                while (n < vectorArray[1].size()) {
                    String string = new String(((SvImplProxy)vectorArray[1].elementAt(n)).getVolName());
                    if (this.svVols.containsKey(string)) {
                        this.svVols.remove(string);
                        this.pickle();
                        this.svMOProxy.deleteSvVol(string);
                    }
                    ++n;
                }
                this.sendConfigEvent((SvImplProxy[])ArrayUtil.vectorToArray((Vector)vectorArray[1], (Class)(class$com$sun$esm$mo$sv$SvImplProxy != null ? class$com$sun$esm$mo$sv$SvImplProxy : (class$com$sun$esm$mo$sv$SvImplProxy = SLMConfigDsw.class$("com.sun.esm.mo.sv.SvImplProxy")))), "SLMConfigDswVolDeleted");
            }
            if (vectorArray[0] != null && vectorArray[0].size() != 0) {
                n = 0;
                while (n < vectorArray[0].size()) {
                    if (((DswVolImplProxy)vectorArray[0].elementAt(n)).getCondition().getStatus() != 20) {
                        ((DswVolImplProxy)vectorArray[0].elementAt(n)).setPairInoperable();
                    }
                    ++n;
                }
                this.sendConfigPairEvent((DswVolImplProxy[])ArrayUtil.vectorToArray((Vector)vectorArray[0], (Class)(class$com$sun$esm$mo$dsw$DswVolImplProxy != null ? class$com$sun$esm$mo$dsw$DswVolImplProxy : (class$com$sun$esm$mo$dsw$DswVolImplProxy = SLMConfigDsw.class$("com.sun.esm.mo.dsw.DswVolImplProxy")))), "SLMConfigDswVolInPairDeleted");
            }
        }
    }

    protected void finalize() throws Throwable {
        this.trace("finalize");
        if (this.dswMOProxy != null) {
            this.dswMOProxy.removeDswVolsMOConditionListener(this);
            this.dswMOProxy.removeDswVolsMOListener(this);
            this.svMOProxy.removeSvVolsListener((SvVolsListener)this);
        }
        super.finalize();
    }

    DswVolImplProxy getBitmap(String string) {
        DswVolImplProxy dswVolImplProxy = null;
        Enumeration enumeration = this.dswPairs.elements();
        while (enumeration.hasMoreElements()) {
            dswVolImplProxy = (DswVolImplProxy)enumeration.nextElement();
            if (string.compareTo(dswVolImplProxy.getBitmapName()) != 0) continue;
            return dswVolImplProxy;
        }
        return null;
    }

    public String getBitmapDirectory() {
        this.trace("bitmap directory = " + this.bitmapDirectory);
        return this.bitmapDirectory;
    }

    public static String[] getConstructorMO() {
        return constructorMO;
    }

    public Vector getDswPairs() {
        Vector<DswPair> vector = new Vector<DswPair>();
        Enumeration enumeration = this.dswPairs.elements();
        this.trace("getDswPairs");
        while (enumeration.hasMoreElements()) {
            DswVolImplProxy dswVolImplProxy = (DswVolImplProxy)enumeration.nextElement();
            vector.addElement(new DswPair(dswVolImplProxy.getMasterName(), dswVolImplProxy.getShadowName(), dswVolImplProxy.getMasterState(), dswVolImplProxy.getShadowState(), dswVolImplProxy.isEnabledIndependent()));
            this.trace("master = " + dswVolImplProxy.getMasterName() + " shadow = " + dswVolImplProxy.getShadowName());
        }
        return vector;
    }

    protected DswVolsMOImplProxy getDswVolsMOProxy() {
        return this.dswMOProxy;
    }

    DswVolImplProxy getMaster(String string) {
        DswVolImplProxy dswVolImplProxy = null;
        Enumeration enumeration = this.dswPairs.elements();
        while (enumeration.hasMoreElements()) {
            dswVolImplProxy = (DswVolImplProxy)enumeration.nextElement();
            if (string.compareTo(dswVolImplProxy.getMasterProxy().getVolName()) != 0) continue;
            return dswVolImplProxy;
        }
        return null;
    }

    public Vector getMasterCandidates() {
        Enumeration enumeration = this.svVols.elements();
        Vector<String> vector = new Vector<String>();
        this.trace("getMasterCandidates");
        while (enumeration.hasMoreElements()) {
            SvImplProxy svImplProxy = (SvImplProxy)enumeration.nextElement();
            if (this.getShadow(svImplProxy.getVolName()) != null || this.getMaster(svImplProxy.getVolName()) != null || this.getBitmap(svImplProxy.getVolName()) != null || svImplProxy.getVolSize() <= 0) continue;
            vector.addElement(new String(svImplProxy.getVolName()));
            this.trace("getMasterCandidates: candidate =  " + vector.lastElement() + " size = " + svImplProxy.getVolSize());
        }
        return vector;
    }

    DswVolImplProxy getShadow(String string) {
        if (this.dswPairs.containsKey(string)) {
            return (DswVolImplProxy)this.dswPairs.get(string);
        }
        return null;
    }

    public Vector getShadowCandidates(String string) {
        Enumeration enumeration = this.svVols.elements();
        Vector<SvVolProperties> vector = new Vector<SvVolProperties>();
        this.trace("getShadowCandidates: master = " + string);
        while (enumeration.hasMoreElements()) {
            SvImplProxy svImplProxy = (SvImplProxy)enumeration.nextElement();
            if (string.compareTo(svImplProxy.getVolName()) == 0 || this.getShadow(svImplProxy.getVolName()) != null || this.getMaster(svImplProxy.getVolName()) != null || this.getBitmap(svImplProxy.getVolName()) != null || svImplProxy.getState() == 1 || svImplProxy.getVolSize() < ((SvImplProxy)this.svVols.get(string)).getVolSize()) continue;
            vector.addElement(new SvVolProperties(svImplProxy.getVolName(), svImplProxy.getVolSize()));
            this.trace("getShadowCandidates: candidate = " + svImplProxy.getVolName());
        }
        return vector;
    }

    protected SvMOImplProxy getSvMOProxy() {
        return this.svMOProxy;
    }

    Vector[] getSvPairHandles(SvImplProxy[] svImplProxyArray) {
        Vector[] vectorArray = new Vector[]{new Vector(), new Vector()};
        Hashtable<String, DswVolImplProxy> hashtable = new Hashtable<String, DswVolImplProxy>();
        int n = 0;
        while (n < svImplProxyArray.length) {
            DswVolImplProxy dswVolImplProxy = this.getShadow(svImplProxyArray[n].getVolName());
            if (dswVolImplProxy != null) {
                hashtable.put(svImplProxyArray[n].getVolName(), dswVolImplProxy);
            } else {
                dswVolImplProxy = this.getMaster(svImplProxyArray[n].getVolName());
                if (dswVolImplProxy != null) {
                    hashtable.put(dswVolImplProxy.getShadowProxy().getVolName(), dswVolImplProxy);
                } else {
                    vectorArray[1].add(svImplProxyArray[n]);
                }
            }
            ++n;
        }
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            vectorArray[0].add((DswVolImplProxy)enumeration.nextElement());
        }
        hashtable = null;
        return vectorArray;
    }

    void getSvVols() {
        SvImplProxy[] svImplProxyArray = null;
        this.trace("getSvVols");
        if (this.svMOProxy == null) {
            this.log("`svconfig_error`", new Object[0]);
            return;
        }
        svImplProxyArray = this.svMOProxy.getSvProxies();
        int n = 0;
        while (n < svImplProxyArray.length) {
            if (svImplProxyArray[n].getState() != 1) {
                this.svVols.put(svImplProxyArray[n].getVolName(), svImplProxyArray[n]);
                this.pickle();
                this.trace("put vol = " + svImplProxyArray[n].getVolName() + " in table");
            }
            ++n;
        }
    }

    public String getTrinket() {
        return "`InstantImage`";
    }

    public Class getTrinketClass() {
        return class$com$sun$esm$util$slm$dsw$DswConstants != null ? class$com$sun$esm$util$slm$dsw$DswConstants : (class$com$sun$esm$util$slm$dsw$DswConstants = SLMConfigDsw.class$("com.sun.esm.util.slm.dsw.DswConstants"));
    }

    public Vector getVolNames() {
        return this.getMasterCandidates();
    }

    void getVolPairs() {
        DswVolImplProxy[] dswVolImplProxyArray = this.dswMOProxy.getDswVolProxies();
        int n = 0;
        while (n < dswVolImplProxyArray.length) {
            this.dswPairs.put(dswVolImplProxyArray[n].getShadowProxy().getVolName(), dswVolImplProxyArray[n]);
            this.pickle();
            this.trace("put pair = " + dswVolImplProxyArray[n].getShadowProxy().getVolName() + " in pairs table");
            ++n;
        }
    }

    int getVolSize(String string) {
        if (this.svVols.containsKey(string)) {
            return ((SvImplProxy)this.svVols.get(string)).getVolSize();
        }
        return 0;
    }

    public void hydrate() {
        SvImplProxy[] svImplProxyArray;
        super.hydrate();
        this.trace("hydrate started");
        this.log("`hydrate_start`", new Object[0]);
        this.initBitmapDirectory();
        DswVolImplProxy[] dswVolImplProxyArray = this.dswMOProxy.getDswVolProxies();
        this.trace("getDswVolProxies returned array length = " + dswVolImplProxyArray.length);
        if (dswVolImplProxyArray.length > 0) {
            this.addVolPairs(dswVolImplProxyArray);
        }
        if ((svImplProxyArray = this.svMOProxy.getSvProxies()).length > 0) {
            this.addVols(svImplProxyArray);
        }
        this.listenToSvMO();
        this.listenToDswMO();
        this.state = 1;
        this.pickle();
        this.trace("Started State Running");
        this.trace("hydrate completed");
        this.log("`hydrate_finish`", new Object[0]);
    }

    void initBitmapDirectory() {
        try {
            if (this.d_debug) {
                this.setBitmapDirectory(debugBitmapDirectory);
            } else if (this.bitmapDirectory == null) {
                this.setBitmapDirectory(defaultBitmapDirectory);
            }
        }
        catch (BitmapDirectoryException bitmapDirectoryException) {
            this.log("`bitmap_directory`", new Object[0], (Throwable)((Object)bitmapDirectoryException));
            this.trace("BitmapDirectoryException");
        }
    }

    public void isBad(SvConditionEventObject svConditionEventObject) {
        this.trace("isBad: obj = " + svConditionEventObject.obj.getClass().getName());
        this.sendSvStatusEvent(svConditionEventObject, "svIsBad", false);
    }

    public void isDegraded(SvConditionEventObject svConditionEventObject) {
        this.trace("isDegraded: obj = " + svConditionEventObject.obj.getClass().getName());
        this.sendSvStatusEvent(svConditionEventObject, "svIsDegraded", true);
    }

    boolean isDisableValid(DswVolImplProxy dswVolImplProxy) {
        int n = dswVolImplProxy.getCondition().getModifier();
        return n != 5 && n != 2 && n != 1 && n != 4 && n != 3;
    }

    public void isGood(SvConditionEventObject svConditionEventObject) {
        this.trace("isGood: obj = " + svConditionEventObject.obj.getClass().getName());
        this.sendSvStatusEvent(svConditionEventObject, "svIsGood", false);
    }

    public boolean isIndependentDisableValid(String string) {
        DswVolImplProxy dswVolImplProxy = this.getShadow(string);
        if (dswVolImplProxy != null) {
            int n = dswVolImplProxy.getCondition().getModifier();
            return n != 6;
        }
        return false;
    }

    public void isRunning(DswConditionEventObject dswConditionEventObject) {
        this.trace("isRunning: obj = " + dswConditionEventObject.obj.getClass().getName());
        if (this.dswMOProxy == null) {
            this.dswMOProxy = (DswVolsMOImplProxy)dswConditionEventObject.obj;
        }
        if (!this.dswMOProxy.isDswVolsMOConditionListener((DswVolsMOConditionListener)this.getProxy())) {
            this.dswMOProxy.addDswVolsMOConditionListener((DswVolsMOConditionListener)this.getProxy());
        }
        if (!this.dswMOProxy.isDswVolsMOListener((DswVolsMOListener)this.getProxy())) {
            this.dswMOProxy.addDswVolsMOListener((DswVolsMOListener)this.getProxy());
        }
        if (!this.svMOProxy.isSvVolsListener((SvVolsListener)this.getProxy())) {
            this.svMOProxy.addSvVolsListener((SvVolsListener)this.getProxy());
        }
    }

    public void isRunning(SvConditionEventObject svConditionEventObject) {
        this.trace("isRunning: obj = " + svConditionEventObject.obj.getClass().getName());
        if (this.svMOProxy == null) {
            this.svMOProxy = (SvMOImplProxy)svConditionEventObject.obj;
        }
        if (!this.svMOProxy.isSvVolsListener((SvVolsListener)this.getProxy())) {
            this.svMOProxy.addSvVolsListener((SvVolsListener)this.getProxy());
        }
        if (!this.svMOProxy.isSvStateListener((SvStateListener)this.getProxy())) {
            this.svMOProxy.addSvStateListener((SvStateListener)this.getProxy());
        }
        if (!this.svMOProxy.isSvStatusListener((SvStatusListener)this.getProxy())) {
            this.svMOProxy.addSvStatusListener((SvStatusListener)this.getProxy());
        }
        this.sendSvStateEvent(svConditionEventObject, "svIsRunning", false);
    }

    public boolean isSLMConfigDswListener(SLMConfigDswListener sLMConfigDswListener) {
        this.trace("isSLMConfigDswListener");
        return this.myListenerDelegate.isListener((EventListener)sLMConfigDswListener);
    }

    public boolean isSLMConfigDswPairListener(SLMConfigDswPairListener sLMConfigDswPairListener) {
        this.trace("isSLMConfigDswPairListener");
        return this.pairListenerDelegate.isListener((EventListener)sLMConfigDswPairListener);
    }

    public boolean isSLMConfigDswSvStateListener(SLMConfigDswSvStateListener sLMConfigDswSvStateListener) {
        this.trace("isSLMConfigDswSvStateListener");
        return this.dswSvStateListenerDelegate.isListener((EventListener)sLMConfigDswSvStateListener);
    }

    public boolean isSLMConfigDswSvStatusListener(SLMConfigDswSvStatusListener sLMConfigDswSvStatusListener) {
        this.trace("isSLMConfigDswSvStatusListener");
        return this.dswSvStatusListenerDelegate.isListener((EventListener)sLMConfigDswSvStatusListener);
    }

    public void isStopped(DswConditionEventObject dswConditionEventObject) {
        this.trace("isStopped: obj = " + dswConditionEventObject.obj.getClass().getName());
        if (this.dswMOProxy == null) {
            this.dswMOProxy = (DswVolsMOImplProxy)dswConditionEventObject.obj;
        }
        this.dswMOProxy.removeDswVolsMOConditionListener(this);
        this.dswMOProxy.removeDswVolsMOListener(this);
    }

    public void isStopped(SvConditionEventObject svConditionEventObject) {
        this.trace("isStopped: obj = " + svConditionEventObject.obj.getClass().getName());
        if (this.svMOProxy == null) {
            this.svMOProxy = (SvMOImplProxy)svConditionEventObject.obj;
        }
        this.svMOProxy.removeSvVolsListener((SvVolsListener)this);
        this.svMOProxy.removeSvStateListener((SvStateListener)this);
        this.svMOProxy.removeSvStatusListener((SvStatusListener)this);
        this.sendSvStateEvent(svConditionEventObject, "svIsStopped", false);
    }

    public void isStopping(DswConditionEventObject dswConditionEventObject) {
        this.trace("isStopping: obj = " + dswConditionEventObject.obj.getClass().getName());
    }

    public void isStopping(SvConditionEventObject svConditionEventObject) {
        this.trace("isStopping: obj = " + svConditionEventObject.obj.getClass().getName());
        this.sendSvStateEvent(svConditionEventObject, "svIsStopping", false);
    }

    public boolean isVisible() {
        return this.visible;
    }

    void listenToDswMO() {
        if (this.dswMOProxy != null) {
            if (!this.dswMOProxy.isDswVolsMOConditionListener((DswVolsMOConditionListener)this.getProxy())) {
                this.dswMOProxy.addDswVolsMOConditionListener((DswVolsMOConditionListener)this.getProxy());
            }
            if (!this.dswMOProxy.isDswVolsMOListener((DswVolsMOListener)this.getProxy())) {
                this.dswMOProxy.addDswVolsMOListener((DswVolsMOListener)this.getProxy());
            }
        }
    }

    void listenToSvMO() {
        if (this.svMOProxy != null) {
            if (!this.svMOProxy.isSvVolsListener((SvVolsListener)this.getProxy())) {
                this.svMOProxy.addSvVolsListener((SvVolsListener)this.getProxy());
            }
            if (!this.svMOProxy.isSvStateListener((SvStateListener)this.getProxy())) {
                this.svMOProxy.addSvStateListener((SvStateListener)this.getProxy());
            }
            if (!this.svMOProxy.isSvStatusListener((SvStatusListener)this.getProxy())) {
                this.svMOProxy.addSvStatusListener((SvStatusListener)this.getProxy());
            }
        }
    }

    private void log(String string, Object[] objectArray) {
        Services.log((String)string, (Object[])objectArray, this.getClass(), (String)"`InstantImage`");
    }

    private void log(String string, Object[] objectArray, Throwable throwable) {
        Services.log((String)string, (Object[])objectArray, this.getClass(), (String)"`InstantImage`", (Throwable)throwable);
    }

    public void managedVols(DswVolsMOEvent dswVolsMOEvent) {
        this.trace("managedVols");
        this.volsManaged(dswVolsMOEvent);
    }

    protected Application newProxy() {
        if (((AppImpl)this).appProxy == null) {
            ((AppImpl)this).appProxy = (Application)ByReference.wrap((Object)this);
        }
        return ((AppImpl)this).appProxy;
    }

    private void pickle() {
        this.trace("pickle");
        try {
            this.oid = Pickle.pickle((Serializable)this, (OID)this.oid, (String)"hydrate");
        }
        catch (PersistenceException persistenceException) {
            this.trace("pickle PersistenceException");
        }
    }

    public void removeSLMConfigDswListener(SLMConfigDswListener sLMConfigDswListener) {
        this.trace("removeSLMConfigDswListener");
        this.myListenerDelegate.removeListener((EventListener)sLMConfigDswListener);
        this.pickle();
    }

    public void removeSLMConfigDswPairListener(SLMConfigDswPairListener sLMConfigDswPairListener) {
        this.trace("removeSLMConfigDswPairListener");
        this.pairListenerDelegate.removeListener((EventListener)sLMConfigDswPairListener);
        this.pickle();
    }

    public void removeSLMConfigDswSvStateListener(SLMConfigDswSvStateListener sLMConfigDswSvStateListener) {
        this.trace("removeSLMConfigDswSvStateListener");
        this.dswSvStateListenerDelegate.removeListener((EventListener)sLMConfigDswSvStateListener);
        this.pickle();
    }

    public void removeSLMConfigDswSvStatusListener(SLMConfigDswSvStatusListener sLMConfigDswSvStatusListener) {
        this.trace("removeSLMConfigDswSvStatusListener");
        this.dswSvStatusListenerDelegate.removeListener((EventListener)sLMConfigDswSvStatusListener);
        this.pickle();
    }

    void sendConfigEvent(SvImplProxy[] svImplProxyArray, String string) {
        if (this.myListenerDelegate != null) {
            String[] stringArray = new String[svImplProxyArray.length];
            int n = 0;
            while (n < svImplProxyArray.length) {
                stringArray[n] = svImplProxyArray[n].getVolName();
                ++n;
            }
            try {
                this.trace("sending " + string + " event");
                this.myListenerDelegate.send((EventObject)new SLMConfigDswVolsEvent(stringArray), string, true);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                this.trace("exception sending " + string + " event " + ExceptionUtil.getExceptionTree((Throwable)throwable));
                this.log("`send_event`", new Object[]{string}, throwable);
            }
        }
    }

    void sendConfigPairEvent(DswVolImplProxy[] dswVolImplProxyArray, String string) {
        this.trace("sendConfigPairEvent: reason = " + string);
        if (this.pairListenerDelegate != null && dswVolImplProxyArray != null && dswVolImplProxyArray.length != 0) {
            DswPair[] dswPairArray = new DswPair[dswVolImplProxyArray.length];
            int n = 0;
            while (n < dswVolImplProxyArray.length) {
                dswPairArray[n] = new DswPair(dswVolImplProxyArray[n].getMasterName(), dswVolImplProxyArray[n].getShadowName(), dswVolImplProxyArray[n].getMasterState(), dswVolImplProxyArray[n].getShadowState(), dswVolImplProxyArray[n].isEnabledIndependent());
                ++n;
            }
            try {
                this.trace("sending " + string + " event");
                this.pairListenerDelegate.send((EventObject)new SLMConfigDswPairEvent(dswPairArray), string, true);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                this.trace("exception sending " + string + " event " + ExceptionUtil.getExceptionTree((Throwable)throwable));
                this.log("`send_event`", new Object[]{string}, throwable);
            }
        } else {
            this.trace("sendConfigPairEvent no vols to send");
        }
    }

    void sendSvStateEvent(SvConditionEventObject svConditionEventObject, String string, boolean bl) {
        if (this.dswSvStateListenerDelegate != null) {
            SLMConfigDswSvException sLMConfigDswSvException = null;
            if (bl) {
                sLMConfigDswSvException = new SLMConfigDswSvException(svConditionEventObject.ex);
            }
            try {
                this.trace("sending " + string + " event");
                this.dswSvStateListenerDelegate.send((EventObject)((Object)new SLMConfigDswSvConditionEventObject(svConditionEventObject.obj, svConditionEventObject.cond, (Throwable)((Object)sLMConfigDswSvException))), string, true);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                this.trace("exception sending " + string + " event " + ExceptionUtil.getExceptionTree((Throwable)throwable));
                this.log("`send_event`", new Object[]{string}, throwable);
            }
        }
    }

    void sendSvStatusEvent(SvConditionEventObject svConditionEventObject, String string, boolean bl) {
        this.trace("sendSvStatusEvent: reason = " + string);
        if (this.dswSvStatusListenerDelegate != null) {
            SLMConfigDswSvException sLMConfigDswSvException = null;
            if (bl) {
                sLMConfigDswSvException = new SLMConfigDswSvException(svConditionEventObject.ex);
            }
            try {
                this.trace("sending " + string + " event");
                this.dswSvStatusListenerDelegate.send((EventObject)((Object)new SLMConfigDswSvConditionEventObject(svConditionEventObject.obj, svConditionEventObject.cond, (Throwable)((Object)sLMConfigDswSvException))), string, true);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                this.trace("exception sending " + string + " event " + ExceptionUtil.getExceptionTree((Throwable)throwable));
                this.log("`send_event`", new Object[]{string}, throwable);
            }
        }
    }

    public synchronized void setBitmapDirectory(String string) throws BitmapDirectoryException {
        this.trace("setBitmapDirectory to " + string);
        if (!this.dswMOProxy.createBitmapDirectory(string)) {
            throw new BitmapDirectoryException(string);
        }
        this.bitmapDirectory = new String(string);
        this.pickle();
    }

    public void suspendPair(String string) throws SLMConfigDswInvalidOpException, VolMountedException {
        Application[] applicationArray;
        this.trace("suspendPair");
        InetStationAddress inetStationAddress = null;
        SLMControlDswVolProxy sLMControlDswVolProxy = null;
        try {
            applicationArray = new AppBoot("localhost");
            InetAddress inetAddress = InetAddress.getByName("localhost");
            this.trace("realm = " + applicationArray.getRealmName() + " station = " + applicationArray.getStationName());
            inetStationAddress = new InetStationAddress(applicationArray.getRealmName(), applicationArray.getStationName(), inetAddress);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            this.trace("Exception thrown trying to get AppManager station address " + ExceptionUtil.getExceptionTree((Throwable)throwable));
            throw SLMConfigDswInvalidOpException.newSuspendPairErr(string);
        }
        applicationArray = AppManagerProxy.lookupByClass((String)"com.sun.esm.apps.control.slm.dsw.SLMControlDswVol", (StationAddress)inetStationAddress);
        if (applicationArray == null) {
            this.trace("AppManager did not find any MC Vol proxies");
            throw SLMConfigDswInvalidOpException.newSuspendPairErr(string);
        }
        int n = 0;
        while (n < applicationArray.length) {
            if (string.compareTo(((SLMControlDswVolProxy)applicationArray[n]).getShadowName()) == 0) {
                sLMControlDswVolProxy = (SLMControlDswVolProxy)applicationArray[n];
                try {
                    sLMControlDswVolProxy.suspend();
                    return;
                }
                catch (SLMControlDswVolException sLMControlDswVolException) {
                    this.trace("SLMControlDswVolException thrown trying to suspend " + string);
                    throw SLMConfigDswInvalidOpException.newSuspendPairErr(string);
                }
                catch (VolMountedException volMountedException) {
                    this.trace("VolMountedException thrown trying to suspend " + string);
                    throw SLMConfigDswInvalidOpException.newSuspendPairErr(string);
                }
                catch (CompositeException compositeException) {
                    this.trace("Exception thrown trying to suspend " + string + " " + ExceptionUtil.getExceptionTree((Throwable)compositeException));
                    throw SLMConfigDswInvalidOpException.newSuspendPairErr(string);
                }
            }
            ++n;
        }
        this.trace("Did not find SLMControlDswVolProxy for " + string);
        throw SLMConfigDswInvalidOpException.newSuspendPairErr(string);
    }

    public void svVolAdded(SvVolsEvent svVolsEvent) {
        this.trace("svVolAdded");
        int n = 0;
        while (n < svVolsEvent.svVol.length) {
            this.log("`svvol_added`", new Object[]{svVolsEvent.svVol[n].getVolName()});
            ++n;
        }
        this.addVols(svVolsEvent.svVol);
    }

    public void svVolDeleted(SvVolsEvent svVolsEvent) {
        this.trace("svVolDeleted");
        int n = 0;
        while (n < svVolsEvent.svVol.length) {
            this.log("`svvol_deleted`", new Object[]{svVolsEvent.svVol[n].getVolName()});
            ++n;
        }
        this.deleteVols(svVolsEvent.svVol);
    }

    private void trace(String string) {
        TraceUtil.trace(string, this.getClass().getName());
    }

    public void volsManaged(DswVolsMOEvent dswVolsMOEvent) {
        this.trace("volsManaged");
        this.addVolPairs(dswVolsMOEvent.vols);
    }

    public void volsUnManaged(DswVolsMOEvent dswVolsMOEvent) {
        this.trace("volsUnManaged");
        this.deleteVolPairs(dswVolsMOEvent.vols);
    }
}

