/*
 * Copyright (c) 2000 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef _SYS_USB_PRINTER_H
#define	_SYS_USB_PRINTER_H

#pragma ident	"@(#)usb_printer.h	1.1	00/03/01 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * This header file contains generic printer class spec (1.0) information
 */

/*
 * Printer class descriptor type
 */
#define	USB_PRINTER_DESCR_TYPE	0x21


/*
 * Printer class specific commands sent to the device
 */
#define	USB_PRINTER_GET_DEVICE_ID	0x00 /* Get IEEEE-1284 compatible ID */
#define	USB_PRINTER_GET_PORT_STATUS	0x01 /* Returns current status */
					/* Flushes buffers of Bulk out pipe */
#define	USB_PRINTER_SOFT_RESET		0x02
#define	USB_PRINTER_CLEAR_FEATURE	0x01	/* Clear a stall */

/*
 * Port status values, see Table 3 of the specification
 */
#define	USB_PRINTER_PORT_NO_ERROR	0x0008	/* No Error */
#define	USB_PRINTER_PORT_NO_SELECT	0x0010	/* Selected */
#define	USB_PRINTER_PORT_EMPTY		0x0020	/* Paper Empty */

/*
 * Application error state
 */
#define	USB_PRINTER_ERR_ERR		0x0001	/* Error */
#define	USB_PRINTER_SLCT_ERR		0x0002	/* Selected */
#define	USB_PRINTER_PE_ERR		0x0004	/* Paper Empty */

#ifdef __cplusplus
}
#endif

#endif	/* _SYS_USB_PRINTER_H */
