/*
 * Decompiled with CFR 0.152.
 */
package com.scmmicro.smartos.core;

import com.scmmicro.smartos.core.ATR;
import com.scmmicro.smartos.exceptions.BadParameterException;
import com.scmmicro.smartos.exceptions.BadParameterValueException;
import com.scmmicro.smartos.exceptions.CardException;
import com.scmmicro.smartos.exceptions.CommunicationException;
import com.scmmicro.smartos.exceptions.TimeOutException;
import com.scmmicro.smartos.physical.Drive;
import com.scmmicro.smartos.util.Buffer;
import com.sun.opencard.common.OCFDebug;

public class SpecificATR
extends ATR {
    boolean verbose = false;

    private byte atrMgr(Drive drive, byte[] byArray) throws CommunicationException, CardException, BadParameterValueException, BadParameterException, TimeOutException {
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        int n = 0;
        byte by4 = 1;
        byte by5 = 0;
        this.Protocol = 0;
        this.SpecProt = 0;
        this.TD1Protocol = 0;
        int n2 = n;
        n = (byte)(n2 + 1);
        this.ts_Mgr(byArray[n2]);
        by2 = (byte)((byArray[n] & 0xF0) >> 4 & 0xF);
        int n3 = n;
        n = (byte)(n3 + 1);
        by3 = (byte)(byArray[n3] & 0xF);
        while (by2 != 0) {
            if ((by2 & 1) != 0) {
                int n4 = n;
                n = (byte)(n4 + 1);
                this.tax_Mgr(drive, by4, byArray[n4]);
            }
            if ((by2 & 2) != 0) {
                int n5 = n;
                n = (byte)(n5 + 1);
                this.tbx_Mgr(by4, byArray[n5]);
            }
            if ((by2 & 4) != 0) {
                int n6 = n;
                n = (byte)(n6 + 1);
                this.tcx_Mgr(by4, byArray[n6]);
            }
            if ((by2 & 8) == 0) break;
            if ((by2 & 8) == 0) continue;
            this.tdx_Mgr(by4, byArray[n]);
            int n7 = n;
            n = (byte)(n7 + 1);
            by2 = (byte)((byArray[n7] & 0xF0) >> 4 & 0xF);
            by4 = (byte)(by4 + 1);
        }
        if ((this.Protocol != 0 || this.SpecProt != 0 || this.TD1Protocol != 0) && (by5 = (byte)(this.lrc_Compute(byArray, n + by3 + 1) ^ byArray[0])) != 0) {
            return -30;
        }
        if (this.Protocol == 14) {
            this.Protocol = 0;
        }
        this.Protocol = this.TD1Protocol;
        if (this.Mode) {
            this.Protocol = this.SpecProt;
        } else if (this.PTS_Enable && (this.Dl != 1 || this.Fl != 1)) {
            this.CGT = (short)(14 + this.EGT);
            this.m_rSession.getParameters().CLP_PTSNecessary = true;
        }
        return by;
    }

    private short computeCycles(byte by, byte by2) {
        if (by >= 10 || by2 == 0) {
            return 0;
        }
        byte by3 = ATR.DlToDi[by & 0xF];
        short s = ATR.FlToCycles[by2 & 0xF];
        s = (short)(s + ((s = (short)(s / (short)by3)) % 2 == 0 ? (short)0 : 1));
        return s;
    }

    private byte conv_Mgr(Buffer buffer) {
        int n = 0;
        if (buffer.getByte(0) == 3) {
            buffer.setByte(0, (byte)63);
        }
        if (buffer.getByte(0) != 63 && buffer.getByte(0) != 59) {
            n = -30;
        }
        return (byte)n;
    }

    void debug(String string) {
        if (this.verbose) {
            System.out.println("SpecificATR : " + string);
        } else {
            try {
                OCFDebug.debugln((String)("SpecificATR:: " + string));
            }
            catch (Exception exception) {}
        }
    }

    private byte lrc_Compute(byte[] byArray, int n) {
        byte by = 0;
        int n2 = 0;
        while (n2 < n) {
            by = (byte)(by ^ byArray[n2]);
            ++n2;
        }
        return by;
    }

    protected byte postPTS() {
        byte by = 0;
        this.ETULength = this.computeCycles(this.Dl, this.Fl);
        if (this.ETULength == 0) {
            return -30;
        }
        this.m_rSession.getParameters().CLP_ETULength = this.ETULength;
        switch (this.Protocol) {
            case 0: {
                this.BWT = this.CWT = (long)(960 * ((short)this.WI & 0xFF) * this.ETULength);
                this.CGT = (short)(14 + ((short)this.EGT & 0xFF));
                break;
            }
            case 1: {
                this.CWT = (long)(11 + (1 << this.CWI)) * (long)this.ETULength;
                this.BWT = (long)(11 + (1 << this.BWI) * 960) * (long)this.ETULength;
                this.CGT = (short)(13 + ((short)this.EGT & 0xFF));
                break;
            }
        }
        return by;
    }

    private byte receptATR(Buffer buffer, Drive drive) throws CommunicationException, CardException, TimeOutException, BadParameterException {
        int n;
        int n2;
        byte by = 0;
        int n3 = 0;
        int n4 = -1;
        byte by2 = 0;
        int n5 = 2;
        Buffer buffer2 = new Buffer(n5);
        if (this.verbose) {
            try {
                n2 = drive.getNumReceived();
                System.out.println("receptATR: there are " + n2 + " bytes available");
            }
            catch (Exception exception) {
                System.out.println("receptATR: getNumReceived() EXCEPTION = " + exception.toString());
                throw new CommunicationException("ogg!");
            }
            System.out.println("receptATR: before receiveBlock()");
        } else {
            try {
                n2 = drive.getNumReceived();
                try {
                    OCFDebug.debugln((String)("receptATR: there are " + n2 + " bytes available"));
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                System.out.println("receptATR: getNumReceived() EXCEPTION = " + exception.toString());
                throw new CommunicationException("ogg!");
            }
        }
        drive.receiveBlock(buffer2);
        if (this.verbose) {
            System.out.println("receptATR: after receiveBlock()");
        } else {
            try {
                OCFDebug.debugln((String)"receptATR: after receiveBlock()");
            }
            catch (Exception exception) {}
        }
        buffer.setByte(0, buffer2.getByte(0));
        buffer.setByte(1, buffer2.getByte(1));
        buffer.setLength(2);
        n3 = (byte)(n3 + 2);
        n5 = 0;
        by = this.conv_Mgr(buffer);
        if (by == -30) {
            return by;
        }
        byte by3 = (byte)(buffer.getByte(n3 - 1) & 0xF);
        n4 = (byte)((buffer.getByte(n3 - 1) & 0xF0) >> 4 & 0xF);
        while (n4 != 0) {
            if ((n4 & 1) != 0) {
                ++n5;
            }
            if ((n4 & 2) != 0) {
                ++n5;
            }
            if ((n4 & 4) != 0) {
                ++n5;
            }
            if ((n4 & 8) != 0) {
                buffer2 = new Buffer(++n5);
                drive.receiveBlock(buffer2);
                n = 0;
                while (n < n5) {
                    buffer.setByte(n3 + n, buffer2.getByte(n));
                    n = (byte)(n + 1);
                }
                n3 = (byte)(n3 + n5);
                buffer.setLength(n3);
                n5 = 0;
                n4 = (byte)((buffer.getByte(n3 - 1) & 0xF0) >> 4 & 0xF);
                by2 = (byte)(buffer.getByte(n3 - 1) & 0xF);
                continue;
            }
            buffer2 = new Buffer(n5);
            drive.receiveBlock(buffer2);
            n = 0;
            while (n < n5) {
                buffer.setByte(n3 + n, buffer2.getByte(n));
                n = (byte)(n + 1);
            }
            n3 = (byte)(n3 + n5);
            buffer.setLength(n3);
            n4 = 0;
        }
        n5 = by2 != 0 ? by3 + 1 : (int)by3;
        buffer2 = new Buffer(n5);
        drive.receiveBlock(buffer2);
        n = 0;
        while (n < n5) {
            buffer.setByte(n3 + n, buffer2.getByte(n));
            n = (byte)(n + 1);
        }
        n3 = (byte)(n3 + n5);
        buffer.setLength(n3);
        n5 = drive.getNumReceived();
        if (n5 != 0) {
            buffer2 = new Buffer(n5);
            drive.receiveBlock(buffer2);
        }
        return by;
    }

    void reset(boolean bl, Buffer buffer, Buffer buffer2, Drive drive) throws CommunicationException, CardException, BadParameterValueException, TimeOutException {
        byte by = 0;
        this.debug("Process Reset ...");
        if (this.m_rSession.m_rParameters.Just_Atr == 0) {
            this.m_rSession.m_rParameters.init();
        }
        this.debug("Init ATR params ...");
        this.initAtr();
        this.debug("init ATR done ...");
        this.PTS_Enable = this.m_rSession.getParameters().CLP_Pts;
        try {
            this.debug("Send TS timeout value ...");
            drive.setParameter((byte)30, this.m_rSession.getParameters().CLP_TS_Timeout);
            long l = this.IWT * 5L / 3580L;
            this.debug("Set Waiting timeout ..." + l);
            drive.setParameter((byte)15, l);
            this.debug("Set power OFF ...");
            if (!bl) {
                drive.setParameter((byte)22, 1L);
            }
            this.debug("Init UART ...");
            drive.setParameter((byte)26, 1L);
            this.debug("Test Short Circuit ...");
            l = drive.getParameter((byte)29);
            if ((byte)l != 0) {
                throw new CardException("Short circuit test failure");
            }
        }
        catch (BadParameterException badParameterException) {
            throw new CommunicationException("Drive.setParameter failed : " + badParameterException.toString());
        }
        try {
            drive.setParameter((byte)22, 2L);
        }
        catch (CardException cardException) {
            try {
                drive.setParameter((byte)22, 1L);
                throw new CardException("SpecificATR.reset : POWER ON Failed " + cardException.toString());
            }
            catch (BadParameterException badParameterException) {
                System.out.println(badParameterException.toString());
                throw new CommunicationException("SpecificATR.reset : setParameter(PLP_POWER)Failed " + badParameterException.toString());
            }
        }
        catch (BadParameterException badParameterException) {
            System.out.println(badParameterException.toString());
            throw new CommunicationException("SpecificATR.reset : setParameter(PLP_POWER)Failed " + badParameterException.toString());
        }
        Buffer buffer3 = new Buffer(32);
        System.out.println("--> before receptATR");
        try {
            by = this.receptATR(buffer3, drive);
        }
        catch (BadParameterException badParameterException) {
            throw new CommunicationException("SpecificATR.reset : wrong parameter " + badParameterException.toString());
        }
        System.out.println("--> after receptATR");
        if (by != 0) {
            try {
                drive.setParameter((byte)22, 1L);
            }
            catch (BadParameterException badParameterException) {
                throw new CommunicationException("SpecificATR.reset : setParameter(PLP_POWER)Failed " + badParameterException.toString());
            }
            throw new CardException();
        }
        if (this.verbose) {
            System.out.println("--> before ATRMgr");
        }
        try {
            by = this.atrMgr(drive, buffer3.getData());
        }
        catch (BadParameterException badParameterException) {
            throw new CommunicationException("SpecificATR.reset : wrong parameter");
        }
        if (this.verbose) {
            System.out.println("--> after ATRMgr, RetCode = " + by);
        }
        if (by == 0) {
            this.m_rSession.getParameters().CLP_Dl = this.Dl;
            this.m_rSession.getParameters().CLP_Fl = this.Fl;
            this.m_rSession.getParameters().CLP_Protocol = this.Protocol;
            if (!this.m_rSession.getParameters().CLP_PTSNecessary) {
                this.updatePar(drive);
            }
        } else {
            throw new CardException();
        }
        buffer2.setData(buffer3.getData(), buffer3.getLength());
        this.m_rSession.getParameters().Just_Atr = 1;
    }

    private void tax_Mgr(Drive drive, byte by, byte by2) throws CommunicationException, CardException, BadParameterValueException, BadParameterException, TimeOutException {
        block0 : switch (by) {
            case 1: {
                this.Fl = (byte)((by2 & 0xF0) >> 4 & 0xF);
                this.Dl = (byte)(by2 & 0xF);
                int n = (int)drive.getParameter((byte)31);
                if (this.computeCycles(this.Dl, this.Fl) >= ATR.COMToETU[n]) break;
                this.Dl = 1;
                this.Fl = 1;
                break;
            }
            case 2: {
                this.Mode = true;
                this.ModifMode = (by2 >> 7 & 1) != 0;
                this.DefPar = (by2 >> 4 & 1) != 0;
                this.SpecProt = (byte)(by2 & 0xF);
                break;
            }
            default: {
                switch (this.Protocol) {
                    case 1: {
                        if (by2 <= 0 || by2 >= 255) break block0;
                        this.IFSC = by2;
                        break block0;
                    }
                    case 15: {
                        if (this.Xl != 0 || this.Cl != 1) break block0;
                        this.Xl = (byte)((by2 & 0xC0) >> 6 & 0xF);
                        this.Cl = (byte)(by2 & 0x3F);
                        break block0;
                    }
                }
            }
        }
    }

    private void tbx_Mgr(byte by, byte by2) {
        block0 : switch (by) {
            case 1: {
                this.Il = (byte)((by2 & 0x60) >> 5 & 0xF);
                this.Pl1 = (byte)(by2 & 0x1F);
                break;
            }
            case 2: {
                if (by2 < 50 || by2 > 250) break;
                this.Pl2 = by2;
                break;
            }
            default: {
                switch (this.Protocol) {
                    case 1: {
                        this.CWI = (byte)(by2 & 0xF);
                        this.BWI = (byte)((by2 & 0xF0) >> 4 & 0xF);
                        break block0;
                    }
                }
            }
        }
    }

    private void tcx_Mgr(byte by, byte by2) {
        block0 : switch (by) {
            case 1: {
                this.EGT = by2;
                if (this.EGT != -1) break;
                this.EGT = 0;
                break;
            }
            case 2: {
                if (this.Protocol != 0) break;
                this.WI = by2;
                break;
            }
            default: {
                switch (this.Protocol) {
                    case 1: {
                        this.ATR_Edc = (by2 & 1) != 0;
                        break block0;
                    }
                }
            }
        }
    }

    private void tdx_Mgr(byte by, byte by2) {
        if (by == 1) {
            if ((byte)(by2 & 0xF) != 14) {
                this.Protocol = this.TD1Protocol = (byte)(by2 & 0xF);
            }
        } else {
            this.Protocol = (byte)(by2 & 0xF);
        }
    }

    private void ts_Mgr(byte by) {
        this.Conv = by != 59;
    }
}

