/*
 * Decompiled with CFR 0.152.
 */
package com.scmmicro.smartos.core;

import com.scmmicro.smartos.core.GLOBAL_PAR;
import com.scmmicro.smartos.core.Protocol;
import com.scmmicro.smartos.core.STATE_EVENT;
import com.scmmicro.smartos.exceptions.BadParameterException;
import com.scmmicro.smartos.exceptions.BadParameterValueException;
import com.scmmicro.smartos.exceptions.CardException;
import com.scmmicro.smartos.exceptions.CommunicationException;
import com.scmmicro.smartos.exceptions.TimeOutException;
import com.scmmicro.smartos.physical.Drive;
import com.scmmicro.smartos.util.Buffer;
import com.scmmicro.smartos.util.Timer;

public class ProtocolT1
extends Protocol {
    static final byte WORKING = 1;
    static final byte END = 0;
    static final byte OFF = 0;
    static final byte LRC = 0;
    static final byte CRC = 1;
    static final byte BEGIN = 0;
    static final byte EMPTY = 0;
    static final byte NUM_PREV_CMDS = 3;
    static final byte LAST_PREV = 0;
    static final byte CHAINING = 1;
    static final byte NO_CHAINING = 0;
    static final byte NB_PCBVALUE = 17;
    static final byte SRQ = 0;
    static final byte SIQ = 1;
    static final byte SIP = 2;
    static final byte SAQ = 3;
    static final byte SAP = 4;
    static final byte SWQ = 5;
    static final byte SWP = 6;
    static final byte IB00 = 7;
    static final byte IB10 = 8;
    static final byte IB01 = 9;
    static final byte IB11 = 10;
    static final byte IB0X = 11;
    static final byte IB1X = 12;
    static final byte R0EF = 13;
    static final byte R1EF = 14;
    static final byte R0EP = 15;
    static final byte R1EP = 16;
    static final byte R0OE = 17;
    static final byte R1OE = 18;
    static final byte RNEP = 19;
    static final byte RNOE = 20;
    static final byte RBERR = 21;
    static final byte RCMD = 22;
    static final byte RET = 23;
    static final byte DEACT = 24;
    static final byte NPB = 25;
    static final byte EV_SRQ = 0;
    static final byte EV_SIQ = 1;
    static final byte EV_SIP = 2;
    static final byte EV_SAQ = 3;
    static final byte EV_SAP = 4;
    static final byte EV_SWQ = 5;
    static final byte EV_SWP = 6;
    static final byte EV_IB00 = 7;
    static final byte EV_IB10 = 8;
    static final byte EV_IB01 = 9;
    static final byte EV_IB11 = 10;
    static final byte EV_R0EF = 11;
    static final byte EV_R1EF = 12;
    static final byte EV_R0EP = 13;
    static final byte EV_R1EP = 14;
    static final byte EV_R0OE = 15;
    static final byte EV_R1OE = 16;
    static final byte ST_2RETRIES = 0;
    static final byte ST_3RETRIES = 1;
    static final byte ST_SRP = 2;
    static final byte ST_SIQ = 3;
    static final byte ST_SIP = 4;
    static final byte ST_SAQ = 5;
    static final byte ST_SAP = 6;
    static final byte ST_SWQ = 7;
    static final byte ST_SWP = 8;
    static final byte ST_IB00 = 9;
    static final byte ST_IB10 = 10;
    static final byte ST_IB01 = 11;
    static final byte ST_IB11 = 12;
    static final byte ST_R0EF = 13;
    static final byte ST_R1EF = 14;
    static final byte ST_R0EP = 15;
    static final byte ST_R1EP = 16;
    static final byte ST_R0OE = 17;
    static final byte ST_R1OE = 18;
    static final byte ST_ERR_TRANS = 19;
    static final byte ST_SYNCH_LOST = 20;
    static final byte ST_OTHER_ERR = 21;
    static final byte CL_OK = 0;
    byte[] Pcb_State;
    byte[][] State_Event;
    byte Action;
    GLOBAL_PAR GblPar;
    STATE_EVENT StateEvent;
    private Timer m_rReceptionTimerT1;
    private Timer m_rReceptionTimerT2;
    private boolean m_bReceptionTimoutT1;
    private boolean m_bReceptionTimoutT2;

    public ProtocolT1() {
        byte[] byArray = new byte[17];
        byArray[0] = -32;
        byArray[1] = -63;
        byArray[2] = -31;
        byArray[3] = -62;
        byArray[4] = -30;
        byArray[5] = -61;
        byArray[6] = -29;
        byArray[8] = 64;
        byArray[9] = 32;
        byArray[10] = 96;
        byArray[11] = -128;
        byArray[12] = -112;
        byArray[13] = -127;
        byArray[14] = -111;
        byArray[15] = -126;
        byArray[16] = -110;
        this.Pcb_State = byArray;
        byte[][] byArrayArray = new byte[22][];
        byte[] byArray2 = new byte[17];
        byArray2[1] = 1;
        byArray2[2] = 22;
        byArray2[3] = 3;
        byArray2[4] = 22;
        byArray2[5] = 22;
        byArray2[6] = 22;
        byArray2[7] = 22;
        byArray2[8] = 22;
        byArray2[9] = 22;
        byArray2[10] = 22;
        byArray2[11] = 22;
        byArrayArray[0] = byArray2;
        byte[] byArray3 = new byte[17];
        byArray3[0] = 24;
        byArrayArray[1] = byArray3;
        byArrayArray[2] = new byte[]{23, 1, 20, 3, 20, 5, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20};
        byte[] byArray4 = new byte[17];
        byArray4[1] = 1;
        byArray4[2] = 2;
        byArray4[3] = 3;
        byArray4[4] = 2;
        byArray4[5] = 5;
        byArray4[6] = 2;
        byArray4[7] = 2;
        byArray4[8] = 2;
        byArray4[9] = 2;
        byArray4[10] = 2;
        byArray4[11] = 2;
        byArray4[12] = 2;
        byArray4[13] = 2;
        byArray4[14] = 2;
        byArray4[15] = 2;
        byArray4[16] = 2;
        byArrayArray[3] = byArray4;
        byte[] byArray5 = new byte[17];
        byArray5[1] = 11;
        byArray5[2] = 20;
        byArray5[3] = 3;
        byArray5[4] = 20;
        byArray5[5] = 5;
        byArray5[6] = 20;
        byArray5[7] = 20;
        byArray5[8] = 20;
        byArray5[9] = 20;
        byArray5[10] = 20;
        byArray5[11] = 20;
        byArray5[12] = 20;
        byArray5[13] = 20;
        byArray5[14] = 20;
        byArray5[15] = 20;
        byArray5[16] = 20;
        byArrayArray[4] = byArray5;
        byte[] byArray6 = new byte[17];
        byArray6[1] = 1;
        byArray6[2] = 4;
        byArray6[3] = 3;
        byArray6[4] = 4;
        byArray6[5] = 5;
        byArray6[6] = 4;
        byArray6[7] = 4;
        byArray6[8] = 4;
        byArray6[9] = 4;
        byArray6[10] = 4;
        byArray6[11] = 4;
        byArray6[12] = 4;
        byArray6[13] = 4;
        byArray6[14] = 4;
        byArray6[15] = 4;
        byArray6[16] = 4;
        byArrayArray[5] = byArray6;
        byte[] byArray7 = new byte[17];
        byArray7[1] = 1;
        byArray7[2] = 20;
        byArray7[3] = 23;
        byArray7[4] = 20;
        byArray7[5] = 5;
        byArray7[6] = 20;
        byArray7[7] = 20;
        byArray7[8] = 20;
        byArray7[9] = 20;
        byArray7[10] = 20;
        byArray7[11] = 20;
        byArray7[12] = 20;
        byArray7[13] = 20;
        byArray7[14] = 20;
        byArray7[15] = 20;
        byArray7[16] = 20;
        byArrayArray[6] = byArray7;
        byte[] byArray8 = new byte[17];
        byArray8[1] = 1;
        byArray8[2] = 6;
        byArray8[3] = 3;
        byArray8[4] = 6;
        byArray8[5] = 5;
        byArray8[6] = 6;
        byArray8[7] = 6;
        byArray8[8] = 6;
        byArray8[9] = 6;
        byArray8[10] = 6;
        byArray8[11] = 6;
        byArray8[12] = 6;
        byArray8[13] = 6;
        byArray8[14] = 6;
        byArray8[15] = 6;
        byArray8[16] = 6;
        byArrayArray[7] = byArray8;
        byte[] byArray9 = new byte[17];
        byArray9[1] = 1;
        byArray9[2] = 20;
        byArray9[3] = 3;
        byArray9[4] = 20;
        byArray9[5] = 23;
        byArray9[6] = 20;
        byArray9[7] = 20;
        byArray9[8] = 20;
        byArray9[9] = 20;
        byArray9[10] = 20;
        byArray9[11] = 20;
        byArray9[12] = 20;
        byArray9[13] = 20;
        byArray9[14] = 20;
        byArray9[15] = 20;
        byArray9[16] = 20;
        byArrayArray[8] = byArray9;
        byte[] byArray10 = new byte[17];
        byArray10[1] = 1;
        byArray10[2] = 23;
        byArray10[3] = 3;
        byArray10[4] = 23;
        byArray10[5] = 5;
        byArray10[6] = 23;
        byArray10[7] = 23;
        byArray10[8] = 23;
        byArray10[9] = 20;
        byArray10[10] = 20;
        byArray10[11] = 23;
        byArray10[12] = 18;
        byArray10[13] = 23;
        byArray10[14] = 16;
        byArray10[15] = 23;
        byArray10[16] = 18;
        byArrayArray[9] = byArray10;
        byte[] byArray11 = new byte[17];
        byArray11[1] = 1;
        byArray11[2] = 23;
        byArray11[3] = 3;
        byArray11[4] = 23;
        byArray11[5] = 5;
        byArray11[6] = 23;
        byArray11[7] = 23;
        byArray11[8] = 23;
        byArray11[9] = 20;
        byArray11[10] = 20;
        byArray11[11] = 17;
        byArray11[12] = 23;
        byArray11[13] = 15;
        byArray11[14] = 23;
        byArray11[15] = 17;
        byArray11[16] = 23;
        byArrayArray[10] = byArray11;
        byte[] byArray12 = new byte[17];
        byArray12[1] = 1;
        byArray12[2] = 14;
        byArray12[3] = 3;
        byArray12[4] = 14;
        byArray12[5] = 5;
        byArray12[6] = 14;
        byArray12[7] = 14;
        byArray12[8] = 14;
        byArray12[9] = 20;
        byArray12[10] = 20;
        byArray12[11] = 14;
        byArray12[12] = 18;
        byArray12[13] = 14;
        byArray12[14] = 16;
        byArray12[15] = 14;
        byArray12[16] = 18;
        byArrayArray[11] = byArray12;
        byte[] byArray13 = new byte[17];
        byArray13[1] = 1;
        byArray13[2] = 13;
        byArray13[3] = 3;
        byArray13[4] = 13;
        byArray13[5] = 5;
        byArray13[6] = 13;
        byArray13[7] = 13;
        byArray13[8] = 13;
        byArray13[9] = 20;
        byArray13[10] = 20;
        byArray13[11] = 17;
        byArray13[12] = 13;
        byArray13[13] = 15;
        byArray13[14] = 13;
        byArray13[15] = 17;
        byArray13[16] = 13;
        byArrayArray[12] = byArray13;
        byte[] byArray14 = new byte[17];
        byArray14[1] = 1;
        byArray14[2] = 11;
        byArray14[3] = 3;
        byArray14[4] = 23;
        byArray14[5] = 5;
        byArray14[6] = 11;
        byArray14[7] = 20;
        byArray14[8] = 20;
        byArray14[9] = 20;
        byArray14[10] = 11;
        byArray14[11] = 20;
        byArray14[12] = 20;
        byArray14[13] = 11;
        byArray14[14] = 11;
        byArray14[15] = 11;
        byArray14[16] = 11;
        byArrayArray[13] = byArray14;
        byte[] byArray15 = new byte[17];
        byArray15[1] = 1;
        byArray15[2] = 12;
        byArray15[3] = 3;
        byArray15[4] = 23;
        byArray15[5] = 5;
        byArray15[6] = 12;
        byArray15[7] = 20;
        byArray15[8] = 20;
        byArray15[9] = 12;
        byArray15[10] = 20;
        byArray15[11] = 20;
        byArray15[12] = 20;
        byArray15[13] = 12;
        byArray15[14] = 12;
        byArray15[15] = 12;
        byArray15[16] = 12;
        byArrayArray[14] = byArray15;
        byte[] byArray16 = new byte[17];
        byArray16[1] = 1;
        byArray16[2] = 20;
        byArray16[3] = 3;
        byArray16[4] = 20;
        byArray16[5] = 5;
        byArray16[6] = 20;
        byArray16[7] = 7;
        byArray16[8] = 20;
        byArray16[9] = 9;
        byArray16[10] = 20;
        byArray16[11] = 13;
        byArray16[12] = 18;
        byArray16[13] = 21;
        byArray16[14] = 21;
        byArray16[15] = 21;
        byArray16[16] = 21;
        byArrayArray[15] = byArray16;
        byte[] byArray17 = new byte[17];
        byArray17[1] = 1;
        byArray17[2] = 20;
        byArray17[3] = 3;
        byArray17[4] = 20;
        byArray17[5] = 5;
        byArray17[6] = 20;
        byArray17[7] = 20;
        byArray17[8] = 8;
        byArray17[9] = 20;
        byArray17[10] = 10;
        byArray17[11] = 17;
        byArray17[12] = 14;
        byArray17[13] = 21;
        byArray17[14] = 21;
        byArray17[15] = 21;
        byArray17[16] = 21;
        byArrayArray[16] = byArray17;
        byte[] byArray18 = new byte[17];
        byArray18[1] = 1;
        byArray18[2] = 20;
        byArray18[3] = 3;
        byArray18[4] = 20;
        byArray18[5] = 5;
        byArray18[6] = 20;
        byArray18[7] = 7;
        byArray18[8] = 20;
        byArray18[9] = 9;
        byArray18[10] = 20;
        byArray18[11] = 13;
        byArray18[12] = 18;
        byArray18[13] = 21;
        byArray18[14] = 21;
        byArray18[15] = 21;
        byArray18[16] = 21;
        byArrayArray[17] = byArray18;
        byte[] byArray19 = new byte[17];
        byArray19[1] = 1;
        byArray19[2] = 20;
        byArray19[3] = 3;
        byArray19[4] = 20;
        byArray19[5] = 5;
        byArray19[6] = 20;
        byArray19[7] = 20;
        byArray19[8] = 8;
        byArray19[9] = 20;
        byArray19[10] = 10;
        byArray19[11] = 17;
        byArray19[12] = 14;
        byArray19[13] = 21;
        byArray19[14] = 21;
        byArray19[15] = 21;
        byArray19[16] = 21;
        byArrayArray[18] = byArray19;
        byte[] byArray20 = new byte[17];
        byArray20[1] = 1;
        byArray20[2] = 19;
        byArray20[3] = 3;
        byArray20[4] = 19;
        byArray20[5] = 5;
        byArray20[6] = 19;
        byArray20[7] = 19;
        byArray20[8] = 19;
        byArray20[9] = 19;
        byArray20[10] = 19;
        byArray20[11] = 15;
        byArray20[12] = 16;
        byArray20[13] = 15;
        byArray20[14] = 16;
        byArray20[15] = 15;
        byArray20[16] = 16;
        byArrayArray[19] = byArray20;
        byte[] byArray21 = new byte[17];
        byArray21[1] = 1;
        byArray21[2] = 2;
        byArray21[3] = 3;
        byArray21[4] = 4;
        byArray21[5] = 5;
        byArray21[6] = 6;
        byArray21[7] = 20;
        byArray21[8] = 20;
        byArray21[9] = 20;
        byArray21[10] = 20;
        byArray21[11] = 17;
        byArray21[12] = 18;
        byArray21[13] = 17;
        byArray21[14] = 18;
        byArray21[15] = 17;
        byArray21[16] = 18;
        byArrayArray[20] = byArray21;
        byte[] byArray22 = new byte[17];
        byArray22[1] = 1;
        byArray22[2] = 20;
        byArray22[3] = 3;
        byArray22[4] = 20;
        byArray22[5] = 5;
        byArray22[6] = 20;
        byArray22[7] = 20;
        byArray22[8] = 20;
        byArray22[9] = 20;
        byArray22[10] = 20;
        byArray22[11] = 17;
        byArray22[12] = 18;
        byArray22[13] = 17;
        byArray22[14] = 18;
        byArray22[15] = 17;
        byArray22[16] = 18;
        byArrayArray[21] = byArray22;
        this.State_Event = byArrayArray;
        this.m_rReceptionTimerT1 = null;
        this.m_rReceptionTimerT2 = null;
        this.m_bReceptionTimoutT1 = false;
        this.m_bReceptionTimoutT2 = false;
        this.Init_StateEvent();
    }

    void BuildAns() {
        if (this.StateEvent.ProtState == 1) {
            this.StateEvent.ProtState = 1;
        }
        this.StateEvent.ProtState = 1;
        if (this.GblPar.ReceiveSize != 0) {
            this.GblPar.ReceiveSize = (short)(this.GblPar.ReceiveSize - (short)(3 + this.GblPar.Edc + 1));
            int n = 3;
            while (n < this.GblPar.ReceiveSize + 3) {
                this.GblPar.ReceiveData[n - 3] = this.GblPar.ReceiveData[n];
                n = (short)(n + 1);
            }
        }
    }

    void BuildCmd() {
        this.StateEvent.ChainingSize = 0;
        if (this.GblPar.CmdSize > ((short)this.GblPar.IfsCard & 0xFF)) {
            this.StateEvent.Chaining = 1;
        }
        if (this.StateEvent.ProtState == 0 && this.GblPar.IfsEnable != 0) {
            this.S_IFS_Request();
        } else if (this.StateEvent.SeqNum_SD == 0) {
            if (this.StateEvent.Chaining == 1) {
                this.I_Block_N0_Chain();
            } else {
                this.I_Block_N0();
            }
        } else if (this.StateEvent.Chaining == 1) {
            this.I_Block_N1_Chain();
        } else {
            this.I_Block_N1();
        }
    }

    private void CLFillAnsBufT1(Buffer buffer, Drive drive) {
        buffer.setData(this.GblPar.pAnswer);
        buffer.setLength(this.GblPar.AnsSize);
        this.GblPar.AnsSize = 0;
    }

    void CL_ExchangeTPDU(Drive drive) throws CommunicationException, CardException, TimeOutException {
        Buffer buffer = new Buffer(262);
        Buffer buffer2 = new Buffer(this.GblPar.SendSize);
        buffer2.setData(this.GblPar.SendData, this.GblPar.SendSize);
        drive.sendBlock(buffer2);
        this.GblPar.ReceiveSize = 0;
        int n = 3;
        buffer2 = new Buffer(n);
        drive.receiveBlock(buffer2);
        buffer.appendBytes(n, buffer2.getData());
        n = 1 + this.GblPar.Edc + (buffer.getByte(2) & 0xFF);
        buffer2 = new Buffer(n);
        drive.receiveBlock(buffer2);
        buffer.appendBytes(n, buffer2.getData());
        buffer.setCapacity(buffer.getLength());
        this.GblPar.ReceiveSize = (short)buffer.getLength();
        n = 0;
        while (n < this.GblPar.ReceiveSize) {
            this.GblPar.ReceiveData[n] = buffer.getByte(n);
            ++n;
        }
    }

    short CheckEDC() {
        short s = 0;
        int n = 0;
        byte by = 0;
        short s2 = 0;
        short s3 = 0;
        if (this.GblPar.Edc == 0) {
            s2 = 0;
            while (s2 < this.GblPar.ReceiveSize) {
                by = (byte)(by ^ this.GblPar.ReceiveData[s2]);
                s2 = (short)(s2 + 1);
            }
            s3 = by;
        } else {
            n = 0;
            s = (byte)((n & 0xFF00) >> 8);
            s = (short)(s + (byte)(n & 0xFF));
            s3 = by;
        }
        return s3;
    }

    byte Check_Tpdu(byte by, byte by2, short s, byte[] byArray) {
        short s2 = 0;
        if (s > ((short)this.GblPar.IfsCard & 0xFF)) {
            return 21;
        }
        if ((by & 0xFFFFFF88) != 0 || (by & 0xF) == by >> 4 && by != 0) {
            return 21;
        }
        if ((by2 == -128 || by2 == -127 || by2 == -126 || by2 == -112 || by2 == -111 || by2 == -110) && s != 0) {
            return 21;
        }
        if ((by2 == -31 || by2 == -63 || by2 == -29 || by2 == -61) && s != 1) {
            return 21;
        }
        if (this.GblPar.Edc == 0) {
            s2 = this.CheckEDC();
        }
        if (this.GblPar.ReceiveSize == 0 || s2 != 0) {
            return 19;
        }
        if (this.GblPar.ReceiveSize < (byte)(s + 3 + this.GblPar.Edc + 1)) {
            return 20;
        }
        return 0;
    }

    byte Deactivate_Contact(Drive drive) throws CommunicationException, CardException, TimeOutException {
        try {
            drive.setParameter((byte)22, 1L);
        }
        catch (BadParameterException badParameterException) {
            throw new CommunicationException();
        }
        catch (BadParameterValueException badParameterValueException) {
            throw new CommunicationException();
        }
        throw new CardException("ERR_PROTOCOL");
    }

    void EDCCompute() {
        this.GblPar.SendData[this.GblPar.SendSize] = 0;
        if (this.GblPar.Edc == 0) {
            short s = 0;
            while (s < this.GblPar.SendSize) {
                this.GblPar.SendData[this.GblPar.SendSize] = (byte)(this.GblPar.SendData[this.GblPar.SendSize] ^ this.GblPar.SendData[s]);
                s = (short)(s + 1);
            }
        } else {
            int n = 0;
            this.GblPar.SendData[this.GblPar.SendSize] = (byte)((n & 0xFF00) >> 8);
            this.GblPar.SendData[this.GblPar.SendSize + 1] = (byte)(n & 0xFF);
        }
        this.GblPar.SendSize = (short)(this.GblPar.SendSize + (short)(this.GblPar.Edc + 1));
    }

    byte Event_Func(byte by, Drive drive) throws CommunicationException, CardException, TimeOutException {
        byte by2 = 1;
        switch (by) {
            case 22: {
                by = this.State_Event[this.StateEvent.PrevCmds.State][this.StateEvent.PrevCmds.Event];
                break;
            }
            case 0: {
                by2 = this.S_Resynch_Request(drive);
                break;
            }
            case 1: {
                by2 = this.S_IFS_Request();
                break;
            }
            case 2: {
                by2 = this.S_IFS_Response();
                break;
            }
            case 3: {
                by2 = this.S_Abort_Request();
                break;
            }
            case 4: {
                by2 = this.S_Abort_Response();
                break;
            }
            case 5: {
                by2 = this.S_WTX_Request();
                break;
            }
            case 6: {
                by2 = this.S_WTX_Response(drive);
                break;
            }
            case 7: {
                by2 = this.I_Block_N0();
                break;
            }
            case 9: {
                by2 = this.I_Block_N0_Chain();
                break;
            }
            case 8: {
                by2 = this.I_Block_N1();
                break;
            }
            case 10: {
                by2 = this.I_Block_N1_Chain();
                break;
            }
            case 11: {
                by2 = this.I_Block_N0_X();
                break;
            }
            case 12: {
                by2 = this.I_Block_N1_X();
                break;
            }
            case 13: {
                by2 = this.R_Block_Err_Free_N0();
                break;
            }
            case 14: {
                by2 = this.R_Block_Err_Free_N1();
                break;
            }
            case 15: {
                by2 = this.R_Block_Edc_Parite_N0();
                break;
            }
            case 16: {
                by2 = this.R_Block_Edc_Parite_N1();
                break;
            }
            case 17: {
                by2 = this.R_Block_Other_Err_N0();
                break;
            }
            case 18: {
                by2 = this.R_Block_Other_Err_N1();
                break;
            }
            case 19: {
                by2 = this.R_Block_Edc_Parite();
                break;
            }
            case 20: {
                by2 = this.R_Block_Other_Err();
                break;
            }
            case 21: {
                by2 = this.R_Block_Error();
                break;
            }
            case 23: {
                by2 = this.ExitMgr();
                break;
            }
            case 24: {
                this.Deactivate_Contact(drive);
                break;
            }
            case 25: {
                by2 = 0;
                break;
            }
            default: {
                by2 = 0;
            }
        }
        return by2;
    }

    byte ExitMgr() {
        return 0;
    }

    void FillAnsBuf() {
        if (this.GblPar.ReceiveSize != 0) {
            int n = this.GblPar.AnsSize + this.GblPar.ReceiveSize;
            Buffer buffer = new Buffer(n);
            if (this.GblPar.AnsSize != 0) {
                buffer.appendBytes(this.GblPar.AnsSize, this.GblPar.pAnswer);
            }
            buffer.setCapacity(n);
            buffer.appendBytes(this.GblPar.ReceiveSize, this.GblPar.ReceiveData);
            this.GblPar.pAnswer = buffer.getData();
            this.GblPar.AnsSize = n;
        }
    }

    byte I_Block_N0() {
        this.GblPar.SendSize = this.GblPar.CmdSize;
        this.GblPar.SendData[0] = this.GblPar.Nad;
        this.GblPar.SendData[1] = 0;
        if (this.StateEvent.PrevCmds.Action != 7) {
            this.StateEvent.SeqNum_SD = this.StateEvent.SeqNum_SD == 0 ? (byte)1 : 0;
        }
        this.GblPar.SendData[2] = (byte)(this.GblPar.SendSize - this.StateEvent.ChainingSize);
        int n = 0;
        while (n < this.GblPar.SendSize - this.StateEvent.ChainingSize) {
            this.GblPar.SendData[n + 3] = this.GblPar.pCommand[n + this.StateEvent.ChainingSize];
            ++n;
        }
        this.GblPar.SendSize = (short)(this.GblPar.SendSize - this.StateEvent.ChainingSize + 3);
        this.EDCCompute();
        this.StateEvent.Action = (byte)7;
        this.UpdateRetries();
        return 1;
    }

    byte I_Block_N0_Chain() {
        this.GblPar.SendData[0] = this.GblPar.Nad;
        this.GblPar.SendData[1] = 32;
        this.GblPar.SendData[2] = this.GblPar.IfsCard;
        if (this.GblPar.Back == 1 || this.StateEvent.PrevCmds.Action == 9) {
            this.StateEvent.ChainingSize -= this.GblPar.IfsCard;
        } else {
            this.StateEvent.SeqNum_SD = this.StateEvent.SeqNum_SD == 0 ? (byte)1 : 0;
        }
        int n = 0;
        while (n < this.GblPar.IfsCard) {
            this.GblPar.SendData[n + 3] = this.GblPar.pCommand[n + this.StateEvent.ChainingSize];
            ++n;
        }
        this.GblPar.SendSize = (short)(this.GblPar.IfsCard + 3);
        this.EDCCompute();
        this.StateEvent.ChainingSize += this.GblPar.IfsCard;
        if (this.GblPar.CmdSize - this.StateEvent.ChainingSize <= this.GblPar.IfsCard) {
            this.StateEvent.Chaining = 0;
        }
        this.StateEvent.Action = (byte)9;
        this.UpdateRetries();
        return 1;
    }

    byte I_Block_N0_X() {
        if (this.StateEvent.Chaining == 0) {
            this.I_Block_N0();
        } else {
            this.I_Block_N0_Chain();
        }
        return 1;
    }

    byte I_Block_N1() {
        this.GblPar.SendSize = this.GblPar.CmdSize;
        this.GblPar.SendData[0] = this.GblPar.Nad;
        this.GblPar.SendData[1] = 64;
        this.GblPar.SendData[2] = (byte)(this.GblPar.SendSize - this.StateEvent.ChainingSize);
        if (this.StateEvent.PrevCmds.Action != 8) {
            this.StateEvent.SeqNum_SD = this.StateEvent.SeqNum_SD == 0 ? (byte)1 : 0;
        }
        int n = 0;
        while (n < this.GblPar.SendSize - this.StateEvent.ChainingSize) {
            this.GblPar.SendData[n + 3] = this.GblPar.pCommand[n + this.StateEvent.ChainingSize];
            ++n;
        }
        this.GblPar.SendSize = (short)(this.GblPar.SendSize - this.StateEvent.ChainingSize + 3);
        this.EDCCompute();
        this.StateEvent.Action = (byte)8;
        this.UpdateRetries();
        return 1;
    }

    byte I_Block_N1_Chain() {
        this.GblPar.SendData[0] = this.GblPar.Nad;
        this.GblPar.SendData[1] = 96;
        this.GblPar.SendData[2] = this.GblPar.IfsCard;
        if (this.GblPar.Back == 1 || this.StateEvent.PrevCmds.Action == 10) {
            this.StateEvent.ChainingSize -= this.GblPar.IfsCard;
        } else {
            this.StateEvent.SeqNum_SD = this.StateEvent.SeqNum_SD == 0 ? (byte)1 : 0;
        }
        int n = 0;
        while (n < this.GblPar.IfsCard) {
            this.GblPar.SendData[n + 3] = this.GblPar.pCommand[n + this.StateEvent.ChainingSize];
            ++n;
        }
        this.GblPar.SendSize = (short)(this.GblPar.IfsCard + 3);
        this.EDCCompute();
        this.StateEvent.ChainingSize += this.GblPar.IfsCard;
        if (this.GblPar.CmdSize - this.StateEvent.ChainingSize <= this.GblPar.IfsCard) {
            this.StateEvent.Chaining = 0;
        }
        this.StateEvent.Action = (byte)10;
        this.UpdateRetries();
        return 1;
    }

    byte I_Block_N1_X() {
        if (this.StateEvent.Chaining == 0) {
            this.I_Block_N1();
        } else {
            this.I_Block_N1_Chain();
        }
        return 1;
    }

    void Init_StateEvent() {
        this.StateEvent = new STATE_EVENT();
        this.GblPar = new GLOBAL_PAR();
        this.StateEvent.Event = 0;
        this.StateEvent.State = 0;
        this.StateEvent.Action = 0;
        this.StateEvent.Retries = 1;
        this.StateEvent.SeqNum_SC = 0;
        this.StateEvent.SeqNum_SD = 0;
        this.StateEvent.SeqNum_R = 0;
        this.StateEvent.Chaining = 0;
        this.StateEvent.ChainingSize = 0;
        this.StateEvent.ProtState = 0;
        this.GblPar.pAnswer = new byte[262];
        this.GblPar.SendData = new byte[262];
        this.GblPar.ReceiveData = new byte[262];
        this.GblPar.ReceiveSize = 0;
        this.GblPar.SendSize = 0;
        this.GblPar.AnsSize = 0;
        this.GblPar.CmdSize = 0;
    }

    byte R_Block_Edc_Parite() {
        byte by = 1;
        if (this.StateEvent.SeqNum_SC == 0) {
            this.R_Block_Edc_Parite_N0();
        } else {
            this.R_Block_Edc_Parite_N1();
        }
        return by;
    }

    byte R_Block_Edc_Parite_N0() {
        byte by = 1;
        this.GblPar.SendData[0] = this.GblPar.Nad;
        this.GblPar.SendData[1] = -127;
        this.GblPar.SendData[2] = 0;
        this.GblPar.SendSize = (short)3;
        this.EDCCompute();
        this.StateEvent.SeqNum_R = 0;
        this.StateEvent.Action = (byte)13;
        this.UpdateRetries();
        return by;
    }

    byte R_Block_Edc_Parite_N1() {
        byte by = 1;
        this.GblPar.SendData[0] = this.GblPar.Nad;
        this.GblPar.SendData[1] = -111;
        this.GblPar.SendData[2] = 0;
        this.GblPar.SendSize = (short)3;
        this.EDCCompute();
        this.StateEvent.SeqNum_R = 1;
        this.StateEvent.Action = (byte)14;
        this.UpdateRetries();
        return by;
    }

    byte R_Block_Err_Free_N0() {
        byte by = 1;
        this.GblPar.SendData[0] = this.GblPar.Nad;
        this.GblPar.SendData[1] = -128;
        this.GblPar.SendData[2] = 0;
        this.GblPar.SendSize = (short)3;
        this.EDCCompute();
        this.StateEvent.SeqNum_R = 0;
        this.StateEvent.Action = (byte)11;
        this.UpdateRetries();
        return by;
    }

    byte R_Block_Err_Free_N1() {
        byte by = 1;
        this.GblPar.SendData[0] = this.GblPar.Nad;
        this.GblPar.SendData[1] = -112;
        this.GblPar.SendData[2] = 0;
        this.GblPar.SendSize = (short)3;
        this.EDCCompute();
        this.StateEvent.SeqNum_R = 1;
        this.StateEvent.Action = (byte)12;
        this.UpdateRetries();
        return by;
    }

    byte R_Block_Error() {
        if (this.StateEvent.SeqNum_SD == 1) {
            if (this.StateEvent.PrevCmds.Action == 9 && (this.StateEvent.State == 16 || this.StateEvent.State == 18)) {
                return this.I_Block_N1_X();
            }
            if (this.StateEvent.State == 15 || this.StateEvent.State == 17) {
                this.GblPar.Back = 1;
                if (this.StateEvent.PrevCmds.Pcb == 0) {
                    this.I_Block_N0();
                } else {
                    this.I_Block_N0_Chain();
                }
                return 1;
            }
        }
        if (this.StateEvent.SeqNum_SD == 0) {
            if (this.StateEvent.PrevCmds.Action == 10 && (this.StateEvent.State == 15 || this.StateEvent.State == 17)) {
                return this.I_Block_N0_X();
            }
            if (this.StateEvent.State == 16 || this.StateEvent.State == 18) {
                this.GblPar.Back = 1;
                if (this.StateEvent.PrevCmds.Pcb == 64) {
                    this.I_Block_N1();
                } else {
                    this.I_Block_N1_Chain();
                }
                return 1;
            }
        }
        switch (this.StateEvent.Event) {
            case 13: 
            case 15: {
                this.R_Block_Other_Err_N0();
                break;
            }
            case 14: 
            case 16: {
                this.R_Block_Other_Err_N1();
                break;
            }
        }
        return 1;
    }

    byte R_Block_Other_Err() {
        byte by = 1;
        if (this.StateEvent.SeqNum_SC == 0) {
            this.R_Block_Other_Err_N0();
        } else {
            this.R_Block_Other_Err_N1();
        }
        return by;
    }

    byte R_Block_Other_Err_N0() {
        byte by = 1;
        this.GblPar.SendData[0] = this.GblPar.Nad;
        this.GblPar.SendData[1] = -126;
        this.GblPar.SendData[2] = 0;
        this.GblPar.SendSize = (short)3;
        this.EDCCompute();
        this.StateEvent.SeqNum_R = 0;
        this.StateEvent.Action = (byte)15;
        this.UpdateRetries();
        return by;
    }

    byte R_Block_Other_Err_N1() {
        byte by = 1;
        this.GblPar.SendData[0] = this.GblPar.Nad;
        this.GblPar.SendData[1] = -110;
        this.GblPar.SendData[2] = 0;
        this.GblPar.SendSize = (short)3;
        this.EDCCompute();
        this.StateEvent.SeqNum_R = 1;
        this.StateEvent.Action = (byte)16;
        this.UpdateRetries();
        return by;
    }

    byte ResendCmd() throws CommunicationException, CardException, TimeOutException {
        byte by = 1;
        return by;
    }

    byte S_Abort_Request() {
        byte by = 1;
        this.GblPar.SendData[0] = this.GblPar.Nad;
        this.GblPar.SendData[1] = -62;
        this.GblPar.SendData[2] = 0;
        this.GblPar.SendSize = (short)3;
        this.EDCCompute();
        this.StateEvent.Action = (byte)3;
        this.UpdateRetries();
        return by;
    }

    byte S_Abort_Response() {
        byte by = 1;
        this.GblPar.SendData[0] = this.GblPar.Nad;
        this.GblPar.SendData[1] = -30;
        this.GblPar.SendData[2] = 0;
        this.GblPar.SendSize = (short)3;
        this.EDCCompute();
        this.StateEvent.Action = (byte)4;
        this.UpdateRetries();
        return by;
    }

    byte S_IFS_Request() {
        byte by = 1;
        this.GblPar.SendData[0] = this.GblPar.Nad;
        this.GblPar.SendData[1] = -63;
        this.GblPar.SendData[2] = 1;
        this.GblPar.SendData[3] = this.GblPar.Ifsd;
        this.GblPar.SendSize = (short)4;
        this.EDCCompute();
        this.StateEvent.Action = 1;
        this.UpdateRetries();
        return by;
    }

    byte S_IFS_Response() {
        byte by = 1;
        this.GblPar.IfsCard = this.GblPar.ReceiveData[3];
        this.m_rSession.getParameters().CLP_Ifsc = this.GblPar.ReceiveData[3];
        this.GblPar.SendData[0] = this.GblPar.Nad;
        this.GblPar.SendData[1] = -31;
        this.GblPar.SendData[2] = 1;
        this.GblPar.SendData[3] = this.GblPar.ReceiveData[3];
        this.GblPar.SendSize = (short)4;
        this.EDCCompute();
        this.StateEvent.Action = (byte)2;
        this.UpdateRetries();
        return by;
    }

    byte S_Resynch_Request(Drive drive) throws CommunicationException, CardException, TimeOutException {
        byte by = 1;
        if (this.StateEvent.ProtState == 0 && this.StateEvent.Retries == 2) {
            this.Deactivate_Contact(drive);
            return 0;
        }
        this.GblPar.SendData[0] = this.GblPar.Nad;
        this.GblPar.SendData[1] = -64;
        this.GblPar.SendData[2] = 0;
        this.GblPar.SendSize = (short)3;
        this.EDCCompute();
        this.StateEvent.Action = 0;
        this.UpdateRetries();
        return by;
    }

    byte S_WTX_Request() {
        byte by = 1;
        this.GblPar.SendData[0] = this.GblPar.Nad;
        this.GblPar.SendData[1] = -61;
        this.GblPar.SendData[2] = 1;
        this.GblPar.SendData[3] = this.GblPar.Wtx;
        this.GblPar.SendSize = (short)4;
        this.EDCCompute();
        this.StateEvent.Action = (byte)5;
        this.UpdateRetries();
        return by;
    }

    byte S_WTX_Response(Drive drive) throws CommunicationException, CardException, TimeOutException {
        byte by = 1;
        this.GblPar.Wtx = this.GblPar.ReceiveData[3];
        this.WTX_Compute(drive, this.GblPar.Wtx);
        this.GblPar.SendData[0] = this.GblPar.Nad;
        this.GblPar.SendData[1] = -29;
        this.GblPar.SendData[2] = 1;
        this.GblPar.SendData[3] = this.GblPar.Wtx;
        this.GblPar.SendSize = (short)4;
        this.EDCCompute();
        this.StateEvent.Action = (byte)6;
        this.UpdateRetries();
        return by;
    }

    /*
     * Unable to fully structure code
     */
    byte StateEventMgr(Drive var1_1) throws CommunicationException, CardException, TimeOutException {
        block22: {
            var2_2 = 1;
            var3_3 = this.GblPar.ReceiveData[0];
            var4_4 = this.GblPar.ReceiveData[1];
            var5_5 = this.GblPar.ReceiveData[2];
            if (var5_5 != 255) {
                this.StateEvent.State = this.Check_Tpdu(var3_3, var4_4, var5_5, this.GblPar.ReceiveData);
            }
            if (this.StateEvent.State != 0) ** GOTO lbl54
            var6_6 = 0;
            while (var6_6 < 17) {
                block23: {
                    if (this.Pcb_State[var6_6] != var4_4) break block23;
                    this.StateEvent.State = (byte)(var6_6 + 2);
                    switch (this.StateEvent.State) {
                        case 8: {
                            if (this.GblPar.ReceiveData[3] == this.GblPar.Wtx) ** GOTO lbl54
                            this.StateEvent.State = 0;
                            ** GOTO lbl54
                        }
                        case 4: {
                            if (this.GblPar.ReceiveData[3] == this.GblPar.Ifsd) ** GOTO lbl54
                            this.StateEvent.State = 0;
                            ** GOTO lbl54
                        }
                        case 11: {
                            if (this.StateEvent.SeqNum_SC == 1) {
                                this.StateEvent.State = 0;
                            } else {
                                this.StateEvent.SeqNum_SC = 1;
                            }
                            this.BuildAns();
                            this.FillAnsBuf();
                            ** GOTO lbl54
                        }
                        case 12: {
                            if (this.StateEvent.SeqNum_SC == 0) {
                                this.StateEvent.State = 0;
                            } else {
                                this.StateEvent.SeqNum_SC = 0;
                            }
                            this.BuildAns();
                            this.FillAnsBuf();
                            ** GOTO lbl54
                        }
                        case 9: {
                            if (this.StateEvent.SeqNum_SC == 1) {
                                this.StateEvent.State = 0;
                            } else {
                                this.StateEvent.SeqNum_SC = 1;
                            }
                            ** GOTO lbl54
                        }
                        case 10: {
                            if (this.StateEvent.SeqNum_SC == 0) {
                                this.StateEvent.State = 0;
                            } else {
                                this.StateEvent.SeqNum_SC = 0;
                            }
                            ** GOTO lbl54
                        }
                        default: {
                            if (this.StateEvent.State != 0) break block22;
                        }
                    }
                }
                var6_6 = (short)(var6_6 + 1);
            }
lbl54:
            // 12 sources

            if (this.StateEvent.State != 0) break block22;
            this.StateEvent.State = (byte)21;
        }
        if (this.StateEvent.State > 14 && this.StateEvent.Retries == 2) {
            this.StateEvent.State = 0;
        }
        if (this.StateEvent.State > 14 && this.StateEvent.Retries == 3) {
            this.StateEvent.State = 1;
        }
        this.Action = this.State_Event[this.StateEvent.State][this.StateEvent.Event];
        var2_2 = this.Event_Func(this.Action, var1_1);
        return var2_2;
    }

    void StorePrevCmd(Drive drive) throws CommunicationException, CardException, TimeOutException {
        if (this.StateEvent.Event == 6) {
            this.WTX_Restore(drive);
        }
        if ((this.GblPar.SendData[1] & 0xFFFFFF9F) == 0) {
            this.StateEvent.PrevCmds.Nad = this.GblPar.SendData[0];
            this.StateEvent.PrevCmds.Pcb = this.GblPar.SendData[1];
            this.StateEvent.PrevCmds.Len = this.GblPar.SendData[2];
            this.StateEvent.PrevCmds.Func = this.Action;
            this.StateEvent.PrevCmds.Event = this.StateEvent.Event;
            this.StateEvent.PrevCmds.State = this.StateEvent.State;
            this.StateEvent.PrevCmds.Action = this.StateEvent.Action;
        }
        this.StateEvent.Event = this.StateEvent.Action;
        this.StateEvent.State = 0;
        this.StateEvent.Action = 0;
    }

    void T1Manager(Drive drive) throws CommunicationException, CardException, TimeOutException {
        byte by = 1;
        this.BuildCmd();
        do {
            this.StorePrevCmd(drive);
            this.CL_ExchangeTPDU(drive);
        } while ((by = this.StateEventMgr(drive)) == 1);
        this.BuildAns();
        this.FillAnsBuf();
    }

    void UpdateRetries() {
        this.StateEvent.Retries = this.StateEvent.Event == this.StateEvent.Action || this.StateEvent.Event >= 11 && this.StateEvent.Action >= 11 ? (byte)(this.StateEvent.Retries + 1) : (byte)1;
    }

    void WTX_Compute(Drive drive, byte by) throws CommunicationException, CardException, TimeOutException {
        try {
            long l = this.m_rSession.getParameters().CLP_Bwt / 3580L;
            if (l < 2048L) {
                l = 2048L;
            }
            drive.setParameter((byte)15, l *= (long)(3 + by));
        }
        catch (BadParameterException badParameterException) {
            System.out.println(badParameterException.toString());
            throw new CommunicationException();
        }
        catch (BadParameterValueException badParameterValueException) {
            System.out.println(badParameterValueException.toString());
            throw new CommunicationException();
        }
    }

    void WTX_Restore(Drive drive) throws CommunicationException, CardException, TimeOutException {
        try {
            long l = this.m_rSession.getParameters().CLP_Bwt / 3580L;
            if (l < 2048L) {
                l = 2048L;
            }
            drive.setParameter((byte)15, l *= 3L);
        }
        catch (BadParameterException badParameterException) {
            System.out.println(badParameterException.toString());
            throw new CommunicationException();
        }
        catch (BadParameterValueException badParameterValueException) {
            System.out.println(badParameterValueException.toString());
            throw new CommunicationException();
        }
    }

    void cardExchange(Buffer buffer, Buffer buffer2, Drive drive) throws CommunicationException, CardException, TimeOutException {
        if (this.m_rSession.getParameters().Just_Atr == 1) {
            this.m_rSession.getParameters().Just_Atr = 0;
            this.GblPar.Edc = !this.m_rSession.getParameters().CLP_Edc ? (byte)0 : 1;
            this.GblPar.Nad = this.m_rSession.getParameters().CLP_Nad;
            this.GblPar.IfsCard = (byte)this.m_rSession.getParameters().CLP_Ifsc;
            this.GblPar.Ifsd = (byte)this.m_rSession.getParameters().CLP_Ifsd;
            this.GblPar.IfsEnable = !this.m_rSession.getParameters().CLP_Ifse ? (byte)0 : 1;
            this.GblPar.Wtx = this.m_rSession.getParameters().CLP_Wtx;
            this.GblPar.Back = 0;
            try {
                drive.setParameter((byte)17, this.m_rSession.getParameters().CLP_ETULength);
                drive.setParameter((byte)2, this.m_rSession.getParameters().CLP_Cgt);
                long l = this.m_rSession.getParameters().CLP_Bwt / 3580L;
                if (l < 2048L) {
                    l = 2048L;
                }
                drive.setParameter((byte)15, l *= 3L);
            }
            catch (BadParameterException badParameterException) {
                throw new CommunicationException();
            }
            catch (BadParameterValueException badParameterValueException) {
                throw new CommunicationException();
            }
        }
        this.GblPar.CmdSize = (short)buffer.getLength();
        this.GblPar.pCommand = new byte[this.GblPar.CmdSize];
        this.GblPar.pCommand = buffer.getData();
        this.T1Manager(drive);
        this.CLFillAnsBufT1(buffer2, drive);
    }
}

