/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.security;

import java.util.Enumeration;
import java.util.Hashtable;
import opencard.core.terminal.CardID;
import opencard.opt.security.Credential;

public abstract class CredentialStore {
    private Hashtable credentialTable = new Hashtable();

    protected CredentialStore() {
    }

    protected final Credential fetchCredential(Object object) {
        return (Credential)this.credentialTable.get(object);
    }

    protected final Enumeration getCredentialIDs() {
        return this.credentialTable.keys();
    }

    public static CredentialStore getInstance(String string) {
        CredentialStore credentialStore = null;
        try {
            Class<?> clazz = Class.forName(string);
            credentialStore = (CredentialStore)clazz.newInstance();
        }
        catch (Exception exception) {}
        return credentialStore;
    }

    protected final void storeCredential(Object object, Credential credential) {
        if (credential != null) {
            this.credentialTable.put(object, credential);
        }
    }

    public abstract boolean supports(CardID var1);
}

