/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.management;

import opencard.core.util.HexString;

public class ApplicationID {
    public static final int RC_0 = 0;
    public static final int RC_1 = 1;
    public static final int RC_2 = 2;
    public static final int RC_3 = 3;
    public static final int RC_4 = 4;
    public static final int RC_5 = 5;
    public static final int RC_6 = 6;
    public static final int RC_7 = 7;
    public static final int RC_8 = 8;
    public static final int RC_9 = 9;
    public static final int RC_A = 10;
    public static final int RC_D = 13;
    public static final int RC_F = 16;
    protected byte[] aid;

    public ApplicationID(String string) {
        this.aid = HexString.parseHexString(string);
    }

    public ApplicationID(byte[] byArray) {
        this.aid = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.aid, 0, this.aid.length);
    }

    public boolean equals(Object object) {
        byte[] byArray;
        if (object instanceof ApplicationID && this.aid.length == (byArray = ((ApplicationID)object).getAID()).length) {
            int n = 0;
            while (n < this.aid.length) {
                if (this.aid[n] != byArray[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public byte[] getAID() {
        return this.aid;
    }

    public int getRegistrationCategory() {
        int n = this.aid[0] & 0xF0;
        if (n > 0 && n < 11) {
            return n;
        }
        if (n == 13) {
            return 13;
        }
        return 16;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.aid.length) {
            n |= this.aid[n2] & 0xFF;
            n <<= 2;
            ++n2;
        }
        return n;
    }

    public String toString() {
        return HexString.hexify(this.aid);
    }
}

