/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.StringTokenizer;
import opencard.core.event.TracerEvent;
import opencard.core.event.TracerListener;

public class Tracer {
    private static String[] traceList = null;
    private static int[] traceLevels;
    private static boolean eventsOnly;
    private static Hashtable tracerListeners;
    private String myClass;
    private Object me;
    static /* synthetic */ Class class$opencard$core$util$Tracer;

    static {
        eventsOnly = false;
        tracerListeners = new Hashtable();
    }

    public Tracer(Class clazz) {
        this((Object)clazz, clazz.getName());
    }

    public Tracer(Object object, Class clazz) {
        this(object, clazz.getName());
    }

    public Tracer(Object object, String string) {
        this.myClass = string;
        this.me = object;
        String string2 = System.getProperty("OpenCard.trace", "");
        eventsOnly = Boolean.getBoolean("OpenCard.trace.eventsOnly");
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        int n = stringTokenizer.countTokens();
        traceList = new String[n];
        traceLevels = new int[n];
        int n2 = 0;
        while (n2 < n) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ":");
            Tracer.traceList[n2] = stringTokenizer2.nextToken();
            try {
                Tracer.traceLevels[n2] = stringTokenizer2.hasMoreTokens() ? Integer.parseInt(stringTokenizer2.nextToken()) : 8;
            }
            catch (NumberFormatException numberFormatException) {
                Tracer.traceLevels[n2] = 8;
            }
            ++n2;
        }
    }

    public static void addTracerListener(TracerListener tracerListener) {
        Tracer.trace(class$opencard$core$util$Tracer != null ? class$opencard$core$util$Tracer : (class$opencard$core$util$Tracer = Tracer.class$("opencard.core.util.Tracer")), (class$opencard$core$util$Tracer != null ? class$opencard$core$util$Tracer : (class$opencard$core$util$Tracer = Tracer.class$("opencard.core.util.Tracer"))).getName(), 7, "addTracerListener", "adding " + tracerListener, null);
        tracerListeners.put(tracerListener, tracerListener);
        Tracer.trace(class$opencard$core$util$Tracer != null ? class$opencard$core$util$Tracer : (class$opencard$core$util$Tracer = Tracer.class$("opencard.core.util.Tracer")), (class$opencard$core$util$Tracer != null ? class$opencard$core$util$Tracer : (class$opencard$core$util$Tracer = Tracer.class$("opencard.core.util.Tracer"))).getName(), 7, "addTracerListener", "tracerListener " + tracerListeners, null);
    }

    public void alert(String string, String string2) {
        this.trace(1, string, string2);
    }

    public void alert(String string, Throwable throwable) {
        this.trace(1, string, throwable);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void critical(String string, String string2) {
        this.trace(2, string, string2);
    }

    public void critical(String string, Throwable throwable) {
        this.trace(2, string, throwable);
    }

    public void debug(String string, String string2) {
        this.trace(7, string, string2);
    }

    public void debug(String string, Throwable throwable) {
        this.trace(7, string, throwable);
    }

    public void emergency(String string, String string2) {
        this.trace(0, string, string2);
    }

    public void emergency(String string, Throwable throwable) {
        this.trace(0, string, throwable);
    }

    public void error(String string, String string2) {
        this.trace(3, string, string2);
    }

    public void error(String string, Throwable throwable) {
        this.trace(3, string, throwable);
    }

    public int getTraceLevel() {
        int n = -1;
        int n2 = 0;
        while (n2 < traceList.length) {
            if (traceList[n2] != null && this.myClass.startsWith(traceList[n2])) {
                n = traceLevels[n2];
            }
            ++n2;
        }
        return n;
    }

    public void info(String string, String string2) {
        this.trace(6, string, string2);
    }

    public void info(String string, Throwable throwable) {
        this.trace(6, string, throwable);
    }

    public void notice(String string, String string2) {
        this.trace(5, string, string2);
    }

    public void notice(String string, Throwable throwable) {
        this.trace(5, string, throwable);
    }

    public static void removeTracerListener(TracerListener tracerListener) {
        tracerListeners.remove(tracerListener);
    }

    protected void trace(int n, String string, String string2) {
        Tracer.trace(this.me, this.myClass, n, string, string2, null);
    }

    protected void trace(int n, String string, Throwable throwable) {
        Tracer.trace(this.me, this.myClass, n, string, null, throwable);
    }

    public static void trace(Object object, String string, int n, String string2, String string3, Throwable throwable) {
        if (string3 == null && throwable == null) {
            return;
        }
        if (string != null) {
            if (traceList == null) {
                return;
            }
            int n2 = 0;
            while (n2 < traceList.length) {
                if (traceList[n2] != null && string.startsWith(traceList[n2]) && n <= traceLevels[n2]) {
                    Object object2;
                    Object object3;
                    TracerEvent tracerEvent;
                    TracerEvent tracerEvent2 = tracerEvent = string3 != null ? new TracerEvent(n, object, string2, Thread.currentThread(), string3) : new TracerEvent(n, object, string2, Thread.currentThread(), throwable);
                    if (!eventsOnly) {
                        object3 = new StringBuffer(tracerEvent.getLevelName()).append(" ");
                        if (tracerEvent.getSource() instanceof Class) {
                            ((StringBuffer)object3).append(((Class)tracerEvent.getSource()).getName()).append(".");
                        } else {
                            ((StringBuffer)object3).append(tracerEvent.getSource().getClass().getName()).append(".");
                        }
                        ((StringBuffer)object3).append(tracerEvent.getMethodName()).append("\n");
                        if (tracerEvent.getMessage() != null) {
                            ((StringBuffer)object3).append("--- message   ").append(tracerEvent.getMessage()).append("\n");
                        } else {
                            object2 = tracerEvent.getThrowable();
                            StringWriter stringWriter = new StringWriter();
                            PrintWriter printWriter = new PrintWriter(stringWriter);
                            ((Throwable)object2).printStackTrace(printWriter);
                            printWriter.flush();
                            ((StringBuffer)object3).append("--- throwable ").append(printWriter.toString()).append("\n");
                        }
                        ((StringBuffer)object3).append("--- thread    ").append(tracerEvent.getThread()).append("\n");
                        ((StringBuffer)object3).append("--- source    ").append(tracerEvent.getSource()).append("\n");
                        System.out.println(String.valueOf(((StringBuffer)object3).toString()) + "\n");
                    }
                    if (tracerListeners.isEmpty()) break;
                    object3 = null;
                    object2 = tracerListeners.elements();
                    while (object2.hasMoreElements()) {
                        object3 = (TracerListener)object2.nextElement();
                        object3.traceEvent(tracerEvent);
                    }
                    break;
                }
                ++n2;
            }
        }
    }

    public void warning(String string, String string2) {
        this.trace(4, string, string2);
    }

    public void warning(String string, Throwable throwable) {
        this.trace(4, string, throwable);
    }
}

