/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.util;

public class HexString {
    protected static final String[] hexChars = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};

    public static String dump(byte[] byArray) {
        return HexString.dump(byArray, 0, byArray.length);
    }

    public static String dump(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return "null";
        }
        char[] cArray = new char[16];
        StringBuffer stringBuffer = new StringBuffer(256);
        int n3 = n;
        while (n3 < n + n2) {
            stringBuffer.append(HexString.hexify(n3 >>> 8 & 0xFF));
            stringBuffer.append(HexString.hexify(n3 & 0xFF));
            stringBuffer.append(":  ");
            int n4 = 0;
            while (n4 < 16) {
                if (n3 < byArray.length) {
                    int n5 = byArray[n3] & 0xFF;
                    stringBuffer.append(HexString.hexify(n5)).append(' ');
                    cArray[n4] = n5 >= 32 && n5 < 127 ? (int)n5 : 46;
                } else {
                    stringBuffer.append("   ");
                    cArray[n4] = 32;
                }
                ++n4;
                ++n3;
            }
            stringBuffer.append(' ').append(cArray).append("\n");
        }
        return stringBuffer.toString();
    }

    public static String hexify(int n) {
        return String.valueOf(hexChars[(n & 0xFF & 0xF0) >>> 4]) + hexChars[n & 0xF];
    }

    public static String hexify(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            if (n > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(hexChars[byArray[n2] >> 4 & 0xF]);
            stringBuffer.append(hexChars[byArray[n2] & 0xF]);
            if (++n == 16) {
                stringBuffer.append('\n');
                n = 0;
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String hexifyShort(byte by, byte by2) {
        return HexString.hexifyShort(by & 0xFF, by2 & 0xFF);
    }

    public static String hexifyShort(int n) {
        return String.valueOf(hexChars[(n & 0xFFFF & 0xF000) >>> 12]) + hexChars[(n & 0xFFF & 0xF00) >>> 8] + hexChars[(n & 0xFF & 0xF0) >>> 4] + hexChars[n & 0xF];
    }

    public static String hexifyShort(int n, int n2) {
        return HexString.hexifyShort(((n & 0xFF) << 8) + (n2 & 0xFF));
    }

    public static byte[] parseHexString(String string) {
        byte[] byArray = new byte[string.length() / 2];
        int n = 0;
        while (n < string.length()) {
            String string2 = string.substring(n, n + 2);
            byArray[n / 2] = (byte)Integer.parseInt(string2, 16);
            n += 2;
        }
        return byArray;
    }

    public static byte[] parseLittleEndianHexString(String string) {
        byte[] byArray = new byte[string.length() / 2 + 1];
        int n = 0;
        while (n < string.length()) {
            String string2 = string.substring(n, n + 2);
            byArray[(string.length() - n) / 2] = (byte)Integer.parseInt(string2, 16);
            n += 2;
        }
        byArray[0] = 0;
        return byArray;
    }
}

