/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.terminal;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import opencard.core.event.CTListener;
import opencard.core.event.CTRListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.Pollable;
import opencard.core.terminal.Slot;
import opencard.core.util.Tracer;

public final class CardTerminalRegistry
implements Runnable {
    protected Hashtable ctListeners = new Hashtable();
    private Tracer itracer = new Tracer((Object)this, class$opencard$core$terminal$CardTerminalRegistry != null ? class$opencard$core$terminal$CardTerminalRegistry : (class$opencard$core$terminal$CardTerminalRegistry = CardTerminalRegistry.class$("opencard.core.terminal.CardTerminalRegistry")));
    private static Tracer ctracer = new Tracer(class$opencard$core$terminal$CardTerminalRegistry != null ? class$opencard$core$terminal$CardTerminalRegistry : (class$opencard$core$terminal$CardTerminalRegistry = CardTerminalRegistry.class$("opencard.core.terminal.CardTerminalRegistry")));
    private static final CardTerminalRegistry registry = new CardTerminalRegistry();
    private static int pollInterval = 500;
    private Vector registeredTerminals = new Vector();
    private Hashtable ctrListeners = new Hashtable();
    private Object pollUpdates = new Object();
    private Vector pollDevices = new Vector();
    private Thread poller = null;
    static /* synthetic */ Class class$opencard$core$terminal$CardTerminalRegistry;

    private CardTerminalRegistry() {
    }

    public void add(CardTerminal cardTerminal) throws CardTerminalException {
        this.registeredTerminals.addElement(cardTerminal);
        this.cardTerminalAdded(cardTerminal);
        cardTerminal.open();
    }

    public void addCTListener(CTListener cTListener) {
        this.itracer.debug("addCTListener", "adding " + cTListener);
        this.ctListeners.put(cTListener, cTListener);
    }

    public synchronized void addCTRListener(CTRListener cTRListener) {
        this.itracer.debug("addCTRListener", "listener " + cTRListener);
        this.ctrListeners.put(cTRListener, cTRListener);
    }

    public void addPollable(Pollable pollable) {
        this.itracer.debug("addPollable", "(" + pollable + ")");
        Object object = this.pollUpdates;
        synchronized (object) {
            this.pollDevices.addElement(pollable);
            if (this.poller == null) {
                this.poller = new Thread(this);
                this.poller.setDaemon(true);
                this.poller.start();
            }
        }
    }

    protected void cardInserted(CardTerminal cardTerminal, int n) {
        this.itracer.debug("cardInserted", "slotID = " + n);
        if (!this.ctListeners.isEmpty()) {
            CTListener cTListener = null;
            Enumeration enumeration = this.ctListeners.elements();
            while (enumeration.hasMoreElements()) {
                cTListener = (CTListener)enumeration.nextElement();
                try {
                    cTListener.cardInserted(new CardTerminalEvent((Object)cardTerminal, 1, cardTerminal.getSlot(n)));
                }
                catch (RuntimeException runtimeException) {
                    this.itracer.critical("cardInserted", runtimeException);
                }
                catch (CardTerminalException cardTerminalException) {
                    this.itracer.critical("cardInserted", cardTerminalException);
                }
            }
            this.itracer.debug("cardInserted", "notified CTListeners");
        }
    }

    protected void cardRemoved(CardTerminal cardTerminal, int n) {
        this.itracer.debug("cardRemoved", "slotID = " + n);
        if (!this.ctListeners.isEmpty()) {
            CTListener cTListener = null;
            Enumeration enumeration = this.ctListeners.elements();
            while (enumeration.hasMoreElements()) {
                cTListener = (CTListener)enumeration.nextElement();
                try {
                    cTListener.cardRemoved(new CardTerminalEvent((Object)cardTerminal, 2, cardTerminal.getSlot(n)));
                }
                catch (RuntimeException runtimeException) {
                    this.itracer.critical("cardRemoved", runtimeException);
                }
                catch (CardTerminalException cardTerminalException) {
                    this.itracer.critical("cardRemoved", cardTerminalException);
                }
            }
            this.itracer.debug("cardRemoved", "notifying CTListeners");
        }
    }

    protected synchronized void cardTerminalAdded(CardTerminal cardTerminal) throws CardTerminalException {
        this.itracer.debug("cardTerminalAdded", "(" + cardTerminal + ")");
        if (!this.ctrListeners.isEmpty()) {
            CTRListener cTRListener = null;
            Enumeration enumeration = this.ctrListeners.elements();
            while (enumeration.hasMoreElements()) {
                cTRListener = (CTRListener)enumeration.nextElement();
                cTRListener.cardTerminalAdded(new CardTerminalEvent((Object)this, 3, cardTerminal));
            }
            this.itracer.debug("cardTerminalAdded", "notifying CTRListeners");
        }
    }

    public CardTerminal cardTerminalForName(String string) {
        CardTerminal cardTerminal = null;
        Vector vector = this.registeredTerminals;
        synchronized (vector) {
            int n = 0;
            while (n < this.countCardTerminals()) {
                if (((CardTerminal)this.registeredTerminals.elementAt(n)).getName().equals(string)) {
                    cardTerminal = (CardTerminal)this.registeredTerminals.elementAt(n);
                    break;
                }
                ++n;
            }
        }
        return cardTerminal;
    }

    protected synchronized void cardTerminalRemoved(CardTerminal cardTerminal) throws CardTerminalException {
        this.itracer.debug("cardTerminalRemoved", "(" + cardTerminal + ")");
        if (!this.ctrListeners.isEmpty()) {
            CTRListener cTRListener = null;
            Enumeration enumeration = this.ctrListeners.elements();
            while (enumeration.hasMoreElements()) {
                cTRListener = (CTRListener)enumeration.nextElement();
            }
            cTRListener.cardTerminalRemoved(new CardTerminalEvent((Object)this, 4, cardTerminal));
            this.itracer.debug("cardTerminalRemoved", "notifying CTRListeners");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public int countCardTerminals() {
        return this.registeredTerminals.size();
    }

    public void createEventsForPresentCards(CTListener cTListener) throws CardTerminalException {
        Enumeration enumeration = this.getCardTerminals();
        while (enumeration.hasMoreElements()) {
            CardTerminal cardTerminal = (CardTerminal)enumeration.nextElement();
            Slot[] slotArray = cardTerminal.slots();
            int n = 0;
            while (n < slotArray.length) {
                if (cardTerminal.isCardPresent(n)) {
                    cTListener.cardInserted(new CardTerminalEvent((Object)cardTerminal, 1, cardTerminal.getSlot(n)));
                }
                ++n;
            }
        }
    }

    public Enumeration getCardTerminals() {
        return this.registeredTerminals.elements();
    }

    public int getPollInterval() {
        return pollInterval;
    }

    public static synchronized CardTerminalRegistry getRegistry() {
        return registry;
    }

    public boolean remove(String string) throws CardTerminalException {
        CardTerminal cardTerminal = null;
        Vector vector = this.registeredTerminals;
        synchronized (vector) {
            int n = 0;
            while (n < this.registeredTerminals.size()) {
                cardTerminal = (CardTerminal)this.registeredTerminals.elementAt(n);
                if (cardTerminal.getName().equals(string)) {
                    cardTerminal.close();
                    this.registeredTerminals.removeElementAt(n);
                    break;
                }
                ++n;
            }
        }
        if (cardTerminal != null) {
            this.cardTerminalRemoved(cardTerminal);
            return true;
        }
        return false;
    }

    public boolean remove(CardTerminal cardTerminal) throws CardTerminalException {
        this.itracer.debug("remove", "closing " + cardTerminal);
        cardTerminal.close();
        this.itracer.debug("remove", "removing " + cardTerminal);
        boolean bl = this.registeredTerminals.removeElement(cardTerminal);
        if (bl) {
            this.itracer.debug("remove", "signalling listeners");
            this.cardTerminalRemoved(cardTerminal);
        }
        this.itracer.debug("remove", "status " + bl);
        return bl;
    }

    public void removeCTListener(CTListener cTListener) {
        this.itracer.debug("removeCTListener", "removing " + cTListener);
        this.ctListeners.remove(cTListener);
    }

    public synchronized void removeCTRListener(CTRListener cTRListener) {
        this.itracer.debug("removeCTRListener", "listener " + cTRListener);
        this.ctrListeners.remove(cTRListener);
    }

    public boolean removePollable(Pollable pollable) {
        boolean bl = false;
        Object object = this.pollUpdates;
        synchronized (object) {
            bl = this.pollDevices.removeElement(pollable);
            if (this.pollDevices.isEmpty() && this.poller != null) {
                this.poller.stop();
                this.poller = null;
            }
        }
        return bl;
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Object object = this.pollUpdates;
                    synchronized (object) {
                        Enumeration enumeration = this.pollDevices.elements();
                        while (enumeration.hasMoreElements()) {
                            Pollable pollable = (Pollable)enumeration.nextElement();
                            try {
                                pollable.poll();
                            }
                            catch (RuntimeException runtimeException) {
                                this.itracer.debug("run", runtimeException);
                            }
                            catch (CardTerminalException cardTerminalException) {
                                this.itracer.debug("run", cardTerminalException);
                            }
                        }
                    }
                    Thread.sleep(pollInterval);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void setPollInterval(int n) {
        pollInterval = n;
    }
}

