/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.utils;

import com.sun.opencard.common.OCFConstants;
import com.sun.opencard.common.OCFDebug;
import com.sun.opencard.common.OCFException;
import com.sun.opencard.server.OCFCardHandle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import opencard.core.service.CardService;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceRegistry;
import opencard.core.service.SmartCard;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class OCFUtils {
    protected static final String OCF_CONFIG_FILE = "/etc/smartcard/opencard.properties";
    protected static final String OCF_CONFIG_FILE_BAK = "/etc/smartcard/opencard.properties.bak";
    protected static final String OCF_CONFIG_FILE_NEW = "/etc/smartcard/opencard.properties.new";
    protected static final String OCF_KEYS_FILE = "/etc/smartcard/.keys";
    protected static final String KEYS_PROP_PREFIX = "ocf.server.keys.";
    protected static Properties ocfProperties = null;
    protected static Properties ocfKeys = null;
    protected static File ocfConfigFile = new File("/etc/smartcard/opencard.properties");
    protected static File ocfConfigFileBak = new File("/etc/smartcard/opencard.properties.bak");
    protected static File ocfConfigFileNew = new File("/etc/smartcard/opencard.properties.new");
    protected static Vector propertyChangeListeners = new Vector();

    static {
        try {
            System.out.println("OCFUtils : <init> load/update props");
            OCFUtils.loadOCFProperties();
            OCFUtils.loadOCFKeys();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener != null && !propertyChangeListeners.contains(propertyChangeListener)) {
            propertyChangeListeners.addElement(propertyChangeListener);
        }
    }

    public static Object decodeParams(String string) throws IOException {
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        byte[] byArray = bASE64Decoder.decodeBuffer(string);
        return byArray;
    }

    public static Object deleteProperty(String string) throws Exception {
        OCFDebug.debugln("OCFUtils::deleteProperty");
        Object var1_1 = null;
        if (string.startsWith(KEYS_PROP_PREFIX)) {
            Properties properties = ocfKeys;
            synchronized (properties) {
                var1_1 = ((Hashtable)ocfKeys).remove(string);
                ocfKeys.store(new FileOutputStream(OCF_KEYS_FILE), null);
            }
        }
        Properties properties = ocfProperties;
        synchronized (properties) {
            var1_1 = ((Hashtable)ocfProperties).remove(string);
            OCFUtils.updateCardProperties(ocfProperties);
        }
        OCFUtils.notifyListeners(ocfProperties, string, var1_1, null);
        return var1_1;
    }

    public static String encodeParams(Object object) throws IOException {
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String string = String.valueOf(object);
        bASE64Encoder.encodeBuffer(string.getBytes(), (OutputStream)byteArrayOutputStream);
        String string2 = byteArrayOutputStream.toString();
        String string3 = "";
        int n = 0;
        int n2 = string2.indexOf(10, n);
        while (n2 != -1) {
            string3 = String.valueOf(string3) + string2.substring(n, n2);
            n = n2 + 1;
            n2 = string2.indexOf(10, n);
        }
        return string3;
    }

    public static CardService getCardService(SmartCard smartCard, Class clazz, OCFCardHandle oCFCardHandle) throws Exception {
        Enumeration enumeration = CardServiceRegistry.getRegistry().getCardServiceFactories();
        CardService cardService = null;
        Enumeration enumeration2 = null;
        while (enumeration.hasMoreElements()) {
            CardServiceFactory cardServiceFactory = (CardServiceFactory)enumeration.nextElement();
            if (!cardServiceFactory.knows(oCFCardHandle.getCardID())) continue;
            enumeration2 = cardServiceFactory.cardServiceClasses(oCFCardHandle.getCardID());
            while (enumeration2.hasMoreElements()) {
                Class clazz2 = (Class)enumeration2.nextElement();
                if (!clazz.isAssignableFrom(clazz2)) continue;
                cardService = smartCard.getCardService(clazz2, false);
                break;
            }
            if (cardService != null) break;
        }
        return cardService;
    }

    public static Class getClass(String string, String string2) throws Exception {
        return OCFUtils.getClass(string, string2, null);
    }

    public static Class getClass(String string, String string2, String string3) throws Exception {
        Class<?> clazz = null;
        String string4 = OCFUtils.getProperty(String.valueOf(OCFConstants.OCF_SERVER_PROPERTY_PREFIX) + string2, null);
        if (string4 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string4, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken();
                if (string3 != null) {
                    string5 = String.valueOf(string5) + string3;
                }
                try {
                    OCFDebug.debugln("Trying to init : " + string5 + "." + string);
                    clazz = Class.forName(String.valueOf(string5) + "." + string);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException(string);
        }
        return clazz;
    }

    public static String getProperty(String string, String string2) throws Exception {
        String string3 = null;
        if (string.startsWith(KEYS_PROP_PREFIX)) {
            string3 = ocfKeys.getProperty(string, string2);
            if (string3 == null) {
                throw new OCFException("Property : " + string + " not defined");
            }
        } else if (string.startsWith(OCFConstants.OCF_CLIENT_RAW_PROPERTY_PREFIX)) {
            string3 = ocfProperties.getProperty(string = string.substring(string.indexOf(OCFConstants.OCF_CLIENT_RAW_PROPERTY_PREFIX)), string2);
            if (string3 == null) {
                throw new OCFException("Property : " + string + " not defined");
            }
        } else {
            string3 = ocfProperties.getProperty(string, string2);
            if (string3 == null) {
                if (string.startsWith(OCFConstants.OCF_CLIENT_PROPERTY_PREFIX)) {
                    String string4 = String.valueOf(OCFConstants.OCF_DEFAULT_PROPERTY_PREFIX) + string.substring(string.lastIndexOf(".") + 1, string.length());
                    String string5 = ocfProperties.getProperty(string4, null);
                    if (string5 == null) {
                        throw new OCFException("Property : " + string + " not defined");
                    }
                    return string5;
                }
                throw new OCFException("Property : " + string + " not defined");
            }
        }
        return string3;
    }

    public static Enumeration listPropertyNames(boolean bl) throws Exception {
        Vector vector = new Vector();
        if (bl) {
            Enumeration<?> enumeration = ocfProperties.propertyNames();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
            Enumeration<?> enumeration2 = ocfKeys.propertyNames();
            while (enumeration2.hasMoreElements()) {
                Object obj = enumeration2.nextElement();
                vector.addElement(obj);
            }
            return vector.elements();
        }
        return ocfProperties.propertyNames();
    }

    protected static void loadOCFKeys() throws Exception {
        if (ocfKeys != null) {
            return;
        }
        ocfKeys = new Properties();
        File file = new File(OCF_KEYS_FILE);
        if (file.exists() && file.canRead()) {
            try {
                Properties properties = new Properties();
                properties.load(new FileInputStream(file));
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String string2 = properties.getProperty(string);
                    ((Hashtable)ocfKeys).put(string, properties.getProperty(string));
                }
            }
            catch (IOException iOException) {
                throw new Exception("Could not load OCF keys file: /etc/smartcard/.keys\n" + iOException.getLocalizedMessage());
            }
        }
    }

    protected static void loadOCFProperties() throws Exception {
        ocfProperties = new Properties();
        File file = new File(OCF_CONFIG_FILE);
        if (file.exists() && file.canRead()) {
            try {
                Properties properties = new Properties();
                properties.load(new FileInputStream(file));
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String string2 = properties.getProperty(string);
                    ((Hashtable)ocfProperties).put(string, properties.getProperty(string));
                }
            }
            catch (IOException iOException) {
                throw new Exception("Could not load OCF property file: /etc/smartcard/opencard.properties\n" + iOException.getLocalizedMessage());
            }
        } else {
            throw new Exception("OCF properties file not present  or unable to read: /etc/smartcard/opencard.properties");
        }
    }

    private static void notifyListeners(Properties properties, String string, Object object, Object object2) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(properties, string, object, object2);
        int n = 0;
        while (n < propertyChangeListeners.size()) {
            try {
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)propertyChangeListeners.elementAt(n);
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n;
        }
    }

    public static void setProperty(String string, String string2) throws Exception {
        OCFDebug.debugln("OCFUtils::setProperty");
        if (string.startsWith(KEYS_PROP_PREFIX)) {
            Properties properties = ocfKeys;
            synchronized (properties) {
                Object object = ocfKeys.setProperty(string, string2);
                ocfKeys.store(new FileOutputStream(OCF_KEYS_FILE), null);
            }
        }
        Properties properties = ocfProperties;
        synchronized (properties) {
            String string3 = (String)ocfProperties.setProperty(string, string2);
            OCFDebug.debugln("OCFUtils::setProperty oldValue=" + string3);
            OCFUtils.updateCardProperties(ocfProperties);
            OCFUtils.notifyListeners(ocfProperties, string, string3, string2);
        }
    }

    private static void updateCardProperties(Properties properties) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(ocfConfigFileNew);
            properties.store(fileOutputStream, null);
            fileOutputStream.close();
            fileOutputStream = null;
            if (ocfConfigFileNew.length() <= 0L) {
                OCFDebug.debugln("failed to create opencard.properties.new");
                return;
            }
            FileInputStream fileInputStream = new FileInputStream(ocfConfigFile);
            FileOutputStream fileOutputStream2 = new FileOutputStream(ocfConfigFileBak);
            byte[] byArray = new byte[256];
            int n = 0;
            while ((n = fileInputStream.read(byArray)) != -1) {
                fileOutputStream2.write(byArray, 0, n);
            }
            fileInputStream.close();
            fileOutputStream2.close();
            fileInputStream = null;
            fileOutputStream2 = null;
            byArray = null;
            ocfConfigFileNew.renameTo(ocfConfigFile);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

