
# Copyright 02/15/02 Sun Microsystems, Inc. All Rights Reserved.
#pragma ident  "@(#)Config-Reader-models-d.x	1.42 02/02/15 Sun Microsystems"

type       = reference

 _rules = { [ source Config-Reader4u-d.rul ] }

system = { [ use MANAGED-OBJECT ]

	mediumDesc = System 
	consoleHint:mediumDesc = base.modules.Config-Reader4u:system

	sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
                mediumDesc        =  tree prop
		consoleHint:hidden = true
		consoleHint:mediumDesc = base.modules.Config-Reader4u:system.sunSmTreeProp

        }
	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4u:system.sunSmNodeName
	}
        os = { [ use STRING MANAGED-PROPERTY ]
           mediumDesc        = Operating System
	   consoleHint:mediumDesc = base.modules.Config-Reader4u:system.os
        }

        OS_version = { [ use STRING MANAGED-PROPERTY ]
           mediumDesc        = Operating System Version
	   consoleHint:mediumDesc = base.modules.Config-Reader4u:system.OS_version
        }

        System_clock_frequency = { [ use STRING MANAGED-PROPERTY ]
           mediumDesc        = System Clock Frequency
	   consoleHint:mediumDesc = base.modules.Config-Reader4u:system.System_clock_frequency
        }

        architecture = { [ use STRING MANAGED-PROPERTY ]
           mediumDesc        = Architecture
	   consoleHint:mediumDesc = base.modules.Config-Reader4u:system.architecture
        }

        hostname = { [ use STRING MANAGED-PROPERTY ]
           mediumDesc        = Hostname Of The System
	   consoleHint:mediumDesc = base.modules.Config-Reader4u:system.hostname
        }

        machine = { [ use STRING MANAGED-PROPERTY ]
           mediumDesc        = Machine Name
	   consoleHint:mediumDesc = base.modules.Config-Reader4u:system.machine
        }

        platform = { [ use STRING MANAGED-PROPERTY ]
           mediumDesc        = System Platform
	   consoleHint:mediumDesc = base.modules.Config-Reader4u:system.platform
        }
        sample = { [ use STRING MANAGED-PROPERTY ]
	   consoleHint:hidden = true
           mediumDesc        = Sampling Time 
	   consoleHint:mediumDesc = base.modules.Config-Reader4u:system.sample
        }

        serial_number = { [ use STRING MANAGED-PROPERTY ]
 	   #consoleHint:hidden = true
           mediumDesc        = Serial Number
	   consoleHint:mediumDesc = base.modules.Config-Reader4u:system.serial_number
        }

        timestamp = { [ use STRING MANAGED-PROPERTY ]
           mediumDesc        = Timestamp
	   consoleHint:mediumDesc = base.modules.Config-Reader4u:system.timestamp
        }

        timestamp_raw = { [ use STRING MANAGED-PROPERTY ]
           mediumDesc        = Raw Timestamp
	   consoleHint:mediumDesc = base.modules.Config-Reader4u:system.timestamp_raw
        }
        total_disks = { [ use STRING MANAGED-PROPERTY ]
           mediumDesc        = Total Disks
	   consoleHint:mediumDesc = base.modules.Config-Reader4u:system.total_disks
        }

        total_memory = { [ use STRING MANAGED-PROPERTY ]
           mediumDesc        = Total Memory
	   consoleHint:mediumDesc = base.modules.Config-Reader4u:system.total_memory
        }

        total_processors = { [ use STRING MANAGED-PROPERTY ]
           mediumDesc        = Total Processors
	   consoleHint:mediumDesc = base.modules.Config-Reader4u:system.total_processors
        }

        total_tape_devices = { [ use STRING MANAGED-PROPERTY ]
           mediumDesc        = Total Tape Devices
	   consoleHint:mediumDesc = base.modules.Config-Reader4u:system.total_tape_devices
        }
	total_model_changes = { [ use INT MANAGED-PROPERTY ]
		mediumDesc        =  Number Of Model property/value changed
		fullDesc  = This value changes whenever there is a difference between previous snapshot and current snapshot.
		consoleHint:hidden = true
		consoleHint:mediumDesc = base.modules.Config-Reader4u:system.total_model_changes
	}
	total_config_changes = { [ use INT MANAGED-PROPERTY ]
		mediumDesc        =  Number Of Times configuration changed
		fullDesc  = This value changes whenever there is a configuration change (nodes added/removed from the tree)
		consoleHint:hidden = true
		consoleHint:mediumDesc = base.modules.Config-Reader4u:system.total_config_changes
	}


}

system-board = { [ use MANAGED-OBJECT ]
	mediumDesc = System Board 
	consoleHint:hidden = true
	consoleHint:mediumDesc = base.modules.Config-Reader4u:system-board

	sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
                mediumDesc        =  tree prop
		consoleHint:mediumDesc = base.modules.Config-Reader4u:system-board.sunSmTreeProp
        }
	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  name
		consoleHint:mediumDesc = base.modules.Config-Reader4u:system-board.sunSmNodeName
	}
}

clock-board = { [ use MANAGED-OBJECT ]
	mediumDesc = Clock Board 
	consoleHint:hidden = true
	consoleHint:mediumDesc = base.modules.Config-Reader4u:clock-board

	sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
                mediumDesc        =  Tree Prop 
		consoleHint:mediumDesc = base.modules.Config-Reader4u:clock-board.sunSmTreeProp
        }
	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4u:clock-board.sunSmNodeName
	}
}


SUNWUltra-1 = { [ use MANAGED-OBJECT ]
	mediumDesc = SUNWUltra-1 
        consoleHint:hidden = true
	consoleHint:mediumDesc = base.modules.Config-Reader4u:SUNWUltra-1

	sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
                mediumDesc        =  Tree Prop
		consoleHint:mediumDesc = base.modules.Config-Reader4u:SUNWUltra-1.sunSmTreeProp
        }
	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4u:SUNWUltra-1.sunSmNodeName
	}
}

SUNWUltra-2 = { [ use MANAGED-OBJECT ]
	mediumDesc = SUNWUltra-2 
        consoleHint:hidden = true
	consoleHint:mediumDesc = base.modules.Config-Reader4u:SUNWUltra-2

	sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
                mediumDesc        =  Tree Prop
		consoleHint:mediumDesc = base.modules.Config-Reader4u:SUNWUltra-2.sunSmTreeProp
        }
	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4u:SUNWUltra-2.sunSmNodeName
	}
}


# slot information

slot = { [ use MANAGED-OBJECT ]
	consoleHint:mediumDesc = base.modules.Config-Reader4u:slot
	consoleHint:hidden = true

slotTbl = { [ use MANAGED-OBJECT-TABLE ]

	mediumDesc = Slot Table
	consoleHint:mediumDesc = base.modules.Config-Reader4u:slot.slotTbl

        solt-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		consoleHint:mediumDesc = base.modules.Config-Reader4u:slot.slotTbl.solt-entry
                index = entry_no

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  Tree Prop
			consoleHint:mediumDesc = base.modules.Config-Reader4u:slot.slotTbl.solt-entry.sunSmTreeProp
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
			consoleHint:mediumDesc = base.modules.Config-Reader4u:slot.slotTbl.solt-entry.sunSmNodeName
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  Entry Number  
			consoleHint:mediumDesc = base.modules.Config-Reader4u:slot.slotTbl.solt-entry.entry_no
		}
		slot-num = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Slot No
			consoleHint:mediumDesc = base.modules.Config-Reader4u:slot.slotTbl.solt-entry.slot-num
		}
	}
}
}

# board information

board = { [ use MANAGED-OBJECT ]
	consoleHint:mediumDesc = base.modules.Config-Reader4u:board

boardTbl = { [ use MANAGED-OBJECT-TABLE ]

	mediumDesc = Board Table
	consoleHint:mediumDesc = base.modules.Config-Reader4u:board.boardTbl

        board-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.Config-Reader4u:board.boardTbl.board-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  tree prop
			consoleHint:mediumDesc = base.modules.Config-Reader4u:board.boardTbl.board-entry.sunSmTreeProp
		}
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
			consoleHint:mediumDesc = base.modules.Config-Reader4u:board.boardTbl.board-entry.sunSmNodeName
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
			consoleHint:mediumDesc = base.modules.Config-Reader4u:board.boardTbl.board-entry.entry_no
		}

		board-num = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Board No
			consoleHint:mediumDesc = base.modules.Config-Reader4u:board.boardTbl.board-entry.board-num
		}
		fru = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Fru
			consoleHint:mediumDesc = base.modules.Config-Reader4u:board.boardTbl.board-entry.fru
		}
		hot-plugged = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Hot Plugged
			consoleHint:mediumDesc = base.modules.Config-Reader4u:board.boardTbl.board-entry.hot-plugged
		}
		hpu = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Hot Pluggable
			consoleHint:mediumDesc = base.modules.Config-Reader4u:board.boardTbl.board-entry.hpu
		}
		memory_size = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Memory Size
			consoleHint:mediumDesc = base.modules.Config-Reader4u:board.boardTbl.board-entry.memory_size
		}
		state = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  State
			consoleHint:mediumDesc = base.modules.Config-Reader4u:board.boardTbl.board-entry.state
		}
		temperature = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
			mediumDesc        =  Temperature
			alarmRules        =  rcr4u205
			consoleHint:mediumDesc = base.modules.Config-Reader4u:board.boardTbl.board-entry.temperature
		}
		type = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Type
			consoleHint:mediumDesc = base.modules.Config-Reader4u:board.boardTbl.board-entry.type
		}
		type-int = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  Type Int
			consoleHint:mediumDesc = base.modules.Config-Reader4u:board.boardTbl.board-entry.type-int
		}
		upa-mid = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  Upa Mid
			consoleHint:mediumDesc = base.modules.Config-Reader4u:board.boardTbl.board-entry.upa-mid
		}

        }
}
}

# cpu board information

cpu-unit = { [ use MANAGED-OBJECT ]
	consoleHint:mediumDesc = base.modules.Config-Reader4u:cpu-unit

cpu-unitTbl = { [ use MANAGED-OBJECT-TABLE ]

	mediumDesc = Cpu Unit  Table
	consoleHint:mediumDesc = base.modules.Config-Reader4u:cpu-unit.cpu-unitTbl

        cpu-unit-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.Config-Reader4u:cpu-unit.cpu-unitTbl.cpu-unit-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  Tree Prop
			consoleHint:mediumDesc = base.modules.Config-Reader4u:cpu-unit.cpu-unitTbl.cpu-unit-entry.sunSmTreeProp
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
			consoleHint:mediumDesc = base.modules.Config-Reader4u:cpu-unit.cpu-unitTbl.cpu-unit-entry.sunSmNodeName
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  Entry Number  
			consoleHint:mediumDesc = base.modules.Config-Reader4u:cpu-unit.cpu-unitTbl.cpu-unit-entry.entry_no
		}
                board-hash = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
                        mediumDesc        =  Board-hash
			consoleHint:mediumDesc = base.modules.Config-Reader4u:cpu-unit.cpu-unitTbl.cpu-unit-entry.board-hash
                }
	        board-num = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Board No
			consoleHint:mediumDesc = base.modules.Config-Reader4u:cpu-unit.cpu-unitTbl.cpu-unit-entry.board-num
		}
		clock-frequency = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Clock Frequency
			consoleHint:mediumDesc = base.modules.Config-Reader4u:cpu-unit.cpu-unitTbl.cpu-unit-entry.clock-frequency
		}
		cpu-type = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Cpu Type
			consoleHint:mediumDesc = base.modules.Config-Reader4u:cpu-unit.cpu-unitTbl.cpu-unit-entry.cpu-type
		}
		dcache-size = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Dcache Size
			consoleHint:mediumDesc = base.modules.Config-Reader4u:cpu-unit.cpu-unitTbl.cpu-unit-entry.dcache-size
		}
		device_type = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  Device type
			consoleHint:mediumDesc = base.modules.Config-Reader4u:cpu-unit.cpu-unitTbl.cpu-unit-entry.device_type
		}
		ecache-size = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Ecache Size
			consoleHint:mediumDesc = base.modules.Config-Reader4u:cpu-unit.cpu-unitTbl.cpu-unit-entry.ecache-size
		}
		fru = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Fru
			consoleHint:mediumDesc = base.modules.Config-Reader4u:cpu-unit.cpu-unitTbl.cpu-unit-entry.fru
		}
		icache-size = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Icache Size
			consoleHint:mediumDesc = base.modules.Config-Reader4u:cpu-unit.cpu-unitTbl.cpu-unit-entry.icache-size
		}
		model = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Model
			consoleHint:mediumDesc = base.modules.Config-Reader4u:cpu-unit.cpu-unitTbl.cpu-unit-entry.model
		}
		pathname_element = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  Pathname Element
			consoleHint:mediumDesc = base.modules.Config-Reader4u:cpu-unit.cpu-unitTbl.cpu-unit-entry.pathname_element
		}
		processor-id = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Processor Id
			consoleHint:mediumDesc = base.modules.Config-Reader4u:cpu-unit.cpu-unitTbl.cpu-unit-entry.processor-id
		}
		reg = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  Reg
			consoleHint:mediumDesc = base.modules.Config-Reader4u:cpu-unit.cpu-unitTbl.cpu-unit-entry.reg
		}
		status = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
			mediumDesc        =  Status
			alarmRules        =  rcr4u207
			consoleHint:mediumDesc = base.modules.Config-Reader4u:cpu-unit.cpu-unitTbl.cpu-unit-entry.status
		}
		unit = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Unit
			consoleHint:mediumDesc = base.modules.Config-Reader4u:cpu-unit.cpu-unitTbl.cpu-unit-entry.unit
		}
		upa-mid = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  Upa Mid
			consoleHint:mediumDesc = base.modules.Config-Reader4u:cpu-unit.cpu-unitTbl.cpu-unit-entry.upa-mid
		}
		upa-portid = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  Upa Portid
			consoleHint:mediumDesc = base.modules.Config-Reader4u:cpu-unit.cpu-unitTbl.cpu-unit-entry.upa-portid
		}
	}
}
}


# disk  information

sd    = { [ use MANAGED-OBJECT ]
	mediumDesc = Disk(sd) Object

sdTbl    = { [ use MANAGED-OBJECT-TABLE ]

	mediumDesc = Disk(sd) Table

        sd-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  Tree Prop
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  Entry Number  
		}
	        device_type = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Device Type
       		}
       		fru = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Fru
       		}
       		mounted_partitions = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        = Mounted Partitions
       		}
       		disk_name = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Disk Name
       		}
	}
}
}


zs    = { [ use MANAGED-OBJECT ]
	consoleHint:hidden = true
	mediumDesc = Zs Table

zsTbl    = { [ use MANAGED-OBJECT-TABLE ]

	mediumDesc = Zs Table

        zs-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  Tree Prop
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  Entry Number  
		}
	        device_type = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Device Type
       		}
       		device_usage = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Device Usage
       		}
       		instance = { [ use STRING MANAGED-PROPERTY ]
	      		mediumDesc        =  Board No
       		}
       		pathname_element = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
       			mediumDesc        = Pathname Element
       		}
	}
}
}

simm    = { [ use MANAGED-OBJECT ]
	consoleHint:mediumDesc = base.modules.Config-Reader4u:simm

simmTbl    = { [ use MANAGED-OBJECT-TABLE ]

	mediumDesc = Simm Table
	consoleHint:mediumDesc = base.modules.Config-Reader4u:simm.simmTbl

        simm-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.Config-Reader4u:simm.simmTbl.simm-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  Tree Prop
			consoleHint:mediumDesc = base.modules.Config-Reader4u:simm.simmTbl.simm-entry.sunSmTreeProp
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  name
			consoleHint:mediumDesc = base.modules.Config-Reader4u:simm.simmTbl.simm-entry.sunSmNodeName
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  Entry Number  
			consoleHint:mediumDesc = base.modules.Config-Reader4u:simm.simmTbl.simm-entry.entry_no
		}
		board_reference_number = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Board Reference Number 
			consoleHint:mediumDesc = base.modules.Config-Reader4u:simm.simmTbl.simm-entry.board_reference_number
		}
		fru = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Fru 
			consoleHint:mediumDesc = base.modules.Config-Reader4u:simm.simmTbl.simm-entry.fru
		}
		size = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Size 
			consoleHint:mediumDesc = base.modules.Config-Reader4u:simm.simmTbl.simm-entry.size
		}
		slot = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Slot 
			consoleHint:mediumDesc = base.modules.Config-Reader4u:simm.simmTbl.simm-entry.slot
		}
		type = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Status 
			consoleHint:mediumDesc = base.modules.Config-Reader4u:simm.simmTbl.simm-entry.type
		}
	}
}
}


AC_PS = { [ use MANAGED-OBJECT ]

	mediumDesc = AC Power Supply
	consoleHint:mediumDesc = base.modules.Config-Reader4u:AC_PS

	sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
                mediumDesc        =  Tree Prop
		consoleHint:mediumDesc = base.modules.Config-Reader4u:AC_PS.sunSmTreeProp
        }
	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4u:AC_PS.sunSmNodeName
	}
	status = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Status 
		consoleHint:mediumDesc = base.modules.Config-Reader4u:AC_PS.status
	}
#	fan_status = { [ use STRING MANAGED-PROPERTY ]
#		mediumDesc        =  Fan Status 
#		consoleHint:mediumDesc = base.modules.Config-Reader4u:AC_PS.fan_status
#	}
}

hot_plug_charges = { [ use MANAGED-OBJECT ]
	mediumDesc = Hot Plug Charges 
	consoleHint:mediumDesc = base.modules.Config-Reader4u:hot_plug_charges

	sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
                mediumDesc        =  Tree Prop
		consoleHint:mediumDesc = base.modules.Config-Reader4u:hot_plug_charges.sunSmTreeProp
        }
	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4u:hot_plug_charges.sunSmNodeName
	}
	fru = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Fru 
		consoleHint:mediumDesc = base.modules.Config-Reader4u:hot_plug_charges.fru
	}
}

auxiliary_5v = { [ use MANAGED-OBJECT ]
	mediumDesc = Auxiliary 5v 
	consoleHint:mediumDesc = base.modules.Config-Reader4u:auxiliary_5v

	sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
                mediumDesc        =  Tree Prop
		consoleHint:mediumDesc = base.modules.Config-Reader4u:auxiliary_5v.sunSmTreeProp
        }
	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4u:auxiliary_5v.sunSmNodeName
	}
	fru = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Fru 
		consoleHint:mediumDesc = base.modules.Config-Reader4u:auxiliary_5v.fru
	}
	status = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
		mediumDesc        =  Status 
		alarmRules        =  rcr4u201
		consoleHint:mediumDesc = base.modules.Config-Reader4u:auxiliary_5v.status
	}
}

peripheral_5v = { [ use MANAGED-OBJECT ]

	mediumDesc = Peripheral 5v 
	consoleHint:mediumDesc = base.modules.Config-Reader4u:peripheral_5v

	sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
                mediumDesc        =  Tree Prop
		consoleHint:mediumDesc = base.modules.Config-Reader4u:peripheral_5v.sunSmTreeProp
        }
	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4u:peripheral_5v.sunSmNodeName
	}
	fru = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Fru 
		consoleHint:mediumDesc = base.modules.Config-Reader4u:peripheral_5v.fru
	}
	status = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
		mediumDesc        =  Status 
		alarmRules        =  rcr4u201
		consoleHint:mediumDesc = base.modules.Config-Reader4u:peripheral_5v.status
	}
}

peripheral_5v_precharge = { [ use MANAGED-OBJECT ]
	mediumDesc = Peripheral 5v Precharge 
	consoleHint:mediumDesc = base.modules.Config-Reader4u:peripheral_5v_precharge

	sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
                mediumDesc        =  Tree Prop
		consoleHint:mediumDesc = base.modules.Config-Reader4u:peripheral_5v_precharge.sunSmTreeProp
        }
	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4u:peripheral_5v_precharge.sunSmNodeName
	}
	fru = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Fru 
		consoleHint:mediumDesc = base.modules.Config-Reader4u:peripheral_5v_precharge.fru
	}
	status = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
		mediumDesc        =  Status 
		alarmRules        =  rcr4u201
		consoleHint:mediumDesc = base.modules.Config-Reader4u:peripheral_5v_precharge.status
	}
}

peripheral_12v = { [ use MANAGED-OBJECT ]
	mediumDesc = Peripheral 12v 
	consoleHint:mediumDesc = base.modules.Config-Reader4u:peripheral_12v

	sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
                mediumDesc        =  Tree Prop
		consoleHint:mediumDesc = base.modules.Config-Reader4u:peripheral_12v.sunSmTreeProp
        }
	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4u:peripheral_12v.sunSmNodeName
	}
	fru = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Fru 
		consoleHint:mediumDesc = base.modules.Config-Reader4u:peripheral_12v.fru
	}
	status = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
		mediumDesc        =  Status 
		alarmRules        =  rcr4u201
		consoleHint:mediumDesc = base.modules.Config-Reader4u:peripheral_12v.status
	}
}

peripheral_12v_precharge = { [ use MANAGED-OBJECT ]
	mediumDesc = Peripheral 12v Precharge 
	consoleHint:mediumDesc = base.modules.Config-Reader4u:peripheral_12v_precharge

	sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
                mediumDesc        =  Tree Prop
		consoleHint:mediumDesc = base.modules.Config-Reader4u:peripheral_12v_precharge.sunSmTreeProp
        }
	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4u:peripheral_12v_precharge.sunSmNodeName
	}
	fru = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Fru 
		consoleHint:mediumDesc = base.modules.Config-Reader4u:peripheral_12v_precharge.fru
	}
	status = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
		mediumDesc        =  Status 
		alarmRules        =  rcr4u201
		consoleHint:mediumDesc = base.modules.Config-Reader4u:peripheral_12v_precharge.status
	}
}

system_3v = { [ use MANAGED-OBJECT ]
	mediumDesc = System 3v 
	consoleHint:mediumDesc = base.modules.Config-Reader4u:system_3v

	sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
                mediumDesc        =  Tree Prop
		consoleHint:mediumDesc = base.modules.Config-Reader4u:system_3v.sunSmTreeProp
        }
	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4u:system_3v.sunSmNodeName
	}
	fru = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Fru 
		consoleHint:mediumDesc = base.modules.Config-Reader4u:system_3v.fru
	}
	status = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
		mediumDesc        =  Status 
		alarmRules        =  rcr4u201
		consoleHint:mediumDesc = base.modules.Config-Reader4u:system_3v.status
	}
}
system_3v_precharge = { [ use MANAGED-OBJECT ]
	mediumDesc = System 3v Precharge 
	consoleHint:mediumDesc = base.modules.Config-Reader4u:system_3v_precharge

	sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
                mediumDesc        =  Tree Prop
		consoleHint:mediumDesc = base.modules.Config-Reader4u:system_3v_precharge.sunSmTreeProp
        }
	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4u:system_3v_precharge.sunSmNodeName
	}
	fru = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Fru 
		consoleHint:mediumDesc = base.modules.Config-Reader4u:system_3v_precharge.fru
	}
	status = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
		mediumDesc        =  Status 
		alarmRules        =  rcr4u201
		consoleHint:mediumDesc = base.modules.Config-Reader4u:system_3v_precharge.status
	}
}
system_5v = { [ use MANAGED-OBJECT ]
	mediumDesc = System 5v 
	consoleHint:mediumDesc = base.modules.Config-Reader4u:system_5v

	sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
                mediumDesc        =  Tree Prop
		consoleHint:mediumDesc = base.modules.Config-Reader4u:system_5v.sunSmTreeProp
        }
	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4u:system_5v.sunSmNodeName
	}
	fru = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Fru 
		consoleHint:mediumDesc = base.modules.Config-Reader4u:system_5v.fru
	}
	status = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
		mediumDesc        =  Status 
		alarmRules        =  rcr4u201
		consoleHint:mediumDesc = base.modules.Config-Reader4u:system_5v.status
	}
}

system_5v_precharge = { [ use MANAGED-OBJECT ]
	mediumDesc = System 5v Precharge 
	consoleHint:mediumDesc = base.modules.Config-Reader4u:system_5v_precharge

	sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
                mediumDesc        =  Tree Prop
		consoleHint:mediumDesc = base.modules.Config-Reader4u:system_5v_precharge.sunSmTreeProp
        }
	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4u:system_5v_precharge.sunSmNodeName
	}
	fru = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Fru 
		consoleHint:mediumDesc = base.modules.Config-Reader4u:system_5v_precharge.fru
	}
	status = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
		mediumDesc        =  Status 
		alarmRules        =  rcr4u201
		consoleHint:mediumDesc = base.modules.Config-Reader4u:system_5v_precharge.status
	}
}
keyswitch = { [ use MANAGED-OBJECT ]
	mediumDesc = Keyswitch 
	consoleHint:mediumDesc = base.modules.Config-Reader4u:keyswitch

	sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
                mediumDesc        =  Tree Prop
		consoleHint:mediumDesc = base.modules.Config-Reader4u:keyswitch.sunSmTreeProp
        }
	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4u:keyswitch.sunSmNodeName
	}
#	fan_status = { [ use STRING MANAGED-PROPERTY ]
#		mediumDesc        =  Fan Status 
#	}
	position = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Position 
		consoleHint:mediumDesc = base.modules.Config-Reader4u:keyswitch.position
	}
}

# peripheral_PS information

peripheral_PS = { [ use MANAGED-OBJECT]
	consoleHint:mediumDesc = base.modules.Config-Reader4u:peripheral_PS

peripheral_PSTbl = { [ use MANAGED-OBJECT-TABLE ]

	mediumDesc = Peripheral PS Table
	consoleHint:mediumDesc = base.modules.Config-Reader4u:peripheral_PS.peripheral_PSTbl

        peripheral_PS-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.Config-Reader4u:peripheral_PS.peripheral_PSTbl.peripheral_PS-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  Tree Prop
			consoleHint:mediumDesc = base.modules.Config-Reader4u:peripheral_PS.peripheral_PSTbl.peripheral_PS-entry.sunSmTreeProp
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
			consoleHint:mediumDesc = base.modules.Config-Reader4u:peripheral_PS.peripheral_PSTbl.peripheral_PS-entry.sunSmNodeName
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  Entry Number  
			consoleHint:mediumDesc = base.modules.Config-Reader4u:peripheral_PS.peripheral_PSTbl.peripheral_PS-entry.entry_no
		}
		fru = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Fru
			consoleHint:mediumDesc = base.modules.Config-Reader4u:peripheral_PS.peripheral_PSTbl.peripheral_PS-entry.fru
		}
		hpu = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Hpu
			consoleHint:mediumDesc = base.modules.Config-Reader4u:peripheral_PS.peripheral_PSTbl.peripheral_PS-entry.hpu
		}
		status = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Status
			consoleHint:mediumDesc = base.modules.Config-Reader4u:peripheral_PS.peripheral_PSTbl.peripheral_PS-entry.status
		}
		unit_no = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Unit No
			consoleHint:mediumDesc = base.modules.Config-Reader4u:peripheral_PS.peripheral_PSTbl.peripheral_PS-entry.unit_no
		}
	}
}
}


# power_supply information

power_supply = { [ use MANAGED-OBJECT]
	consoleHint:mediumDesc = base.modules.Config-Reader4u:power_supply

power_supplyTbl = { [ use MANAGED-OBJECT-TABLE ]

	mediumDesc = Power Supply Table
	consoleHint:mediumDesc = base.modules.Config-Reader4u:power_supply.power_supplyTbl

        power_supply-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.Config-Reader4u:power_supply.power_supplyTbl.power_supply-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  Tree Prop
			consoleHint:mediumDesc = base.modules.Config-Reader4u:power_supply.power_supplyTbl.power_supply-entry.sunSmTreeProp
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
			consoleHint:mediumDesc = base.modules.Config-Reader4u:power_supply.power_supplyTbl.power_supply-entry.sunSmNodeName
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  Entry Number  
			consoleHint:mediumDesc = base.modules.Config-Reader4u:power_supply.power_supplyTbl.power_supply-entry.entry_no
		}
		fru = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Fru
			consoleHint:mediumDesc = base.modules.Config-Reader4u:power_supply.power_supplyTbl.power_supply-entry.fru
		}
		hpu = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Hpu
			consoleHint:mediumDesc = base.modules.Config-Reader4u:power_supply.power_supplyTbl.power_supply-entry.hpu
		}
		status = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
			mediumDesc        = Status
			consoleHint:mediumDesc = base.modules.Config-Reader4u:power_supply.power_supplyTbl.power_supply-entry.status
			alarmRules        =  rcr4u203
		}
		unit_no = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Unit No
			consoleHint:mediumDesc = base.modules.Config-Reader4u:power_supply.power_supplyTbl.power_supply-entry.unit_no
		}
	}
}
}

rack_fan = { [ use MANAGED-OBJECT ]

	mediumDesc = Rack Fan 
	consoleHint:mediumDesc = base.modules.Config-Reader4u:rack_fan

	sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
                mediumDesc        =  tree prop
		consoleHint:mediumDesc = base.modules.Config-Reader4u:rack_fan.sunSmTreeProp
        }
	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4u:rack_fan.sunSmNodeName
	}
	status = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Status 
		consoleHint:mediumDesc = base.modules.Config-Reader4u:rack_fan.status
	}
}


disk_fan = { [ use MANAGED-OBJECT ]

	consoleHint:hidden = true
	mediumDesc = Disk Fan 
	consoleHint:mediumDesc = base.modules.Config-Reader4u:disk_fan

	sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
                mediumDesc        =  tree prop
		consoleHint:mediumDesc = base.modules.Config-Reader4u:disk_fan.sunSmTreeProp
        }
	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4u:disk_fan.sunSmNodeName
	}
	hpu = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Hpu 
		consoleHint:mediumDesc = base.modules.Config-Reader4u:disk_fan.hpu
	}
	status = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Status 
		consoleHint:mediumDesc = base.modules.Config-Reader4u:disk_fan.status
	}
}

remote_console = { [ use MANAGED-OBJECT ]

	mediumDesc = Remote Console 
	consoleHint:mediumDesc = base.modules.Config-Reader4u:remote_console

	sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
                mediumDesc        =  tree prop
		consoleHint:mediumDesc = base.modules.Config-Reader4u:remote_console.sunSmTreeProp
        }
	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4u:remote_console.sunSmNodeName
	}
	status = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Status 
		consoleHint:mediumDesc = base.modules.Config-Reader4u:remote_console.status
	}
}

# fhc information

fhc = { [ use MANAGED-OBJECT ]
	consoleHint:mediumDesc = base.modules.Config-Reader4u:fhc

fhcTbl = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Fhc 
	consoleHint:mediumDesc = base.modules.Config-Reader4u:fhc.fhcTbl


        fhc-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.Config-Reader4u:fhc.fhcTbl.fhc-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  Tree Prop
			consoleHint:mediumDesc = base.modules.Config-Reader4u:fhc.fhcTbl.fhc-entry.sunSmTreeProp
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
			consoleHint:mediumDesc = base.modules.Config-Reader4u:fhc.fhcTbl.fhc-entry.sunSmNodeName
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
			consoleHint:mediumDesc = base.modules.Config-Reader4u:fhc.fhcTbl.fhc-entry.entry_no
		}
		board_num = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Board Num
			consoleHint:mediumDesc = base.modules.Config-Reader4u:fhc.fhcTbl.fhc-entry.board_num
		}
		model = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Model
			consoleHint:mediumDesc = base.modules.Config-Reader4u:fhc.fhcTbl.fhc-entry.model
		}
		reg = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        = Reg
			consoleHint:mediumDesc = base.modules.Config-Reader4u:fhc.fhcTbl.fhc-entry.reg
		}
		upa-mid = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Upa Mid
			consoleHint:mediumDesc = base.modules.Config-Reader4u:fhc.fhcTbl.fhc-entry.upa-mid
		}
		version_no = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Version No
			consoleHint:mediumDesc = base.modules.Config-Reader4u:fhc.fhcTbl.fhc-entry.version_no
		}
	}
}
}

# ac information

ac = { [ use MANAGED-OBJECT]
	consoleHint:mediumDesc = base.modules.Config-Reader4u:ac

acTbl = { [ use MANAGED-OBJECT-TABLE ]

	mediumDesc = Ac Table
	consoleHint:mediumDesc = base.modules.Config-Reader4u:ac.acTbl

        ac-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.Config-Reader4u:ac.acTbl.ac-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
			consoleHint:mediumDesc = base.modules.Config-Reader4u:ac.acTbl.ac-entry.sunSmTreeProp
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
			consoleHint:mediumDesc = base.modules.Config-Reader4u:ac.acTbl.ac-entry.sunSmNodeName
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
			consoleHint:mediumDesc = base.modules.Config-Reader4u:ac.acTbl.ac-entry.entry_no
		}
		bank-0-status = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
			mediumDesc        = Bank0 Status
			alarmRules        =  rcr4u218
			consoleHint:mediumDesc = base.modules.Config-Reader4u:ac.acTbl.ac-entry.bank-0-status
		}
		bank-1-status = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Bank1 Status
			consoleHint:mediumDesc = base.modules.Config-Reader4u:ac.acTbl.ac-entry.bank-1-status
		}
		device_type = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Device Type
			consoleHint:mediumDesc = base.modules.Config-Reader4u:ac.acTbl.ac-entry.device_type
		}
		model = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Model
			consoleHint:mediumDesc = base.modules.Config-Reader4u:ac.acTbl.ac-entry.model
		}
		pv_ancestor_alarm = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        = Pv Ancestor Alarm
			consoleHint:mediumDesc = base.modules.Config-Reader4u:ac.acTbl.ac-entry.pv_ancestor_alarm
		}
		reg = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        = Reg
			consoleHint:mediumDesc = base.modules.Config-Reader4u:ac.acTbl.ac-entry.reg
		}
		version_no = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Version No
			consoleHint:mediumDesc = base.modules.Config-Reader4u:ac.acTbl.ac-entry.version_no
		}
	}
}
}

# environ information

environment = { [ use MANAGED-OBJECT]
	consoleHint:mediumDesc = base.modules.Config-Reader4u:environment
	consoleHint:hidden = true

environmentTbl = { [ use MANAGED-OBJECT-TABLE ]

	mediumDesc = Environment Table
	consoleHint:mediumDesc = base.modules.Config-Reader4u:environment.environmentTbl

        environment-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.Config-Reader4u:environment.environmentTbl.environment-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
			consoleHint:mediumDesc = base.modules.Config-Reader4u:environment.environmentTbl.environment-entry.sunSmTreeProp
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
			consoleHint:mediumDesc = base.modules.Config-Reader4u:environment.environmentTbl.environment-entry.sunSmNodeName
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
			consoleHint:mediumDesc = base.modules.Config-Reader4u:environment.environmentTbl.environment-entry.entry_no
		}
		reg = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        = Reg
			consoleHint:mediumDesc = base.modules.Config-Reader4u:environment.environmentTbl.environment-entry.reg
		}
	}
}
}

# environ information

environ = { [ use MANAGED-OBJECT ]
	consoleHint:mediumDesc = base.modules.Config-Reader4u:environ
	consoleHint:hidden = true

environTbl = { [ use MANAGED-OBJECT-TABLE ]

        mediumDesc = Environ Table
	consoleHint:mediumDesc = base.modules.Config-Reader4u:environ.environTbl

        environ-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.Config-Reader4u:environ.environTbl.environ-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
			consoleHint:mediumDesc = base.modules.Config-Reader4u:environ.environTbl.environ-entry.sunSmTreeProp
	        }
                sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  Name
			consoleHint:mediumDesc = base.modules.Config-Reader4u:environ.environTbl.environ-entry.sunSmNodeName
                }
                entry_no = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
                        mediumDesc        =  Entry number
			consoleHint:mediumDesc = base.modules.Config-Reader4u:environ.environTbl.environ-entry.entry_no
                }
                instance = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        = Instance
			consoleHint:mediumDesc = base.modules.Config-Reader4u:environ.environTbl.environ-entry.instance
                }
                reg = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        = Reg
			consoleHint:mediumDesc = base.modules.Config-Reader4u:environ.environTbl.environ-entry.reg
                }
        }
}
}


# flashprom information

flashprom = { [ use MANAGED-OBJECT ]
	consoleHint:mediumDesc = base.modules.Config-Reader4u:flashprom
	consoleHint:hidden = true

flashpromTbl = { [ use MANAGED-OBJECT-TABLE ]

	mediumDesc = Flashprom Table
	consoleHint:mediumDesc = base.modules.Config-Reader4u:flashprom.flashpromTbl

        flashprom-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.Config-Reader4u:flashprom.flashpromTbl.flashprom-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
			consoleHint:mediumDesc = base.modules.Config-Reader4u:flashprom.flashpromTbl.flashprom-entry.sunSmTreeProp
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
			consoleHint:mediumDesc = base.modules.Config-Reader4u:flashprom.flashpromTbl.flashprom-entry.sunSmNodeName
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
			consoleHint:mediumDesc = base.modules.Config-Reader4u:flashprom.flashpromTbl.flashprom-entry.entry_no
		}
		model = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Model
			consoleHint:mediumDesc = base.modules.Config-Reader4u:flashprom.flashpromTbl.flashprom-entry.model
		}
		reg = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        = Reg
			consoleHint:mediumDesc = base.modules.Config-Reader4u:flashprom.flashpromTbl.flashprom-entry.reg
		}
	}
}
}

# simmstat information

simmstat = { [ use MANAGED-OBJECT ]
	consoleHint:mediumDesc = base.modules.Config-Reader4u:simmstat
	consoleHint:hidden = true
simmstatTbl = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Simmstat Table
	consoleHint:mediumDesc = base.modules.Config-Reader4u:simmstat.simmstatTbl
        simmstat-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.Config-Reader4u:simmstat.simmstatTbl.simmstat-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
			consoleHint:mediumDesc = base.modules.Config-Reader4u:simmstat.simmstatTbl.simmstat-entry.sunSmTreeProp
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
			consoleHint:mediumDesc = base.modules.Config-Reader4u:simmstat.simmstatTbl.simmstat-entry.sunSmNodeName
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
			consoleHint:mediumDesc = base.modules.Config-Reader4u:simmstat.simmstatTbl.simmstat-entry.entry_no
		}
		instance = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Instance
			consoleHint:mediumDesc = base.modules.Config-Reader4u:simmstat.simmstatTbl.simmstat-entry.instance
		}
		reg = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        = Reg
			consoleHint:mediumDesc = base.modules.Config-Reader4u:simmstat.simmstatTbl.simmstat-entry.reg
		}
	}
}
}


# sram information

sram = { [ use MANAGED-OBJECT ]
	consoleHint:mediumDesc = base.modules.Config-Reader4u:sram
	consoleHint:hidden = true
sramTbl = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Sram Table
	consoleHint:mediumDesc = base.modules.Config-Reader4u:sram.sramTbl

        sram-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.Config-Reader4u:sram.sramTbl.sram-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  Tree Prop
			consoleHint:mediumDesc = base.modules.Config-Reader4u:sram.sramTbl.sram-entry.sunSmTreeProp
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
			consoleHint:mediumDesc = base.modules.Config-Reader4u:sram.sramTbl.sram-entry.sunSmNodeName
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
			consoleHint:mediumDesc = base.modules.Config-Reader4u:sram.sramTbl.sram-entry.entry_no
		}
		reg = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        = Reg
			consoleHint:mediumDesc = base.modules.Config-Reader4u:sram.sramTbl.sram-entry.reg
		}
	}
}
}


# sbus information

sbus = { [ use MANAGED-OBJECT ]
	mediumDesc = Sbus Object

sbusTbl = { [ use MANAGED-OBJECT-TABLE ]

	mediumDesc = Sbus Table

        sbus-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
		}
		clock-frequency = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Clock Frequency
		}
		board_num = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        = Board No
		}
		device_type = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        = Device Type
		}
		model = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Model
		}
		network_count = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Network Count
		}
		reg = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        = Reg
		}
		upa-mid = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        = Upa Mid
		}
		upa-portid = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        = Upa Portid
		}
		version_no = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        = Version No
		}
	}
}
}

# ba information

ba = { [ use MANAGED-OBJECT ]
	consoleHint:hidden = true

baTbl = { [ use MANAGED-OBJECT-TABLE ]

	mediumDesc = Ba Table

        ba-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
		}
		instance = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Instance
		}
		model = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Model
		}
		reg = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        = Reg
		}
	}
}
}


# soc information

soc = { [ use MANAGED-OBJECT ]
	mediumDesc = Soc Object

socTbl = { [ use MANAGED-OBJECT-TABLE ]

	mediumDesc = Soc Table

        soc-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
		}
		device_type = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        = Device Type
		}
		instance = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        = Instance
		}
		model = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Model
		}
		port-wwns = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Port Wwns
		}
		reg = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        = Reg
		}
		soc-fcode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Soc Fcode
		}
		soc-wwn = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Soc Wwn
		}
	}
}
}


# SUNWsocmod information

SUNWsocmod = { [ use MANAGED-OBJECT ]
	consoleHint:hidden = true

SUNWsocmodTbl = { [ use MANAGED-OBJECT-TABLE ]

	mediumDesc = SUNWsocmod Table


        SUNWsocmod-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
		}
	}
}
}


# SUNWhme
SUNWhme = { [ use MANAGED-OBJECT ]
	mediumDesc = SUNWhme Object

SUNWhmeTbl = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = SUNWhme Table


        SUNWhme-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
		}
	        device_type = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
       			mediumDesc        =  Device Type
       		}
	        ether = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Ether
       		}
	        inet = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Inet
       		}
	        dt_name = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Dt Name
       		}
	        reg = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
       			mediumDesc        =  Reg
       		}
	        pathname_element = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
       			mediumDesc        =  Pathname Element
       		}
	        symbol = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
       			mediumDesc        =  Symbol
       		}
	}
}
}


SUNWfas = { [ use MANAGED-OBJECT ]
	mediumDesc = SUNWfas Object

SUNWfasTbl = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = SUNWfas Table


        SUNWfas-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
		}
		device_type = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Device Type 
		}
		disk_count = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Disk Count 
		}
		reg = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  Reg 
		}
		tape_count = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Tape Count 
		}
	}
}
}


# SUNWpln information

SUNWpln = { [ use MANAGED-OBJECT ]
	mediumDesc = SUNWpln Object

SUNWplnTbl = { [ use MANAGED-OBJECT-TABLE ]

	mediumDesc = SUNWpln Table

        SUNWpln-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
		}
		device_type = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Device Type
		}
		disk_count = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Disk Count
		}
		instance = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        = Instance
		}
		status = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Status
		}
		unit_no = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Unit No
		}
	}
}
}


# disk  information

ssd    = { [ use MANAGED-OBJECT ]
	mediumDesc = Disk(ssd) Object

ssdTbl    = { [ use MANAGED-OBJECT-TABLE ]

	mediumDesc = Disk(ssd) Table

        ssd-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
		}
	        device_type = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Device Type
       		}
       		fru = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Fru
       		}
       		instance = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Instance
       		}
       		mounted_partitions = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        = Mounted Partitions
       		}
       		disk_name = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Disk Name
       		}
	}
}
}


# fas  information

fas    = { [ use MANAGED-OBJECT ]
	mediumDesc = Fas Object

fasTbl    = { [ use MANAGED-OBJECT-TABLE ]

	mediumDesc = Fas Table

        fas-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
		}
	        device_type = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Device Type
       		}
       		disk_count = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Disk Count
       		}
       		instance = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        = Instance
       		}
       		reg = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
       			mediumDesc        =  Reg
       		}
       		tape_count = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Tape Count
       		}
	}
}
}

# cdrom0  information

cdrom0    = { [ use MANAGED-OBJECT ]
	mediumDesc = CDrom Object

cdrom0Tbl    = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = CDrom Table

        cdrom0-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
		}
	        device_type = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Device Type
       		}
       		fru = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Fru
       		}
       		instance = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        = Instance
       		}
       		mounted_partitions = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Mounted Partitions
       		}
       		dev_name = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Dev Name
       		}
	}
}
}

# hme  information

hme    = { [ use MANAGED-OBJECT ]
	mediumDesc = Hme Object

hmeTbl    = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Hme Table

        hme-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
		}
	        device_type = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Device Type
       		}
	        ether = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Ether
       		}
	        inet = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Inet
       		}
	        instance = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Instance
       		}
#	        name = { [ use STRING MANAGED-PROPERTY ]
#       			mediumDesc        =  device_type
#       		}
	        pathname_element = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
       			mediumDesc        =  Pathname Element
       		}
	        symbol = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Symbol
       		}
	}
}
}

# isp  information

isp    = { [ use MANAGED-OBJECT ]
	consoleHint:hidden = true

ispTbl    = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Isp Table

        isp-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
		}
	        device_type = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Device Type
       		}
       		disk_count = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Disk Count
       		}
       		instance = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        = Instance
       		}
       		model = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Model
       		}
       		reg = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
       			mediumDesc        =  Reg
       		}
       		tape_count = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Tape Count
       		}
	}
}
}


# st  information

st    = { [ use MANAGED-OBJECT ]
	mediumDesc = St Object

stTbl    = { [ use MANAGED-OBJECT-TABLE ]

	mediumDesc = St Table

        st-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
		}
	        device_type = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Device Type
       		}
       		fru = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Fru
       		}
       		model = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        = Model
       		}
       		tape_name = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Tape Name
       		}
       		status = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
       			mediumDesc        =  Status
			alarmRules        =  rcr4u225
       		}
	}
}
}



# led  information

led    = { [ use MANAGED-OBJECT ]
	consoleHint:mediumDesc = base.modules.Config-Reader4u:led
	consoleHint:hidden = true

ledTbl    = { [ use MANAGED-OBJECT-TABLE ]

	mediumDesc = Led Table
	consoleHint:mediumDesc = base.modules.Config-Reader4u:led.ledTbl

        led-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.Config-Reader4u:led.ledTbl.led-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
			consoleHint:mediumDesc = base.modules.Config-Reader4u:led.ledTbl.led-entry.sunSmTreeProp
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
			consoleHint:mediumDesc = base.modules.Config-Reader4u:led.ledTbl.led-entry.sunSmNodeName
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
			consoleHint:mediumDesc = base.modules.Config-Reader4u:led.ledTbl.led-entry.entry_no
		}
       		led-num = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Led No
			consoleHint:mediumDesc = base.modules.Config-Reader4u:led.ledTbl.led-entry.led-num 
       		}
       		state = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  State
			consoleHint:mediumDesc = base.modules.Config-Reader4u:led.ledTbl.led-entry.state
       		}
	}
}
}


# central  information

central    = { [ use MANAGED-OBJECT ]
	consoleHint:hidden = true
	consoleHint:mediumDesc = base.modules.Config-Reader4u:central

centralTbl    = { [ use MANAGED-OBJECT-TABLE ]

	mediumDesc = Central Table
	consoleHint:mediumDesc = base.modules.Config-Reader4u:central.centralTbl

        central-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.Config-Reader4u:central.centralTbl.central-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
			consoleHint:mediumDesc = base.modules.Config-Reader4u:central.centralTbl.central-entry.sunSmTreeProp
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
			consoleHint:mediumDesc = base.modules.Config-Reader4u:central.centralTbl.central-entry.sunSmNodeName
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
			consoleHint:mediumDesc = base.modules.Config-Reader4u:central.centralTbl.central-entry.entry_no
		}
       		reg = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
       			mediumDesc        =  Reg
			consoleHint:mediumDesc = base.modules.Config-Reader4u:central.centralTbl.central-entry.reg
       		}
       		upa-mid = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Upa Mid
			consoleHint:mediumDesc = base.modules.Config-Reader4u:central.centralTbl.central-entry.upa-mid
       		}
	}
}
}

# eeprom  information

eeprom    = { [ use MANAGED-OBJECT ]
	consoleHint:hidden = true
	consoleHint:mediumDesc = base.modules.Config-Reader4u:eeprom

eepromTbl    = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Eeprom Table
	consoleHint:mediumDesc = base.modules.Config-Reader4u:eeprom.eepromTbl

        eeprom-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.Config-Reader4u:eeprom.eepromTbl.eeprom-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
			consoleHint:mediumDesc = base.modules.Config-Reader4u:eeprom.eepromTbl.eeprom-entry.sunSmTreeProp
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
			consoleHint:mediumDesc = base.modules.Config-Reader4u:eeprom.eepromTbl.eeprom-entry.sunSmNodeName
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
			consoleHint:mediumDesc = base.modules.Config-Reader4u:eeprom.eepromTbl.eeprom-entry.entry_no
		}
	        model = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Model
			consoleHint:mediumDesc = base.modules.Config-Reader4u:eeprom.eepromTbl.eeprom-entry.model
       		}
       		reg = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	       		mediumDesc        =  Reg
			consoleHint:mediumDesc = base.modules.Config-Reader4u:eeprom.eepromTbl.eeprom-entry.reg
       		}
	}
}
}



# sysctrl  information

sysctrl    = { [ use MANAGED-OBJECT ]
	consoleHint:mediumDesc = base.modules.Config-Reader4u:sysctrl
	consoleHint:hidden = true

sysctrlTbl    = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Sysctrl Table
	consoleHint:mediumDesc = base.modules.Config-Reader4u:sysctrl.sysctrlTbl

        sysctrl-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.Config-Reader4u:sysctrl.sysctrlTbl.sysctrl-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
			consoleHint:mediumDesc = base.modules.Config-Reader4u:sysctrl.sysctrlTbl.sysctrl-entry.sunSmTreeProp
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
			consoleHint:mediumDesc = base.modules.Config-Reader4u:sysctrl.sysctrlTbl.sysctrl-entry.sunSmNodeName
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
			consoleHint:mediumDesc = base.modules.Config-Reader4u:sysctrl.sysctrlTbl.sysctrl-entry.entry_no
		}
	        instance = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Instance
			consoleHint:mediumDesc = base.modules.Config-Reader4u:sysctrl.sysctrlTbl.sysctrl-entry.instance
       		}
       		reg = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	       		mediumDesc        =  Reg
			consoleHint:mediumDesc = base.modules.Config-Reader4u:sysctrl.sysctrlTbl.sysctrl-entry.reg
       		}
	}
}
}


# cgsix  information

cgsix    = { [ use MANAGED-OBJECT ]
	consoleHint:hidden = true

cgsixTbl    = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Cgsix Table

        cgsix-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  Tree Prop
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
		}
	        device_type = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Device Type
       		}
       		height = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Height
       		}
       		model = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Model
       		}
       		reg = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
       			mediumDesc        =  Reg
       		}
       		width = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Width
       		}
	}
}
}

# socal  information

socal    = { [ use MANAGED-OBJECT ]
	mediumDesc = Socal Object

socalTbl    = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Socal Table

        socal-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
		}
	        device_type = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Device Type
       		}
       		instance = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Instance
       		}
       		model = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Model
       		}
       		reg = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
       			mediumDesc        =  Reg
       		}
	}
}
}

# sf  information

sf    = { [ use MANAGED-OBJECT ]
	mediumDesc = Sf Object

sfTbl    = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Sf Table

        sf-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
		}
	        device_type = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Device Type
       		}
       		disk_count = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Disk Count
       		}
       		instance = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
       			mediumDesc        =  Instance
       		}
       		port-wwn = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Port Wwn
       		}
       		reg = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
       			mediumDesc        =  Reg
       		}
       		slot-num = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Slot No
       		}
	}
}
}



# fan  information

fan    = { [ use MANAGED-OBJECT ]
	consoleHint:mediumDesc = base.modules.Config-Reader4u:fan

fanTbl    = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Fan Table
	consoleHint:mediumDesc = base.modules.Config-Reader4u:fan.fanTbl

        fan-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.Config-Reader4u:fan.fanTbl.fan-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
			consoleHint:mediumDesc = base.modules.Config-Reader4u:fan.fanTbl.fan-entry.sunSmTreeProp
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
			consoleHint:mediumDesc = base.modules.Config-Reader4u:fan.fanTbl.fan-entry.sunSmNodeName
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
			consoleHint:mediumDesc = base.modules.Config-Reader4u:fan.fanTbl.fan-entry.entry_no
		}
       		status = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
       			mediumDesc        =  Status
			alarmRules        =  rcr4u204
			consoleHint:mediumDesc = base.modules.Config-Reader4u:fan.fanTbl.fan-entry.status
       		}
	}
}
}


# disks information

#disk    = { [ use MANAGED-OBJECT-TABLE ]
#	mediumDesc = Disk Table
#
#        disk-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
#                index = entry_no
#
#		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
#			consoleHint:hidden = true
#	                mediumDesc        =  tree prop
#	        }
#		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
#			mediumDesc        =  Name
#		}
##		entry_no = { [ use INT MANAGED-PROPERTY ]
#			consoleHint:hidden = true
#			mediumDesc        =  entry number  
#		}
#       		scsi-target-id = { [ use STRING MANAGED-PROPERTY ]
#       			mediumDesc        =  SCSI Target Id
#       		}
#	}
#}
#
memory    = { [ use MANAGED-OBJECT ]
	consoleHint:mediumDesc = base.modules.Config-Reader4u:memory
	consoleHint:hidden = true

memoryTbl    = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Memory Table
	consoleHint:mediumDesc = base.modules.Config-Reader4u:memory.memoryTbl

        memory-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.Config-Reader4u:memory.memoryTbl.memory-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
			consoleHint:mediumDesc = base.modules.Config-Reader4u:memory.memoryTbl.memory-entry.sunSmTreeProp
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
			consoleHint:mediumDesc = base.modules.Config-Reader4u:memory.memoryTbl.memory-entry.sunSmNodeName
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
			consoleHint:mediumDesc = base.modules.Config-Reader4u:memory.memoryTbl.memory-entry.entry_no
		}
       		pathname_element = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
       			mediumDesc        =  Pathname Element
			consoleHint:mediumDesc = base.modules.Config-Reader4u:memory.memoryTbl.memory-entry.pathname_element
       		}
	}
}
}



# SUNWsoc information

SUNWsoc = { [ use MANAGED-OBJECT ]
	mediumDesc = SUNWsoc Object

SUNWsocTbl = { [ use MANAGED-OBJECT-TABLE ]

	mediumDesc = SUNWsoc Table

        SUNWsoc-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
		}
		device_type = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Device Type
		}
		model = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Model
		}
		port-wwns = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Port Wwns
		}
		reg = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        = reg
		}
		soc-fcode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Soc Fcode
		}
		soc-wwn = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Soc Wwn
		}
	}
}
}




# sbus-speed information

sbus-speed = { [ use MANAGED-OBJECT ]
	consoleHint:hidden = true

sbus-speedTbl = { [ use MANAGED-OBJECT-TABLE ]

	mediumDesc = Sbus-speed Table

        sbus-speed-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
		}
		reg = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        = Reg
		}
	}
}
}


# simm-status information

simm-status = { [ use MANAGED-OBJECT ]
	consoleHint:mediumDesc = base.modules.Config-Reader4u:simm-status
	consoleHint:hidden = true

simm-statusTbl = { [ use MANAGED-OBJECT-TABLE ]

	mediumDesc = Simm-status Table
	consoleHint:mediumDesc = base.modules.Config-Reader4u:simm-status.simm-statusTbl


        simm-status-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.Config-Reader4u:simm-status.simm-statusTbl.simm-status-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
			consoleHint:mediumDesc = base.modules.Config-Reader4u:simm-status.simm-statusTbl.simm-status-entry.sunSmTreeProp
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
			consoleHint:mediumDesc = base.modules.Config-Reader4u:simm-status.simm-statusTbl.simm-status-entry.sunSmNodeName
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
			consoleHint:mediumDesc = base.modules.Config-Reader4u:simm-status.simm-statusTbl.simm-status-entry.entry_no
		}
		reg = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        = Reg
			consoleHint:mediumDesc = base.modules.Config-Reader4u:simm-status.simm-statusTbl.simm-status-entry.reg
		}
	}
}
}


# simm-group information

simm-group = { [ use MANAGED-OBJECT ]
	consoleHint:mediumDesc = base.modules.Config-Reader4u:simm-group
	consoleHint:hidden = true

simm-groupTbl = { [ use MANAGED-OBJECT-TABLE ]

	mediumDesc = Simm-group Table
	consoleHint:mediumDesc = base.modules.Config-Reader4u:simm-group.simm-groupTbl


        simm-group-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.Config-Reader4u:simm-group.simm-groupTbl.simm-group-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
			consoleHint:mediumDesc = base.modules.Config-Reader4u:simm-group.simm-groupTbl.simm-group-entry.sunSmTreeProp
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
			consoleHint:mediumDesc = base.modules.Config-Reader4u:simm-group.simm-groupTbl.simm-group-entry.sunSmNodeName
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
			consoleHint:mediumDesc = base.modules.Config-Reader4u:simm-group.simm-groupTbl.simm-group-entry.entry_no
		}
		device_type = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Device Type
			consoleHint:mediumDesc = base.modules.Config-Reader4u:simm-group.simm-groupTbl.simm-group-entry.device_type
		}
		group_no = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Group No
			consoleHint:mediumDesc = base.modules.Config-Reader4u:simm-group.simm-groupTbl.simm-group-entry.group_no
		}
		size = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Size
			consoleHint:mediumDesc = base.modules.Config-Reader4u:simm-group.simm-groupTbl.simm-group-entry.size
		}
		status = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        = Status
			consoleHint:mediumDesc = base.modules.Config-Reader4u:simm-group.simm-groupTbl.simm-group-entry.status
		}
	}
}
}
# isp  information

QLGCisp    = { [ use MANAGED-OBJECT ]
	consoleHint:hidden = true

QLGCispTbl    = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = QLGCisp Table

        QLGCisp-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
		}
	        device_type = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Device Type
       		}
       		disk_count = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Disk Count
       		}
       		model = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Model
       		}
       		reg = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
       			mediumDesc        =  Reg
       		}
       		tape_count = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Tape Count
       		}
	}
}
}



# audiocs  information

audiocs    = { [ use MANAGED-OBJECT ]
	consoleHint:hidden = true

audiocsTbl    = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Audiocs Table

        audiocs-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
		}
	        device_type = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Device Type
       		}
       		instance = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Instance
       		}
       		pathname_element = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
       			mediumDesc        =  Pathname Element
       		}
	}
}
}



# bpp  information

bpp    = { [ use MANAGED-OBJECT ]
	consoleHint:hidden = true

bppTbl    = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Bpp Table

        bpp-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
		}
       		instance = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Instance
       		}
       		pathname_element = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
       			mediumDesc        =  Pathname Element
       		}
	}
}
}


# fd  information

fd    = { [ use MANAGED-OBJECT ]
	mediumDesc = Fd Object

fdTbl    = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Fd Table

        fd-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
		}
       		device_type = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Device Type
       		}
       		fru = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Fru
       		}
       		instance = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Instance
       		}
       		pathname_element = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	       		mediumDesc        =  Pathname Element
       		}
       		status = { [ use STRING MANAGED-PROPERTY ]
       			mediumDesc        =  Status
       		}
	}
}
}


sbus-slot    = { [ use MANAGED-OBJECT ]
	mediumDesc = Sbus-Slot Object

sbus-slotTbl    = { [ use MANAGED-OBJECT-TABLE ]

	mediumDesc = Sbus-Slot Table

        sbus-slot-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
		}
       		slot-num = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Slot No
       		}
	}
}
}

sbus-board    = { [ use MANAGED-OBJECT ]
	mediumDesc = Sbus-Board Object

sbus-boardTbl    = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Sbus-Board Table

        sbus-board-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
		}
       		board-num = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Board No
       		}
       		fru = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Fru
       		}
       		model = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Model
       		}
       		state = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  State
       		}
       		type = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Type
       		}
	}
}
}

ffb    = { [ use MANAGED-OBJECT ]
	consoleHint:mediumDesc = base.modules.Config-Reader4u:ffb
	consoleHint:hidden = true

ffbTbl    = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Ffb Table
	consoleHint:mediumDesc = base.modules.Config-Reader4u:ffb.ffbTbl

        ffb-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.Config-Reader4u:ffb.ffbTbl.ffb-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
			consoleHint:mediumDesc = base.modules.Config-Reader4u:ffb.ffbTbl.ffb-entry.sunSmTreeProp
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
			consoleHint:mediumDesc = base.modules.Config-Reader4u:ffb.ffbTbl.ffb-entry.sunSmNodeName
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
			consoleHint:mediumDesc = base.modules.Config-Reader4u:ffb.ffbTbl.ffb-entry.entry_no
		}
       	 	buffer	= { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Buffer Type
			consoleHint:mediumDesc = base.modules.Config-Reader4u:ffb.ffbTbl.ffb-entry.buffer
       		}
       		device_type = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Device Type
			consoleHint:mediumDesc = base.modules.Config-Reader4u:ffb.ffbTbl.ffb-entry.device_type
		}
       		model = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Model
			consoleHint:mediumDesc = base.modules.Config-Reader4u:ffb.ffbTbl.ffb-entry.model
       		}
       		pathname_element = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	       		mediumDesc        =  Pathname Element
			consoleHint:mediumDesc = base.modules.Config-Reader4u:ffb.ffbTbl.ffb-entry.pathname_element
       		}
	}
}
}


SUNWffb    = { [ use MANAGED-OBJECT ]
	consoleHint:hidden = true
	consoleHint:mediumDesc = base.modules.Config-Reader4u:SUNWffb

SUNWffbTbl    = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = SUNWffb Table
	consoleHint:mediumDesc = base.modules.Config-Reader4u:SUNWffb.SUNWffbTbl

        SUNWffb-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.Config-Reader4u:SUNWffb.SUNWffbTbl.SUNWffb-entry

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
			consoleHint:mediumDesc = base.modules.Config-Reader4u:SUNWffb.SUNWffbTbl.SUNWffb-entry.sunSmTreeProp
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
			consoleHint:mediumDesc = base.modules.Config-Reader4u:SUNWffb.SUNWffbTbl.SUNWffb-entry.sunSmNodeName
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
			consoleHint:mediumDesc = base.modules.Config-Reader4u:SUNWffb.SUNWffbTbl.SUNWffb-entry.entry_no
		}
       		3DRAM = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  3DRAM
			consoleHint:mediumDesc = base.modules.Config-Reader4u:SUNWffb.SUNWffbTbl.SUNWffb-entry.3DRAM
       		}
       		DAC = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  DAC
			consoleHint:mediumDesc = base.modules.Config-Reader4u:SUNWffb.SUNWffbTbl.SUNWffb-entry.DAC
       		}
       		FBC_version = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  FBC Version
			consoleHint:mediumDesc = base.modules.Config-Reader4u:SUNWffb.SUNWffbTbl.SUNWffb-entry.FBC_version
       		}
       		board_type = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Board Type
			consoleHint:mediumDesc = base.modules.Config-Reader4u:SUNWffb.SUNWffbTbl.SUNWffb-entry.board_type
       		}
       		buffer = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Buffer
			consoleHint:mediumDesc = base.modules.Config-Reader4u:SUNWffb.SUNWffbTbl.SUNWffb-entry.buffer
       		}
       		device_type = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Device Type
			consoleHint:mediumDesc = base.modules.Config-Reader4u:SUNWffb.SUNWffbTbl.SUNWffb-entry.device_type
       		}
       		height = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Height
			consoleHint:mediumDesc = base.modules.Config-Reader4u:SUNWffb.SUNWffbTbl.SUNWffb-entry.height
       		}
       		model = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Model
			consoleHint:mediumDesc = base.modules.Config-Reader4u:SUNWffb.SUNWffbTbl.SUNWffb-entry.model
       		}
       		revision = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Revision
			consoleHint:mediumDesc = base.modules.Config-Reader4u:SUNWffb.SUNWffbTbl.SUNWffb-entry.revision
       		}
       		upa-portid = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Upa Portid
			consoleHint:mediumDesc = base.modules.Config-Reader4u:SUNWffb.SUNWffbTbl.SUNWffb-entry.upa-portid
       		}
       		width = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Width
			consoleHint:mediumDesc = base.modules.Config-Reader4u:SUNWffb.SUNWffbTbl.SUNWffb-entry.width
       		}
	}
}
}

pci    = { [ use MANAGED-OBJECT ]
	mediumDesc = Pci Object

pciTbl    = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Pci Table

        pci-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no

		sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	                mediumDesc        =  tree prop
	        }
		sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  Name
		}
		entry_no = { [ use INT MANAGED-PROPERTY ]
			consoleHint:hidden = true
			mediumDesc        =  entry number  
		}
       		compatible0 = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Compatible0
       		}
       		device_type = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Device Type
       		}
       		model = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Model
       		}
       		reg = { [ use STRING MANAGED-PROPERTY ]
			consoleHint:hidden = true
	       		mediumDesc        =  Reg
       		}
       		upa-mid = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Upa Mid
       		}
       		upa-portid = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Upa Portid
       		}
       		version = { [ use STRING MANAGED-PROPERTY ]
	       		mediumDesc        =  Version No
       		}
	}
}
}


hardware-rules = { [ use MANAGED-OBJECT ]

        mediumDesc = Hardware Rules
	consoleHint:hidden = true
	consoleHint:mediumDesc = base.modules.Config-Reader4u:hardware-rules

        rcr4u208 = { [ use RULE _rules MANAGED-PROPERTY ]
                mediumDesc        =  ECC Error
                alarmRules        = rcr4u208
		consoleHint:mediumDesc = base.modules.Config-Reader4u:hardware-rules.rcr4u208
        }

#        rcr4u209 = { [ use RULE _rules MANAGED-PROPERTY ]
#                mediumDesc        =  SIMM 
#                alarmRules        = rcr4u209
#		consoleHint:mediumDesc = base.modules.Config-Reader4u:hardware-rules.rcr4u209
#        }
        rcr4u210 = { [ use RULE _rules MANAGED-PROPERTY ]
                mediumDesc        =  Hardware Error
                alarmRules        = rcr4u210
		consoleHint:mediumDesc = base.modules.Config-Reader4u:hardware-rules.rcr4u210
        }
        rcr4u211 = { [ use RULE _rules MANAGED-PROPERTY ]
                mediumDesc        =  Fatal Error
                alarmRules        = rcr4u211
		consoleHint:mediumDesc = base.modules.Config-Reader4u:hardware-rules.rcr4u211
        }
 #       rcr4u212 = { [ use RULE _rules MANAGED-PROPERTY ]
 #               mediumDesc        =  CPU detects ECC error on SIMM
 #               alarmRules        = rcr4u212
 #		consoleHint:mediumDesc = base.modules.Config-Reader4u:hardware-rules.rcr4u212
 #       }
        rcr4u214 = { [ use RULE _rules MANAGED-PROPERTY ]
                mediumDesc        =   Power Failing
                alarmRules        = rcr4u214
		consoleHint:mediumDesc = base.modules.Config-Reader4u:hardware-rules.rcr4u214
        }
        rcr4u216 = { [ use RULE _rules MANAGED-PROPERTY ]
                mediumDesc        =   Cpu Panic
                alarmRules        = rcr4u216
		consoleHint:mediumDesc = base.modules.Config-Reader4u:hardware-rules.rcr4u216
        }
        rcr4u217 = { [ use RULE _rules MANAGED-PROPERTY ]
                mediumDesc        =  Scsi Tape Error
                alarmRules        = rcr4u217
		consoleHint:mediumDesc = base.modules.Config-Reader4u:hardware-rules.rcr4u217
        }
        rcr4u219 = { [ use RULE _rules MANAGED-PROPERTY ]
                mediumDesc        =  Disk Removed
                alarmRules        = rcr4u219
		consoleHint:mediumDesc = base.modules.Config-Reader4u:hardware-rules.rcr4u219
        }
        rcr4u220 = { [ use RULE _rules MANAGED-PROPERTY ]
                mediumDesc        =  Disk Insert
                alarmRules        = rcr4u220
		consoleHint:mediumDesc = base.modules.Config-Reader4u:hardware-rules.rcr4u220
        }
#        rcr4u222 = { [ use RULE _rules MANAGED-PROPERTY ]
#                mediumDesc        =  Testing Sunvts Messages Log
#                alarmRules        = rcr4u222
#		consoleHint:mediumDesc = base.modules.Config-Reader4u:hardware-rules.rcr4u222
#        }
#        rcr4u223 = { [ use RULE _rules MANAGED-PROPERTY ]
#                mediumDesc        =  Testing Sunvts Messages Log
#                alarmRules        = rcr4u223
#		consoleHint:mediumDesc = base.modules.Config-Reader4u:hardware-rules.rcr4u223
#        }
        rcr4u213 = { [ use RULE _rules MANAGED-PROPERTY ]
                mediumDesc        =  Hpu Removed
                alarmRules        = rcr4u213
		consoleHint:mediumDesc = base.modules.Config-Reader4u:hardware-rules.rcr4u213
        }
        rcr4u215 = { [ use RULE _rules MANAGED-PROPERTY ]
                mediumDesc        =  Hpu Hotplugged Into
                alarmRules        = rcr4u215
		consoleHint:mediumDesc = base.modules.Config-Reader4u:hardware-rules.rcr4u215
        }
        rcr4u224 = { [ use RULE _rules MANAGED-PROPERTY ]
                mediumDesc        =  Scsi Tapes
                alarmRules        = rcr4u224
		consoleHint:mediumDesc = base.modules.Config-Reader4u:hardware-rules.rcr4u224
        }
        rcr4u221 = { [ use RULE _rules MANAGED-PROPERTY ]
                mediumDesc        =  Redundant Power
                alarmRules        = rcr4u221
		consoleHint:mediumDesc = base.modules.Config-Reader4u:hardware-rules.rcr4u221
        }
}

pfa-rules = { [ use MANAGED-OBJECT ]

        mediumDesc = PFA Rules
	consoleHint:mediumDesc = base.modules.Config-Reader4u:pfa-rules

        rpfa300 = { [ use RULE _rules MANAGED-PROPERTY ]
                mediumDesc        =  PFA SIMM RULE
                alarmRules        = rpfa300
		consoleHint:mediumDesc = base.modules.Config-Reader4u:pfa-rules.rpfa300
        }

        rpfa301 = { [ use RULE _rules MANAGED-PROPERTY ]
                mediumDesc        =  PFA DISK RULE
                alarmRules        = rpfa301
		consoleHint:mediumDesc = base.modules.Config-Reader4u:pfa-rules.rpfa301
        }

        rpfa302 = { [ use RULE _rules MANAGED-PROPERTY ]
                mediumDesc        =  SMART/PFA DISK RULE
                alarmRules        = rpfa302
		consoleHint:mediumDesc = base.modules.Config-Reader4u:pfa-rules.rpfa302
        }
}

#
# io_controller information. These nodes are the nodes which head the
# IO device subtrees (currently sbus, pci, and sbi). These nodes are
# separated into a different table than io_device since controller nodes
# have a different generic set of properties.
#
io_controller = { [ use MANAGED-OBJECT ]
	consoleHint:mediumDesc = base.modules.Config-Reader4u:io_controller

io_controllerTbl = { [ use MANAGED-OBJECT-TABLE ]

        mediumDesc = IO Controllers Table
	consoleHint:mediumDesc = base.modules.Config-Reader4u:io_controller.io_controllerTbl

        io_controllerEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.Config-Reader4u:io_controller.io_controllerTbl.io_controllerEntry

                sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
                        consoleHint:hidden = true
                        mediumDesc        =  tree prop
			consoleHint:mediumDesc = base.modules.Config-Reader4u:io_controller.io_controllerTbl.io_controllerEntry.sunSmTreeProp
                }
                sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  Name
			consoleHint:mediumDesc = base.modules.Config-Reader4u:io_controller.io_controllerTbl.io_controllerEntry.sunSmNodeName
                }
                entry_no = { [ use INT MANAGED-PROPERTY ]
                        consoleHint:hidden = true
                        mediumDesc        =  entry number
			consoleHint:mediumDesc = base.modules.Config-Reader4u:io_controller.io_controllerTbl.io_controllerEntry.entry_no
                }

                board_num = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        = Board Number
			consoleHint:mediumDesc = base.modules.Config-Reader4u:io_controller.io_controllerTbl.io_controllerEntry.board_num
                }
                clock-frequency = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        = Clock Frequency
			consoleHint:mediumDesc = base.modules.Config-Reader4u:io_controller.io_controllerTbl.io_controllerEntry.clock-frequency
                }
                device_type = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        = Device Type
			consoleHint:mediumDesc = base.modules.Config-Reader4u:io_controller.io_controllerTbl.io_controllerEntry.device_type
                }
                instance = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        = Instance Number
			consoleHint:mediumDesc = base.modules.Config-Reader4u:io_controller.io_controllerTbl.io_controllerEntry.instance
                }
                model = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        = Model
			consoleHint:mediumDesc = base.modules.Config-Reader4u:io_controller.io_controllerTbl.io_controllerEntry.model
                }
                reg = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        = Reg
			consoleHint:mediumDesc = base.modules.Config-Reader4u:io_controller.io_controllerTbl.io_controllerEntry.reg
                }
                upa-mid = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        = UPA Mid
			consoleHint:mediumDesc = base.modules.Config-Reader4u:io_controller.io_controllerTbl.io_controllerEntry.upa-mid
                }
                upa-portid = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        = UPA Portid
			consoleHint:mediumDesc = base.modules.Config-Reader4u:io_controller.io_controllerTbl.io_controllerEntry.upa-portid
                }
                version_no = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        = Version Number
			consoleHint:mediumDesc = base.modules.Config-Reader4u:io_controller.io_controllerTbl.io_controllerEntry.version_no
                }
        }
}
}


#
# io_device information. These nodes are all those between {sbus,
# pci, sbi} and the leaf device nodes for disks, networks, and tapes.
# The properties listed here are a generic set of properties for these
# nodes. A particular node may have more properties, but we can only
# display the generic properties via SyMON.
#
io_device = { [ use MANAGED-OBJECT ]
	consoleHint:mediumDesc = base.modules.Config-Reader4u:io_device

io_deviceTbl = { [ use MANAGED-OBJECT-TABLE ]

        mediumDesc = IO Devices Table
	consoleHint:mediumDesc = base.modules.Config-Reader4u:io_device.io_deviceTbl

        io_deviceEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.Config-Reader4u:io_device.io_deviceTbl.io_deviceEntry

                sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
                        consoleHint:hidden = true
                        mediumDesc        =  tree prop
			consoleHint:mediumDesc = base.modules.Config-Reader4u:io_device.io_deviceTbl.io_deviceEntry.sunSmTreeProp
                }
                sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  Name
			consoleHint:mediumDesc = base.modules.Config-Reader4u:io_device.io_deviceTbl.io_deviceEntry.sunSmNodeName
                }
                entry_no = { [ use INT MANAGED-PROPERTY ]
                        consoleHint:hidden = true
                        mediumDesc        =  entry number
			consoleHint:mediumDesc = base.modules.Config-Reader4u:io_device.io_deviceTbl.io_deviceEntry.entry_no
                }

                device_type = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        = Device Type
			consoleHint:mediumDesc = base.modules.Config-Reader4u:io_device.io_deviceTbl.io_deviceEntry.device_type
                }
                disk_count = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        = Disk Count
			consoleHint:mediumDesc = base.modules.Config-Reader4u:io_device.io_deviceTbl.io_deviceEntry.disk_count
                }
                instance = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        = Instance Number
			consoleHint:mediumDesc = base.modules.Config-Reader4u:io_device.io_deviceTbl.io_deviceEntry.instance
                }
                model = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        = Model
			consoleHint:mediumDesc = base.modules.Config-Reader4u:io_device.io_deviceTbl.io_deviceEntry.model
                }
                node_hierarchy = { [ use STRING MANAGED-PROPERTY ]
                        consoleHint:hidden = true
                        mediumDesc        = Node Hierarchy
			consoleHint:mediumDesc = base.modules.Config-Reader4u:io_device.io_deviceTbl.io_deviceEntry.node_hierarchy
                }
                network_count = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        = Network Count
			consoleHint:mediumDesc = base.modules.Config-Reader4u:io_device.io_deviceTbl.io_deviceEntry.network_count
                }
                reg = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        = Reg
			consoleHint:mediumDesc = base.modules.Config-Reader4u:io_device.io_deviceTbl.io_deviceEntry.reg
                }
                tape_count = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        = Tape Count
			consoleHint:mediumDesc = base.modules.Config-Reader4u:io_device.io_deviceTbl.io_deviceEntry.tape_count
                }
        }
}
}

# disk  information

disk    = { [ use MANAGED-OBJECT ]
	consoleHint:mediumDesc = base.modules.Config-Reader4u:disk

diskTbl    = { [ use MANAGED-OBJECT-TABLE ]

        mediumDesc = Disk Devices Table
	consoleHint:mediumDesc = base.modules.Config-Reader4u:disk.diskTbl

        diskEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.Config-Reader4u:disk.diskTbl.diskEntry

                sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
                        consoleHint:hidden = true
                        mediumDesc        =  Tree Prop
			consoleHint:mediumDesc = base.modules.Config-Reader4u:disk.diskTbl.diskEntry.sunSmTreeProp
                }
                sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  Name
			consoleHint:mediumDesc = base.modules.Config-Reader4u:disk.diskTbl.diskEntry.sunSmNodeName
                }
                entry_no = { [ use INT MANAGED-PROPERTY ]
                        consoleHint:hidden = true
                        mediumDesc        =  Entry Number
			consoleHint:mediumDesc = base.modules.Config-Reader4u:disk.diskTbl.diskEntry.entry_no
                }

                device_type = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  Device Type
			consoleHint:mediumDesc = base.modules.Config-Reader4u:disk.diskTbl.diskEntry.device_type
                }
                disk_name = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  Disk Name
			consoleHint:mediumDesc = base.modules.Config-Reader4u:disk.diskTbl.diskEntry.disk_name
                }
                fru = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  Field Replaceable
			consoleHint:mediumDesc = base.modules.Config-Reader4u:disk.diskTbl.diskEntry.fru
                }
                instance = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        = Instance Number
			consoleHint:mediumDesc = base.modules.Config-Reader4u:disk.diskTbl.diskEntry.instance
                }
#                mounted_partitions = { [ use STRING MANAGED-PROPERTY ]
#                        mediumDesc        = Mounted Partitions
#			consoleHint:mediumDesc = base.modules.Config-Reader4u:disk.diskTbl.diskEntry.mounted_partitions
#                }
                node_hierarchy = { [ use STRING MANAGED-PROPERTY ]
                        consoleHint:hidden = true
                        mediumDesc        = Node Hierarchy
			consoleHint:mediumDesc = base.modules.Config-Reader4u:disk.diskTbl.diskEntry.node_hierarchy
                }
                target = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  Disk Target
			consoleHint:mediumDesc = base.modules.Config-Reader4u:disk.diskTbl.diskEntry.target
                }
        }
}
}


# tape  information
tape    = { [ use MANAGED-OBJECT ]
	consoleHint:mediumDesc = base.modules.Config-Reader4u:tape

tapeTbl    = { [ use MANAGED-OBJECT-TABLE ]
        mediumDesc = Tape Devices Table
	consoleHint:mediumDesc = base.modules.Config-Reader4u:tape.tapeTbl

        tapeEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.Config-Reader4u:tape.tapeTbl.tapeEntry

                sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
                        consoleHint:hidden = true
                        mediumDesc        =  tree prop
			consoleHint:mediumDesc = base.modules.Config-Reader4u:tape.tapeTbl.tapeEntry.sunSmTreeProp
                }
                sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  Name
			consoleHint:mediumDesc = base.modules.Config-Reader4u:tape.tapeTbl.tapeEntry.sunSmNodeName
                }
                entry_no = { [ use INT MANAGED-PROPERTY ]
                        consoleHint:hidden = true
                        mediumDesc        =  entry number
			consoleHint:mediumDesc = base.modules.Config-Reader4u:tape.tapeTbl.tapeEntry.entry_no
                }
                device_type = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  Device Type
			consoleHint:mediumDesc = base.modules.Config-Reader4u:tape.tapeTbl.tapeEntry.device_type
                }
                fru = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  Field Replaceable
			consoleHint:mediumDesc = base.modules.Config-Reader4u:tape.tapeTbl.tapeEntry.fru
                }
                instance = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        = Instance Number
			consoleHint:mediumDesc = base.modules.Config-Reader4u:tape.tapeTbl.tapeEntry.instance
                }
                model = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        = Model
			consoleHint:mediumDesc = base.modules.Config-Reader4u:tape.tapeTbl.tapeEntry.model
                }
                node_hierarchy = { [ use STRING MANAGED-PROPERTY ]
                        consoleHint:hidden = true
                        mediumDesc        = Node Hierarchy
			consoleHint:mediumDesc = base.modules.Config-Reader4u:tape.tapeTbl.tapeEntry.node_hierarchy
                }
                tape_name = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  Tape Name
			consoleHint:mediumDesc = base.modules.Config-Reader4u:tape.tapeTbl.tapeEntry.tape_name
                }
                status = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
                        mediumDesc        =  Status
			alarmRules        =  rcr4u225
			consoleHint:mediumDesc = base.modules.Config-Reader4u:tape.tapeTbl.tapeEntry.status
                }
                target = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  Tape Target
			consoleHint:mediumDesc = base.modules.Config-Reader4u:tape.tapeTbl.tapeEntry.target
                }
        }
}
}


# Network devices

network = { [ use MANAGED-OBJECT ]
	consoleHint:mediumDesc = base.modules.Config-Reader4u:network

networkTbl = { [ use MANAGED-OBJECT-TABLE ]
        mediumDesc = Network Devices Table
	consoleHint:mediumDesc = base.modules.Config-Reader4u:network.networkTbl
        networkEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.Config-Reader4u:network.networkTbl.networkEntry

                sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
                        consoleHint:hidden = true
                        mediumDesc        =  tree prop
			consoleHint:mediumDesc = base.modules.Config-Reader4u:network.networkTbl.networkEntry.sunSmTreeProp
                }
                sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  Name
			consoleHint:mediumDesc = base.modules.Config-Reader4u:network.networkTbl.networkEntry.sunSmNodeName
                }
                entry_no = { [ use INT MANAGED-PROPERTY ]
                        consoleHint:hidden = true
                        mediumDesc        =  entry number
			consoleHint:mediumDesc = base.modules.Config-Reader4u:network.networkTbl.networkEntry.entry_no
                }

                device_type = { [ use STRING MANAGED-PROPERTY ]
##                      consoleHint:hidden = true
                        mediumDesc        =  Device Type
			consoleHint:mediumDesc = base.modules.Config-Reader4u:network.networkTbl.networkEntry.device_type
                }
                ether = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  Ethernet Address
			consoleHint:mediumDesc = base.modules.Config-Reader4u:network.networkTbl.networkEntry.ether
                }
                inet = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  Internet Address
			consoleHint:mediumDesc = base.modules.Config-Reader4u:network.networkTbl.networkEntry.inet
                }
                interface_name = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  Interface Name
			consoleHint:mediumDesc = base.modules.Config-Reader4u:network.networkTbl.networkEntry.interface_name
                }
                node_hierarchy = { [ use STRING MANAGED-PROPERTY ]
                        consoleHint:hidden = true
                        mediumDesc        = Node Hierarchy
			consoleHint:mediumDesc = base.modules.Config-Reader4u:network.networkTbl.networkEntry.node_hierarchy
                }
                symbolic_name = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  Symbolic Name
			consoleHint:mediumDesc = base.modules.Config-Reader4u:network.networkTbl.networkEntry.symbolic_name
                }
                reg = { [ use STRING MANAGED-PROPERTY ]
                        consoleHint:hidden = true
                        mediumDesc        =  Reg
			consoleHint:mediumDesc = base.modules.Config-Reader4u:network.networkTbl.networkEntry.reg
                }
##              pathname_element = { [ use STRING MANAGED-PROPERTY ]
##                      consoleHint:hidden = true
##                              mediumDesc        =  Pathname Element
##                      }
        }
}
}

io-unit = { [ use MANAGED-OBJECT ]
	consoleHint:hidden = true
	consoleHint:mediumDesc = base.modules.Config-Reader4u:io-unit

io-unitTbl = { [ use MANAGED-OBJECT-TABLE ]
        mediumDesc = Io Unit
	consoleHint:mediumDesc = base.modules.Config-Reader4u:io-unit.io-unitTbl

        io-unitEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                index = entry_no
		consoleHint:mediumDesc = base.modules.Config-Reader4u:io-unit.io-unitTbl.io-unitEntry

                sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
                        consoleHint:hidden = true
                        mediumDesc        =  tree prop
			consoleHint:mediumDesc = base.modules.Config-Reader4u:io-unit.io-unitTbl.io-unitEntry.sunSmTreeProp
                }
                sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  Name
			consoleHint:mediumDesc = base.modules.Config-Reader4u:io-unit.io-unitTbl.io-unitEntry.sunSmNodeName
                }
                entry_no = { [ use INT MANAGED-PROPERTY ]
                        consoleHint:hidden = true
                        mediumDesc        =  entry number
			consoleHint:mediumDesc = base.modules.Config-Reader4u:io-unit.io-unitTbl.io-unitEntry.entry_no
                }

                board_num = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  Board Number 
			consoleHint:mediumDesc = base.modules.Config-Reader4u:io-unit.io-unitTbl.io-unitEntry.board_num
                }
                device-id = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  Device Id 
			consoleHint:mediumDesc = base.modules.Config-Reader4u:io-unit.io-unitTbl.io-unitEntry.device-id
                }
                instance = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  Instance 
			consoleHint:mediumDesc = base.modules.Config-Reader4u:io-unit.io-unitTbl.io-unitEntry.instance
                }
                reg = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  Reg 
			consoleHint:mediumDesc = base.modules.Config-Reader4u:io-unit.io-unitTbl.io-unitEntry.reg
                }
	}
}
}


[ load Config-Reader4u-ruleinit-d.x ]
[ load Config-Reader4u-ruletext-d.x ]


