/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.receptors.rmi;

import com.sun.symon.base.security.SySecurity;
import com.sun.symon.base.server.events.SvRequestListener;
import com.sun.symon.base.server.receptors.SrReceptor;
import com.sun.symon.base.server.receptors.rmi.RMIResponseInterface;
import com.sun.symon.base.server.receptors.rmi.RMIServer;
import com.sun.symon.base.server.receptors.rmi.RMIServerException;
import com.sun.symon.base.server.receptors.rmi.RMIServerSession;
import com.sun.symon.base.server.receptors.rmi.SrRMIHttpReceptor;
import com.sun.symon.base.server.receptors.rmi.SrRMISecurity;
import com.sun.symon.base.server.receptors.rmi.SrRMISession;
import com.sun.symon.base.utility.UcDDL;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Properties;

public class SrRMIReceptor
extends SrReceptor {
    private String RmiHost = null;
    private int RmiPort = -1;
    private SrRMIHttpReceptor ClassHandler = new SrRMIHttpReceptor();
    private SySecurity sySecurity;
    private SrRMISecurity Security = null;
    private String securityURL = null;
    private int securityFlag = -1;
    private String privateKey = null;
    private String publicId = "public";
    private String publicPassword = "public";
    private String privateId = "private";
    private String privatePassword = "maplesyrup";
    private String topologyHost = null;
    private int topologyPort = -1;
    private String configurationHost = null;
    private int configurationPort = -1;
    private String eventHost = null;
    private int eventPort = -1;
    private int sessionLimit = 0;
    private int numSessions = 0;
    private String imageSubpath = null;

    public SrRMIReceptor() throws RMIServerException {
        String string = this.ClassHandler.getCodeBase();
        Properties properties = System.getProperties();
        ((Hashtable)properties).put("java.rmi.server.codebase", string);
        System.setProperties(properties);
        UcDDL.logInfoMessage((String)("RMI HTTP server listening at codebase " + string));
        this.sySecurity = new SySecurity();
    }

    public void addSvRequestListener(SvRequestListener svRequestListener) {
        super.addSvRequestListener(svRequestListener);
        this.ClassHandler.addSvRequestListener(svRequestListener);
    }

    public synchronized void clientDied(SrRMISession srRMISession) {
        --this.numSessions;
        UcDDL.logDebugMessage((String)("client died ... numSessions=" + this.numSessions));
    }

    public String getConfigurationBaseURL() {
        String string = "";
        if (this.configurationHost != null && this.configurationPort != -1) {
            string = "snmp://" + this.configurationHost + ":" + this.configurationPort + "/";
        }
        return string;
    }

    public String getESDIR() {
        return System.getProperty("ESDIR");
    }

    public String getEventBaseURL() {
        String string = "";
        if (this.eventHost != null && this.eventPort != -1) {
            string = "snmp://" + this.eventHost + ":" + this.eventPort + "/";
        }
        return string;
    }

    public String getImageSubpath() {
        return this.imageSubpath;
    }

    public String getPrivateId() {
        return this.privateId;
    }

    public String getPrivatePassword() {
        return this.privatePassword;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getPublicPassword() {
        return this.publicPassword;
    }

    public String getTopologyBaseURL() {
        String string = "";
        if (this.topologyHost != null && this.topologyPort != -1) {
            string = "snmp://" + this.topologyHost + ":" + this.topologyPort + "/";
        }
        return string;
    }

    public void removeSvRequestListener(SvRequestListener svRequestListener) {
        super.removeSvRequestListener(svRequestListener);
        this.ClassHandler.removeSvRequestListener(svRequestListener);
    }

    private void restart() {
        if (this.RmiHost != null && this.RmiPort != -1 && this.securityURL != null && this.securityFlag != -1 && this.privateKey != null && this.privatePassword != null) {
            this.startServer();
        }
    }

    public void setConfigurationHost(String string) {
        block2: {
            this.configurationHost = string;
            if (this.configurationPort == -1) break block2;
            try {
                String string2 = InetAddress.getByName(this.configurationHost).getHostAddress();
                UcDDL.logInfoMessage((String)("configuration server host and port = " + this.configurationHost + " (" + string2 + ") port " + this.configurationPort));
            }
            catch (UnknownHostException unknownHostException) {}
        }
    }

    public void setConfigurationPort(int n) {
        block2: {
            this.configurationPort = n;
            if (this.configurationHost == null) break block2;
            try {
                String string = InetAddress.getByName(this.configurationHost).getHostAddress();
                UcDDL.logInfoMessage((String)("configuration server host and port = " + this.configurationHost + " (" + string + ") port " + this.configurationPort));
            }
            catch (UnknownHostException unknownHostException) {}
        }
    }

    public void setEnabledSecuritySchemes(String string) {
        this.sySecurity.keepSchemes(string);
    }

    public void setEventHost(String string) {
        block2: {
            this.eventHost = string;
            if (this.eventPort == -1) break block2;
            try {
                String string2 = InetAddress.getByName(this.eventHost).getHostAddress();
                UcDDL.logInfoMessage((String)("event manager host and port = " + this.eventHost + " (" + string2 + ") port " + this.eventPort));
            }
            catch (UnknownHostException unknownHostException) {}
        }
    }

    public void setEventPort(int n) {
        block2: {
            this.eventPort = n;
            if (this.eventHost == null) break block2;
            try {
                String string = InetAddress.getByName(this.eventHost).getHostAddress();
                UcDDL.logInfoMessage((String)("event manager host and port = " + this.eventHost + " (" + string + ") port " + this.eventPort));
            }
            catch (UnknownHostException unknownHostException) {}
        }
    }

    public void setImageSubpath(String string) {
        this.imageSubpath = string;
    }

    public void setPrivateId(String string) {
        this.privateId = string;
    }

    public void setPrivateKey(String string) {
        this.privateKey = string;
        this.restart();
    }

    public void setPrivatePassword(String string) {
        this.privatePassword = string;
    }

    public void setPublicId(String string) {
        this.publicId = string;
    }

    public void setPublicPassword(String string) {
        this.publicPassword = string;
    }

    public void setRmiHost(String string) {
        this.RmiHost = string;
        this.restart();
    }

    public void setRmiPort(int n) {
        this.RmiPort = n;
        this.restart();
    }

    public void setSecurityFlag(int n) {
        this.securityFlag = n;
        this.restart();
    }

    public void setSecurityURL(String string) {
        this.securityURL = string;
        this.restart();
    }

    public void setSessionLimit(int n) {
        this.sessionLimit = n;
    }

    public void setTopologyHost(String string) {
        block2: {
            this.topologyHost = string;
            if (this.topologyPort == -1) break block2;
            try {
                String string2 = InetAddress.getByName(this.topologyHost).getHostAddress();
                UcDDL.logInfoMessage((String)("topology agent host and port = " + this.topologyHost + " (" + string2 + ") port " + this.topologyPort));
            }
            catch (UnknownHostException unknownHostException) {}
        }
    }

    public void setTopologyPort(int n) {
        block2: {
            this.topologyPort = n;
            if (this.topologyHost == null) break block2;
            try {
                String string = InetAddress.getByName(this.topologyHost).getHostAddress();
                UcDDL.logInfoMessage((String)("topology agent host and port = " + this.topologyHost + " (" + string + ") port " + this.topologyPort));
            }
            catch (UnknownHostException unknownHostException) {}
        }
    }

    private void startServer() {
        try {
            new Server(this.RmiHost, this.RmiPort);
        }
        catch (RMIServerException rMIServerException) {
            UcDDL.logErrorMessage((String)("RMI host = " + this.RmiHost));
            UcDDL.logErrorMessage((String)("RMI port = " + this.RmiPort));
            UcDDL.logErrorMessage((String)"RMI init", (Throwable)rMIServerException);
        }
        if (this.securityURL.compareTo("") == 0) {
            this.securityURL = String.valueOf(this.getConfigurationBaseURL()) + "oid/1.3.6.1.4.1.42.2.12.2.2.34.1.0";
        }
        this.Security = this.securityFlag == 0 ? new SrRMISecurity(this, "", this.privatePassword) : new SrRMISecurity(this, this.securityURL, this.privatePassword);
        if (this.sessionLimit == 0) {
            String string = null;
            try {
                string = System.getProperty("NUM_FDS");
                int n = Integer.parseInt(string);
                this.sessionLimit = (n - 30) / 4;
                if (this.sessionLimit < 1) {
                    this.sessionLimit = 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                UcDDL.logErrorMessage((String)("can't parse NUM_FDS: '" + string + "'"), (Throwable)numberFormatException);
                this.sessionLimit = -1;
            }
        }
        UcDDL.logInfoMessage((String)("Number of client sessions that will be allowed to connect: " + (this.sessionLimit == -1 ? "unlimited" : String.valueOf(this.sessionLimit))));
    }

    private class Server
    extends RMIServer {
        Server(String string, int n) throws RMIServerException {
            super(string, n);
        }

        protected RMIServerSession newSessionInterface(RMIResponseInterface rMIResponseInterface) throws RemoteException {
            boolean bl;
            Object object = SrRMIReceptor.this;
            synchronized (object) {
                UcDDL.logDebugMessage((String)("sessionLimit=" + SrRMIReceptor.this.sessionLimit));
                UcDDL.logDebugMessage((String)("numSessions=" + SrRMIReceptor.this.numSessions));
                if (SrRMIReceptor.this.sessionLimit == -1 || SrRMIReceptor.this.numSessions < SrRMIReceptor.this.sessionLimit) {
                    SrRMIReceptor srRMIReceptor = SrRMIReceptor.this;
                    srRMIReceptor.numSessions = srRMIReceptor.numSessions + 1;
                    bl = true;
                } else {
                    bl = false;
                }
            }
            object = bl ? new SrRMISession(SrRMIReceptor.this.sySecurity, SrRMIReceptor.this, rMIResponseInterface, SrRMIReceptor.this.Security, SrRMIReceptor.this.privateKey) : null;
            return object;
        }
    }
}

