/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.utility;

import com.sun.symon.base.utility.UcDDLChannel;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public class UcDDL {
    private static Object lock = new Object();
    private static Vector chanList = new Vector();
    private static Hashtable chanHash = new Hashtable();
    private static final int MAX_NAME_LEN = 7;
    private static boolean DefaultEnabled = true;
    public static final int DDL_ERROR = UcDDL.createChannel("error");
    public static final int DDL_WARNING = UcDDL.createChannel("warning");
    public static final int DDL_INFO = UcDDL.createChannel("info");
    public static final int DDL_DEBUG = UcDDL.createChannel("debug");
    private static PrintWriter defaultStream = new PrintWriter(System.err, true);

    public static void channelActivate(int n, boolean bl) {
        Object object = lock;
        synchronized (object) {
            UcDDLChannel ucDDLChannel = (UcDDLChannel)chanList.elementAt(n);
            ucDDLChannel.enabled = bl;
        }
    }

    public static void channelActivate(String string, boolean bl) {
        Object object = lock;
        synchronized (object) {
            String string2 = UcDDL.channelNormalize(string);
            UcDDLChannel ucDDLChannel = (UcDDLChannel)chanHash.get(string2);
            if (ucDDLChannel == null) {
                UcDDL.createChannel(string, bl);
            } else {
                ucDDLChannel.enabled = bl;
            }
        }
    }

    public static void channelActivateList(String string) {
        UcDDL.channelActivateList(string, true);
    }

    public static void channelActivateList(String string, boolean bl) {
        boolean bl2;
        boolean bl3 = string.equals("*");
        if (bl3) {
            bl2 = true;
            bl = true;
        } else {
            bl2 = false;
        }
        Object object = lock;
        synchronized (object) {
            DefaultEnabled = bl3;
            if (bl) {
                int n = chanList.size();
                int n2 = 0;
                while (n2 < n) {
                    UcDDLChannel ucDDLChannel = (UcDDLChannel)chanList.elementAt(n2);
                    ucDDLChannel.enabled = bl2;
                    ++n2;
                }
            }
            if (!bl3) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    UcDDL.channelActivate(stringTokenizer.nextToken(), true);
                }
            }
        }
    }

    public static boolean channelIsActive(int n) {
        Object object = lock;
        synchronized (object) {
            UcDDLChannel ucDDLChannel = (UcDDLChannel)chanList.elementAt(n);
            boolean bl = ucDDLChannel.enabled;
            Object var3_4 = null;
            return bl;
        }
    }

    public static int channelLookup(String string) {
        Object object = lock;
        synchronized (object) {
            string = UcDDL.channelNormalize(string);
            UcDDLChannel ucDDLChannel = (UcDDLChannel)chanHash.get(string);
            if (ucDDLChannel == null) {
                int n = -1;
                Object var3_5 = null;
                return n;
            }
            int n = ucDDLChannel.index;
            Object var3_6 = null;
            return n;
        }
    }

    private static String channelNormalize(String string) {
        int n = string.length();
        if (n < 7) {
            int n2 = 7 - n;
            StringBuffer stringBuffer = new StringBuffer(7);
            stringBuffer.append(string);
            while (n2-- > 0) {
                stringBuffer.append(' ');
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static void channelSetDefaultStream(PrintWriter printWriter) {
        Object object = lock;
        synchronized (object) {
            if (defaultStream != null) {
                defaultStream = printWriter;
            }
        }
    }

    public static void channelSetStream(int n, PrintWriter printWriter) {
        Object object = lock;
        synchronized (object) {
            UcDDLChannel ucDDLChannel = (UcDDLChannel)chanList.elementAt(n);
            ucDDLChannel.stream = printWriter;
        }
    }

    public static void channelSetStream(String string, PrintWriter printWriter) {
        Object object = lock;
        synchronized (object) {
            String string2 = UcDDL.channelNormalize(string);
            UcDDLChannel ucDDLChannel = (UcDDLChannel)chanHash.get(string2);
            if (ucDDLChannel == null) {
                UcDDL.logErrorMessage("invalid channel name: '" + string + "'");
                Object var3_5 = null;
                return;
            }
            ucDDLChannel.stream = printWriter;
        }
    }

    public static int createChannel(String string) {
        return UcDDL.createChannel(string, DefaultEnabled);
    }

    public static int createChannel(String string, boolean bl) {
        Object object = lock;
        synchronized (object) {
            int n;
            int n2 = string.length();
            if (n2 == 0) {
                UcDDL.logErrorMessage("empty channel names are not allowed");
                int n3 = DDL_INFO;
                Object var4_6 = null;
                return n3;
            }
            if (n2 < 7) {
                string = UcDDL.channelNormalize(string);
            } else if (n2 > 7) {
                UcDDL.logWarningMessage("long channel names are discouraged (>7 chars)");
            }
            UcDDLChannel ucDDLChannel = (UcDDLChannel)chanHash.get(string);
            if (ucDDLChannel == null) {
                n = chanList.size();
                UcDDLChannel ucDDLChannel2 = new UcDDLChannel(string, n, bl);
                chanList.addElement(ucDDLChannel2);
                chanHash.put(string, ucDDLChannel2);
            } else {
                n = ucDDLChannel.index;
            }
            int n4 = n;
            Object var4_7 = null;
            return n4;
        }
    }

    public static void croak(String string) {
        Exception exception = new Exception("Internally generated error.");
        UcDDL.croak(string, exception);
    }

    public static void croak(String string, Throwable throwable) {
        UcDDL.logMessage(DDL_ERROR, String.valueOf(string) + " - " + throwable.getMessage(), throwable);
        System.exit(1);
    }

    public static String[] getChannelNames() {
        Object object = lock;
        synchronized (object) {
            int n = chanList.size();
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                UcDDLChannel ucDDLChannel = (UcDDLChannel)chanList.elementAt(n2);
                String string = ucDDLChannel.name;
                int n3 = string.indexOf(" ");
                if (n3 != -1) {
                    string = string.substring(0, n3);
                }
                stringArray[n2] = string;
                ++n2;
            }
            String[] stringArray2 = stringArray;
            Object var2_8 = null;
            return stringArray2;
        }
    }

    public static void logDebugMessage(String string) {
        UcDDL.logMessage(DDL_DEBUG, string, null);
    }

    public static void logDebugMessage(String string, Throwable throwable) {
        UcDDL.logMessage(DDL_DEBUG, string, throwable);
    }

    public static void logErrorMessage(String string) {
        UcDDL.logMessage(DDL_ERROR, string, null);
    }

    public static void logErrorMessage(String string, Throwable throwable) {
        UcDDL.logMessage(DDL_ERROR, string, throwable);
    }

    public static void logInfoMessage(String string) {
        UcDDL.logMessage(DDL_INFO, string, null);
    }

    public static void logInfoMessage(String string, Throwable throwable) {
        UcDDL.logMessage(DDL_INFO, string, throwable);
    }

    public static void logMessage(int n, String string) {
        UcDDL.logMessage(n, string, null);
    }

    public static void logMessage(int n, String string, Throwable throwable) {
        int n2;
        PrintWriter printWriter;
        String string2;
        Object object;
        Object object2 = lock;
        synchronized (object2) {
            object = (UcDDLChannel)chanList.elementAt(n);
            if (!((UcDDLChannel)object).enabled) {
                Object var6_5 = null;
                return;
            }
            string2 = ((UcDDLChannel)object).name;
            printWriter = ((UcDDLChannel)object).stream;
            if (printWriter == null && (printWriter = defaultStream) == null) {
                printWriter = new PrintWriter(System.out, true);
            }
        }
        object2 = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM d HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        object = String.valueOf(string2) + " " + simpleDateFormat.format((Date)object2) + " " + Thread.currentThread().getName() + ": ";
        if (throwable != null) {
            string = String.valueOf(string) + "\n" + throwable;
        }
        if (throwable != null || (n2 = string.indexOf(10)) != -1 && n2 < string.length() - 1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                printWriter.println(String.valueOf(object) + stringTokenizer.nextToken());
            }
        } else {
            if (n2 != -1) {
                string = string.substring(0, string.length() - 1);
            }
            printWriter.println(String.valueOf(object) + string);
        }
    }

    public static void logWarningMessage(String string) {
        UcDDL.logMessage(DDL_WARNING, string, null);
    }

    public static void logWarningMessage(String string, Throwable throwable) {
        UcDDL.logMessage(DDL_WARNING, string, throwable);
    }
}

