/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.security.strong;

import com.sun.symon.base.security.SyEndSecureInterface;
import com.sun.symon.base.security.SyExponentialKeyAgreement;
import com.sun.symon.base.security.SyKeyExchange;
import com.sun.symon.base.security.SyKeyHashAuthentication;
import com.sun.symon.base.security.SySecurityException;
import com.sun.symon.base.security.strong.PrivateKey;
import com.sun.symon.base.security.strong.SyScheme;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;

class EndSecure
implements SyEndSecureInterface {
    private SyExponentialKeyAgreement key = new SyExponentialKeyAgreement();
    private boolean wantEncryption;
    private SyKeyHashAuthentication author;
    private Signature dsa;

    EndSecure(String string) throws SySecurityException {
        try {
            this.dsa = Signature.getInstance("DSA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            SyScheme.handleEx(noSuchAlgorithmException);
        }
        try {
            this.dsa.initSign(new PrivateKey(string));
        }
        catch (InvalidKeyException invalidKeyException) {
            SyScheme.handleEx(invalidKeyException);
        }
    }

    private byte[] authenticate(byte[] byArray) throws SySecurityException {
        byte[] byArray2;
        byte[][] byArray3 = SyScheme.splitBytes(byArray);
        if (!this.author.verify(byArray = byArray3[0], byArray2 = byArray3[1])) {
            throw new SySecurityException("unauthentic data", 1);
        }
        return byArray;
    }

    public byte[] decode(byte[] byArray, boolean bl) throws SySecurityException {
        if (bl) {
            byArray = SyKeyExchange.apply(this.key.getSecretKey(), byArray);
        } else if (this.wantEncryption) {
            byArray = this.decrypt(byArray);
        }
        byArray = this.authenticate(byArray);
        return byArray;
    }

    private byte[] decrypt(byte[] byArray) throws SySecurityException {
        return byArray;
    }

    public byte[] encode(byte[] byArray, boolean bl) throws SySecurityException {
        byArray = this.sign(byArray);
        if (bl) {
            byArray = this.encrypt(byArray);
        } else if (this.wantEncryption) {
            byArray = this.encrypt(byArray);
        }
        return byArray;
    }

    private byte[] encrypt(byte[] byArray) throws SySecurityException {
        return byArray;
    }

    public byte[] negotiate(boolean bl, byte[] byArray) throws SySecurityException {
        this.wantEncryption = bl;
        byte[] byArray2 = byArray;
        this.key.setPublicValue(byArray2);
        this.author = new SyKeyHashAuthentication(this.key.getSecretKey());
        return this.sign(this.key.getPublicValue());
    }

    private synchronized byte[] sign(byte[] byArray) throws SySecurityException {
        byte[] byArray2;
        try {
            this.dsa.update(byArray);
            byArray2 = this.dsa.sign();
        }
        catch (SignatureException signatureException) {
            SyScheme.handleEx(signatureException);
            byArray2 = null;
        }
        return SyScheme.joinBytes(byArray, byArray2);
    }
}

