/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.alarm;

import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRequestStatus;
import com.sun.symon.base.client.alarm.SMAlarmIteratorAsync;
import com.sun.symon.base.client.alarm.SMAlarmObjectRequest;
import com.sun.symon.base.client.alarm.SMAlarmObjectResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.ResourceBundle;
import java.util.Vector;

class SMRawAlarmDataReader
extends Thread {
    private SMRawDataRequest handle;
    private Object identifier;
    private SMAlarmIteratorAsync iter;
    private Socket sock;
    private InputStream ip;
    private SMAlarmObjectResponse callback;
    private SMAlarmObjectRequest alarmReq;
    private boolean isStop = false;

    public SMRawAlarmDataReader(SMRawDataRequest sMRawDataRequest, Socket socket, InputStream inputStream, Object object, SMAlarmObjectResponse sMAlarmObjectResponse, SMAlarmIteratorAsync sMAlarmIteratorAsync, SMAlarmObjectRequest sMAlarmObjectRequest) {
        this.sock = socket;
        this.ip = inputStream;
        this.handle = sMRawDataRequest;
        this.identifier = object;
        this.iter = sMAlarmIteratorAsync;
        this.callback = sMAlarmObjectResponse;
        this.alarmReq = sMAlarmObjectRequest;
    }

    public void run() {
        SMRequestStatus sMRequestStatus = null;
        boolean bl = true;
        ResourceBundle resourceBundle = this.handle.getResourceBundle();
        while (bl) {
            if (this.isStop) {
                block13: {
                    try {
                        this.sock.close();
                    }
                    catch (IOException iOException) {
                        sMRequestStatus = new SMRequestStatus(3, iOException.getMessage());
                        if (this.callback == null) break block13;
                        this.callback.getAlarmResponse(sMRequestStatus, null, this.identifier, this.iter);
                    }
                }
                bl = false;
                continue;
            }
            StringBuffer stringBuffer = new StringBuffer();
            byte[] byArray = new byte[4096];
            int n = -1;
            try {
                this.sock.setSoTimeout(0);
            }
            catch (SocketException socketException) {
                bl = false;
                sMRequestStatus = new SMRequestStatus(3, socketException.getMessage());
                if (this.callback == null) continue;
                this.callback.getAlarmResponse(sMRequestStatus, null, this.identifier, this.iter);
                continue;
            }
            do {
                try {
                    n = this.ip.read(byArray);
                }
                catch (Exception exception) {}
                if (n == -1) break;
                stringBuffer.append(new String(byArray, 0, n));
            } while (!stringBuffer.toString().endsWith("eom\n"));
            if (stringBuffer.length() == 0) {
                bl = false;
                if (n == -1) {
                    return;
                }
                sMRequestStatus = new SMRequestStatus(3, resourceBundle.getString("AlarmRequest.EventManagerConnectionBroken"));
                if (this.callback == null) continue;
                this.callback.getAlarmResponse(sMRequestStatus, null, this.identifier, this.iter);
                continue;
            }
            Vector vector = null;
            try {
                vector = this.alarmReq.handleRawAlarmData(stringBuffer);
            }
            catch (Exception exception) {
                bl = false;
                sMRequestStatus = new SMRequestStatus(3, exception.getMessage());
                if (this.callback == null) continue;
                this.callback.getAlarmResponse(sMRequestStatus, null, this.identifier, this.iter);
                continue;
            }
            if (vector == null) continue;
            sMRequestStatus = new SMRequestStatus(0, resourceBundle.getString("Success"));
            if (this.callback == null) continue;
            this.callback.getAlarmResponse(sMRequestStatus, vector, this.identifier, this.iter);
        }
    }

    public void setStop() {
        this.isStop = true;
    }
}

