/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.alarm;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRawDataResponse;
import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.base.client.alarm.SMAlarmStatusResponse;
import com.sun.symon.base.client.alarm.SMAlarmStatusTxltr;
import com.sun.symon.base.utility.UcAgentURL;
import com.sun.symon.base.utility.UcDDL;
import java.awt.Color;
import java.awt.Image;
import java.util.StringTokenizer;
import java.util.Vector;

public class SMAlarmStatusRequest {
    private SMRawDataRequest handle;
    private static Image[] SmallOverlayImages = new Image[]{null, null, null, null, null, null, null};
    private static Image[] LargeOverlayImages = new Image[]{null, null, null, null, null, null, null};
    private static Color[] StatusColours = new Color[]{null, Color.black, Color.red, Color.yellow, Color.blue, Color.pink, Color.gray};
    private static String[] StatusNames = new String[]{"Clear", "Down", "Critical", "Alert", "Caution", "Indeterminate", "Off"};

    public SMAlarmStatusRequest(SMRawDataRequest sMRawDataRequest) {
        this.handle = sMRawDataRequest;
    }

    public Object getAlarmStatusRequest(String string, String string2, SMAlarmStatusResponse sMAlarmStatusResponse, Object object) throws SMAPIException {
        String[] stringArray = new String[]{SMRawDataRequest.buildShadowURL(string, "statuslist", null), SMRawDataRequest.buildShadowURL(string, "module", null)};
        return this.handle.getURLValue(stringArray, string2, (SMRawDataResponse)new SMAlarmStatusTxltr(sMAlarmStatusResponse, true, null, true), object);
    }

    public Object getChildAlarmStatusRequest(String string, String string2, SMAlarmStatusResponse sMAlarmStatusResponse, Object object) throws SMAPIException {
        String[] stringArray = new String[]{SMRawDataRequest.buildShadowURL(string, "indexedstatus", null), SMRawDataRequest.buildShadowURL(string, "module", null)};
        UcAgentURL ucAgentURL = new UcAgentURL(string);
        String string3 = "snmp://" + ucAgentURL.getHost() + ":" + ucAgentURL.getPort() + "/mod/" + ucAgentURL.getModuleSpec() + "/entityViewTable" + "/entityViewEntry/entityStatus";
        return this.handle.getURLValue(stringArray, string2, (SMRawDataResponse)new SMAlarmStatusTxltr(sMAlarmStatusResponse, true, string3, false), object);
    }

    public static Color getStatusColor(String string) {
        return StatusColours[SMAlarmStatusRequest.getStatusIndex(string)];
    }

    public static int getStatusIndex(String string) {
        if (string.substring(0, 2).compareTo("OK") == 0 || string.compareTo("ACK") == 0) {
            return 0;
        }
        if (string.compareTo("DWN") == 0) {
            return 1;
        }
        if (string.compareTo("ERR") == 0) {
            return 2;
        }
        if (string.compareTo("WRN") == 0) {
            return 3;
        }
        if (string.compareTo("INF") == 0) {
            return 4;
        }
        if (string.compareTo("IRR") == 0) {
            return 5;
        }
        return 6;
    }

    public static String getStatusName(String string) {
        return StatusNames[SMAlarmStatusRequest.getStatusIndex(string)];
    }

    public static Image getStatusOverlay(String string, boolean bl) {
        int n = SMAlarmStatusRequest.getStatusIndex(string);
        if (bl) {
            return SmallOverlayImages[n];
        }
        return LargeOverlayImages[n];
    }

    public Object getTableRowAlarmStatusRequest(String string, String string2, String string3, SMAlarmStatusResponse sMAlarmStatusResponse, Object object) throws SMAPIException {
        if (string2.length() != 0 && string2.charAt(0) == '#') {
            string2 = string2.substring(1);
        }
        String[] stringArray = new String[]{SMRawDataRequest.buildShadowURL(string, "tablestatus", string2), SMRawDataRequest.buildShadowURL(string, "module", null)};
        return this.handle.getURLValue(stringArray, string3, (SMRawDataResponse)new SMAlarmStatusTxltr(sMAlarmStatusResponse, false, null, false), object);
    }

    public Object getTopAlarmStatusRequest(String string, String string2, SMAlarmStatusResponse sMAlarmStatusResponse, Object object) throws SMAPIException {
        String[] stringArray = new String[]{SMRawDataRequest.buildShadowURL(string, "status", null), SMRawDataRequest.buildShadowURL(string, "module", null)};
        return this.handle.getURLValue(stringArray, string2, (SMRawDataResponse)new SMAlarmStatusTxltr(sMAlarmStatusResponse, false, null, false), object);
    }

    public static void initializeStatusDetails(SMRawDataRequest sMRawDataRequest) {
        SMResourceAccess sMResourceAccess = new SMResourceAccess(sMRawDataRequest);
        String string = sMResourceAccess.getConfigFile("alarm-configure-j.x");
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        Vector vector = new Vector();
        while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2;
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() == 0 || string2.charAt(0) == '#' || (stringTokenizer2 = new StringTokenizer(string2)).countTokens() != 4) continue;
            String string3 = stringTokenizer2.nextToken().trim();
            int n = -1;
            if (string3.equalsIgnoreCase("clear")) {
                n = 0;
            } else if (string3.equalsIgnoreCase("down")) {
                n = 1;
            } else if (string3.equalsIgnoreCase("critical")) {
                n = 2;
            } else if (string3.equalsIgnoreCase("alert")) {
                n = 3;
            } else if (string3.equalsIgnoreCase("caution")) {
                n = 4;
            } else if (string3.equalsIgnoreCase("indet")) {
                n = 5;
            } else if (string3.equalsIgnoreCase("off")) {
                n = 6;
            } else {
                UcDDL.logErrorMessage((String)("Invalid alarm configure state " + string3));
                continue;
            }
            String string4 = stringTokenizer2.nextToken().trim();
            SMAlarmStatusRequest.SmallOverlayImages[n] = string4.equalsIgnoreCase("null") ? null : sMResourceAccess.getImage(string4);
            string4 = stringTokenizer2.nextToken().trim();
            SMAlarmStatusRequest.LargeOverlayImages[n] = string4.equalsIgnoreCase("null") ? null : sMResourceAccess.getImage(string4);
            String string5 = stringTokenizer2.nextToken().trim();
            SMAlarmStatusRequest.StatusColours[n] = SMAlarmStatusRequest.translateColour(string5);
        }
    }

    private static Color translateColour(String string) {
        if (string.equalsIgnoreCase("null")) {
            return null;
        }
        if (string.equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (string.equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        if (string.equalsIgnoreCase("cyan")) {
            return Color.cyan;
        }
        if (string.equalsIgnoreCase("darkgray")) {
            return Color.darkGray;
        }
        if (string.equalsIgnoreCase("darkgrey")) {
            return Color.darkGray;
        }
        if (string.equalsIgnoreCase("gray")) {
            return Color.gray;
        }
        if (string.equalsIgnoreCase("grey")) {
            return Color.gray;
        }
        if (string.equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (string.equalsIgnoreCase("lightgray")) {
            return Color.lightGray;
        }
        if (string.equalsIgnoreCase("lightgrey")) {
            return Color.lightGray;
        }
        if (string.equalsIgnoreCase("magenta")) {
            return Color.magenta;
        }
        if (string.equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (string.equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (string.equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (string.equalsIgnoreCase("white")) {
            return Color.white;
        }
        if (string.equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        try {
            return Color.decode(string);
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)("Invalid alarm configure colour " + string));
            return null;
        }
    }
}

