/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.alarm;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.alarm.SMAlarmIteratorAsync;
import com.sun.symon.base.client.alarm.SMAlarmIteratorSync;
import com.sun.symon.base.client.alarm.SMAlarmObjectData;
import com.sun.symon.base.client.alarm.SMAlarmObjectResponse;
import com.sun.symon.base.client.alarm.SMAlarmOperationStatus;
import com.sun.symon.base.client.alarm.SMRawAlarmDataReader;
import com.sun.symon.base.client.alarm.SMReqConnect;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.server.types.StString;
import com.sun.symon.base.utility.UcListUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class SMAlarmObjectRequest {
    private SMRawDataRequest handle;
    private Socket syncSock;
    private Vector asyncSocks;
    private ResourceBundle rbundle;
    private String eventbaseURL = null;
    private String probeURL = null;

    public SMAlarmObjectRequest(SMRawDataRequest sMRawDataRequest, String string) throws SMAPIException {
        this.handle = sMRawDataRequest;
        if (string == null) {
            this.eventbaseURL = this.handle.getEventBaseURL();
            this.probeURL = String.valueOf(this.eventbaseURL) + "mod/eventmgr/probe?runadhoccommand.probe";
        } else {
            this.eventbaseURL = "snmp://" + string + "/";
            this.probeURL = "snmp://" + string + "/mod/eventmgr/probe?runadhoccommand.probe";
        }
        this.rbundle = this.handle.getResourceBundle();
    }

    public Vector ackAlarms(String[] stringArray, String string) throws SMAPIException {
        String[] stringArray2 = new String[1];
        StObject[][] stObjectArray = new StObject[1][1];
        stringArray2[0] = String.valueOf(this.eventbaseURL) + "mod/eventmgr/actions?eventack";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            if (n + 1 < stringArray.length) {
                stringBuffer.append(" ");
            }
            ++n;
        }
        if (string == null || string.length() == 0) {
            stringBuffer.append("} {" + this.handle.getUserId() + "}");
        } else {
            stringBuffer.append("} {" + this.handle.getUserId() + "} {" + string + "}");
        }
        stObjectArray[0][0] = new StString(stringBuffer.toString());
        StObject[][] stObjectArray2 = this.handle.setURLValue(stringArray2, stObjectArray);
        Vector<SMAlarmOperationStatus> vector = new Vector<SMAlarmOperationStatus>();
        if (stObjectArray2[0][0].toString().length() != 0) {
            Vector vector2 = new Vector();
            Vector vector3 = new Vector();
            UcListUtil.decomposeList((String)stObjectArray2[0][0].toString(), vector2);
            int n2 = 0;
            while (n2 < vector2.size()) {
                UcListUtil.decomposeList((String)vector2.elementAt(n2).toString(), vector3);
                SMAlarmOperationStatus sMAlarmOperationStatus = new SMAlarmOperationStatus(vector3.elementAt(0).toString(), vector3.elementAt(1).toString());
                vector.addElement(sMAlarmOperationStatus);
                ++n2;
            }
            if (vector.size() != 0) {
                return vector;
            }
            return null;
        }
        return null;
    }

    public synchronized void closeConnection() throws SMAPIException {
        try {
            String string = "q\n";
            if (this.asyncSocks == null) {
                return;
            }
            SMReqConnect sMReqConnect = null;
            Socket socket = null;
            SMRawAlarmDataReader sMRawAlarmDataReader = null;
            int n = 0;
            while (n < this.asyncSocks.size()) {
                sMReqConnect = (SMReqConnect)this.asyncSocks.elementAt(n);
                if (sMReqConnect != null && (socket = sMReqConnect.sock) != null) {
                    OutputStream outputStream = socket.getOutputStream();
                    outputStream.write(string.getBytes());
                    outputStream.flush();
                    sMRawAlarmDataReader = sMReqConnect.receiver;
                    if (sMRawAlarmDataReader != null) {
                        sMRawAlarmDataReader.setStop();
                    } else {
                        socket.close();
                    }
                }
                ++n;
            }
            this.asyncSocks.removeAllElements();
            this.asyncSocks = null;
        }
        catch (Exception exception) {
            throw new SMAPIException(exception.getMessage());
        }
    }

    public void closeConnection(String string) throws SMAPIException {
        try {
            String string2 = "q\n";
            SMReqConnect sMReqConnect = this.removeConnection(string);
            Socket socket = sMReqConnect.sock;
            if (sMReqConnect == null || (socket = sMReqConnect.sock) == null) {
                return;
            }
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(string2.getBytes());
            outputStream.flush();
            SMRawAlarmDataReader sMRawAlarmDataReader = sMReqConnect.receiver;
            if (sMRawAlarmDataReader != null) {
                sMRawAlarmDataReader.setStop();
            } else {
                socket.close();
            }
        }
        catch (Exception exception) {
            throw new SMAPIException(exception.getMessage());
        }
    }

    public synchronized void closeSyncConnection() throws SMAPIException {
        try {
            String string = "q\n";
            if (this.syncSock != null) {
                OutputStream outputStream = this.syncSock.getOutputStream();
                outputStream.write(string.getBytes());
                outputStream.flush();
                this.syncSock.close();
                this.syncSock = null;
            }
        }
        catch (Exception exception) {
            throw new SMAPIException(exception.getMessage());
        }
    }

    public Vector deleteAlarms(String[] stringArray, String string) throws SMAPIException {
        String[] stringArray2 = new String[1];
        StObject[][] stObjectArray = new StObject[1][1];
        stringArray2[0] = String.valueOf(this.eventbaseURL) + "mod/eventmgr/actions?eventdelete";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            if (n + 1 < stringArray.length) {
                stringBuffer.append(" ");
            }
            ++n;
        }
        if (string == null || string.length() == 0) {
            stringBuffer.append("} {" + this.handle.getUserId() + "}");
        } else {
            stringBuffer.append("} {" + this.handle.getUserId() + "} {" + string + "}");
        }
        stObjectArray[0][0] = new StString(stringBuffer.toString());
        StObject[][] stObjectArray2 = this.handle.setURLValue(stringArray2, stObjectArray);
        Vector<SMAlarmOperationStatus> vector = new Vector<SMAlarmOperationStatus>();
        if (stObjectArray2[0][0].toString().length() != 0) {
            Vector vector2 = new Vector();
            Vector vector3 = new Vector();
            UcListUtil.decomposeList((String)stObjectArray2[0][0].toString(), vector2);
            int n2 = 0;
            while (n2 < vector2.size()) {
                UcListUtil.decomposeList((String)vector2.elementAt(n2).toString(), vector3);
                SMAlarmOperationStatus sMAlarmOperationStatus = new SMAlarmOperationStatus(vector3.elementAt(0).toString(), vector3.elementAt(1).toString());
                vector.addElement(sMAlarmOperationStatus);
                ++n2;
            }
            if (vector.size() != 0) {
                return vector;
            }
            return null;
        }
        return null;
    }

    public Vector fixAlarms(String[] stringArray, String string) throws SMAPIException {
        String[] stringArray2 = new String[1];
        StObject[][] stObjectArray = new StObject[1][1];
        stringArray2[0] = String.valueOf(this.eventbaseURL) + "mod/eventmgr/actions?eventfix";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            if (n + 1 < stringArray.length) {
                stringBuffer.append(" ");
            }
            ++n;
        }
        if (string == null || string.length() == 0) {
            stringBuffer.append("} {" + this.handle.getUserId() + "}");
        } else {
            stringBuffer.append("} {" + this.handle.getUserId() + "} {" + string + "}");
        }
        stObjectArray[0][0] = new StString(stringBuffer.toString());
        StObject[][] stObjectArray2 = this.handle.setURLValue(stringArray2, stObjectArray);
        Vector<SMAlarmOperationStatus> vector = new Vector<SMAlarmOperationStatus>();
        if (stObjectArray2[0][0].toString().length() != 0) {
            Vector vector2 = new Vector();
            Vector vector3 = new Vector();
            UcListUtil.decomposeList((String)stObjectArray2[0][0].toString(), vector2);
            int n2 = 0;
            while (n2 < vector2.size()) {
                UcListUtil.decomposeList((String)vector2.elementAt(n2).toString(), vector3);
                SMAlarmOperationStatus sMAlarmOperationStatus = new SMAlarmOperationStatus(vector3.elementAt(0).toString(), vector3.elementAt(1).toString());
                vector.addElement(sMAlarmOperationStatus);
                ++n2;
            }
            if (vector.size() != 0) {
                return vector;
            }
            return null;
        }
        return null;
    }

    public void getAlarms(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, SMAlarmObjectResponse sMAlarmObjectResponse, Object object) throws SMAPIException {
        this.registRequest(string, object, sMAlarmObjectResponse);
        this.getAlarms(string, string2, string3, string4, string5, string6, string7, string8, false, sMAlarmObjectResponse, object);
    }

    public void getAlarms(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, SMAlarmObjectResponse sMAlarmObjectResponse, Object object, String string9) throws SMAPIException {
        this.registRequest(string, object, sMAlarmObjectResponse);
        this.getAlarms(string, string2, string3, string4, string5, string6, string7, string8, false, sMAlarmObjectResponse, object, string9);
    }

    public synchronized SMAlarmIteratorSync getAlarms(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) throws SMAPIException {
        if (this.syncSock == null) {
            this.syncSock = this.handle.probeConnect(this.probeURL, null);
        }
        Vector vector = this.getAlarms(string, string2, string3, string4, string5, string6, string7, string8, string9, false);
        return new SMAlarmIteratorSync(vector, this, string);
    }

    public void getAlarms(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, SMAlarmObjectResponse sMAlarmObjectResponse, Object object) throws SMAPIException {
        this.registRequest(string, object, sMAlarmObjectResponse);
        this.getAlarms(string, string2, string3, string4, string5, string6, string7, string8, string9, false, sMAlarmObjectResponse, object, 1);
    }

    Vector getAlarms(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl) throws SMAPIException {
        InputStream inputStream;
        OutputStream outputStream;
        if (string == null || string.length() == 0) {
            throw new SMAPIException(this.rbundle.getString("AlarmRequest.InvalidRequestIdParameterPassed"));
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("rtyp(B)|rid(" + string + ")");
        } else {
            stringBuffer.append("rtyp(S)|rid(" + string + ")");
            if (string2 != null && string2.length() != 0) {
                stringBuffer.append("|host(" + string2 + ")");
            }
            if (string3 != null && string3.length() != 0) {
                stringBuffer.append("|url(" + string3 + ")");
            } else {
                stringBuffer.append("|url({*})");
            }
            if (string4 != null && string4.length() != 0) {
                stringBuffer.append("|als(" + string4 + ")");
            }
            if (string5 != null && string5.length() != 0) {
                stringBuffer.append("|evs(" + string5 + ")");
            }
            if (string6 != null && string6.length() != 0) {
                stringBuffer.append("|ack(" + string6 + ")");
            }
            if (string7 != null && string7.length() != 0) {
                stringBuffer.append("|rulg(" + string7 + ")");
            }
            if (string8 != null && string8.length() != 0) {
                stringBuffer.append("|ruid(" + string8 + ")");
            }
            if (string9 != null && string9.length() != 0) {
                stringBuffer.append("|evid(" + string9 + ")");
            }
        }
        stringBuffer.append("|eom\n");
        try {
            this.syncSock.setSoTimeout(60000);
        }
        catch (SocketException socketException) {
            throw new SMAPIException(socketException.getMessage());
        }
        try {
            outputStream = this.syncSock.getOutputStream();
            inputStream = this.syncSock.getInputStream();
            outputStream.write(stringBuffer.toString().getBytes());
            outputStream.flush();
        }
        catch (Exception exception) {
            throw new SMAPIException(exception.getMessage());
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        byte[] byArray = new byte[4096];
        int n = -1;
        try {
            do {
                if ((n = inputStream.read(byArray)) == -1) {
                    throw new SMAPIException(this.rbundle.getString("AlarmRequest.TimeoutReadAlarmData"));
                }
                stringBuffer2.append(new String(byArray, 0, n));
            } while (!stringBuffer2.toString().endsWith("eom\n"));
            outputStream.write(new String("f\n").getBytes());
            outputStream.flush();
        }
        catch (Exception exception) {
            throw new SMAPIException(exception.getMessage());
        }
        if (stringBuffer2.length() == 0) {
            return null;
        }
        return this.handleRawAlarmData(stringBuffer2);
    }

    void getAlarms(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl, SMAlarmObjectResponse sMAlarmObjectResponse, Object object, int n) throws SMAPIException {
        SMAlarmIteratorAsync sMAlarmIteratorAsync = new SMAlarmIteratorAsync(this, string, sMAlarmObjectResponse, object, n);
        if (string == null || string.length() == 0) {
            throw new SMAPIException(this.rbundle.getString("AlarmRequest.InvalidRequestIdParameterPassed"));
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("rtyp(B)|rid(" + string + ")");
        } else {
            stringBuffer.append("rtyp(S)|rid(" + string + ")");
            if (string2 != null && string2.length() != 0) {
                stringBuffer.append("|host(" + string2 + ")");
            }
            if (string3 != null && string3.length() != 0) {
                stringBuffer.append("|url(" + string3 + ")");
            } else {
                stringBuffer.append("|url({*})");
            }
            if (string4 != null && string4.length() != 0) {
                stringBuffer.append("|als(" + string4 + ")");
            }
            if (string5 != null && string5.length() != 0) {
                stringBuffer.append("|evs(" + string5 + ")");
            }
            if (string6 != null && string6.length() != 0) {
                stringBuffer.append("|ack(" + string6 + ")");
            }
            if (string7 != null && string7.length() != 0) {
                stringBuffer.append("|rulg(" + string7 + ")");
            }
            if (string8 != null && string8.length() != 0) {
                stringBuffer.append("|ruid(" + string8 + ")");
            }
            if (string9 != null && string9.length() != 0) {
                stringBuffer.append("|evid(" + string9 + ")");
            }
        }
        stringBuffer.append("|eom\n");
        SMReqConnect sMReqConnect = this.getReqConnection(string);
        if (sMReqConnect == null || sMReqConnect.sock == null) {
            return;
        }
        Socket socket = sMReqConnect.sock;
        SMAlarmObjectResponse sMAlarmObjectResponse2 = sMReqConnect.callback;
        Object object2 = sMReqConnect.identifier;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            outputStream = socket.getOutputStream();
            inputStream = socket.getInputStream();
            outputStream.write(stringBuffer.toString().getBytes());
            outputStream.flush();
        }
        catch (Exception exception) {
            throw new SMAPIException(exception.getMessage());
        }
        SMRawAlarmDataReader sMRawAlarmDataReader = null;
        sMRawAlarmDataReader = sMReqConnect.receiver;
        if (sMRawAlarmDataReader == null) {
            sMRawAlarmDataReader = new SMRawAlarmDataReader(this.handle, socket, inputStream, object2, sMAlarmObjectResponse2, sMAlarmIteratorAsync, this);
            sMReqConnect.addRecv(sMRawAlarmDataReader);
            sMRawAlarmDataReader.start();
        }
    }

    void getAlarms(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl, SMAlarmObjectResponse sMAlarmObjectResponse, Object object) throws SMAPIException {
        if (string == null || string.length() == 0) {
            throw new SMAPIException(this.rbundle.getString("AlarmRequest.InvalidRequestIdParameterPassed"));
        }
        if (!bl) {
            Object object2;
            Object object3;
            if (string2 == null || string2.length() == 0) {
                throw new SMAPIException(this.rbundle.getString("AlarmRequest.InvalidTopologyNameParameterPassed"));
            }
            String string9 = this.handle.getTopologyBaseURL();
            String[] stringArray = new String[]{String.valueOf(string9) + "sym/base/mibman/modules/serverSupport/moduleTable/moduleEntry/name", String.valueOf(string9) + "sym/base/mibman/modules/serverSupport/moduleTable/moduleEntry/modspec"};
            StObject[][] stObjectArray = this.handle.getURLValue(stringArray);
            if (stObjectArray.length != 2) {
                throw new SMAPIException(this.rbundle.getString("AlarmRequest.UnableToReadTheModuleTable"));
            }
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            UcListUtil.decomposeList((String)stObjectArray[0][0].toString(), vector2);
            UcListUtil.decomposeList((String)stObjectArray[1][0].toString(), vector);
            String string10 = null;
            int n = 0;
            while (n < vector2.size()) {
                object3 = vector2.elementAt(n).toString();
                if (((String)object3).indexOf(string2) != -1) {
                    string10 = vector.elementAt(n).toString();
                    break;
                }
                ++n;
            }
            if (string10 == null) {
                throw new SMAPIException(this.rbundle.getString("AlarmRequest.TopologyNameDoesNotExistInTheServerContext"));
            }
            object3 = new Vector();
            stringArray = new String[]{String.valueOf(string9) + "mod/" + string10 + "/?topologywalk"};
            block1: while (true) {
                if ((stObjectArray = this.handle.getURLValue(stringArray)).length != stringArray.length) {
                    throw new SMAPIException(this.rbundle.getString("AlarmRequest.UnableToPerformTopologywalk"));
                }
                object2 = new StringTokenizer(stObjectArray[0][0].toString(), " ");
                Vector<String> vector3 = new Vector<String>();
                while (((StringTokenizer)object2).hasMoreElements()) {
                    String string11 = ((StringTokenizer)object2).nextElement().toString();
                    long l = Long.valueOf(((StringTokenizer)object2).nextElement().toString());
                    if (l == 1L) {
                        vector3.addElement(string11);
                        continue;
                    }
                    ((Vector)object3).addElement(string11);
                }
                if (vector3.size() == 0) break;
                stringArray = new String[vector3.size()];
                int n2 = 0;
                while (true) {
                    if (n2 >= vector3.size()) continue block1;
                    stringArray[n2] = String.valueOf(vector3.elementAt(n2).toString()) + "?topologywalk";
                    ++n2;
                }
                break;
            }
            object2 = new StringBuffer();
            int n3 = 0;
            while (n3 < ((Vector)object3).size()) {
                ((StringBuffer)object2).append("{" + ((Vector)object3).elementAt(n3).toString() + "}");
                ++n3;
            }
            this.getAlarms(string, null, ((StringBuffer)object2).toString(), string3, string4, string5, string6, string7, string8, false, sMAlarmObjectResponse, object, 0);
        } else {
            this.getAlarms(string, null, null, null, null, null, null, null, null, true, sMAlarmObjectResponse, object, 0);
        }
    }

    void getAlarms(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl, SMAlarmObjectResponse sMAlarmObjectResponse, Object object, String string9) throws SMAPIException {
        if (string == null || string.length() == 0) {
            throw new SMAPIException(this.rbundle.getString("AlarmRequest.InvalidRequestIdParameterPassed"));
        }
        if (!bl) {
            Object object2;
            if (string2 == null || string2.length() == 0) {
                throw new SMAPIException(this.rbundle.getString("AlarmRequest.InvalidTopologyURLParameterPassed"));
            }
            Vector<String> vector = new Vector<String>();
            String[] stringArray = new String[]{String.valueOf(string2) + "/?topologywalk"};
            block0: while (true) {
                if (((StObject[][])(object2 = this.handle.getURLValue(stringArray))).length != stringArray.length) {
                    throw new SMAPIException(this.rbundle.getString("AlarmRequest.UnableToPerformTopologywalk"));
                }
                StringTokenizer stringTokenizer = new StringTokenizer(object2[0][0].toString(), " ");
                Vector<String> vector2 = new Vector<String>();
                while (stringTokenizer.hasMoreElements()) {
                    String string10 = stringTokenizer.nextElement().toString();
                    long l = Long.valueOf(stringTokenizer.nextElement().toString());
                    if (l == 1L) {
                        vector2.addElement(string10);
                        continue;
                    }
                    vector.addElement(string10);
                }
                if (vector2.size() == 0) break;
                stringArray = new String[vector2.size()];
                int n = 0;
                while (true) {
                    if (n >= vector2.size()) continue block0;
                    stringArray[n] = String.valueOf(vector2.elementAt(n).toString()) + "?topologywalk";
                    ++n;
                }
                break;
            }
            object2 = new StringBuffer();
            int n = 0;
            while (n < vector.size()) {
                ((StringBuffer)object2).append("{" + vector.elementAt(n).toString() + "} ");
                ++n;
            }
            this.getAlarms(string, null, ((StringBuffer)object2).toString(), string3, string4, string5, string6, string7, string8, false, sMAlarmObjectResponse, object, 0);
        } else {
            this.getAlarms(string, null, null, null, null, null, null, null, null, true, sMAlarmObjectResponse, object, 0);
        }
    }

    private synchronized SMReqConnect getReqConnection(String string) {
        if (this.asyncSocks == null) {
            return null;
        }
        SMReqConnect sMReqConnect = null;
        int n = 0;
        while (n < this.asyncSocks.size()) {
            sMReqConnect = (SMReqConnect)this.asyncSocks.elementAt(n);
            if (sMReqConnect != null && string.equals(sMReqConnect.requestId)) {
                return sMReqConnect;
            }
            ++n;
        }
        return null;
    }

    final Vector handleRawAlarmData(StringBuffer stringBuffer) throws SMAPIException {
        Vector<SMAlarmObjectData> vector = new Vector<SMAlarmObjectData>();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), "|");
        while (stringTokenizer.hasMoreElements()) {
            String string = stringTokenizer.nextElement().toString();
            if (string.startsWith("eom")) {
                hashtable.put(string, "");
            } else {
                int n2 = string.indexOf("(");
                if (string.substring(n2 + 1).length() != 0) {
                    hashtable.put(string.substring(0, n2), string.substring(n2 + 1, string.length() - 1));
                } else {
                    hashtable.put(string.substring(0, n2), "");
                }
            }
            if (!hashtable.containsKey("eom") && !hashtable.containsKey("eom\n")) continue;
            if (hashtable.get("stat") != null) {
                long l = Long.valueOf(hashtable.get("stat").toString());
                if (l < 0L) {
                    throw new SMAPIException(String.valueOf(this.rbundle.getString("AlarmRequest.ErrorInEventManagerResponse")) + "  " + Long.valueOf(hashtable.get("stat").toString()));
                }
                if (l == 0L) {
                    String string2 = hashtable.get("rtyp").toString();
                    if (string2.compareTo("P") == 0) {
                        return null;
                    }
                    return vector;
                }
            }
            SMAlarmObjectData sMAlarmObjectData = new SMAlarmObjectData(String.valueOf(++n), hashtable.get("evid").toString(), hashtable.get("ruid").toString(), Long.valueOf(hashtable.get("otim").toString()), Long.valueOf(hashtable.get("atim").toString()), Long.valueOf(hashtable.get("ctim").toString()), Long.valueOf(hashtable.get("ftim").toString()), Long.valueOf(hashtable.get("utim").toString()), Long.valueOf(hashtable.get("dtim").toString()), hashtable.get("smsg").toString(), hashtable.get("lmsg").toString(), hashtable.get("url").toString(), hashtable.get("host").toString(), hashtable.get("evs").toString(), hashtable.get("als").toString(), hashtable.get("mtyp").toString(), hashtable.get("rulg").toString(), hashtable.get("anam").toString(), hashtable.get("fnam").toString(), hashtable.get("dnam").toString(), hashtable.get("ursn").toString());
            vector.addElement(sMAlarmObjectData);
            hashtable = new Hashtable();
        }
        return vector;
    }

    private synchronized void registRequest(String string, Object object, SMAlarmObjectResponse sMAlarmObjectResponse) throws SMAPIException {
        if (this.asyncSocks == null) {
            this.asyncSocks = new Vector();
        }
        SMReqConnect sMReqConnect = null;
        int n = 0;
        while (n < this.asyncSocks.size()) {
            sMReqConnect = (SMReqConnect)this.asyncSocks.elementAt(n);
            if (sMReqConnect != null && string.equals(sMReqConnect.requestId)) {
                return;
            }
            ++n;
        }
        Socket socket = this.handle.probeConnect(this.probeURL, null);
        sMReqConnect = new SMReqConnect(string, socket, object, sMAlarmObjectResponse);
        this.asyncSocks.addElement(sMReqConnect);
    }

    private synchronized SMReqConnect removeConnection(String string) {
        if (this.asyncSocks == null) {
            return null;
        }
        SMReqConnect sMReqConnect = null;
        int n = 0;
        while (n < this.asyncSocks.size()) {
            sMReqConnect = (SMReqConnect)this.asyncSocks.elementAt(n);
            if (sMReqConnect != null && sMReqConnect.requestId != null && string.equals(sMReqConnect.requestId)) {
                this.asyncSocks.remove(sMReqConnect);
                return sMReqConnect;
            }
            ++n;
        }
        return null;
    }
}

