/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.receptors.rmi;

import com.sun.symon.base.security.SySecurity;
import com.sun.symon.base.server.common.ScSecurityCredential;
import com.sun.symon.base.server.receptors.SrReceptor;
import com.sun.symon.base.server.receptors.SrSessionByHandle;
import com.sun.symon.base.server.receptors.rmi.RMILoginException;
import com.sun.symon.base.server.receptors.rmi.RMIResponseInterface;
import com.sun.symon.base.server.receptors.rmi.RMISecurityException;
import com.sun.symon.base.server.receptors.rmi.RMIServerSession;
import com.sun.symon.base.server.receptors.rmi.SrRMIReceptor;
import com.sun.symon.base.server.receptors.rmi.SrRMISecurity;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcPeriodicException;
import com.sun.symon.base.utility.UcTickerTimer;
import com.sun.symon.base.utility.UcTickerTimerResponse;
import java.io.PrintWriter;
import java.rmi.RemoteException;

public class SrRMISession
extends RMIServerSession {
    private SrRMIReceptor Receptor;
    private RMIResponseInterface Resp;
    private ScSecurityCredential UserTicket;
    private SrSessionByHandle Session;
    private SrRMISecurity Security;
    private String UserId;
    private UcTickerTimer Ticker;
    private boolean waitMode = false;

    SrRMISession(SySecurity sySecurity, SrRMIReceptor srRMIReceptor, RMIResponseInterface rMIResponseInterface, SrRMISecurity srRMISecurity, String string) throws RemoteException {
        super(sySecurity, string);
        this.Receptor = srRMIReceptor;
        this.Resp = rMIResponseInterface;
        this.UserTicket = null;
        this.Session = new Session(srRMIReceptor);
        this.Security = srRMISecurity;
        this.UserId = null;
        try {
            this.Ticker = new UcTickerTimer(60L, new UcTickerTimerResponse(){
                Pinger clientPingerThread;

                public void processTick() {
                    if (this.clientPingerThread == null || this.clientPingerThread.isDone()) {
                        this.clientPingerThread = new Pinger(SrRMISession.this.Resp, SrRMISession.this.Session);
                        this.clientPingerThread.start();
                    }
                }

                public void processTickEnd() {
                }
            });
        }
        catch (UcPeriodicException ucPeriodicException) {}
        if (this.Ticker.start()) {
            UcDDL.logDebugMessage((String)"Client pinger started");
        }
    }

    private void clientDied() {
        RMISecurityException rMISecurityException = new RMISecurityException(2);
        this.setSecurityException(rMISecurityException);
        this.Ticker.stop();
        this.Receptor.clientDied(this);
    }

    protected synchronized void doAuthenticate(String string, String string2) throws RMILoginException {
        UcDDL.logDebugMessage((String)("authenticate user " + string));
        if (this.Session.isDead()) {
            throw new RMILoginException(3);
        }
        this.UserTicket = this.Security.getCredentials(string, string2);
        this.UserId = string;
    }

    protected void doDeleteRequest(String string) throws RMISecurityException {
        this.Session.requestDeleteByHandle(string);
    }

    protected String doGetURL(int n) {
        String string;
        switch (n) {
            case 0: {
                string = this.Receptor.getConfigurationBaseURL();
                break;
            }
            case 1: {
                string = this.Receptor.getEventBaseURL();
                break;
            }
            case 2: {
                string = this.Receptor.getTopologyBaseURL();
                break;
            }
            case 3: {
                string = this.Receptor.getESDIR();
                break;
            }
            case 4: {
                string = this.Receptor.getImageSubpath();
                break;
            }
            default: {
                UcDDL.logErrorMessage((String)("invalid urlType: " + n));
                string = null;
            }
        }
        return string;
    }

    protected void doNewRequest(int n, String[] stringArray, StObject[][] stObjectArray, String string, String string2) throws RMISecurityException {
        if (stringArray != null && stringArray.length == 1 && stringArray[0] != null && stringArray[0].equals("exit://clientIsExiting/") && stObjectArray != null && stObjectArray.length == 1 && stObjectArray[0].length == 1 && stObjectArray[0][0] != null && stObjectArray[0][0].toString().equals("goodbye")) {
            UcDDL.logInfoMessage((String)"Received disconnect signal from a client");
            this.Session.died(new Exception("Client is disconnecting"));
        } else {
            this.Session.requestCreateByHandle(string2, n, stringArray, stObjectArray, string).emit();
        }
    }

    private void handleResponse(String string, String string2, Exception exception) {
        block3: {
            try {
                boolean bl = this.respond(this.Resp, string, string2, exception);
                if (!bl) {
                    this.Session.requestDeleteByHandle(string);
                }
                this.waitMode = false;
            }
            catch (RemoteException remoteException) {
                if (this.waitMode) break block3;
                UcDDL.logWarningMessage((String)("Client callback failed: " + remoteException));
                this.waitMode = true;
            }
        }
    }

    private void handleResponse(String string, StObject[][] stObjectArray) {
        block3: {
            try {
                boolean bl = this.respond(this.Resp, string, stObjectArray);
                if (!bl) {
                    this.Session.requestDeleteByHandle(string);
                }
                this.waitMode = false;
            }
            catch (RemoteException remoteException) {
                if (this.waitMode) break block3;
                UcDDL.logWarningMessage((String)("Client callback failed: " + remoteException));
                this.waitMode = true;
            }
        }
    }

    private class Session
    extends SrSessionByHandle {
        private int retries = 0;
        private int MAX_RETRIES = 5;

        Session(SrReceptor srReceptor) {
            super(srReceptor);
        }

        public boolean died(Exception exception) {
            boolean bl = super.died(exception);
            if (bl) {
                SrRMISession.this.clientDied();
            }
            return bl;
        }

        protected void dump(PrintWriter printWriter) {
            printWriter.println("  user=" + SrRMISession.this.UserId);
            super.dump(printWriter);
        }

        protected ScSecurityCredential getUserTicket() {
            return SrRMISession.this.UserTicket;
        }

        public void handleRemoteException(Exception exception) {
            ++this.retries;
            UcDDL.logWarningMessage((String)("Client ping failed. Attempt " + this.retries + " of " + this.MAX_RETRIES));
            if (this.retries >= this.MAX_RETRIES) {
                this.died(exception);
            }
        }

        protected void requestResponse(String string, String string2, Exception exception) {
            SrRMISession.this.handleResponse(string, string2, exception);
        }

        protected void requestResponse(String string, StObject[][] stObjectArray) {
            SrRMISession.this.handleResponse(string, stObjectArray);
        }

        public void resetCounter() {
            this.retries = 0;
        }
    }

    private class Pinger
    extends Thread {
        RMIResponseInterface response;
        SrSessionByHandle session;
        boolean flag;

        Pinger(RMIResponseInterface rMIResponseInterface, SrSessionByHandle srSessionByHandle) {
            this.response = rMIResponseInterface;
            this.session = srSessionByHandle;
            this.flag = false;
        }

        public boolean isDone() {
            return this.flag;
        }

        public void run() {
            try {
                this.response.ping();
                ((Session)this.session).resetCounter();
            }
            catch (RemoteException remoteException) {
                UcDDL.logWarningMessage((String)("Client ping failed: " + remoteException));
                ((Session)this.session).handleRemoteException(remoteException);
            }
            this.flag = true;
        }
    }
}

