/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.main;

import com.sun.symon.base.bootstrap.BsRMIBootstrap;
import com.sun.symon.base.bootstrap.BsRMIBootstrapException;
import com.sun.symon.base.console.main.ConsoleLoginPanel;
import com.sun.symon.base.console.main.ConsoleLoginRunner;
import com.sun.symon.base.console.main.CustomPanel;
import com.sun.symon.base.console.main.CustomTextField;
import com.sun.symon.base.console.tools.editor.CtMarginPanel;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class SymonConsoleLoginPanel
extends ConsoleLoginPanel {
    public JButton helpButt;
    public JButton optionButt;
    private JDialog helpDialog;
    private JButton okButt;
    private JDialog optionDialog;
    private CustomTextField serverPort;
    private String serverPortString;
    private ButtonGroup securityGroup;
    private JRadioButton weakButton;
    private JRadioButton mediumButton;
    private JRadioButton strongButton;
    private JButton applyButt;
    private JButton cancelButt;
    protected String remoteHost;
    protected String remotePort;
    protected CustomTextField serverHost;
    private boolean portOk = false;
    private String baseXFile;

    public SymonConsoleLoginPanel(JFrame jFrame, String string, String string2, String string3, String string4, boolean bl, boolean bl2) {
        super(jFrame, bl, string3, bl2);
        this.remoteHost = string2;
        this.remotePort = string;
        this.baseXFile = string4;
    }

    private boolean allRequiredPresent() {
        if (this.loginIDTextfield.getText().trim().length() == 0) {
            this.loginIDTextfield.requestFocus();
            ((Component)this.frame).setCursor(Cursor.getPredefinedCursor(0));
            this.frame.getToolkit().sync();
            return false;
        }
        if (this.serverHost.getText().trim().length() == 0) {
            this.serverHost.requestFocus();
            ((Component)this.frame).setCursor(Cursor.getPredefinedCursor(0));
            this.frame.getToolkit().sync();
            return false;
        }
        InetAddress inetAddress = null;
        this.hostName = this.serverHost.getText().trim();
        try {
            inetAddress = InetAddress.getByName(this.hostName);
        }
        catch (UnknownHostException unknownHostException) {
            String string = UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:badhost", (boolean)true);
            this.showInvalidInfoDialog(string);
            this.serverHost.requestFocus();
            ((Component)this.frame).setCursor(Cursor.getPredefinedCursor(0));
            this.frame.getToolkit().sync();
            return false;
        }
        catch (Exception exception) {
            Toolkit.getDefaultToolkit().beep();
            String string = UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:checksecurity", (boolean)true);
            this.showInvalidInfoDialog(string);
            this.serverHost.requestFocus();
            ((Component)this.frame).setCursor(Cursor.getPredefinedCursor(0));
            this.frame.getToolkit().sync();
            return false;
        }
        this.checkPort();
        if (!this.portOk) {
            this.optionButt.requestFocus();
            return false;
        }
        return true;
    }

    public void build() {
        JTextArea jTextArea = new JTextArea(UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:helptext", (boolean)true));
        jTextArea.setEditable(false);
        this.okButt = new JButton(UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:okbutt", (boolean)true));
        JPanel jPanel = new JPanel();
        jPanel.add(this.okButt);
        this.helpDialog = new JDialog(this.frame, UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:help", (boolean)true), true);
        this.helpDialog.getContentPane().add("Center", new JScrollPane(jTextArea));
        this.helpDialog.getContentPane().add("South", jPanel);
        ((Component)this.helpDialog).setSize(550, 400);
        this.helpDialog.setResizable(true);
        CtMarginPanel ctMarginPanel = new CtMarginPanel(new Insets(0, 50, 10, 50));
        ctMarginPanel.setLayout(new GridLayout(1, 3));
        CustomPanel customPanel = new CustomPanel();
        this.applyButt = new JButton(UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:applybutt", (boolean)true));
        this.cancelButt = new JButton(UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:cancelbutt", (boolean)true));
        ctMarginPanel.add(this.applyButt);
        ctMarginPanel.add(new JLabel(""));
        ctMarginPanel.add(this.cancelButt);
        this.serverPort = new CustomTextField(5);
        if (this.remotePort == null) {
            this.serverPort.setText(new Integer(this.hostPort).toString());
        } else {
            this.lastSavedPort = this.remotePort.trim();
            this.serverPort.setText(this.lastSavedPort);
        }
        JLabel jLabel = new JLabel(UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:portlabel", (boolean)true));
        GridBagLayout gridBagLayout = new GridBagLayout();
        customPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 10, 4, 0);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        customPanel.add(jLabel);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.serverPort, gridBagConstraints);
        customPanel.add(this.serverPort);
        CustomPanel customPanel2 = new CustomPanel();
        GridLayout gridLayout = new GridLayout(4, 1);
        customPanel2.setLayout(gridLayout);
        customPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 0));
        JLabel jLabel2 = new JLabel(UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:security.label", (boolean)true));
        this.securityGroup = new ButtonGroup();
        this.weakButton = new JRadioButton(UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:security.weak", (boolean)true));
        this.mediumButton = new JRadioButton(UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:security.medium", (boolean)true), true);
        this.strongButton = new JRadioButton(UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:security.strong", (boolean)true));
        this.weakButton.setFont(this.font);
        this.mediumButton.setFont(this.font);
        this.strongButton.setFont(this.font);
        this.securityGroup.add(this.weakButton);
        this.securityGroup.add(this.mediumButton);
        this.securityGroup.add(this.strongButton);
        customPanel2.add(jLabel2);
        customPanel2.add(this.weakButton);
        customPanel2.add(this.mediumButton);
        customPanel2.add(this.strongButton);
        this.optionDialog = new JDialog(this.frame, UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:optionTitle", (boolean)true), true);
        this.optionDialog.getContentPane().add("North", customPanel2);
        this.optionDialog.getContentPane().add("Center", customPanel);
        this.optionDialog.getContentPane().add("South", ctMarginPanel);
        super.createStatusBox();
        this.cancelButt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SymonConsoleLoginPanel.this.serverPort.setText(SymonConsoleLoginPanel.this.lastSavedPort);
                ((Component)SymonConsoleLoginPanel.this.optionDialog).setVisible(false);
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
                SymonConsoleLoginPanel.this.optionDialog.dispose();
                if (!SymonConsoleLoginPanel.this.allRequiredPresent()) {
                    return;
                }
                SymonConsoleLoginPanel.this.loginButt.requestFocus();
            }
        });
        this.applyButt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SymonConsoleLoginPanel.this.checkPort();
                if (!SymonConsoleLoginPanel.this.portOk) {
                    SymonConsoleLoginPanel.this.serverPort.requestFocus();
                    return;
                }
                SymonConsoleLoginPanel.this.lastSavedPort = SymonConsoleLoginPanel.this.serverPort.getText().trim();
                SymonConsoleLoginPanel.this.securityScheme = SymonConsoleLoginPanel.this.getSelectedSecurityScheme();
                ((Component)SymonConsoleLoginPanel.this.optionDialog).setVisible(false);
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
                SymonConsoleLoginPanel.this.optionDialog.dispose();
                if (!SymonConsoleLoginPanel.this.allRequiredPresent()) {
                    return;
                }
                SymonConsoleLoginPanel.this.loginButt.requestFocus();
            }
        });
        this.serverPort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SymonConsoleLoginPanel.this.checkPort();
                if (!SymonConsoleLoginPanel.this.portOk) {
                    SymonConsoleLoginPanel.this.serverPort.requestFocus();
                    return;
                }
                SymonConsoleLoginPanel.this.lastSavedPort = SymonConsoleLoginPanel.this.serverPort.getText().trim();
                ((Component)SymonConsoleLoginPanel.this.optionDialog).setVisible(false);
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
                SymonConsoleLoginPanel.this.optionDialog.dispose();
                if (!SymonConsoleLoginPanel.this.allRequiredPresent()) {
                    return;
                }
                SymonConsoleLoginPanel.this.loginButt.requestFocus();
            }
        });
        this.okButt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)SymonConsoleLoginPanel.this.helpDialog).setVisible(false);
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
                SymonConsoleLoginPanel.this.helpDialog.dispose();
            }
        });
        this.serverPort.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                Character c = new Character('\n');
                if (c.equals(new Character(keyEvent.getKeyChar()))) {
                    SymonConsoleLoginPanel.this.serverPort.transferFocus();
                }
            }
        });
        super.setTitle();
        super.layoutMainPanel();
        this.constraints.gridwidth = 1;
        this.constraints.fill = 1;
        this.constraints.weightx = 0.0;
        JLabel jLabel3 = new JLabel(UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:serverhost", (boolean)true));
        this.gridbag.setConstraints(jLabel3, this.constraints);
        this.enterUserDataPanel.add(jLabel3);
        this.serverHost = new CustomTextField();
        this.serverHost.addActionListener(this);
        this.serverHost.setText(this.remoteHost);
        this.statusBox.validate();
        this.frame.repaint();
        this.constraints.weightx = 1.0;
        this.constraints.fill = 2;
        this.constraints.gridwidth = 0;
        this.gridbag.setConstraints(this.serverHost, this.constraints);
        this.enterUserDataPanel.add(this.serverHost);
        super.layoutButtons();
        this.helpButt = new JButton(UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:helpbutt", (boolean)true));
        this.helpButt.addActionListener(this);
        this.buttonPanel.add(this.helpButt);
        this.optionButt = new JButton(UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:optionbutt", (boolean)true));
        this.optionButt.addActionListener(this);
        this.buttonPanel.add(this.optionButt);
        super.addExitButton();
    }

    private void checkPort() {
        String string = this.serverPort.getText().trim();
        if (string.length() == 0) {
            this.serverPort.setText(ConsoleLoginPanel.DEFAULT_PORT_STRING);
            this.hostPort = ConsoleLoginPanel.DEFAULT_PORT;
        }
        try {
            this.hostPort = Integer.parseInt(string);
        }
        catch (Exception exception) {
            String string2 = UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:badport", (boolean)true);
            this.showInvalidInfoDialog(string2);
            this.optionButt.requestFocus();
            this.portOk = false;
            return;
        }
        if (this.hostPort < 0 || this.hostPort > 65535) {
            String string3 = UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:badport", (boolean)true);
            this.showInvalidInfoDialog(string3);
            this.optionButt.requestFocus();
            this.portOk = false;
            return;
        }
        this.portOk = true;
    }

    protected void enableButtons(boolean bl) {
        this.loginButt.setEnabled(bl);
        this.optionButt.setEnabled(bl);
        this.helpButt.setEnabled(bl);
        this.exitButt.setEnabled(bl);
        if (bl) {
            this.serverHost.addActionListener(this);
        } else {
            this.serverHost.removeActionListener(this);
        }
    }

    private String getSelectedSecurityScheme() {
        if (this.weakButton.isSelected()) {
            return "weak";
        }
        if (this.strongButton.isSelected()) {
            return "strong";
        }
        return "medium";
    }

    protected void handleBootException(BsRMIBootstrapException bsRMIBootstrapException) {
        ((Component)this.frame).setVisible(true);
        String string = null;
        switch (bsRMIBootstrapException.getReason()) {
            case 1: {
                string = "remoteex";
                this.serverHost.requestFocus();
                break;
            }
            case 2: {
                string = "registryex";
                this.optionButt.requestFocus();
                break;
            }
            case 3: {
                string = "unboundex";
                this.serverHost.requestFocus();
                break;
            }
            case 4: {
                string = "invalidurlex";
                this.optionButt.requestFocus();
                break;
            }
            case 5: {
                string = "unexpectedex(" + bsRMIBootstrapException.getMessage() + ")";
                this.loginIDTextfield.requestFocus();
                break;
            }
            case 17: {
                string = "sessionlimitex";
                this.loginIDTextfield.requestFocus();
                break;
            }
            case 6: {
                string = "rejectex";
                this.loginIDTextfield.requestFocus();
                break;
            }
            case 7: {
                string = "unknownex";
                this.loginIDTextfield.requestFocus();
                break;
            }
            case 8: {
                string = "logerrorex";
                this.loginIDTextfield.requestFocus();
                break;
            }
            case 12: {
                string = "nosecurityex";
                this.loginIDTextfield.requestFocus();
                break;
            }
            case 13: {
                string = "logtimeoutex";
                this.loginIDTextfield.requestFocus();
                break;
            }
            case 14: {
                string = "loginvaliduser";
                this.loginIDTextfield.requestFocus();
                break;
            }
            case 16: {
                string = "loginvalidpassword";
                this.loginIDTextfield.requestFocus();
                break;
            }
            case 15: {
                string = "logunknownuser";
                this.loginIDTextfield.requestFocus();
                break;
            }
            case 9: {
                string = "classex";
                this.optionButt.requestFocus();
                break;
            }
            case 10: {
                string = "initex";
                this.optionButt.requestFocus();
                break;
            }
            case 11: {
                string = "bootex";
                this.optionButt.requestFocus();
                break;
            }
        }
        String string2 = bsRMIBootstrapException.getReason() == 2 ? String.valueOf(UcInternationalizer.translateKey((String)("base.console.main.ConsoleLogin:" + string), (boolean)true)) + " " + this.hostPort : UcInternationalizer.translateKey((String)("base.console.main.ConsoleLogin:" + string), (boolean)true);
        this.showInvalidInfoDialog(string2);
        this.statusMesg.setText("");
        this.frame.repaint();
    }

    public void handleButtonPress(ActionEvent actionEvent) {
        BsRMIBootstrap bsRMIBootstrap;
        Object object = actionEvent.getSource();
        if (object == this.helpButt) {
            this.helpButt.setEnabled(false);
            this.helpDialog.show();
            this.helpButt.setEnabled(true);
            return;
        }
        if (object == this.exitButt) {
            System.exit(0);
        }
        if (object == this.optionButt) {
            this.optionButt.setEnabled(false);
            this.serverPort.requestFocus();
            this.setSecurityScheme();
            this.optionDialog.pack();
            this.optionDialog.setResizable(false);
            this.optionDialog.show();
            this.optionButt.setEnabled(true);
            return;
        }
        if (object == this.loginIDTextfield) {
            this.loginIDTextfield.transferFocus();
            return;
        }
        if (object == this.passwordField) {
            this.passwordField.transferFocus();
            return;
        }
        ((Component)this.frame).setCursor(Cursor.getPredefinedCursor(3));
        this.frame.getToolkit().sync();
        if (this.loginIDTextfield.getText().trim().length() == 0) {
            String string = UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:needid", (boolean)true);
            this.showInvalidInfoDialog(string);
            this.loginIDTextfield.requestFocus();
            ((Component)this.frame).setCursor(Cursor.getPredefinedCursor(0));
            this.frame.getToolkit().sync();
            return;
        }
        if (this.passwordField.getText().length() == 0) {
            String string = UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:needpw", (boolean)true);
            this.showInvalidInfoDialog(string);
            this.passwordField.requestFocus();
            ((Component)this.frame).setCursor(Cursor.getPredefinedCursor(0));
            ((Component)this.frame).setCursor(Cursor.getPredefinedCursor(0));
            this.frame.getToolkit().sync();
            return;
        }
        if (this.serverHost.getText().trim().length() == 0) {
            String string = UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:needhost", (boolean)true);
            this.showInvalidInfoDialog(string);
            this.serverHost.requestFocus();
            ((Component)this.frame).setCursor(Cursor.getPredefinedCursor(0));
            this.frame.getToolkit().sync();
            return;
        }
        InetAddress inetAddress = null;
        this.hostName = this.serverHost.getText().trim();
        try {
            inetAddress = InetAddress.getByName(this.hostName);
        }
        catch (UnknownHostException unknownHostException) {
            String string = UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:badhost", (boolean)true);
            this.showInvalidInfoDialog(string);
            this.serverHost.requestFocus();
            ((Component)this.frame).setCursor(Cursor.getPredefinedCursor(0));
            this.frame.getToolkit().sync();
            return;
        }
        catch (Exception exception) {
            Toolkit.getDefaultToolkit().beep();
            String string = UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:checksecurity", (boolean)true);
            this.showInvalidInfoDialog(string);
            this.serverHost.requestFocus();
            ((Component)this.frame).setCursor(Cursor.getPredefinedCursor(0));
            this.frame.getToolkit().sync();
            return;
        }
        this.checkPort();
        if (!this.portOk) {
            this.optionButt.requestFocus();
            return;
        }
        this.loginButt.setEnabled(false);
        this.optionButt.setEnabled(false);
        this.helpButt.setEnabled(false);
        this.exitButt.setEnabled(false);
        this.serverHost.removeActionListener(this);
        this.statusMesg.setText(UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:starting", (boolean)true));
        this.frame.repaint();
        try {
            bsRMIBootstrap = new BsRMIBootstrap(this.hostName, this.hostPort);
        }
        catch (BsRMIBootstrapException bsRMIBootstrapException) {
            this.handleBootException(bsRMIBootstrapException);
            this.loginButt.setEnabled(true);
            this.optionButt.setEnabled(true);
            this.helpButt.setEnabled(true);
            this.exitButt.setEnabled(true);
            this.serverHost.addActionListener(this);
            return;
        }
        catch (Exception exception) {
            this.showInvalidInfoDialog(UcInternationalizer.translateKey((String)("com.sun.symon.base.console.main.ConsoleLogin:unexpectedex(" + exception.toString() + ")")));
            this.loginButt.setEnabled(true);
            this.optionButt.setEnabled(true);
            this.helpButt.setEnabled(true);
            this.exitButt.setEnabled(true);
            this.statusMesg.setText("");
            this.frame.repaint();
            return;
        }
        this.statusMesg.setText(UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:connectok", (boolean)true));
        this.statusBox.validate();
        this.frame.repaint();
        ConsoleLoginRunner consoleLoginRunner = new ConsoleLoginRunner(this, bsRMIBootstrap, this.baseXFile);
        consoleLoginRunner.start();
    }

    private void setSecurityScheme() {
        if (this.securityScheme.equals("weak")) {
            this.weakButton.setSelected(true);
        } else if (this.securityScheme.equals("strong")) {
            this.strongButton.setSelected(true);
        } else {
            this.mediumButton.setSelected(true);
        }
    }
}

