/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.main;

import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.server.receptors.rmi.RMIClientLevel1;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.server.types.StString;
import com.sun.symon.base.utility.UcListUtil;
import java.util.Vector;

public class ServerControl {
    public static final int DUMP_CONTEXT_CACHE = 0;
    public static final int CLEAR_CONTEXT_CACHE = 1;
    public static final int REMOVE_HOST_CONTEXT_CACHE = 2;
    public static final int REMOVE_HOSTPORT_CONTEXT_CACHE = 3;
    public static final int DUMP_FINDER_CACHE = 4;
    public static final int CLEAR_FINDER_CACHE = 5;
    public static final int REMOVE_HOST_FINDER_CACHE = 6;
    public static final int REMOVE_HOSTPORT_FINDER_CACHE = 7;

    public static String formatResponse(StObject[][] stObjectArray) {
        if (stObjectArray.length != 1 || stObjectArray[0].length != 1 || stObjectArray[0][0] == null) {
            return "Invalid return value";
        }
        Vector vector = new Vector();
        UcListUtil.decomposeList((String)((StString)stObjectArray[0][0]).toString(), vector);
        if (vector.size() != 3) {
            return "Invalid return value";
        }
        Vector vector2 = new Vector();
        UcListUtil.decomposeList((String)((String)vector.elementAt(0)), vector2);
        Vector vector3 = new Vector();
        UcListUtil.decomposeList((String)((String)vector.elementAt(1)), vector3);
        Vector vector4 = new Vector();
        UcListUtil.decomposeList((String)((String)vector.elementAt(2)), vector4);
        String string = "\n*** Subpath Cache with Shadow ***\n";
        int n = 0;
        while (n < vector3.size()) {
            string = String.valueOf(string) + (String)vector3.elementAt(n) + "\n";
            ++n;
        }
        string = String.valueOf(string) + "\n*** Subpath Cache without Shadow ***\n";
        int n2 = 0;
        while (n2 < vector2.size()) {
            string = String.valueOf(string) + (String)vector2.elementAt(n2) + "\n";
            ++n2;
        }
        string = String.valueOf(string) + "\n*** Shadow Oid Cache ***\n";
        int n3 = 0;
        while (n3 < vector4.size()) {
            string = String.valueOf(string) + (String)vector4.elementAt(n3) + "\n";
            ++n3;
        }
        return string;
    }

    public static void main(String[] stringArray) {
        System.out.println();
        if (stringArray.length < 5 || stringArray.length > 7) {
            ServerControl.usage();
        }
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        try {
            n = Integer.parseInt(stringArray[1]);
        }
        catch (Exception exception) {
            System.err.println("Invalid Server Port Value: " + stringArray[1]);
            System.exit(1);
        }
        try {
            n2 = Integer.parseInt(stringArray[4]);
        }
        catch (Exception exception) {
            System.err.println("Invalid Command Value: " + stringArray[4]);
            System.exit(1);
        }
        if (stringArray.length == 7) {
            try {
                n3 = Integer.parseInt(stringArray[6]);
            }
            catch (Exception exception) {
                System.err.println("Invalid Agent Port Value: " + stringArray[6]);
                System.exit(1);
            }
        }
        String string = stringArray[0];
        String string2 = stringArray[2];
        String string3 = stringArray[3];
        String string4 = null;
        if (stringArray.length > 5) {
            string4 = stringArray[5];
        }
        String[] stringArray2 = new String[1];
        String string5 = null;
        stringArray2[0] = "control://" + string + ":" + n + "/";
        String string6 = null;
        String string7 = null;
        switch (n2) {
            case 0: {
                stringArray2[0] = String.valueOf(stringArray2[0]) + "context";
                break;
            }
            case 1: {
                stringArray2[0] = String.valueOf(stringArray2[0]) + "context";
                string5 = "clear";
                break;
            }
            case 2: {
                if (string4 == null) {
                    ServerControl.usage();
                }
                stringArray2[0] = String.valueOf(stringArray2[0]) + "context";
                string5 = "remove " + string4;
                break;
            }
            case 3: {
                if (string4 == null || n3 == -1) {
                    ServerControl.usage();
                }
                stringArray2[0] = String.valueOf(stringArray2[0]) + "context";
                string5 = "remove " + string4 + ":" + n3;
                break;
            }
            case 4: {
                stringArray2[0] = String.valueOf(stringArray2[0]) + "finder";
                string6 = "sym/base/control/cache#0";
                break;
            }
            case 5: {
                stringArray2[0] = String.valueOf(stringArray2[0]) + "finder";
                string5 = "clear";
                string6 = "sym/base/control/cache#0";
                string7 = "*";
                break;
            }
            case 6: {
                if (string4 == null) {
                    ServerControl.usage();
                }
                stringArray2[0] = String.valueOf(stringArray2[0]) + "finder";
                string5 = "remove " + string4;
                string6 = "sym/base/control/cache#0";
                string7 = string4;
                break;
            }
            case 7: {
                if (string4 == null || n3 == -1) {
                    ServerControl.usage();
                }
                stringArray2[0] = String.valueOf(stringArray2[0]) + "finder";
                string5 = "remove " + string4 + ":" + n3;
                string6 = "sym/base/control/cache#0";
                string7 = String.valueOf(string4) + ":" + n3;
                break;
            }
            default: {
                System.err.println("Invalid Command Value: " + n2);
                System.exit(1);
            }
        }
        try {
            RMIClientLevel1 rMIClientLevel1 = new RMIClientLevel1(string, n);
            System.out.println("Connecting to Sun Management Center Server...");
            System.out.println();
            rMIClientLevel1.authenticate(string2, string3, "687a8398ad4a85077d33b72a94e16ffde0c4ba023e9c9ba77b247cc25bd3cd0015bc24b7429916751e681fd02e5ad6eb5345eb7c75b39a1c304e0f000846aa470b755b0640af974e7fc70daa6191dff6efa31a09431bb5e9848b7dc4cf4b97e1dbca31792d2860ca5a5990dfb369e1bcf296274a4e4984c8089329679dd304cd");
            SMRawDataRequest sMRawDataRequest = new SMRawDataRequest(rMIClientLevel1);
            System.out.println();
            System.out.println("Checking Sun Management Center Server version...");
            String string8 = null;
            try {
                string8 = sMRawDataRequest.getServerVersion("revision");
            }
            catch (Exception exception) {
                sMRawDataRequest.disconnect();
                System.err.println("The Sun Management Center Console version you are using does not support this utility");
                System.exit(1);
            }
            if (string8 == null || string8.equals("2_0_00_00")) {
                sMRawDataRequest.disconnect();
                System.err.println("The Sun Management Center Server version you are using does not support this utility.");
                System.exit(1);
            }
            System.out.println();
            System.out.println("Initiating Server Control Function...");
            try {
                StObject[][] stObjectArray;
                StObject[][] stObjectArray2 = null;
                if (string5 == null) {
                    stObjectArray2 = sMRawDataRequest.getURLValue(stringArray2);
                } else {
                    stObjectArray = new StObject[1][1];
                    stObjectArray[0][0] = new StString(string5);
                    stObjectArray2 = sMRawDataRequest.setURLValue(stringArray2, stObjectArray);
                }
                System.out.println((StString)stObjectArray2[0][0]);
                if (string6 != null) {
                    if (string7 == null) {
                        stringArray2[0] = String.valueOf(sMRawDataRequest.getTopologyBaseURL()) + string6;
                        stObjectArray2 = sMRawDataRequest.getURLValue(stringArray2);
                        System.out.println();
                        System.out.println("TOPOLOGY MANAGER FINDER CACHES");
                        System.out.println(ServerControl.formatResponse(stObjectArray2));
                        stringArray2[0] = String.valueOf(sMRawDataRequest.getEventBaseURL()) + string6;
                        stObjectArray2 = sMRawDataRequest.getURLValue(stringArray2);
                        System.out.println();
                        System.out.println("EVENT AGENT FINDER CACHES");
                        System.out.println(ServerControl.formatResponse(stObjectArray2));
                        stringArray2[0] = String.valueOf(sMRawDataRequest.getConfigurationBaseURL()) + string6;
                        stObjectArray2 = sMRawDataRequest.getURLValue(stringArray2);
                        System.out.println();
                        System.out.println("CONFIGURATION SERVER FINDER CACHES");
                        System.out.println(ServerControl.formatResponse(stObjectArray2));
                    } else {
                        stObjectArray = new StObject[1][1];
                        stObjectArray[0][0] = new StString(string7);
                        stringArray2[0] = String.valueOf(sMRawDataRequest.getTopologyBaseURL()) + string6;
                        sMRawDataRequest.setURLValue(stringArray2, stObjectArray);
                        System.out.println();
                        if (string7.equals("*")) {
                            System.out.println("Topology Manager Oid Cache cleared of all entries");
                        } else {
                            System.out.println("Topology Manager Oid Cache cleared of entries for " + string7);
                        }
                        System.out.println();
                        stringArray2[0] = String.valueOf(sMRawDataRequest.getEventBaseURL()) + string6;
                        sMRawDataRequest.setURLValue(stringArray2, stObjectArray);
                        if (string7.equals("*")) {
                            System.out.println("Event Agent Oid Cache cleared of all entries");
                        } else {
                            System.out.println("Event Agent Oid Cache cleared of entries for " + string7);
                        }
                        System.out.println();
                        stringArray2[0] = String.valueOf(sMRawDataRequest.getConfigurationBaseURL()) + string6;
                        sMRawDataRequest.setURLValue(stringArray2, stObjectArray);
                        if (string7.equals("*")) {
                            System.out.println("Configuration Server Oid Cache cleared of all entries");
                        } else {
                            System.out.println("Configuration Server Oid Cache cleared of entries for " + string7);
                        }
                    }
                }
                sMRawDataRequest.disconnect();
                System.exit(0);
            }
            catch (Exception exception) {
                sMRawDataRequest.disconnect();
                System.err.println("Server Control Function failed: " + exception);
                System.exit(1);
            }
        }
        catch (Exception exception) {
            System.err.println("Server Control Function failed: " + exception);
            System.exit(1);
        }
    }

    public static void usage() {
        System.err.println("usage: jre ServerControl serverhost serverport user password command [agenthost] [agentport]");
        System.err.println();
        System.err.println("Available commands:");
        System.err.println("0 = DUMP_CONTEXT_CACHE");
        System.err.println("1 = CLEAR_CONTEXT_CACHE");
        System.err.println("2 = REMOVE_HOST_CONTEXT_CACHE (agenthost must be specified)");
        System.err.println("3 = REMOVE_HOSTPORT_CONTEXT_CACHE (agenthost and agentport must be specified)");
        System.err.println("4 = DUMP_FINDER_CACHE");
        System.err.println("5 = CLEAR_FINDER_CACHE");
        System.err.println("6 = REMOVE_HOST_FINDER_CACHE (agenthost must be specified)");
        System.err.println("7 = REMOVE_HOSTPORT_FINDER_CACHE (agenthost and agentport must be specified)");
        System.exit(1);
    }
}

