/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.logview;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRequestStatus;
import com.sun.symon.base.client.log.SMLogViewerRequest;
import com.sun.symon.base.client.log.SMLogViewerResponse;
import com.sun.symon.base.console.logview.LogPanel;
import com.sun.symon.base.console.logview.TailListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

class TailListener
extends JDialog
implements ActionListener {
    private LogPanel logPanel;
    private JRadioButton enableTail;
    private JRadioButton disableTail;
    private JCheckBox clearArea;
    private JTextField patternText;
    private boolean changed = false;
    private boolean enable = false;
    private boolean clear = false;
    private String pattern = "";
    private TailOKListener tailOKListener;
    private JLabel status;

    public TailListener(LogPanel logPanel, Frame frame) {
        super(frame);
        this.logPanel = logPanel;
        this.setTitle(this.logPanel.translate("monitorFilterOptions"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Container container = this.getContentPane();
        container.setLayout(gridBagLayout);
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        jPanel.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 10, 5, 5)));
        this.enableTail = new JRadioButton(this.logPanel.translate("enableMonitoring"));
        this.disableTail = new JRadioButton(this.logPanel.translate("disableMonitoring"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.enableTail);
        buttonGroup.add(this.disableTail);
        jPanel.add(this.enableTail);
        jPanel.add(this.disableTail);
        this.enableTail.setSelected(this.enable);
        this.disableTail.setSelected(this.enable ^ true);
        gridBagConstraints.insets = new Insets(25, 20, 0, 20);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        container.add((Component)jPanel, gridBagConstraints);
        this.clearArea = new JCheckBox(this.logPanel.translate("clearMessages"));
        this.clearArea.setSelected(this.clear);
        gridBagConstraints.insets = new Insets(10, 20, 0, 20);
        container.add((Component)this.clearArea, gridBagConstraints);
        this.patternText = new JTextField();
        this.patternText.setMargin(new Insets(1, 2, 1, 0));
        this.patternText.setColumns(8);
        if (this.changed) {
            this.patternText.setText(this.pattern);
        } else {
            this.patternText.setText(this.logPanel.getFilter().getPattern());
        }
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(10, 20, 0, 0);
        gridBagConstraints.anchor = 10;
        container.add((Component)this.patternText, gridBagConstraints);
        JLabel jLabel = new JLabel(this.logPanel.translate("textToMatch"));
        jLabel.setForeground(Color.black);
        gridBagConstraints.insets = new Insets(15, 3, 0, 15);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        container.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(20, 5, 0, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        container.add((Component)new JSeparator(), gridBagConstraints);
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 25, 5));
        JButton jButton = new JButton(this.logPanel.translate("ok"));
        JButton jButton2 = new JButton(this.logPanel.translate("apply"));
        TailOKListener tailOKListener = new TailOKListener();
        jButton.addActionListener(tailOKListener);
        jButton2.addActionListener(tailOKListener);
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jButton.setActionCommand("OK");
        JButton jButton3 = new JButton(this.logPanel.translate("cancel"));
        jButton3.setToolTipText(this.logPanel.translate("cancelToolTip"));
        class TailCancelListener
        implements ActionListener {
            private final /* synthetic */ TailListener this$0;

            TailCancelListener(TailListener tailListener) {
                this.this$0 = tailListener;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)this.this$0).setVisible(false);
                this.this$0.initTailListener();
            }
        }
        jButton3.addActionListener(new TailCancelListener(this));
        jPanel2.add(jButton3);
        gridBagConstraints.insets = new Insets(10, 0, 15, 0);
        gridBagConstraints.gridwidth = 0;
        container.add((Component)jPanel2, gridBagConstraints);
        this.pack();
    }

    static /* synthetic */ boolean access$1(TailListener tailListener) {
        return tailListener.changed;
    }

    static /* synthetic */ boolean access$10(TailListener tailListener) {
        return tailListener.enable;
    }

    static /* synthetic */ boolean access$4(TailListener tailListener) {
        return tailListener.clear;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isVisible()) {
            this.show();
            return;
        }
        ((Component)this).setVisible(true);
    }

    void initTailListener() {
        this.enableTail.setSelected(this.enable);
        this.clearArea.setSelected(this.clear);
        if (this.changed) {
            this.patternText.setText(this.pattern);
        } else {
            this.patternText.setText(this.logPanel.getFilter().getPattern());
        }
    }

    class TailOKListener
    implements ActionListener,
    SMLogViewerResponse {
        private SMLogViewerRequest tailReq = null;
        private boolean newPattern;
        private Object[] oneOption = new Object[]{TailListener.access$0(TailListener.this).translate("ok")};

        TailOKListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component = (Component)actionEvent.getSource();
            TailListener.this.changed = true;
            if (TailListener.this.clearArea.isSelected()) {
                TailListener.this.clear = true;
                TailListener.this.logPanel.setTailArea("");
            } else {
                TailListener.this.clear = false;
            }
            String string = TailListener.this.patternText.getText().trim();
            this.newPattern = !string.equals(TailListener.this.pattern);
            TailListener.this.pattern = string;
            if (TailListener.this.enableTail.isSelected() && this.tailReq == null || this.newPattern) {
                TailListener.this.enable = true;
                try {
                    if (this.tailReq != null) {
                        this.tailReq.closeConnection();
                    }
                    this.tailReq = new SMLogViewerRequest(TailListener.this.logPanel.getRawRequestHandle(), TailListener.this.logPanel.getAgentHost(), TailListener.this.logPanel.getAgentPort());
                    this.tailReq.logSearch(TailListener.this.logPanel.getFileTypeSelection(), null, TailListener.this.pattern, (SMLogViewerResponse)this, new Object());
                }
                catch (SMAPIException sMAPIException) {
                    JOptionPane.showOptionDialog(TailListener.this.logPanel.getLogWindow(component), TailListener.this.logPanel.translate("monitoringRequestFailed"), TailListener.this.logPanel.translate("alert"), -1, 0, null, this.oneOption, this.oneOption[0]);
                    return;
                }
            }
            if (!TailListener.this.enableTail.isSelected()) {
                TailListener.this.enable = false;
                if (this.tailReq != null) {
                    try {
                        this.tailReq.closeConnection();
                    }
                    catch (SMAPIException sMAPIException) {}
                }
                this.tailReq = null;
            }
            if (actionEvent.getActionCommand().compareTo("OK") == 0) {
                ((Component)TailListener.this).setVisible(false);
            }
        }

        public void logSearchResponse(SMRequestStatus sMRequestStatus, StringBuffer stringBuffer, Object object) {
            if (this.tailReq != null && stringBuffer != null) {
                TailListener.this.logPanel.setTailArea(stringBuffer.toString());
            }
        }
    }
}

