/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.logview;

import com.sun.symon.base.console.logview.Filter;
import com.sun.symon.base.console.logview.FilterListener;
import com.sun.symon.base.console.logview.LogPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

class FilterListener
extends JDialog
implements ActionListener {
    private LogPanel logPanel;
    private Container contentPane;
    private JPanel morePanel;
    private JComboBox startMonthList;
    private JComboBox startDayList;
    private JComboBox startYearList;
    private JComboBox startHourList;
    private JComboBox startMinuteList;
    private JComboBox startSecondList;
    private JComboBox endMonthList;
    private JComboBox endDayList;
    private JComboBox endYearList;
    private JComboBox endHourList;
    private JComboBox endMinuteList;
    private JComboBox endSecondList;
    private JRadioButton startAM;
    private JRadioButton startPM;
    private JRadioButton endAM;
    private JRadioButton endPM;
    private JRadioButton oldest = null;
    private JRadioButton latest = null;
    private JTextField maxMatchesText = null;
    private JTextField patternText;
    private Filter filter;
    private Filter previousFilter;
    private FilterMoreListener filterMoreListener;
    private EndListener endListener;
    private boolean newEnd = false;
    private boolean pendingNewEnd = false;

    public FilterListener(LogPanel logPanel, Frame frame) {
        super(frame);
        this.logPanel = logPanel;
        this.setTitle(this.logPanel.translate("messageFilterOptions"));
        this.filter = this.logPanel.getFilter();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.contentPane = this.getContentPane();
        this.contentPane.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel(this.logPanel.translate("startDate"));
        gridBagConstraints.insets = new Insets(25, 25, 0, 0);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = 1;
        this.contentPane.add((Component)jLabel, gridBagConstraints);
        this.startMonthList = new JComboBox();
        int n = 0;
        while (n < Filter.month.length) {
            this.startMonthList.addItem(this.logPanel.translate(Filter.month[n]));
            ++n;
        }
        this.startMonthList.setSelectedIndex(this.filter.getStartMonth());
        this.startMonthList.setPreferredSize(new Dimension(120, 23));
        gridBagConstraints.insets = new Insets(21, 5, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 3;
        this.contentPane.add((Component)this.startMonthList, gridBagConstraints);
        this.startDayList = new JComboBox<String>(Filter.day);
        this.startDayList.setSelectedIndex(this.filter.getStartDay());
        this.startDayList.setPreferredSize(new Dimension(48, 23));
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(21, 8, 0, 0);
        gridBagConstraints.fill = 0;
        this.contentPane.add((Component)this.startDayList, gridBagConstraints);
        this.startYearList = new JComboBox<String>(Filter.year);
        this.startYearList.setSelectedIndex(this.filter.getStartYear());
        this.startYearList.setPreferredSize(new Dimension(65, 23));
        gridBagConstraints.insets = new Insets(21, 8, 0, 25);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        this.contentPane.add((Component)this.startYearList, gridBagConstraints);
        JLabel jLabel2 = new JLabel(this.logPanel.translate("startTime"));
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = 1;
        this.contentPane.add((Component)jLabel2, gridBagConstraints);
        this.startHourList = new JComboBox<String>(Filter.hour);
        this.startHourList.setSelectedIndex(this.filter.getStartHour());
        this.startHourList.setPreferredSize(new Dimension(48, 23));
        gridBagConstraints.insets = new Insets(11, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        this.contentPane.add((Component)this.startHourList, gridBagConstraints);
        JLabel jLabel3 = new JLabel(this.logPanel.translate("colon"));
        jLabel3.setFont(new Font("Display", 1, 12));
        jLabel3.setForeground(Color.black);
        gridBagConstraints.insets = new Insets(11, 2, 0, 0);
        gridBagConstraints.anchor = 17;
        this.contentPane.add((Component)jLabel3, gridBagConstraints);
        this.startMinuteList = new JComboBox<String>(Filter.minute);
        this.startMinuteList.setSelectedIndex(this.filter.getStartMinute());
        this.startMinuteList.setPreferredSize(new Dimension(48, 23));
        gridBagConstraints.insets = new Insets(11, 2, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.contentPane.add((Component)this.startMinuteList, gridBagConstraints);
        JLabel jLabel4 = new JLabel(this.logPanel.translate("colon"));
        jLabel4.setFont(new Font("Display", 1, 12));
        jLabel4.setForeground(Color.black);
        gridBagConstraints.insets = new Insets(11, 2, 0, 0);
        gridBagConstraints.anchor = 17;
        this.contentPane.add((Component)jLabel4, gridBagConstraints);
        this.startSecondList = new JComboBox<String>(Filter.second);
        this.startSecondList.setSelectedIndex(this.filter.getStartSecond());
        this.startSecondList.setPreferredSize(new Dimension(48, 23));
        gridBagConstraints.insets = new Insets(11, 2, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        this.contentPane.add((Component)this.startSecondList, gridBagConstraints);
        this.contentPane.add((Component)new JLabel(" "), gridBagConstraints);
        JLabel jLabel5 = new JLabel(this.logPanel.translate("endDate"));
        gridBagConstraints.insets = new Insets(25, 32, 0, 0);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        this.contentPane.add((Component)jLabel5, gridBagConstraints);
        this.endMonthList = new JComboBox();
        n = 0;
        while (n < Filter.month.length) {
            this.endMonthList.addItem(this.logPanel.translate(Filter.month[n]));
            ++n;
        }
        this.endMonthList.setSelectedIndex(this.filter.getEndMonth());
        this.endMonthList.setPreferredSize(new Dimension(120, 23));
        this.endListener = new EndListener();
        this.endMonthList.addItemListener(this.endListener);
        gridBagConstraints.insets = new Insets(21, 5, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 3;
        this.contentPane.add((Component)this.endMonthList, gridBagConstraints);
        this.endDayList = new JComboBox<String>(Filter.day);
        this.endDayList.setSelectedIndex(this.filter.getEndDay());
        this.endDayList.setPreferredSize(new Dimension(48, 23));
        this.endDayList.addItemListener(this.endListener);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(21, 8, 0, 0);
        gridBagConstraints.fill = 0;
        this.contentPane.add((Component)this.endDayList, gridBagConstraints);
        this.endYearList = new JComboBox<String>(Filter.year);
        this.endYearList.setSelectedIndex(this.filter.getEndYear());
        this.endYearList.setPreferredSize(new Dimension(65, 23));
        this.endYearList.addItemListener(this.endListener);
        gridBagConstraints.insets = new Insets(21, 8, 0, 25);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        this.contentPane.add((Component)this.endYearList, gridBagConstraints);
        JLabel jLabel6 = new JLabel(this.logPanel.translate("endTime"));
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = 1;
        this.contentPane.add((Component)jLabel6, gridBagConstraints);
        this.endHourList = new JComboBox<String>(Filter.hour);
        this.endHourList.setSelectedIndex(this.filter.getEndHour());
        this.endHourList.setPreferredSize(new Dimension(48, 23));
        this.endHourList.addItemListener(this.endListener);
        gridBagConstraints.insets = new Insets(11, 5, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        this.contentPane.add((Component)this.endHourList, gridBagConstraints);
        JLabel jLabel7 = new JLabel(this.logPanel.translate("colon"));
        jLabel7.setFont(new Font("Display", 1, 12));
        jLabel7.setForeground(Color.black);
        gridBagConstraints.insets = new Insets(11, 2, 0, 0);
        gridBagConstraints.anchor = 17;
        this.contentPane.add((Component)jLabel7, gridBagConstraints);
        this.endMinuteList = new JComboBox<String>(Filter.minute);
        this.endMinuteList.setSelectedIndex(this.filter.getEndMinute());
        this.endMinuteList.setPreferredSize(new Dimension(48, 23));
        this.endMinuteList.addItemListener(this.endListener);
        gridBagConstraints.insets = new Insets(11, 2, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.contentPane.add((Component)this.endMinuteList, gridBagConstraints);
        JLabel jLabel8 = new JLabel(this.logPanel.translate("colon"));
        jLabel8.setFont(new Font("Display", 1, 12));
        jLabel8.setForeground(Color.black);
        gridBagConstraints.insets = new Insets(11, 2, 0, 0);
        gridBagConstraints.anchor = 17;
        this.contentPane.add((Component)jLabel8, gridBagConstraints);
        this.endSecondList = new JComboBox<String>(Filter.second);
        this.endSecondList.setSelectedIndex(this.filter.getEndSecond());
        this.endSecondList.setPreferredSize(new Dimension(48, 23));
        gridBagConstraints.insets = new Insets(11, 2, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        this.contentPane.add((Component)this.endSecondList, gridBagConstraints);
        JLabel jLabel9 = new JLabel(this.logPanel.translate("textToMatch"));
        gridBagConstraints.insets = new Insets(30, 15, 0, 0);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = 4;
        this.contentPane.add((Component)jLabel9, gridBagConstraints);
        this.patternText = new JTextField();
        this.patternText.setColumns(13);
        this.patternText.setMargin(new Insets(2, 2, 2, 0));
        this.patternText.setText(this.filter.getPattern());
        gridBagConstraints.insets = new Insets(25, 6, 0, 25);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        this.contentPane.add((Component)this.patternText, gridBagConstraints);
        this.morePanel = new JPanel();
        gridBagConstraints.fill = 2;
        this.contentPane.add((Component)this.morePanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.contentPane.add((Component)new JSeparator(), gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        JButton jButton = new JButton(this.logPanel.translate("ok"));
        FilterOKListener filterOKListener = new FilterOKListener();
        jButton.addActionListener(filterOKListener);
        jButton.setToolTipText(this.logPanel.translate("okToolTip"));
        gridBagConstraints.gridx = -1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jButton, gridBagConstraints);
        jButton.setActionCommand("OK");
        JButton jButton2 = new JButton(this.logPanel.translate("apply"));
        jButton2.addActionListener(filterOKListener);
        jButton2.setToolTipText(this.logPanel.translate("applyToolTip"));
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        jPanel.add((Component)jButton2, gridBagConstraints);
        JButton jButton3 = new JButton(this.logPanel.translate("cancel"));
        jButton3.setToolTipText(this.logPanel.translate("cancelToolTip"));
        class FilterCancelListener
        implements ActionListener {
            private final /* synthetic */ FilterListener this$0;

            FilterCancelListener(FilterListener filterListener) {
                this.this$0 = filterListener;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)this.this$0).setVisible(false);
                this.this$0.initFilterListener();
                FilterListener.access$2(this.this$0, FilterListener.access$0(this.this$0));
            }
        }
        jButton3.addActionListener(new FilterCancelListener(this));
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)jButton3, gridBagConstraints);
        JButton jButton4 = new JButton(this.logPanel.translate("reset"));
        class ResetListener
        implements ActionListener {
            private final /* synthetic */ FilterListener this$0;

            ResetListener(FilterListener filterListener) {
                this.this$0 = filterListener;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                FilterListener.access$4(this.this$0, new Filter());
                FilterListener.access$5(this.this$0).setFilter(FilterListener.access$3(this.this$0));
                this.this$0.initFilterListener();
                FilterListener.access$6(this.this$0).setVisible(false);
                FilterListener.access$6(this.this$0).setVisible(true);
                FilterListener.access$7(this.this$0, false);
                FilterListener.access$2(this.this$0, false);
            }
        }
        jButton4.addActionListener(new ResetListener(this));
        jButton4.setToolTipText(this.logPanel.translate("resetToolTip"));
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jButton4, gridBagConstraints);
        JButton jButton5 = new JButton(this.logPanel.translate("noFilters"));
        class NoFilterListener
        implements ActionListener {
            private final /* synthetic */ FilterListener this$0;

            NoFilterListener(FilterListener filterListener) {
                this.this$0 = filterListener;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                FilterListener.access$4(this.this$0, new Filter());
                FilterListener.access$3(this.this$0).setNoFilters();
                FilterListener.access$5(this.this$0).setFilter(FilterListener.access$3(this.this$0));
                this.this$0.initFilterListener();
                FilterListener.access$6(this.this$0).setVisible(false);
                FilterListener.access$6(this.this$0).setVisible(true);
                FilterListener.access$7(this.this$0, false);
                FilterListener.access$2(this.this$0, false);
            }
        }
        jButton5.addActionListener(new NoFilterListener(this));
        jButton5.setToolTipText(this.logPanel.translate("noFiltersToolTip"));
        gridBagConstraints.insets = new Insets(15, 15, 0, 0);
        jPanel.add((Component)jButton5, gridBagConstraints);
        JButton jButton6 = new JButton(this.logPanel.translate("advanced"));
        jButton6.setToolTipText(this.logPanel.translate("advancedtToolTip"));
        this.filterMoreListener = new FilterMoreListener();
        jButton6.addActionListener(this.filterMoreListener);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)jButton6, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(15, 15, 15, 15);
        this.contentPane.add((Component)jPanel, gridBagConstraints);
        this.pack();
    }

    static /* synthetic */ boolean access$0(FilterListener filterListener) {
        return filterListener.newEnd;
    }

    static /* synthetic */ void access$4(FilterListener filterListener, Filter filter) {
        filterListener.filter = filter;
    }

    static /* synthetic */ Container access$6(FilterListener filterListener) {
        return filterListener.contentPane;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isVisible()) {
            this.show();
            return;
        }
        if (!this.newEnd) {
            this.filter.setCurrentEndTime(this.startYearList, this.endYearList);
            this.initFilterListener();
            this.logPanel.setFilter(this.filter);
        }
        ((Component)this).setVisible(true);
    }

    void initFilterListener() {
        this.startYearList.setSelectedIndex(this.filter.getStartYear());
        this.startMonthList.setSelectedIndex(this.filter.getStartMonth());
        this.startDayList.setSelectedIndex(this.filter.getStartDay());
        this.startHourList.setSelectedIndex(this.filter.getStartHour());
        this.startMinuteList.setSelectedIndex(this.filter.getStartMinute());
        this.startSecondList.setSelectedIndex(this.filter.getStartSecond());
        this.endYearList.setSelectedIndex(this.filter.getEndYear());
        this.endMonthList.setSelectedIndex(this.filter.getEndMonth());
        this.endDayList.setSelectedIndex(this.filter.getEndDay());
        this.endHourList.setSelectedIndex(this.filter.getEndHour());
        this.endMinuteList.setSelectedIndex(this.filter.getEndMinute());
        this.endSecondList.setSelectedIndex(this.filter.getEndSecond());
        this.patternText.setText(this.filter.getPattern());
        if (this.latest != null) {
            this.latest.setSelected(this.filter.getFromLatest());
        }
        if (this.latest != null) {
            this.oldest.setSelected(!this.filter.getFromLatest());
        }
        if (this.maxMatchesText != null) {
            this.maxMatchesText.setText(String.valueOf(this.filter.getMaxMatches()));
        }
    }

    class FilterMoreListener
    implements ActionListener {
        FilterMoreListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (string.equals(FilterListener.this.logPanel.translate("basic"))) {
                jButton.setText(FilterListener.this.logPanel.translate("advanced"));
                jButton.setToolTipText(FilterListener.this.logPanel.translate("advancedtToolTip"));
                FilterListener.this.morePanel.removeAll();
                FilterListener.this.pack();
                return;
            }
            jButton.setText(FilterListener.this.logPanel.translate("basic"));
            jButton.setToolTipText(FilterListener.this.logPanel.translate("basicToolTip"));
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            FilterListener.this.morePanel.setLayout(gridBagLayout);
            JLabel jLabel = new JLabel(FilterListener.this.logPanel.translate("searchDirection"));
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.insets = new Insets(15, 0, 0, 0);
            gridBagConstraints.anchor = 12;
            FilterListener.this.morePanel.add((Component)jLabel, gridBagConstraints);
            FilterListener.this.oldest = new JRadioButton(FilterListener.this.logPanel.translate("forward"));
            FilterListener.this.latest = new JRadioButton(FilterListener.this.logPanel.translate("backward"));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(FilterListener.this.oldest);
            buttonGroup.add(FilterListener.this.latest);
            if (FilterListener.this.filter.getFromLatest()) {
                FilterListener.this.latest.setSelected(true);
            } else {
                FilterListener.this.oldest.setSelected(true);
            }
            gridBagConstraints.insets = new Insets(10, 10, 0, 0);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridwidth = 0;
            FilterListener.this.morePanel.add((Component)FilterListener.this.oldest, gridBagConstraints);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.insets = new Insets(0, 10, 0, 0);
            FilterListener.this.morePanel.add((Component)new JLabel(" "), gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            FilterListener.this.morePanel.add((Component)FilterListener.this.latest, gridBagConstraints);
            JLabel jLabel2 = new JLabel(FilterListener.this.logPanel.translate("maxMatches"));
            gridBagConstraints.insets = new Insets(15, 0, 0, 0);
            gridBagConstraints.anchor = 12;
            gridBagConstraints.gridwidth = 1;
            FilterListener.this.morePanel.add((Component)jLabel2, gridBagConstraints);
            FilterListener.this.maxMatchesText = new JTextField();
            FilterListener.this.maxMatchesText.setMargin(new Insets(2, 2, 2, 0));
            FilterListener.this.maxMatchesText.setColumns(7);
            FilterListener.this.maxMatchesText.setText(String.valueOf(FilterListener.this.filter.getMaxMatches()));
            gridBagConstraints.insets = new Insets(10, 10, 20, 0);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            FilterListener.this.morePanel.add((Component)FilterListener.this.maxMatchesText, gridBagConstraints);
            FilterListener.this.pack();
        }
    }

    class FilterOKListener
    implements ActionListener {
        FilterOKListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component = (Component)actionEvent.getSource();
            Object[] objectArray = new Object[]{FilterListener.this.logPanel.translate("ok")};
            FilterListener.this.filter.setStartMonth(FilterListener.this.startMonthList.getSelectedIndex());
            FilterListener.this.filter.setStartDay(FilterListener.this.startDayList.getSelectedIndex());
            FilterListener.this.filter.setStartYear(FilterListener.this.startYearList.getSelectedIndex());
            FilterListener.this.filter.setStartHour(FilterListener.this.startHourList.getSelectedIndex());
            FilterListener.this.filter.setStartMinute(FilterListener.this.startMinuteList.getSelectedIndex());
            FilterListener.this.filter.setStartSecond(FilterListener.this.startSecondList.getSelectedIndex());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM d yyyy hh mm ss");
            String string = FilterListener.this.logPanel.translate(Filter.month[FilterListener.this.filter.getStartMonth()]);
            String string2 = new String(String.valueOf(string) + " " + Filter.day[FilterListener.this.filter.getStartDay()] + " " + Filter.year[FilterListener.this.filter.getStartYear()] + " " + Filter.hour[FilterListener.this.filter.getStartHour()] + " " + Filter.minute[FilterListener.this.filter.getStartMinute()] + " " + Filter.second[FilterListener.this.filter.getStartSecond()]);
            long l = simpleDateFormat.parse(string2, new ParsePosition(0)).getTime() / 1000L;
            FilterListener.this.filter.setStartTimeStamp(l);
            FilterListener.this.filter.setEndMonth(FilterListener.this.endMonthList.getSelectedIndex());
            FilterListener.this.filter.setEndDay(FilterListener.this.endDayList.getSelectedIndex());
            FilterListener.this.filter.setEndYear(FilterListener.this.endYearList.getSelectedIndex());
            FilterListener.this.filter.setEndHour(FilterListener.this.endHourList.getSelectedIndex());
            FilterListener.this.filter.setEndMinute(FilterListener.this.endMinuteList.getSelectedIndex());
            FilterListener.this.filter.setEndSecond(FilterListener.this.endSecondList.getSelectedIndex());
            String string3 = FilterListener.this.logPanel.translate(Filter.month[FilterListener.this.filter.getEndMonth()]);
            String string4 = new String(String.valueOf(string3) + " " + Filter.day[FilterListener.this.filter.getEndDay()] + " " + Filter.year[FilterListener.this.filter.getEndYear()] + " " + Filter.hour[FilterListener.this.filter.getEndHour()] + " " + Filter.minute[FilterListener.this.filter.getEndMinute()] + " " + Filter.second[FilterListener.this.filter.getEndSecond()]);
            l = simpleDateFormat.parse(string4, new ParsePosition(0)).getTime() / 1000L;
            FilterListener.this.filter.setEndTimeStamp(l);
            if (FilterListener.this.latest != null) {
                FilterListener.this.filter.setFromLatest(FilterListener.this.latest.isSelected());
            }
            if (FilterListener.this.maxMatchesText != null) {
                Integer n;
                try {
                    n = new Integer(FilterListener.this.maxMatchesText.getText());
                }
                catch (Exception exception) {
                    JOptionPane.showOptionDialog(FilterListener.this.logPanel.getLogWindow(component), FilterListener.this.logPanel.translate("enterDecimal"), FilterListener.this.logPanel.translate("alert"), -1, 0, null, objectArray, objectArray[0]);
                    return;
                }
                if (n < 0) {
                    JOptionPane.showOptionDialog(FilterListener.this.logPanel.getLogWindow(component), FilterListener.this.logPanel.translate("enterDecimal"), FilterListener.this.logPanel.translate("alert"), -1, 0, null, objectArray, objectArray[0]);
                    return;
                }
                FilterListener.this.filter.setMaxMatches(n);
            }
            if (FilterListener.this.patternText != null) {
                FilterListener.this.filter.setPattern(FilterListener.this.patternText.getText().trim());
            }
            if (actionEvent.getActionCommand().compareTo("OK") == 0) {
                ((Component)FilterListener.this).setVisible(false);
            }
            FilterListener.this.logPanel.getReloadButton().doClick();
            FilterListener.this.newEnd = FilterListener.this.pendingNewEnd;
        }
    }

    class EndListener
    implements ItemListener {
        EndListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (!FilterListener.this.isVisible()) {
                return;
            }
            if (itemEvent.getStateChange() == 2) {
                FilterListener.this.pendingNewEnd = true;
            }
        }
    }
}

