/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.didgets;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRequestStatus;
import com.sun.symon.base.client.topology.SMUserDomainData;
import com.sun.symon.base.client.topology.SMUserDomainRequest;
import com.sun.symon.base.client.topology.SMUserDomainResponse;
import com.sun.symon.base.console.awx.AwxServiceManager;
import com.sun.symon.base.console.awx.AwxServiceProvider;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcURL;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class CdDomainTable
extends JScrollPane
implements ItemListener,
ListSelectionListener,
MouseListener,
AwxServiceManager,
SMUserDomainResponse,
Runnable {
    private SMUserDomainRequest RequestHandle = null;
    private SMUserDomainData[] current = null;
    private AwxServiceProvider provider = null;
    private int columns = 0;
    private String[][] values = null;
    private String[] headers = null;
    private boolean showAll = true;
    private JTable table = new JTable();
    private JLabel defaultDomain = null;
    private JLabel parentGroup = null;
    private String parentGroupUrl = "";
    private int RefreshInterval = 300;
    private Object handle = null;
    private SMRawDataRequest Requestor = null;
    private boolean remote = false;
    private String Host = null;
    private String Port = null;
    private int count = 0;
    private boolean nameSetFirst = true;
    private MyTableModel dataModel = new MyTableModel();

    public CdDomainTable() {
        this.getViewport().add(this.table);
        this.setColumnHeaderView(this.table.getTableHeader());
        this.getHorizontalScrollBar().setUnitIncrement(10);
        this.getHorizontalScrollBar().setBlockIncrement(10);
        this.table.addMouseListener(this);
    }

    public void clearSelection() {
        this.table.clearSelection();
    }

    public void getDomainDataResponse(SMRequestStatus sMRequestStatus, SMUserDomainData[] sMUserDomainDataArray, Object object) {
        if (sMRequestStatus.getReturnCode() != 0) {
            UcDDL.logErrorMessage((String)("Domain list request unsuccessful: " + sMRequestStatus.getMessageText()));
            if (sMRequestStatus.getReturnCode() == 4) {
                this.Requestor.launchTimeoutNotification("both");
            }
            return;
        }
        if (sMUserDomainDataArray[0] != null) {
            this.setDefaultDomain(sMUserDomainDataArray[0].getDomainName());
        } else {
            this.setDefaultDomain("");
        }
        SMUserDomainData[] sMUserDomainDataArray2 = new SMUserDomainData[sMUserDomainDataArray.length - 1];
        int n = 0;
        while (n < sMUserDomainDataArray.length - 1) {
            sMUserDomainDataArray2[n] = sMUserDomainDataArray[n + 1];
            ++n;
        }
        if (sMUserDomainDataArray2 != null) {
            CdDomainTable cdDomainTable = this;
            synchronized (cdDomainTable) {
                this.values = new String[sMUserDomainDataArray2.length][this.columns];
                int n2 = 0;
                while (n2 < sMUserDomainDataArray2.length) {
                    String string;
                    this.values[n2][0] = sMUserDomainDataArray2[n2].getDomainName();
                    if (this.parentGroupUrl.compareTo("") != 0 && UcURL.areURLsEqual((String)this.parentGroupUrl, (String)(string = sMUserDomainDataArray2[n2].getDomainRootUrl()))) {
                        this.setParentGroup(this.values[n2][0]);
                    }
                    ++n2;
                }
            }
        } else {
            this.values = null;
        }
        this.current = sMUserDomainDataArray2;
        this.table.invalidate();
        this.dataModel.fireTableDataChanged();
    }

    public SMUserDomainData getSelectedDomain() {
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return null;
        }
        return this.current[n];
    }

    public Dimension getSize() {
        if (this.count == 0) {
            this.nameSetFirst = false;
        }
        ++this.count;
        return super.getSize();
    }

    public void init() {
        block2: {
            if (this.Requestor == null || this.remote) break block2;
            try {
                this.handle = this.RequestHandle.getUserDomainsRequest("", new Integer(this.RefreshInterval).toString(), (SMUserDomainResponse)this, null);
            }
            catch (SMAPIException sMAPIException) {
                UcDDL.logErrorMessage((String)"Failed to send get user domains request with exception", (Throwable)sMAPIException);
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getID() != 701) {
            return;
        }
        JComboBox jComboBox = null;
        try {
            jComboBox = (JComboBox)itemEvent.getSource();
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"unknown state change", (Throwable)exception);
            return;
        }
        if (jComboBox.getSelectedIndex() == 0) {
            this.showAll = false;
            this.clearSelection();
        } else {
            this.showAll = true;
        }
    }

    private SMUserDomainData[] loadDomains() {
        if (this.RequestHandle == null) {
            return null;
        }
        SMUserDomainData[] sMUserDomainDataArray = null;
        try {
            sMUserDomainDataArray = this.showAll ? this.RequestHandle.getAllConfiguredDomains() : this.RequestHandle.getUserConfiguredDomains();
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logErrorMessage((String)"Domain entries retrieval exception ", (Throwable)sMAPIException);
        }
        return sMUserDomainDataArray;
    }

    public void loadRemoteList(String string, String string2) {
        this.Host = string;
        this.Port = string2;
        Thread thread = new Thread((Runnable)this, "remote-domain-load");
        thread.start();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 500 && mouseEvent.getClickCount() > 1 && this.table.getSelectedRow() >= 0) {
            this.provider.triggerService("doubleSelect");
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void registerServiceProvider(AwxServiceProvider awxServiceProvider) {
        block3: {
            this.provider = awxServiceProvider;
            if (awxServiceProvider != null) break block3;
            this.RequestHandle = null;
            if (this.Requestor != null && !this.remote) {
                try {
                    this.Requestor.removeURLRequest(this.handle);
                }
                catch (SMAPIException sMAPIException) {
                    UcDDL.logErrorMessage((String)"Error removing periodic domain list request", (Throwable)sMAPIException);
                }
            }
        }
    }

    public void run() {
        try {
            this.provider.triggerService("busyStart");
            String[] stringArray = new String[]{"base.console.ConsoleTopology:remote.requestinglist"};
            this.provider.triggerService("message", stringArray);
            SMUserDomainData[] sMUserDomainDataArray = this.RequestHandle.getRemoteDomains(this.Host, this.Port);
            if (sMUserDomainDataArray != null) {
                CdDomainTable cdDomainTable = this;
                synchronized (cdDomainTable) {
                    this.values = new String[sMUserDomainDataArray.length][this.columns];
                    int n = 0;
                    while (n < sMUserDomainDataArray.length) {
                        String string;
                        this.values[n][0] = sMUserDomainDataArray[n].getDomainName();
                        if (this.parentGroupUrl.compareTo("") != 0 && UcURL.areURLsEqual((String)this.parentGroupUrl, (String)(string = sMUserDomainDataArray[n].getDomainRootUrl()))) {
                            this.setParentGroup(this.values[n][0]);
                        }
                        ++n;
                    }
                }
            } else {
                this.values = null;
            }
            this.current = sMUserDomainDataArray;
            this.table.invalidate();
            stringArray[0] = "";
            this.provider.triggerService("message", stringArray);
            this.provider.triggerService("busyEnd");
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logErrorMessage((String)("Domain list request unsuccessful: " + (Object)((Object)sMAPIException)));
            String[] stringArray = new String[]{sMAPIException.getReasonCode() == 1 ? "base.console.ConsoleTopology:remote.listnoaccess" : "base.console.ConsoleTopology:remote.listerror"};
            this.provider.triggerService("messageBell", stringArray);
            this.provider.triggerService("busyEnd");
        }
    }

    public synchronized void setColumns(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.columns = stringTokenizer.countTokens();
        this.headers = new String[this.columns];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.headers[n] = stringTokenizer.nextToken();
            ++n;
        }
        this.table.setModel(this.dataModel);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        this.table.setSelectionMode(0);
    }

    private synchronized void setDefaultDomain(String string) {
        if (this.nameSetFirst) {
            this.invalidate();
            this.validate();
            this.repaint();
        }
        if (this.defaultDomain != null) {
            this.defaultDomain.setText(string);
            this.defaultDomain.invalidate();
            this.defaultDomain.revalidate();
            this.defaultDomain.repaint();
            this.defaultDomain.invalidate();
            this.defaultDomain.revalidate();
            this.defaultDomain.repaint();
        }
    }

    public void setDefaultDomainObject(Object object) {
        this.defaultDomain = (JLabel)object;
    }

    private synchronized void setParentGroup(String string) {
        if (this.parentGroup != null) {
            this.parentGroup.setText(string);
            this.parentGroup.invalidate();
            this.parentGroup.revalidate();
            this.parentGroup.repaint();
            this.parentGroup.invalidate();
            this.parentGroup.revalidate();
            this.parentGroup.repaint();
        }
    }

    public void setParentGroupObject(Object object) {
        this.parentGroup = (JLabel)object;
    }

    public void setParentGroupUrl(String string) {
        this.parentGroupUrl = string;
    }

    public void setRemoteFlag(boolean bl) {
        this.remote = bl;
    }

    public void setRequestHandle(SMRawDataRequest sMRawDataRequest) {
        if (sMRawDataRequest == null) {
            this.RequestHandle = null;
        } else {
            this.RequestHandle = new SMUserDomainRequest(sMRawDataRequest);
            this.Requestor = sMRawDataRequest;
        }
    }

    public void setShowGrid(boolean bl) {
        this.table.setShowGrid(bl);
    }

    public void setShowHorizontalLines(boolean bl) {
        this.table.setShowHorizontalLines(bl);
    }

    public void setShowVerticalLines(boolean bl) {
        this.table.setShowVerticalLines(bl);
    }

    private void sizeColumnWidths() {
        TableColumn tableColumn = null;
        FontMetrics fontMetrics = ((Component)this.table).getFontMetrics(this.table.getFont());
        int n = 0;
        while (n < this.columns) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.values.length) {
                int n4 = fontMetrics.stringWidth(" " + this.values[n3][n] + " ");
                if (n4 > n2) {
                    n2 = n4;
                }
                ++n3;
            }
            tableColumn = this.table.getColumnModel().getColumn(n);
            if (n2 > 75) {
                tableColumn.setMinWidth(n2);
            } else {
                tableColumn.setMinWidth(75);
            }
            ++n;
        }
        this.table.setAutoResizeMode(4);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.table.getSelectedRow();
        if (n < 0) {
            if (this.provider != null) {
                this.provider.triggerService("domainDeselect");
            }
        } else if (this.provider != null) {
            if (this.parentGroupUrl.compareTo("") != 0) {
                this.provider.triggerService("domainSelect");
            } else {
                this.provider.triggerService("noParentDomainSelect");
            }
        }
    }

    class MyTableModel
    extends AbstractTableModel {
        MyTableModel() {
        }

        public int getColumnCount() {
            return CdDomainTable.this.columns;
        }

        public String getColumnName(int n) {
            return CdDomainTable.this.headers[n];
        }

        public int getRowCount() {
            if (CdDomainTable.this.values == null) {
                return 0;
            }
            return CdDomainTable.this.values.length;
        }

        public synchronized Object getValueAt(int n, int n2) {
            if (CdDomainTable.this.values == null) {
                return null;
            }
            if (n >= CdDomainTable.this.values.length) {
                return null;
            }
            if (n2 >= CdDomainTable.this.values[n].length) {
                return null;
            }
            return CdDomainTable.this.values[n][n2];
        }
    }
}

