/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.alarms;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.alarm.SMAlarmObjectRequest;
import com.sun.symon.base.client.topology.SMTopologyRequest;
import com.sun.symon.base.console.alarms.AckListener;
import com.sun.symon.base.console.alarms.AlarmData;
import com.sun.symon.base.console.alarms.AlarmTable;
import com.sun.symon.base.console.alarms.DeleteAllListener;
import com.sun.symon.base.console.alarms.DeleteListener;
import com.sun.symon.base.console.alarms.ResetListener;
import com.sun.symon.base.console.alarms.Show;
import com.sun.symon.base.console.alarms.ShowListener;
import com.sun.symon.base.console.alarms.SortListener;
import com.sun.symon.base.console.awx.AwxServiceManager;
import com.sun.symon.base.console.awx.AwxServiceProvider;
import com.sun.symon.base.utility.UcAgentURL;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.EtchedBorder;

public class AlarmPanel
extends JPanel
implements AwxServiceManager {
    static final Cursor waitCursor = Cursor.getPredefinedCursor(3);
    static final Cursor defaultCursor = Cursor.getPredefinedCursor(0);
    private final Color buttonColor = new Color(230, 230, 230);
    private AlarmPanel alarmPanel;
    private AlarmTable alarmTable;
    private Show show = new Show();
    private String alarmUrl;
    private String agentHost;
    private String agentPort;
    private String domainUrl = null;
    private String contextUrl = null;
    private String objectUrl = null;
    private String hostPort = null;
    private String alarmSeverity = null;
    private String exceptionMessage = null;
    private String exception1 = null;
    private String exception2 = null;
    private String requestId = "1";
    private JLabel status = null;
    private SMTopologyRequest topRequest = null;
    private SMRawDataRequest rawRequest = null;
    private SMAlarmObjectRequest request = null;
    private JButton showButton;
    private JButton sortButton;
    private JButton resetButton;
    private JButton ackButton;
    private JButton fixButton;
    private JButton deleteButton;
    private JButton deleteAllButton;
    private JButton editRuleButton;
    private JPanel countPanel;
    private JPanel buttonPanel1;
    private JPanel startPanel;
    private JPanel endPanel;
    private JPanel ackPanel;
    private JPanel rulePanel;
    private JLabel startLabel;
    private JLabel endLabel;
    private JLabel ackLabel;
    private JLabel ruleLabel;
    private JLabel ruleId;
    private String dateTime;
    private String rule;
    private String start;
    private String end;
    private String ack;
    private String by;
    private boolean active = true;
    private JScrollPane scrollPane;
    private boolean firstTime = true;
    private boolean skipRetry = false;
    private ShowListener showListener;
    private SortListener sortListener;
    private ResetListener resetListener;
    private Object[] oneOption = new Object[]{this.translate("ok")};
    private String[] errorMsg = new String[]{this.translate("securityError"), this.translate("timeoutError"), this.translate("genericError"), this.translate("genericError"), this.translate("genericError"), this.translate("genericError"), this.translate("genericError"), this.translate("genericError")};

    public void cleanUp() {
        try {
            if (this.request != null) {
                this.request.closeConnection(this.requestId);
            }
        }
        catch (Exception exception) {}
        this.request = null;
        this.rawRequest = null;
    }

    void createUrl() {
        UcAgentURL ucAgentURL;
        UcAgentURL ucAgentURL2 = new UcAgentURL(this.contextUrl);
        String string = "snmp://" + ucAgentURL2.getHost() + ":" + ucAgentURL2.getPort() + "/mod/" + ucAgentURL2.getModuleSpec() + "/entityViewTable" + "/entityViewEntry/entityStatus" + ucAgentURL2.getFragment() + "/";
        this.alarmUrl = this.objectUrl != null ? ((ucAgentURL = new UcAgentURL(this.objectUrl)).getModuleSpec().equals("") ? new String("{snmp://" + this.agentHost + ":" + this.agentPort + "/}" + " {" + string + "}") : new String("{snmp://" + this.agentHost + ":" + this.agentPort + "/mod/" + ucAgentURL.getModuleSpec() + "/}" + " {" + string + "}")) : new String("{snmp://" + this.agentHost + ":" + this.agentPort + "/}" + " {" + string + "}");
    }

    String getAgentHost() {
        return this.agentHost;
    }

    String getAgentPort() {
        return this.agentPort;
    }

    Frame getAlarmFrame(Component component) {
        Frame frame = null;
        while ((component = component.getParent()) != null) {
            if (!(component instanceof Frame)) continue;
            frame = (Frame)component;
            break;
        }
        return frame;
    }

    AlarmTable getAlarmTable() {
        return this.alarmTable;
    }

    String getAlarmUrl() {
        return this.alarmUrl;
    }

    Window getAlarmWindow(Component component) {
        Window window = null;
        while ((component = component.getParent()) != null) {
            if (!(component instanceof Window)) continue;
            window = (Window)component;
            break;
        }
        return window;
    }

    public String getContextUrl() {
        return this.contextUrl;
    }

    JPanel getCountPanel() {
        return this.countPanel;
    }

    public String getDomainUrl() {
        return this.domainUrl;
    }

    SMRawDataRequest getRawRequestHandle() {
        return this.rawRequest;
    }

    SMAlarmObjectRequest getRequestHandle() {
        return this.request;
    }

    String getRequestId() {
        return this.requestId;
    }

    Show getShow() {
        return this.show;
    }

    SortListener getSortListener() {
        return this.sortListener;
    }

    public JLabel getWindowStatusField() {
        return this.status;
    }

    public void init() {
        try {
            this.hostPort = this.topRequest.getEventMngrFromContext(this.contextUrl);
        }
        catch (SMAPIException sMAPIException) {
            JOptionPane.showOptionDialog(this.getAlarmWindow(this), String.valueOf(this.translate("requestHostPortException")) + "\n" + this.errorMsg[sMAPIException.getReasonCode()], this.translate("alert"), -1, 0, null, this.oneOption, this.oneOption[0]);
        }
        if (this.hostPort == null || this.hostPort.length() == 0) {
            this.hostPort = null;
            this.skipRetry = true;
            JOptionPane.showOptionDialog(this.getAlarmWindow(this), this.translate("nullHostPortWarning"), this.translate("alert"), -1, 2, null, this.oneOption, this.oneOption[0]);
        }
        try {
            this.request = new SMAlarmObjectRequest(this.rawRequest, this.hostPort);
        }
        catch (SMAPIException sMAPIException) {
            JOptionPane.showOptionDialog(this.getAlarmWindow(this), String.valueOf(this.translate("requestHandleException")) + "\n" + this.errorMsg[sMAPIException.getReasonCode()], this.translate("alert"), -1, 0, null, this.oneOption, this.oneOption[0]);
            this.request = null;
        }
        if (this.request == null) {
            return;
        }
        this.createUrl();
        this.alarmPanel = this;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(this.translate("tableActions"));
        gridBagConstraints2.insets = new Insets(0, 6, 0, 0);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridwidth = 0;
        jPanel.add((Component)jLabel, gridBagConstraints2);
        this.buttonPanel1 = new JPanel(new FlowLayout(0, 5, 0));
        this.showButton = new JButton(this.translate("show"));
        this.showButton.setMargin(new Insets(2, 5, 2, 5));
        this.showButton.setToolTipText(this.translate("showSpecificAlarms"));
        this.showListener = new ShowListener(this, this.getAlarmFrame(this));
        this.showButton.addActionListener(this.showListener);
        this.buttonPanel1.add(this.showButton);
        this.sortButton = new JButton(this.translate("sort"));
        this.sortButton.setMargin(new Insets(2, 5, 2, 5));
        this.sortButton.setToolTipText(this.translate("sortAlarmTable"));
        this.sortListener = new SortListener(this, this.getAlarmFrame(this));
        this.sortButton.addActionListener(this.sortListener);
        this.buttonPanel1.add(this.sortButton);
        this.resetButton = new JButton(this.translate("reset"));
        this.resetButton.setMargin(new Insets(2, 5, 2, 5));
        this.resetButton.setToolTipText(this.translate("resetTable"));
        this.resetListener = new ResetListener(this);
        this.resetButton.addActionListener(this.resetListener);
        this.buttonPanel1.add(this.resetButton);
        gridBagConstraints2.insets = new Insets(3, 2, 0, 0);
        jPanel.add((Component)this.buttonPanel1, gridBagConstraints2);
        gridBagConstraints.insets = new Insets(22, 9, 0, 5);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)jPanel, gridBagConstraints);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JLabel jLabel2 = new JLabel(this.translate("alarmActions"));
        gridBagConstraints3.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.gridwidth = 0;
        jPanel2.add((Component)jLabel2, gridBagConstraints3);
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 5, 0));
        this.ackButton = new JButton(this.translate("acknowledge"));
        this.ackButton.setMargin(new Insets(2, 5, 2, 5));
        this.ackButton.setToolTipText(this.translate("acknowledgeAlarm"));
        AckListener ackListener = new AckListener();
        ackListener.setAlarmPanel(this);
        this.ackButton.addActionListener(ackListener);
        jPanel3.add(this.ackButton);
        this.deleteButton = new JButton(this.translate("delete"));
        this.deleteButton.setMargin(new Insets(2, 5, 2, 5));
        this.deleteButton.setToolTipText(this.translate("deleteAlarm"));
        DeleteListener deleteListener = new DeleteListener();
        deleteListener.setAlarmPanel(this);
        this.deleteButton.addActionListener(deleteListener);
        jPanel3.add(this.deleteButton);
        this.deleteAllButton = new JButton(this.translate("deleteAll"));
        this.deleteAllButton.setMargin(new Insets(2, 5, 2, 5));
        this.deleteAllButton.setToolTipText(this.translate("deleteAllAlarms"));
        DeleteAllListener deleteAllListener = new DeleteAllListener();
        deleteAllListener.setAlarmPanel(this);
        this.deleteAllButton.addActionListener(deleteAllListener);
        jPanel3.add(this.deleteAllButton);
        gridBagConstraints3.insets = new Insets(3, 0, 0, 0);
        jPanel2.add((Component)jPanel3, gridBagConstraints3);
        gridBagConstraints.insets = new Insets(22, 0, 0, 10);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)jPanel2, gridBagConstraints);
        this.alarmTable = new AlarmTable();
        this.alarmTable.setAlarmPanel(this);
        this.alarmTable.init();
        if (this.getDomainUrl() != null) {
            this.alarmTable.getDomainAlarms(false);
        } else {
            this.alarmTable.getHostAlarms(false);
        }
        this.scrollPane = new JScrollPane(this.alarmTable, 20, 31);
        this.scrollPane.setBorder(new EtchedBorder());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(25, 15, 0, 15);
        this.add((Component)this.scrollPane, gridBagConstraints);
        this.countPanel = new JPanel(new FlowLayout(0, 4, 0));
        this.countPanel.add(new JLabel(this.translate("countLabel")));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.countPanel, gridBagConstraints);
        JSeparator jSeparator = new JSeparator();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(15, 15, 0, 15);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)jSeparator, gridBagConstraints);
        this.rule = new String(this.translate("rule"));
        this.start = new String(this.translate("conditionBegan"));
        this.end = new String(this.translate("conditionEnded"));
        this.ack = new String(this.translate("conditionAcked"));
        this.by = new String(" " + this.translate("by") + " ");
        this.startPanel = new JPanel(new FlowLayout(0));
        this.startPanel.add(new JLabel(this.start));
        this.endPanel = new JPanel(new FlowLayout(0));
        this.endPanel.add(new JLabel(this.end));
        this.ackPanel = new JPanel(new FlowLayout(0));
        this.ackPanel.add(new JLabel(this.ack));
        this.rulePanel = new JPanel(new FlowLayout(0));
        this.rulePanel.add(new JLabel(this.rule));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(15, 10, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.startPanel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 10, 0, 0);
        this.add((Component)this.endPanel, gridBagConstraints);
        this.add((Component)this.ackPanel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(10, 10, 20, 0);
        this.add((Component)this.rulePanel, gridBagConstraints);
        if (this.getDomainUrl() != null) {
            JSeparator jSeparator2 = new JSeparator();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(0, 15, 7, 15);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            this.add((Component)jSeparator2, gridBagConstraints);
        }
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
            }
        });
    }

    boolean isActive() {
        return this.active;
    }

    public void registerServiceProvider(AwxServiceProvider awxServiceProvider) {
        AwxServiceProvider awxServiceProvider2 = null;
        awxServiceProvider2 = awxServiceProvider;
    }

    void setActive(boolean bl) {
        Window window = this.getAlarmWindow(this);
        AlarmTable alarmTable = this.getAlarmTable();
        this.active = bl;
        this.showButton.setEnabled(bl);
        this.sortButton.setEnabled(bl);
        this.resetButton.setEnabled(bl);
        this.ackButton.setEnabled(bl);
        this.deleteButton.setEnabled(bl);
        this.deleteAllButton.setEnabled(bl);
        alarmTable.setEnabled(bl);
    }

    public void setAgentHost(String string) {
        this.agentHost = new String(string);
        if (this.agentHost.compareTo("") == 0 || this.agentHost == null) {
            JOptionPane.showOptionDialog(this.getAlarmWindow(this), this.translate("invalidHostAddress"), this.translate("alert"), -1, 0, null, this.oneOption, this.oneOption[0]);
        }
    }

    public void setAgentPort(String string) {
        this.agentPort = new String(string);
        if (this.agentPort.compareTo("") == 0 || this.agentPort == null) {
            JOptionPane.showOptionDialog(this.getAlarmWindow(this), this.translate("invalidAgentPort"), this.translate("alert"), -1, 0, null, this.oneOption, this.oneOption[0]);
        }
    }

    void setAlarmCount(String string) {
        if (this.countPanel != null) {
            JLabel jLabel = new JLabel(string);
            jLabel.setForeground(Color.black);
            this.countPanel.removeAll();
            this.getParent().validate();
            this.countPanel.add(new JLabel(this.translate("countLabel")));
            this.countPanel.add(jLabel);
            this.getParent().validate();
        }
    }

    public void setAlarmSeverity(String string) {
        this.show.setDomainShow(string);
    }

    public void setContextUrl(String string) {
        this.contextUrl = string;
    }

    public void setDomainUrl(String string) {
        this.domainUrl = string;
    }

    public void setObjectUrl(String string) {
        this.objectUrl = string;
    }

    public void setRawDataRequestHandle(SMRawDataRequest sMRawDataRequest) {
        if (this.skipRetry) {
            this.skipRetry = false;
            return;
        }
        this.rawRequest = sMRawDataRequest;
        this.topRequest = new SMTopologyRequest(sMRawDataRequest);
    }

    void setShow(Show show) {
        this.show = show;
    }

    public void setWindowStatusField(Object object) {
        this.status = (JLabel)object;
    }

    public String translate(String string) {
        return UcInternationalizer.translateKey((String)("com.sun.symon.base.console.alarms.AlarmBundle:" + string));
    }

    void updateMore(AlarmData alarmData) {
        String string;
        this.startPanel.removeAll();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1, Locale.getDefault());
        dateFormat.setTimeZone(TimeZone.getDefault());
        if (alarmData.startTime != 0L) {
            string = this.start.concat(" " + dateFormat.format(new Date(alarmData.startTime)));
            this.startLabel = new JLabel(string);
            this.startPanel.add(this.startLabel);
        } else {
            this.startLabel = new JLabel(this.start);
            this.startLabel.setEnabled(false);
            this.startPanel.add(this.startLabel);
        }
        this.endPanel.removeAll();
        if (alarmData.endTime != 0L) {
            string = this.end.concat(" " + dateFormat.format(new Date(alarmData.endTime)));
            this.endLabel = new JLabel(string);
            this.endPanel.add(this.endLabel);
        } else {
            this.endLabel = new JLabel(this.end);
            this.endLabel.setEnabled(false);
            this.endPanel.add(this.endLabel);
        }
        this.ackPanel.removeAll();
        if (alarmData.getAckTime() != 0L) {
            string = this.ack.concat(" " + dateFormat.format(new Date(alarmData.getAckTime())));
            String string2 = this.by.concat(alarmData.getAckUser());
            this.ackLabel = new JLabel(string.concat(string2));
            this.ackPanel.add(this.ackLabel);
        } else {
            this.ackLabel = new JLabel(this.ack);
            this.ackLabel.setEnabled(false);
            this.ackPanel.add(this.ackLabel);
        }
        this.rulePanel.removeAll();
        this.ruleLabel = new JLabel(this.rule);
        this.rulePanel.add(this.ruleLabel);
        if (alarmData.ruleId != null && alarmData.ruleId.length() > 0) {
            this.ruleId = new JLabel(alarmData.ruleId);
            this.ruleId.setForeground(Color.black);
            this.rulePanel.add(this.ruleId);
        } else {
            this.ruleLabel.setEnabled(false);
        }
        this.getParent().validate();
    }
}

