/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.moh;

import com.sun.ctmgx.common.PackageInfo;
import com.sun.ctmgx.common.PackageInfoList;
import com.sun.ctmgx.common.PackageInfoListEvent;
import com.sun.ctmgx.common.PackageInfoListListener;
import com.sun.ctmgx.common.SystemView;
import com.sun.ctmgx.moh.ContainmentTree;
import com.sun.ctmgx.moh.NetraCtDefs;
import com.sun.ctmgx.moh.ObjectCreationNotification;
import com.sun.ctmgx.moh.ObjectDeletionNotification;
import com.sun.ctmgx.moh.Software;
import com.sun.ctmgx.moh.SoftwareInstalled;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;

class SwInstalled
implements PackageInfoListListener {
    private MBeanServer server;
    private SystemView sysView;
    private ContainmentTree ct;
    private PackageInfoList packageInfoList;
    private HashMap swInstanceMap = new HashMap();
    private HashMap swObjectNameMap = new HashMap();
    private String relId;
    private transient long id = 0L;

    public SwInstalled(MBeanServer mBeanServer, PackageInfoList packageInfoList, ContainmentTree containmentTree) {
        this.server = mBeanServer;
        this.packageInfoList = packageInfoList;
        this.ct = containmentTree;
    }

    private synchronized void addEntry(PackageInfo packageInfo) {
        this.createEntry(packageInfo);
        this.removeRelation(this.relId);
        this.createRelation();
        Software software = (Software)this.swInstanceMap.get(packageInfo);
        ObjectName objectName = (ObjectName)this.swObjectNameMap.get(packageInfo);
        ObjectCreationNotification objectCreationNotification = new ObjectCreationNotification("netract.moh.object.creation", software, objectName, software.getSequenceNumber(), "Software has been created", objectName, NetraCtDefs.OBJECT_NAME_NE);
        software.sendNotification(objectCreationNotification);
    }

    private void createEntry(PackageInfo packageInfo) {
        SoftwareInstalled softwareInstalled = new SoftwareInstalled(packageInfo);
        ObjectName objectName = null;
        try {
            long l = this.id++;
            objectName = new ObjectName("NetraCt:dn=" + NetraCtDefs.OBJECT_NAME_NE.getKeyProperty("dn") + "/" + packageInfo.getName() + "_" + l + ",name=" + packageInfo.getName() + ",id=" + l);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            malformedObjectNameException.printStackTrace();
        }
        this.swInstanceMap.put(packageInfo, softwareInstalled);
        this.swObjectNameMap.put(packageInfo, objectName);
        try {
            this.server.registerMBean(softwareInstalled, objectName);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void createRelation() {
        Collection collection = this.swObjectNameMap.values();
        if (!collection.isEmpty()) {
            ObjectName[] objectNameArray = new ObjectName[]{};
            ObjectName[] objectNameArray2 = collection.toArray(objectNameArray);
            this.relId = this.ct.createMohRelation("NE-Software", NetraCtDefs.OBJECT_NAME_NE, objectNameArray2);
        }
    }

    void init() {
        this.packageInfoList.addPackageInfoListListener((PackageInfoListListener)this);
        PackageInfo[] packageInfoArray = this.packageInfoList.toArray();
        int n = 0;
        while (n < packageInfoArray.length) {
            this.createEntry(packageInfoArray[n]);
            ++n;
        }
        this.createRelation();
        int n2 = 0;
        while (n2 < packageInfoArray.length) {
            Software software = (Software)this.swInstanceMap.get(packageInfoArray[n2]);
            ObjectName objectName = (ObjectName)this.swObjectNameMap.get(packageInfoArray[n2]);
            ObjectCreationNotification objectCreationNotification = new ObjectCreationNotification("netract.moh.object.creation", software, objectName, software.getSequenceNumber(), "Software has been created", objectName, NetraCtDefs.OBJECT_NAME_NE);
            software.sendNotification(objectCreationNotification);
            ++n2;
        }
    }

    public void packageInfoAdded(PackageInfoListEvent packageInfoListEvent) {
        PackageInfo packageInfo = packageInfoListEvent.getPackageInfo();
        this.addEntry(packageInfo);
    }

    public void packageInfoRemoved(PackageInfoListEvent packageInfoListEvent) {
        PackageInfo packageInfo = packageInfoListEvent.getPackageInfo();
        this.removeEntry(packageInfo);
    }

    private synchronized void removeEntry(PackageInfo packageInfo) {
        Software software = (Software)this.swInstanceMap.remove(packageInfo);
        ObjectName objectName = (ObjectName)this.swObjectNameMap.remove(packageInfo);
        Serializable serializable = software;
        synchronized (serializable) {
            software.remote_deletion = false;
            try {
                try {
                    this.server.unregisterMBean(objectName);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                Object var7_6 = null;
                software.remote_deletion = true;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                software.remote_deletion = true;
                throw throwable;
            }
        }
        serializable = new ObjectDeletionNotification("netract.moh.object.deletion", software, objectName, software.getSequenceNumber(), "Software has been deleted", objectName, NetraCtDefs.OBJECT_NAME_NE);
        software.sendNotification((Notification)serializable);
    }

    private void removeRelation(String string) {
        this.ct.removeMohRelation(string);
    }
}

