/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.moh;

import com.sun.ctmgx.common.HolderIf;
import com.sun.ctmgx.common.PlugInUnitIf;
import com.sun.ctmgx.moh.AttributeChangeNotification;
import com.sun.ctmgx.moh.ContainmentTree;
import com.sun.ctmgx.moh.EquipmentHolder;
import com.sun.ctmgx.moh.EquipmentHolderType;
import com.sun.ctmgx.moh.ObjectCreationNotification;
import com.sun.ctmgx.moh.ObjectDeletionNotification;
import com.sun.ctmgx.moh.PlugInUnit;
import com.sun.ctmgx.moh.PlugInUnitCoyote;
import com.sun.ctmgx.moh.PlugInUnitFan;
import com.sun.ctmgx.moh.SlotMBean;
import com.sun.ctmgx.moh.SlotStatus;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.ObjectName;

public class Slot
extends EquipmentHolder
implements SlotMBean {
    PlugInUnitIf tempPlugIn;
    PlugInUnit plugin;
    ObjectName on_plugin;
    PropChangeListener listener;
    String types;
    SlotStatus slot_status = SlotStatus.FULL;
    ObjectName sw_load;

    public Slot() {
    }

    Slot(HolderIf holderIf, ContainmentTree containmentTree) {
        super(holderIf, containmentTree);
        this.type = EquipmentHolderType.SLOT;
        this.types = holderIf.getAcceptableTypes();
        this.listener = new PropChangeListener(this);
        int n = holderIf.getSlotStatus();
        if (n == 2 || n == 0) {
            this.slot_status = SlotStatus.EMPTY;
        } else if (n == 1) {
            this.slot_status = SlotStatus.FULL;
        }
        if (SlotStatus.FULL.equals(this.slot_status)) {
            this.tempPlugIn = holderIf.getPlugInUnit();
            if (this.tempPlugIn != null) {
                this.plugin = "coyote".equals(this.tempPlugIn.getEntityName()) ? new PlugInUnitCoyote(this.tempPlugIn, containmentTree) : ("fan".equals(this.tempPlugIn.getEntityName()) ? new PlugInUnitFan(this.tempPlugIn, containmentTree) : new PlugInUnit(this.tempPlugIn, containmentTree));
            }
        }
    }

    public String getAcceptablePlugInUnitTypes() {
        return this.types;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] mBeanNotificationInfoArray = super.getNotificationInfo();
        ArrayList<MBeanNotificationInfo> arrayList = new ArrayList<MBeanNotificationInfo>();
        int n = 0;
        while (n < mBeanNotificationInfoArray.length) {
            arrayList.add(mBeanNotificationInfoArray[n]);
            ++n;
        }
        MBeanNotificationInfo mBeanNotificationInfo = new MBeanNotificationInfo(new String[]{"netract.moh.attribute.change"}, "com.sun.ctmgx.moh.AttributeChangeNotification", "Sent when an attribute changes its value.");
        arrayList.add(mBeanNotificationInfo);
        return arrayList.toArray(mBeanNotificationInfoArray);
    }

    public SlotStatus getSlotStatus() {
        return this.slot_status;
    }

    public ObjectName getSoftwareLoad() {
        return this.sw_load;
    }

    void init() {
        if (this.slot_status == SlotStatus.FULL) {
            try {
                this.on_plugin = new ObjectName("NetraCt:dn=" + this.name.getKeyProperty("dn") + "/" + this.tempPlugIn.getEntityName() + "_" + this.tempPlugIn.getEntityParentRelPos() + ",name=" + this.tempPlugIn.getEntityName() + ",id=" + PlugInUnit.getPlugInUnitId());
                this.server.registerMBean(this.plugin, this.on_plugin);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.plugin.init();
            ObjectName[] objectNameArray = new ObjectName[]{this.on_plugin};
            this.ct.createMohRelation("EquipmentHolder-PlugInUnit", this.name, objectNameArray);
        }
    }

    public void setAcceptablePlugInUnitTypes(String string) {
        String string2 = this.types;
        String string3 = string;
        this.types = string;
        if (!string2.equals(string3)) {
            AttributeChangeNotification attributeChangeNotification = new AttributeChangeNotification("netract.moh.attribute.change", this, this.name, this.getSequenceNumber(), "Acceptable PlugIn Unit Types has changed", "AcceptablePlugInUnitTypes", "String", string2, string3);
            this.sendNotification(attributeChangeNotification);
        }
    }

    public void setSoftwareLoad(ObjectName objectName) {
        ObjectName objectName2 = this.sw_load;
        ObjectName objectName3 = objectName;
        this.sw_load = objectName;
        if (!objectName2.equals(objectName3)) {
            AttributeChangeNotification attributeChangeNotification = new AttributeChangeNotification("netract.moh.attribute.change", this, this.name, this.getSequenceNumber(), "Software Load has changed", "SoftwareLoad", "ObjectName", objectName2, objectName3);
            this.sendNotification(attributeChangeNotification);
        }
    }

    void start() {
        this.holder.addPropertyChangeListener((PropertyChangeListener)this.listener);
        if (SlotStatus.FULL.equals(this.slot_status)) {
            ObjectCreationNotification objectCreationNotification = new ObjectCreationNotification("netract.moh.object.creation", this.plugin, this.on_plugin, this.plugin.getSequenceNumber(), "PlugInUnit has been created", this.on_plugin, this.name);
            this.plugin.sendNotification(objectCreationNotification);
            this.plugin.start();
        }
    }

    void stop() {
        if (SlotStatus.FULL.equals(this.slot_status)) {
            this.plugin.stop();
        }
        this.holder.removePropertyChangeListener((PropertyChangeListener)this.listener);
        if (SlotStatus.FULL.equals(this.slot_status)) {
            Serializable serializable = this.plugin;
            synchronized (serializable) {
                this.plugin.remote_deletion = false;
                try {
                    try {
                        this.server.unregisterMBean(this.on_plugin);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    Object var4_3 = null;
                    this.plugin.remote_deletion = true;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.plugin.remote_deletion = true;
                    throw throwable;
                }
            }
            serializable = new ObjectDeletionNotification("netract.moh.object.deletion", this.plugin, this.on_plugin, this.plugin.getSequenceNumber(), "PlugInUnit has been deleted", this.on_plugin, this.name);
            this.plugin.sendNotification((Notification)serializable);
        }
    }

    class PropChangeListener
    implements PropertyChangeListener {
        Slot slot;

        public PropChangeListener(Slot slot2) {
            this.slot = slot2;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            int n = (Integer)propertyChangeEvent.getOldValue();
            int n2 = (Integer)propertyChangeEvent.getNewValue();
            if ("slotStatus".equals(string) && n != n2) {
                SlotStatus slotStatus = Slot.this.slot_status;
                if (n2 == 1) {
                    Slot.this.slot_status = SlotStatus.FULL;
                } else if (n2 == 0) {
                    Slot.this.slot_status = SlotStatus.EMPTY;
                }
                AttributeChangeNotification attributeChangeNotification = new AttributeChangeNotification("netract.moh.attribute.change", this.slot, Slot.this.name, Slot.this.getSequenceNumber(), "Slot Status has changed", "SlotStatus", "SlotStatus", slotStatus, Slot.this.slot_status);
                Slot.this.sendNotification(attributeChangeNotification);
                if (n2 == 1) {
                    Slot.this.tempPlugIn = Slot.this.holder.getPlugInUnit();
                    if (Slot.this.tempPlugIn != null) {
                        Slot.this.plugin = "coyote".equals(Slot.this.tempPlugIn.getEntityName()) ? new PlugInUnitCoyote(Slot.this.tempPlugIn, Slot.this.ct) : ("fan".equals(Slot.this.tempPlugIn.getEntityName()) ? new PlugInUnitFan(Slot.this.tempPlugIn, Slot.this.ct) : new PlugInUnit(Slot.this.tempPlugIn, Slot.this.ct));
                    }
                    Slot.this.init();
                    ObjectCreationNotification objectCreationNotification = new ObjectCreationNotification("netract.moh.object.creation", Slot.this.plugin, Slot.this.on_plugin, Slot.this.plugin.getSequenceNumber(), "PlugInUnit has been created", Slot.this.on_plugin, Slot.this.name);
                    Slot.this.plugin.sendNotification(objectCreationNotification);
                    Slot.this.plugin.start();
                } else if (n2 == 0) {
                    Slot.this.plugin.stop();
                    Serializable serializable = Slot.this.plugin;
                    synchronized (serializable) {
                        Slot.this.plugin.remote_deletion = false;
                        try {
                            try {
                                Slot.this.server.unregisterMBean(Slot.this.on_plugin);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            Object var10_10 = null;
                            Slot.this.plugin.remote_deletion = true;
                        }
                        catch (Throwable throwable) {
                            Object var10_11 = null;
                            Slot.this.plugin.remote_deletion = true;
                            throw throwable;
                        }
                    }
                    serializable = new ObjectDeletionNotification("netract.moh.object.deletion", Slot.this.plugin, Slot.this.on_plugin, Slot.this.plugin.getSequenceNumber(), "PlugInUnit has been deleted", Slot.this.on_plugin, Slot.this.name);
                    Slot.this.plugin.sendNotification((Notification)serializable);
                }
            }
        }
    }
}

