/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.moh;

import com.sun.ctmgx.common.EquipmentIf;
import com.sun.ctmgx.common.Midplane;
import com.sun.ctmgx.common.PackageInfoList;
import com.sun.ctmgx.common.ProcessInfoList;
import com.sun.ctmgx.common.SystemView;
import com.sun.ctmgx.moh.AttributeChangeNotification;
import com.sun.ctmgx.moh.ContainmentTree;
import com.sun.ctmgx.moh.Equipment;
import com.sun.ctmgx.moh.NEMBean;
import com.sun.ctmgx.moh.NetraCtDefs;
import com.sun.ctmgx.moh.ObjectCreationNotification;
import com.sun.ctmgx.moh.ObjectDeletionNotification;
import com.sun.ctmgx.moh.OperationalState;
import com.sun.ctmgx.moh.StateChangeNotification;
import com.sun.ctmgx.moh.SwInstalled;
import com.sun.ctmgx.moh.SwRunning;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.management.JMRuntimeException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;

public class NE
extends NotificationBroadcasterSupport
implements NEMBean,
MBeanRegistration,
Serializable {
    boolean remote_deletion = true;
    private MBeanServer server;
    private ObjectName name;
    private SystemView sysView;
    private Midplane midplane;
    private PackageInfoList packageInfoList;
    private ProcessInfoList processInfoList;
    ContainmentTree ct;
    Equipment mp;
    SwInstalled swi;
    SwRunning swr;
    ObjectName on_mp;
    PropChangeListener listener;
    OperationalState oper_state;
    private String location_name = "";
    private String vendor_name = "Sun Microsystems, Inc.";
    private String version;
    private ObjectName asp = NetraCtDefs.OBJECT_NAME_ASP;
    private transient long sequenceNumber = 0L;

    public NE() {
        throw new JMRuntimeException("Remote creation of instances of this MBean is not allowed.");
    }

    NE(SystemView systemView, ContainmentTree containmentTree) {
        this.sysView = systemView;
        this.ct = containmentTree;
        this.midplane = systemView.getMidplane();
        this.version = this.getNeType();
        this.oper_state = OperationalState.getState(this.midplane.getOperStatus());
        this.listener = new PropChangeListener(this);
        this.mp = new Equipment((EquipmentIf)this.midplane, containmentTree);
        this.packageInfoList = systemView.getPackageInfoList();
        this.processInfoList = systemView.getProcessInfoList();
    }

    public ObjectName getAlarmSeverityProfilePointer() {
        return this.asp;
    }

    public long getExternalTime() {
        return System.currentTimeMillis();
    }

    public String getLocationName() {
        return this.location_name;
    }

    private String getNeType() {
        int n = SystemView.getSystemType();
        String string = n == 0 ? "Netra ct 800" : (n == 3 ? "Netra ct 400 diskless" : "Netra ct 400 diskfull");
        return string;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"netract.moh.object.creation"}, "com.sun.ctmgx.moh.ObjectCreationNotification", "Sent when an object is created."), new MBeanNotificationInfo(new String[]{"netract.moh.object.deletion"}, "com.sun.ctmgx.moh.ObjectDeletionNotification", "Sent when an object is deleted."), new MBeanNotificationInfo(new String[]{"netract.moh.attribute.change"}, "com.sun.ctmgx.moh.AttributeChangeNotification", "Sent when an attribute changes its value."), new MBeanNotificationInfo(new String[]{"netract.moh.state.change"}, "com.sun.ctmgx.moh.StateChangeNotification", "Sent when an state attribute changes its value.")};
        return mBeanNotificationInfoArray;
    }

    public OperationalState getOperationalState() {
        return this.oper_state;
    }

    private synchronized long getSequenceNumber() {
        return this.sequenceNumber++;
    }

    public String getVendorName() {
        return this.vendor_name;
    }

    public String getVersion() {
        return this.version;
    }

    void init() {
        try {
            this.on_mp = new ObjectName("NetraCt:dn=" + this.name.getKeyProperty("dn") + "/" + this.midplane.getEntityName() + "_" + this.midplane.getEntityParentRelPos() + ",name=" + this.midplane.getEntityName() + ",id=" + Equipment.getEquipmentId());
            this.server.registerMBean(this.mp, this.on_mp);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.mp.init();
        ObjectName[] objectNameArray = new ObjectName[]{this.on_mp};
        this.ct.createMohRelation("NE-Equipment", NetraCtDefs.OBJECT_NAME_NE, objectNameArray);
        this.swi = new SwInstalled(this.server, this.packageInfoList, this.ct);
        this.swi.init();
        this.swr = new SwRunning(this.server, this.processInfoList, this.ct);
        this.swr.init();
    }

    public void postDeregister() {
        ObjectDeletionNotification objectDeletionNotification = new ObjectDeletionNotification("netract.moh.object.deletion", this, this.name, this.getSequenceNumber(), "NE has been deleted", this.name, null);
        this.sendNotification(objectDeletionNotification);
    }

    public void postRegister(Boolean bl) {
        if (bl.booleanValue()) {
            ObjectCreationNotification objectCreationNotification = new ObjectCreationNotification("netract.moh.object.creation", this, this.name, this.getSequenceNumber(), "NE has been created", this.name, null);
            this.sendNotification(objectCreationNotification);
        }
    }

    public void preDeregister() throws Exception {
        if (this.remote_deletion) {
            throw new JMRuntimeException("Remote deletion of instances of this MBean is not allowed.");
        }
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.server = mBeanServer;
        this.name = objectName;
        return objectName;
    }

    public void setAlarmSeverityProfilePointer(ObjectName objectName) {
        ObjectName objectName2 = this.asp;
        ObjectName objectName3 = objectName;
        if (objectName != null) {
            boolean bl;
            try {
                bl = this.server.isInstanceOf(objectName, "com.sun.ctmgx.moh.AlarmSeverityProfile");
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("MBean " + exception.getMessage() + " not registered.");
            }
            if (!bl) {
                throw new IllegalArgumentException("The given ObjectName does not correspond to an MBean of class com.sun.ctmgx.moh.AlarmSeverityProfile");
            }
            this.asp = objectName;
        } else {
            this.asp = NetraCtDefs.OBJECT_NAME_ASP;
        }
        if (!objectName2.equals(objectName3)) {
            AttributeChangeNotification attributeChangeNotification = new AttributeChangeNotification("netract.moh.attribute.change", this, this.name, this.getSequenceNumber(), "Alarm Severity Profile Pointer has changed", "AlarmSeverityProfilePointer", "ObjectName", objectName2, objectName3);
            this.sendNotification(attributeChangeNotification);
        }
    }

    public void setLocationName(String string) {
        String string2 = this.location_name;
        String string3 = string;
        this.location_name = string;
        if (!string2.equals(string3)) {
            AttributeChangeNotification attributeChangeNotification = new AttributeChangeNotification("netract.moh.attribute.change", this, this.name, this.getSequenceNumber(), "Location Name has changed", "LocationName", "String", string2, string3);
            this.sendNotification(attributeChangeNotification);
        }
    }

    void start() {
        this.midplane.addPropertyChangeListener((PropertyChangeListener)this.listener);
        ObjectCreationNotification objectCreationNotification = new ObjectCreationNotification("netract.moh.object.creation", this.mp, this.on_mp, this.mp.getSequenceNumber(), "Equipment has been created", this.on_mp, this.name);
        this.mp.sendNotification(objectCreationNotification);
        this.mp.start();
    }

    void stop() {
        this.mp.stop();
        this.midplane.removePropertyChangeListener((PropertyChangeListener)this.listener);
        Serializable serializable = this.mp;
        synchronized (serializable) {
            this.mp.remote_deletion = false;
            try {
                try {
                    this.server.unregisterMBean(this.on_mp);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                Object var4_3 = null;
                this.mp.remote_deletion = true;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.mp.remote_deletion = true;
                throw throwable;
            }
        }
        serializable = new ObjectDeletionNotification("netract.moh.object.deletion", this.mp, this.on_mp, this.mp.getSequenceNumber(), "Equipment has been deleted", this.on_mp, this.name);
        this.mp.sendNotification((Notification)serializable);
    }

    class PropChangeListener
    implements PropertyChangeListener {
        NE ne;

        public PropChangeListener(NE nE2) {
            this.ne = nE2;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            int n = (Integer)propertyChangeEvent.getOldValue();
            int n2 = (Integer)propertyChangeEvent.getNewValue();
            if ("operStatus".equals(string) && n != n2) {
                NE.this.oper_state = OperationalState.getState(n2);
                StateChangeNotification stateChangeNotification = new StateChangeNotification("netract.moh.state.change", this.ne, NE.this.name, NE.this.getSequenceNumber(), "Operational State value has changed", "OperationalState", "OperationalState", OperationalState.getState(n), OperationalState.getState(n2));
                NE.this.sendNotification(stateChangeNotification);
            }
        }
    }
}

