/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.moh;

import com.sun.ctmgx.common.Debug;
import com.sun.ctmgx.common.SystemView;
import com.sun.ctmgx.moh.AdministrativeState;
import com.sun.ctmgx.moh.AlarmNotificationFilter;
import com.sun.ctmgx.moh.AlarmSeverity;
import com.sun.ctmgx.moh.AlarmSeverityProfile;
import com.sun.ctmgx.moh.ContainmentTree;
import com.sun.ctmgx.moh.EFD;
import com.sun.ctmgx.moh.FullLog;
import com.sun.ctmgx.moh.LOL;
import com.sun.ctmgx.moh.NE;
import com.sun.ctmgx.moh.NetraCtDefs;
import java.io.Serializable;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.relation.RelationService;

public class MohMM {
    MBeanServer server;
    SystemView sysView;
    Debug debug = new Debug();

    public MohMM(MBeanServer mBeanServer, SystemView systemView) {
        this.server = mBeanServer;
        this.sysView = systemView;
        this.initialise();
    }

    private void initialise() {
        Serializable serializable;
        Serializable serializable2;
        EFD eFD = new EFD();
        try {
            this.server.registerMBean(eFD, NetraCtDefs.OBJECT_NAME_EFD);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.debug.write(6, "EFD done");
        FullLog fullLog = new FullLog(eFD);
        try {
            this.server.registerMBean(fullLog, NetraCtDefs.OBJECT_NAME_LOG_ALARM);
            serializable2 = new AlarmNotificationFilter();
            ((NotificationFilterSupport)serializable2).enableType("netract.moh.alarm");
            ((AlarmNotificationFilter)serializable2).enableSeverity(AlarmSeverity.CLEARED);
            ((AlarmNotificationFilter)serializable2).enableSeverity(AlarmSeverity.INDETERMINATE);
            ((AlarmNotificationFilter)serializable2).enableSeverity(AlarmSeverity.CRITICAL);
            ((AlarmNotificationFilter)serializable2).enableSeverity(AlarmSeverity.MAJOR);
            ((AlarmNotificationFilter)serializable2).enableSeverity(AlarmSeverity.MINOR);
            ((AlarmNotificationFilter)serializable2).enableSeverity(AlarmSeverity.WARNING);
            fullLog.setFilter((NotificationFilter)serializable2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        serializable2 = new FullLog(eFD);
        try {
            this.server.registerMBean(serializable2, NetraCtDefs.OBJECT_NAME_LOG_ALL);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        LOL lOL = new LOL(eFD);
        try {
            this.server.registerMBean(lOL, NetraCtDefs.OBJECT_NAME_LOL_ALARM);
            serializable = new AlarmNotificationFilter();
            ((NotificationFilterSupport)serializable).enableType("netract.moh.alarm");
            ((AlarmNotificationFilter)serializable).enableSeverity(AlarmSeverity.CLEARED);
            ((AlarmNotificationFilter)serializable).enableSeverity(AlarmSeverity.INDETERMINATE);
            ((AlarmNotificationFilter)serializable).enableSeverity(AlarmSeverity.CRITICAL);
            ((AlarmNotificationFilter)serializable).enableSeverity(AlarmSeverity.MAJOR);
            ((AlarmNotificationFilter)serializable).enableSeverity(AlarmSeverity.MINOR);
            ((AlarmNotificationFilter)serializable).enableSeverity(AlarmSeverity.WARNING);
            lOL.setFilter((NotificationFilter)serializable);
            lOL.addAttribute("Type");
            lOL.addAttribute("PerceivedSeverity");
            lOL.setAdministrativeState(AdministrativeState.UNLOCKED);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        serializable = new LOL(eFD);
        try {
            this.server.registerMBean(serializable, NetraCtDefs.OBJECT_NAME_LOL_ALL);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        RelationService relationService = new RelationService(true);
        try {
            this.server.registerMBean(relationService, NetraCtDefs.OBJECT_NAME_RS);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.debug.write(6, "relation service done");
        ContainmentTree containmentTree = new ContainmentTree(relationService);
        try {
            this.server.registerMBean(containmentTree, NetraCtDefs.OBJECT_NAME_CT);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.debug.write(6, "containment tree done");
        HashMap<String, AlarmSeverity> hashMap = new HashMap<String, AlarmSeverity>();
        hashMap.put("netract.moh.alarm.high.temperature", AlarmSeverity.MINOR);
        hashMap.put("netract.moh.alarm.fuse.failure", AlarmSeverity.MINOR);
        hashMap.put("netract.moh.alarm.fan.failure", AlarmSeverity.MINOR);
        AlarmSeverityProfile alarmSeverityProfile = new AlarmSeverityProfile(hashMap);
        try {
            this.server.registerMBean(alarmSeverityProfile, NetraCtDefs.OBJECT_NAME_ASP);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.debug.write(6, "alarm severity profile done");
        NE nE = new NE(this.sysView, containmentTree);
        try {
            this.server.registerMBean(nE, NetraCtDefs.OBJECT_NAME_NE);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        nE.init();
        nE.start();
        this.debug.write(6, "ne done");
        this.debug.write(6, "MOH agent is up.");
    }
}

