/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.moh;

import com.sun.ctmgx.common.Cpu;
import com.sun.ctmgx.common.EquipmentIf;
import com.sun.ctmgx.common.Log;
import com.sun.ctmgx.moh.AlarmNotification;
import com.sun.ctmgx.moh.AlarmSeverity;
import com.sun.ctmgx.moh.ContainmentTree;
import com.sun.ctmgx.moh.Equipment;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import javax.management.MBeanNotificationInfo;

public class EquipmentCpu
extends Equipment {
    Cpu cpu;

    public EquipmentCpu() {
    }

    EquipmentCpu(EquipmentIf equipmentIf, ContainmentTree containmentTree) {
        super(equipmentIf, containmentTree);
        this.cpu = (Cpu)equipmentIf;
        this.listener = new PropChangeListenerCpu((Equipment)this);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] mBeanNotificationInfoArray = super.getNotificationInfo();
        ArrayList<MBeanNotificationInfo> arrayList = new ArrayList<MBeanNotificationInfo>();
        int n = 0;
        while (n < mBeanNotificationInfoArray.length) {
            arrayList.add(mBeanNotificationInfoArray[n]);
            ++n;
        }
        MBeanNotificationInfo mBeanNotificationInfo = new MBeanNotificationInfo(new String[]{"netract.moh.alarm.high.temperature"}, "com.sun.ctmgx.moh.AlarmNotification", "Sent when a problem occurs and an alarm is to be sent.");
        arrayList.add(mBeanNotificationInfo);
        return arrayList.toArray(mBeanNotificationInfoArray);
    }

    class PropChangeListenerCpu
    extends Equipment.PropChangeListener {
        public PropChangeListenerCpu(Equipment equipment) {
            super(equipment);
        }

        void alarmChange(Boolean bl, String string) {
            if (bl.booleanValue()) {
                this.setHighTempAlarm(string);
            } else {
                this.clearHighTempAlarm(string);
            }
        }

        void clearHighTempAlarm(String string) {
            this.sendHighTempAlarm(string, AlarmSeverity.CLEARED);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("warningTempAlarm".equals(string)) {
                this.alarmChange((Boolean)propertyChangeEvent.getNewValue(), "Warning threshold exceeded");
            } else if ("shutdownTempAlarm".equals(string)) {
                this.alarmChange((Boolean)propertyChangeEvent.getNewValue(), "Shutdown threshold exceeded");
            }
        }

        void sendHighTempAlarm(String string) {
            AlarmSeverity alarmSeverity = AlarmSeverity.INDETERMINATE;
            try {
                Object[] objectArray = new Object[]{"netract.moh.alarm.high.temperature"};
                String[] stringArray = new String[]{"java.lang.String"};
                AlarmSeverity alarmSeverity2 = (AlarmSeverity)EquipmentCpu.this.server.invoke(EquipmentCpu.this.asp, "getAlarmSeverity", objectArray, stringArray);
                if (alarmSeverity2 == null) {
                    Log.error((Object)this, (String)"sev is null");
                    alarmSeverity = AlarmSeverity.INDETERMINATE;
                } else {
                    alarmSeverity = alarmSeverity2;
                }
            }
            catch (Exception exception) {
                Log.error((Object)this, (String)exception.toString());
                alarmSeverity = AlarmSeverity.INDETERMINATE;
            }
            this.sendHighTempAlarm(string, alarmSeverity);
        }

        void sendHighTempAlarm(String string, AlarmSeverity alarmSeverity) {
            AlarmNotification alarmNotification = new AlarmNotification("netract.moh.alarm.high.temperature", this.equip, EquipmentCpu.this.name, EquipmentCpu.this.getSequenceNumber(), "High Temperature Alarm Notification", alarmSeverity, string, false, null, "no repair action defined", null);
            EquipmentCpu.this.sendNotification(alarmNotification);
        }

        void setHighTempAlarm(String string) {
            this.sendHighTempAlarm(string);
        }
    }
}

