/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.common;

import com.sun.ctmgx.common.Debug;
import com.sun.ctmgx.common.KStat;
import com.sun.ctmgx.common.MonitorFactory;
import com.sun.ctmgx.common.PollEventListener;
import com.sun.ctmgx.common.PollMonitor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class TempInfo
implements PollEventListener {
    String label;
    int type;
    int currentTemperature;
    int minimum;
    int warningThreshold;
    int shutdownThreshold;
    boolean temperatureChange = false;
    private Debug debug = new Debug();
    PropertyChangeSupport changes = new PropertyChangeSupport(this);
    PollMonitor pollMonitor;
    KStat ks;

    static {
        System.loadLibrary("TempInfo");
    }

    public TempInfo(int n) {
        this("adc-dac", n, "adc_temp");
    }

    public TempInfo(String string, int n, String string2) {
        this.ks = new KStat(string, n, string2);
        byte[] byArray = this.ks.read();
        try {
            this.set(byArray);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
        }
        this.pollMonitor = MonitorFactory.getPollMonitor();
        this.pollMonitor.addPollEventListener(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public int getCurrentTemperature() {
        return this.currentTemperature;
    }

    public String getLabel() {
        return this.label;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getShutdownThreshold() {
        return this.shutdownThreshold;
    }

    public int getType() {
        return this.type;
    }

    public int getWarningThreshold() {
        return this.warningThreshold;
    }

    public void handleEvent() {
        this.debug.write((Object)this, 7, "In handleEvent");
        byte[] byArray = this.ks.read();
        try {
            this.set(byArray);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    private void set(int n, int n2, int n3, int n4) {
        this.setValue(n);
        this.setWarningThreshold(n3);
        this.setShutdownThreshold(n4);
        if (this.temperatureChange) {
            this.changes.firePropertyChange("temperatureChange", false, true);
        }
        this.temperatureChange = false;
    }

    private native void set(byte[] var1);

    private void setLabel(String string) {
        String string2 = this.label;
        this.label = string;
        this.changes.firePropertyChange("label", string2, this.label);
    }

    private void setMinimum(int n) {
        int n2 = this.minimum;
        this.minimum = n;
        this.changes.firePropertyChange("minimum", n2, this.minimum);
    }

    private void setShutdownThreshold(int n) {
        if (this.shutdownThreshold != n) {
            this.shutdownThreshold = n;
            this.temperatureChange = true;
        }
    }

    private void setValue(int n) {
        if (this.currentTemperature != n) {
            this.currentTemperature = n;
            this.temperatureChange = true;
        }
    }

    private void setWarningThreshold(int n) {
        if (this.warningThreshold != n) {
            this.warningThreshold = n;
            this.temperatureChange = true;
        }
    }
}

