/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.common;

import com.sun.ctmgx.common.TempAlarmControl;

public class TempAlarmControlContext {
    private TempAlarmControl owner;
    private TempAlarmControlState state;

    public TempAlarmControlContext(TempAlarmControl tempAlarmControl) {
        this.owner = tempAlarmControl;
        this.state = TempAlarmControlState.NORMAL;
    }

    protected TempAlarmControl getOwner() {
        return this.owner;
    }

    protected TempAlarmControlState getState() {
        return this.state;
    }

    public void normalTemp() {
        this.getState().normalTemp(this);
    }

    protected void setState(TempAlarmControlState tempAlarmControlState) {
        this.state = tempAlarmControlState;
    }

    public void shutdownTemp() {
        this.getState().shutdownTemp(this);
    }

    public void warningTemp() {
        this.getState().warningTemp(this);
    }

    protected static abstract class TempAlarmControlState {
        protected static TempAlarmControlState NORMAL = new Normal();
        protected static TempAlarmControlState WARNING = new Warning();
        protected static TempAlarmControlState SHUTDOWN = new Shutdown();

        protected TempAlarmControlState() {
        }

        protected void normalTemp(TempAlarmControlContext tempAlarmControlContext) {
        }

        protected void shutdownTemp(TempAlarmControlContext tempAlarmControlContext) {
        }

        protected void warningTemp(TempAlarmControlContext tempAlarmControlContext) {
        }
    }

    protected static class Normal
    extends TempAlarmControlState {
        protected Normal() {
        }

        protected void normalTemp(TempAlarmControlContext tempAlarmControlContext) {
        }

        protected void shutdownTemp(TempAlarmControlContext tempAlarmControlContext) {
            tempAlarmControlContext.getOwner().setShutdownAlarm();
            tempAlarmControlContext.setState(TempAlarmControlState.SHUTDOWN);
        }

        protected void warningTemp(TempAlarmControlContext tempAlarmControlContext) {
            tempAlarmControlContext.getOwner().setWarningAlarm();
            tempAlarmControlContext.setState(TempAlarmControlState.WARNING);
        }
    }

    protected static class Warning
    extends TempAlarmControlState {
        protected Warning() {
        }

        protected void normalTemp(TempAlarmControlContext tempAlarmControlContext) {
            tempAlarmControlContext.getOwner().clearWarningAlarm();
            tempAlarmControlContext.setState(TempAlarmControlState.NORMAL);
        }

        protected void shutdownTemp(TempAlarmControlContext tempAlarmControlContext) {
            tempAlarmControlContext.getOwner().clearWarningAlarm();
            tempAlarmControlContext.getOwner().setShutdownAlarm();
            tempAlarmControlContext.setState(TempAlarmControlState.SHUTDOWN);
        }

        protected void warningTemp(TempAlarmControlContext tempAlarmControlContext) {
        }
    }

    protected static class Shutdown
    extends TempAlarmControlState {
        protected Shutdown() {
        }

        protected void normalTemp(TempAlarmControlContext tempAlarmControlContext) {
            tempAlarmControlContext.getOwner().clearShutdownAlarm();
            tempAlarmControlContext.setState(TempAlarmControlState.NORMAL);
        }

        protected void shutdownTemp(TempAlarmControlContext tempAlarmControlContext) {
        }

        protected void warningTemp(TempAlarmControlContext tempAlarmControlContext) {
            tempAlarmControlContext.getOwner().clearShutdownAlarm();
            tempAlarmControlContext.getOwner().setWarningAlarm();
            tempAlarmControlContext.setState(TempAlarmControlState.WARNING);
        }
    }
}

