/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.common;

import com.sun.ctmgx.common.LogWatcher;
import com.sun.ctmgx.common.SyslogEvent;
import com.sun.ctmgx.common.SyslogListener;
import javax.management.snmp.SnmpPduRequest;
import javax.management.snmp.SnmpPduTrap;
import javax.management.snmp.manager.SnmpEventReportDispatcher;
import javax.management.snmp.manager.SnmpTrapListener;

public class SyslogMonitor
implements SyslogEvent.Constants {
    private SyslogListener listener;
    private LogWatcher logWatcher;

    public SyslogMonitor() {
        this(Integer.getInteger("syslogMonitor.port", 8090));
    }

    public SyslogMonitor(int n) {
        String string = SyslogEvent.Constants.DSMRM_COMPENSATING_ACTIONS_STARTED.subString;
        try {
            SnmpEventReportDispatcher snmpEventReportDispatcher = new SnmpEventReportDispatcher(n);
            TrapListenerImpl trapListenerImpl = new TrapListenerImpl();
            snmpEventReportDispatcher.addTrapListener((SnmpTrapListener)trapListenerImpl);
            Thread thread = new Thread((Runnable)snmpEventReportDispatcher);
            thread.start();
            this.startLogWatcher(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addSyslogListener(SyslogListener syslogListener) {
        this.listener = syslogListener;
    }

    public void removeSyslogListener(SyslogListener syslogListener) {
        if (this.listener == syslogListener) {
            this.listener = null;
        }
    }

    private void sendEvent(SyslogEvent syslogEvent) {
        if (this.listener != null) {
            this.listener.processEvent(syslogEvent);
        }
    }

    void startLogWatcher(int n) {
        SyslogEvent.Constants.Type[] typeArray = SyslogEvent.Constants.Type.toArray();
        int[] nArray = new int[typeArray.length];
        String[] stringArray = new String[typeArray.length];
        int n2 = 0;
        while (n2 < typeArray.length) {
            stringArray[n2] = typeArray[n2].subString;
            nArray[n2] = typeArray[n2].code;
            ++n2;
        }
        this.logWatcher = new LogWatcher(stringArray, nArray, n);
        this.logWatcher.start();
    }

    class TrapListenerImpl
    implements SnmpTrapListener {
        TrapListenerImpl() {
        }

        public void processSnmpTrapV1(SnmpPduTrap snmpPduTrap) {
            int n = snmpPduTrap.specificTrap;
            String string = snmpPduTrap.varBindList[0].value.toString();
            SyslogEvent.Constants.Type type = SyslogEvent.Constants.Type.getType(n);
            SyslogEvent syslogEvent = new SyslogEvent(this, type, string);
            SyslogMonitor.this.sendEvent(syslogEvent);
        }

        public void processSnmpTrapV2(SnmpPduRequest snmpPduRequest) {
        }
    }
}

