/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.common;

import com.sun.ctmgx.common.Coyote;
import com.sun.ctmgx.common.CoyoteInfo;
import com.sun.ctmgx.common.D130;
import com.sun.ctmgx.common.Debug;
import com.sun.ctmgx.common.Device;
import com.sun.ctmgx.common.HolderImpl;
import com.sun.ctmgx.common.MonitorFactory;
import com.sun.ctmgx.common.ScsiContainer;
import com.sun.ctmgx.common.ScsiSlotInfo;
import com.sun.ctmgx.common.SsmdMonitor;

public class ScsiSlot
extends HolderImpl {
    ScsiSlotInfo scsiSlotInfo;
    D130[] d130List;
    Coyote coyote;
    ScsiContainer parent;
    Debug debug = new Debug();

    ScsiSlot(ScsiSlotInfo scsiSlotInfo, ScsiContainer scsiContainer) {
        super("scsi_slot", "scsi_slot", 5, 3, 0, 4, scsiSlotInfo.getD130List().length > 0 ? 1 : 0, new String());
        Object object;
        this.parent = scsiContainer;
        this.scsiSlotInfo = scsiSlotInfo;
        this.d130List = scsiSlotInfo.getD130List();
        int n = this.d130List.length;
        if (n > 0) {
            object = new CoyoteInfo(this.d130List);
            this.coyote = new Coyote((CoyoteInfo)object);
            this.holderPlugIn = this.coyote;
        }
        if (scsiSlotInfo.isController()) {
            object = MonitorFactory.getSsmdMonitor();
            ((SsmdMonitor)object).addAScsiSlot(this);
        }
    }

    void clear() {
        if (this.holderPlugIn == null) {
            return;
        }
        if (this.scsiSlotInfo.isController()) {
            this.coyote.scsiSlot.clear();
        }
        this.holderPlugIn.stopMonitoring();
        this.coyote = null;
        this.holderPlugIn = null;
        int n = this.holderSlotStatus;
        this.holderSlotStatus = 0;
        this.propChangeSupport.firePropertyChange("slotStatus", new Integer(n), new Integer(this.holderSlotStatus));
    }

    Coyote getCoyote() {
        return this.coyote;
    }

    void initCoyotes(D130[] d130Array) {
        CoyoteInfo coyoteInfo = new CoyoteInfo(d130Array);
        this.coyote = new Coyote(coyoteInfo);
        this.holderPlugIn = this.coyote;
        int n = this.holderSlotStatus;
        this.holderSlotStatus = 1;
        this.propChangeSupport.firePropertyChange("slotStatus", new Integer(n), new Integer(this.holderSlotStatus));
        Coyote coyote = this.coyote.scsiSlot.getCoyote();
        if (coyote != null) {
            ScsiSlot scsiSlot = this.coyote.scsiSlot;
            n = scsiSlot.holderSlotStatus;
            scsiSlot.holderSlotStatus = 1;
            scsiSlot.propChangeSupport.firePropertyChange("slotStatus", new Integer(n), new Integer(scsiSlot.holderSlotStatus));
        }
    }

    void reset() {
        Device[] deviceArray = this.parent.getScsiDevices(this.entityParentRelPos);
        this.scsiSlotInfo = new ScsiSlotInfo(deviceArray);
        D130[] d130Array = this.scsiSlotInfo.getD130List();
        this.reset(d130Array);
        this.d130List = d130Array;
    }

    void reset(D130[] d130Array) {
        int n = d130Array.length;
        if (this.d130List.length == 0) {
            if (n > 0) {
                this.initCoyotes(d130Array);
            }
            return;
        }
        if (n == 0) {
            this.clear();
            return;
        }
        boolean bl = false;
        if (this.d130List[0].equals(d130Array[0])) {
            bl = true;
        }
        if (!bl) {
            this.clear();
            this.initCoyotes(d130Array);
        } else {
            this.coyote.coyoteInfo.onConnection(true);
            D130[] d130Array2 = new D130[n - 1];
            int n2 = 0;
            while (n2 < d130Array2.length) {
                d130Array2[n2] = d130Array[n2 + 1];
                ++n2;
            }
            this.coyote.scsiSlot.reset(d130Array2);
        }
    }

    public void stopMonitoring() {
        super.stopMonitoring();
        if (this.scsiSlotInfo.isController()) {
            SsmdMonitor ssmdMonitor = MonitorFactory.getSsmdMonitor();
            ssmdMonitor.removeAScsiSlot(this);
        }
    }
}

