/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.common;

import com.sun.ctmgx.common.Debug;
import com.sun.ctmgx.common.EnvmondEvent;
import com.sun.ctmgx.common.EnvmondEventListener;
import com.sun.ctmgx.common.KStat;
import com.sun.ctmgx.common.MonitorFactory;
import com.sun.ctmgx.common.PollMonitor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class PsInfo
implements EnvmondEventListener {
    boolean present;
    boolean ok;
    boolean temperatureOk;
    boolean fanOk;
    boolean on;
    int version;
    int deviceInstance;
    String deviceType = "03";
    KStat ks;
    PollMonitor pollMonitor;
    private Debug debug = new Debug();
    private PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);

    static {
        System.loadLibrary("PsInfo");
    }

    PsInfo(int n) {
        this("gpio", n, 0, "gpio_pwrsupply" + n);
    }

    public PsInfo(String string, int n, int n2, String string2) {
        this.deviceInstance = n;
        this.ks = new KStat(string, n2, string2);
        byte[] byArray = this.ks.read();
        this.create(byArray);
        this.pollMonitor = MonitorFactory.getPollMonitor();
        this.pollMonitor.addPollEventListener(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    protected void create(byte[] byArray) {
        try {
            this.set(byArray);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
        }
    }

    public int getDeviceInstance() {
        return this.deviceInstance;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public int getVersion() {
        return this.version;
    }

    public void handleEvent() {
        this.handleEvent(new EnvmondEvent(new Object()));
    }

    public void handleEvent(EnvmondEvent envmondEvent) {
        this.debug.write((Object)this, 7, "In PsInfo handleEvent");
        byte[] byArray = this.ks.read();
        try {
            this.set(byArray);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
        }
    }

    public boolean isFanOk() {
        return this.fanOk;
    }

    public boolean isOk() {
        return this.ok;
    }

    public boolean isOn() {
        return this.on;
    }

    public boolean isPresent() {
        return this.present;
    }

    public boolean isTemperatureOk() {
        return this.temperatureOk;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    protected native void set(byte[] var1);

    protected void setAll(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n) {
        this.setPresent(bl);
        this.setOk(bl2);
        this.setTemperatureOk(bl3);
        this.setFanOk(bl4);
        this.setOn(bl5);
        this.setVersion(n);
    }

    private void setFanOk(boolean bl) {
        boolean bl2 = this.fanOk;
        this.fanOk = bl;
        this.propChangeSupport.firePropertyChange("fanOk", bl2, this.fanOk);
    }

    private void setOk(boolean bl) {
        boolean bl2 = this.ok;
        this.ok = bl;
        this.propChangeSupport.firePropertyChange("ok", bl2, this.ok);
    }

    private void setOn(boolean bl) {
        boolean bl2 = this.on;
        this.on = bl;
        this.propChangeSupport.firePropertyChange("on", bl2, this.on);
    }

    private void setPresent(boolean bl) {
        boolean bl2 = this.present;
        this.present = bl;
        this.propChangeSupport.firePropertyChange("present", bl2, this.present);
    }

    private void setTemperatureOk(boolean bl) {
        boolean bl2 = this.temperatureOk;
        this.temperatureOk = bl;
        this.propChangeSupport.firePropertyChange("temperatureOk", bl2, this.temperatureOk);
    }

    private void setVersion(int n) {
        int n2 = this.version;
        this.version = n;
        this.propChangeSupport.firePropertyChange("version", n2, this.version);
    }

    void stopMonitoring() {
        this.pollMonitor.removePollEventListener(this);
    }
}

