/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.common;

import com.sun.ctmgx.common.Debug;
import com.sun.ctmgx.common.ProcessWatcher;

public class Ndd {
    private Debug debug = new Debug();
    final String NDD = "ndd_ctmgx";
    final String NDD_SET = "-set";
    String driverName;
    int driverInstance;
    String[] nddGet;
    String[] nddSet;

    static {
        System.loadLibrary("Ndd");
    }

    Ndd(String string) {
        this.driverName = string;
        this.nddGet = new String[4];
        this.nddGet[0] = "ndd_ctmgx";
        this.nddGet[1] = this.driverName;
        this.nddSet = new String[5];
        this.nddSet[0] = "ndd_ctmgx";
        this.nddSet[1] = "-set";
        this.nddSet[2] = this.driverName;
        this.driverInstance = 0;
    }

    Ndd(String string, int n) {
        this(string);
        this.driverInstance = n;
        this.debug.write((Object)this, 7, "driver name = " + string + ", instance = " + this.driverInstance);
    }

    String get(int n, String string) {
        this.nddGet[2] = string;
        this.nddGet[3] = Integer.toString(n);
        return this.get(this.nddGet);
    }

    String get(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[100];
        boolean bl = false;
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            ProcessWatcher processWatcher = new ProcessWatcher(process);
            Thread thread = new Thread(processWatcher);
            thread.start();
            Thread.currentThread();
            Thread.yield();
            if (thread.isAlive()) {
                this.debug.write((Object)this, 7, "processWatcher alive will let it terminate within 200 ms ...");
                thread.join(5000L);
                if (thread.isAlive()) {
                    this.debug.write((Object)this, 7, "processWatcher  thread did not terminate, killing process");
                    process.destroy();
                    Thread.currentThread();
                    Thread.yield();
                }
            }
            if (thread.isAlive()) {
                stringBuffer.append("3");
            } else {
                stringBuffer.append(process.exitValue());
            }
            process.getInputStream().close();
            process.getOutputStream().close();
            process.getErrorStream().close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuffer.toString();
    }

    String getLinkStatus() {
        this.nddGet[2] = "link_status";
        this.nddGet[3] = Integer.toString(this.driverInstance);
        return this.get(this.nddGet);
    }

    int ioctlGetLinkStatus() {
        int n = 4;
        n = this.ioctlGetLinkStatus(this.driverName, this.driverInstance);
        return n;
    }

    native int ioctlGetLinkStatus(String var1, int var2);

    private static void main(String[] stringArray) {
        int n = 0;
        Ndd ndd = new Ndd("/dev/hme");
        if (stringArray.length <= 1) {
            return;
        }
        if (stringArray.length == 2) {
            n = 0;
            while (n < 1000) {
                System.out.println("iteration " + n + ": " + stringArray[0] + " = " + ndd.get(Integer.parseInt(stringArray[0]), stringArray[1]));
                ++n;
            }
        }
    }
}

